from taihe.parse.antlr.TaiheAST import TaiheAST

from typing import Any


class TaiheVisitor:
    def visit(self, node: TaiheAST.any) -> Any:
        return node._accept(self)

    def visit_token(self, node: TaiheAST.token) -> Any:
        raise NotImplementedError()

    def visit_Spec(self, node: TaiheAST.Spec) -> Any:
        raise NotImplementedError()

    def visit_ScopeAttr(self, node: TaiheAST.ScopeAttr) -> Any:
        raise NotImplementedError()

    def visit_DeclAttr(self, node: TaiheAST.DeclAttr) -> Any:
        raise NotImplementedError()

    def visit_UsePackage(self, node: TaiheAST.UsePackage) -> Any:
        return self.visit_Use(node)

    def visit_UseSymbol(self, node: TaiheAST.UseSymbol) -> Any:
        return self.visit_Use(node)

    def visit_Use(self, node: TaiheAST.Use) -> Any:
        raise NotImplementedError()

    def visit_PkgName(self, node: TaiheAST.PkgName) -> Any:
        raise NotImplementedError()

    def visit_DeclAliasPair(self, node: TaiheAST.DeclAliasPair) -> Any:
        raise NotImplementedError()

    def visit_Struct(self, node: TaiheAST.Struct) -> Any:
        return self.visit_SpecField(node)

    def visit_GlobalFunction(self, node: TaiheAST.GlobalFunction) -> Any:
        return self.visit_SpecField(node)

    def visit_Union(self, node: TaiheAST.Union) -> Any:
        return self.visit_SpecField(node)

    def visit_Interface(self, node: TaiheAST.Interface) -> Any:
        return self.visit_SpecField(node)

    def visit_Enum(self, node: TaiheAST.Enum) -> Any:
        return self.visit_SpecField(node)

    def visit_SpecField(self, node: TaiheAST.SpecField) -> Any:
        raise NotImplementedError()

    def visit_EnumProperty(self, node: TaiheAST.EnumProperty) -> Any:
        return self.visit_EnumItem(node)

    def visit_EnumItem(self, node: TaiheAST.EnumItem) -> Any:
        raise NotImplementedError()

    def visit_StructProperty(self, node: TaiheAST.StructProperty) -> Any:
        return self.visit_StructField(node)

    def visit_StructField(self, node: TaiheAST.StructField) -> Any:
        raise NotImplementedError()

    def visit_UnionProperty(self, node: TaiheAST.UnionProperty) -> Any:
        return self.visit_UnionField(node)

    def visit_UnionField(self, node: TaiheAST.UnionField) -> Any:
        raise NotImplementedError()

    def visit_InterfaceFunction(self, node: TaiheAST.InterfaceFunction) -> Any:
        return self.visit_InterfaceField(node)

    def visit_InterfaceField(self, node: TaiheAST.InterfaceField) -> Any:
        raise NotImplementedError()

    def visit_InterfaceParent(self, node: TaiheAST.InterfaceParent) -> Any:
        raise NotImplementedError()

    def visit_Parameter(self, node: TaiheAST.Parameter) -> Any:
        raise NotImplementedError()

    def visit_SimpleAttrItem(self, node: TaiheAST.SimpleAttrItem) -> Any:
        return self.visit_AttrItem(node)

    def visit_TupleAttrItem(self, node: TaiheAST.TupleAttrItem) -> Any:
        return self.visit_AttrItem(node)

    def visit_AttrItem(self, node: TaiheAST.AttrItem) -> Any:
        raise NotImplementedError()

    def visit_FloatAttrVal(self, node: TaiheAST.FloatAttrVal) -> Any:
        return self.visit_AttrVal(node)

    def visit_BoolAttrVal(self, node: TaiheAST.BoolAttrVal) -> Any:
        return self.visit_AttrVal(node)

    def visit_StringAttrVal(self, node: TaiheAST.StringAttrVal) -> Any:
        return self.visit_AttrVal(node)

    def visit_IntAttrVal(self, node: TaiheAST.IntAttrVal) -> Any:
        return self.visit_AttrVal(node)

    def visit_AttrVal(self, node: TaiheAST.AttrVal) -> Any:
        raise NotImplementedError()

    def visit_ShortType(self, node: TaiheAST.ShortType) -> Any:
        return self.visit_Type(node)

    def visit_GenericType(self, node: TaiheAST.GenericType) -> Any:
        return self.visit_Type(node)

    def visit_LongType(self, node: TaiheAST.LongType) -> Any:
        return self.visit_Type(node)

    def visit_CallbackType(self, node: TaiheAST.CallbackType) -> Any:
        return self.visit_Type(node)

    def visit_Type(self, node: TaiheAST.Type) -> Any:
        raise NotImplementedError()

    def visit_ParenthesisFloatExpr(self, node: TaiheAST.ParenthesisFloatExpr) -> Any:
        return self.visit_FloatExpr(node)

    def visit_BinaryFloatExpr(self, node: TaiheAST.BinaryFloatExpr) -> Any:
        return self.visit_FloatExpr(node)

    def visit_UnaryFloatExpr(self, node: TaiheAST.UnaryFloatExpr) -> Any:
        return self.visit_FloatExpr(node)

    def visit_ConditionalFloatExpr(self, node: TaiheAST.ConditionalFloatExpr) -> Any:
        return self.visit_FloatExpr(node)

    def visit_LiteralFloatExpr(self, node: TaiheAST.LiteralFloatExpr) -> Any:
        return self.visit_FloatExpr(node)

    def visit_FloatExpr(self, node: TaiheAST.FloatExpr) -> Any:
        raise NotImplementedError()

    def visit_ConditionalIntExpr(self, node: TaiheAST.ConditionalIntExpr) -> Any:
        return self.visit_IntExpr(node)

    def visit_ParenthesisIntExpr(self, node: TaiheAST.ParenthesisIntExpr) -> Any:
        return self.visit_IntExpr(node)

    def visit_UnaryIntExpr(self, node: TaiheAST.UnaryIntExpr) -> Any:
        return self.visit_IntExpr(node)

    def visit_BinaryIntExpr(self, node: TaiheAST.BinaryIntExpr) -> Any:
        return self.visit_IntExpr(node)

    def visit_LiteralIntExpr(self, node: TaiheAST.LiteralIntExpr) -> Any:
        return self.visit_IntExpr(node)

    def visit_BinaryIntShiftExpr(self, node: TaiheAST.BinaryIntShiftExpr) -> Any:
        return self.visit_IntExpr(node)

    def visit_IntExpr(self, node: TaiheAST.IntExpr) -> Any:
        raise NotImplementedError()

    def visit_ConditionalBoolExpr(self, node: TaiheAST.ConditionalBoolExpr) -> Any:
        return self.visit_BoolExpr(node)

    def visit_IntComparisonBoolExpr(self, node: TaiheAST.IntComparisonBoolExpr) -> Any:
        return self.visit_BoolExpr(node)

    def visit_ParenthesisBoolExpr(self, node: TaiheAST.ParenthesisBoolExpr) -> Any:
        return self.visit_BoolExpr(node)

    def visit_UnaryBoolExpr(self, node: TaiheAST.UnaryBoolExpr) -> Any:
        return self.visit_BoolExpr(node)

    def visit_LiteralBoolExpr(self, node: TaiheAST.LiteralBoolExpr) -> Any:
        return self.visit_BoolExpr(node)

    def visit_FloatComparisonBoolExpr(self, node: TaiheAST.FloatComparisonBoolExpr) -> Any:
        return self.visit_BoolExpr(node)

    def visit_BinaryBoolExpr(self, node: TaiheAST.BinaryBoolExpr) -> Any:
        return self.visit_BoolExpr(node)

    def visit_BoolExpr(self, node: TaiheAST.BoolExpr) -> Any:
        raise NotImplementedError()

    def visit_LiteralStringExpr(self, node: TaiheAST.LiteralStringExpr) -> Any:
        return self.visit_StringExpr(node)

    def visit_ParenthesisStringExpr(self, node: TaiheAST.ParenthesisStringExpr) -> Any:
        return self.visit_StringExpr(node)

    def visit_StringExpr(self, node: TaiheAST.StringExpr) -> Any:
        raise NotImplementedError()

