from dataclasses import dataclass
from typing import Any, Union, List, Optional


class TaiheAST:
    @dataclass(kw_only=True)
    class any:
        _beg: tuple[int, int]
        _end: tuple[int, int]

        def _accept(self, visitor) -> Any:
            raise NotImplementedError()


    @dataclass
    class token(any):
        text: str

        def __str__(self):
            return self.text

        def _accept(self, visitor) -> Any:
            return visitor.visit_token(self)

    @dataclass
    class Spec(any):
        uses: List["TaiheAST.Use"]
        fields: List["TaiheAST.SpecField"]
        attrs: List["TaiheAST.ScopeAttr"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_Spec(self)

    @dataclass
    class ScopeAttr(any):
        name: "TaiheAST.token"
        vals: List["TaiheAST.AttrVal"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_ScopeAttr(self)

    @dataclass
    class DeclAttr(any):
        name: "TaiheAST.token"
        vals: List["TaiheAST.AttrVal"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_DeclAttr(self)

    Use = Union[
        "TaiheAST.UsePackage",
        "TaiheAST.UseSymbol",
    ]

    @dataclass
    class PkgName(any):
        parts: List["TaiheAST.token"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_PkgName(self)

    @dataclass
    class DeclAliasPair(any):
        decl_name: "TaiheAST.token"
        decl_alias: Optional["TaiheAST.token"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_DeclAliasPair(self)

    SpecField = Union[
        "TaiheAST.Struct",
        "TaiheAST.GlobalFunction",
        "TaiheAST.Union",
        "TaiheAST.Interface",
        "TaiheAST.Enum",
    ]

    EnumItem = Union[
        "TaiheAST.EnumProperty",
    ]

    StructField = Union[
        "TaiheAST.StructProperty",
    ]

    UnionField = Union[
        "TaiheAST.UnionProperty",
    ]

    InterfaceField = Union[
        "TaiheAST.InterfaceFunction",
    ]

    @dataclass
    class InterfaceParent(any):
        attrs: List["TaiheAST.DeclAttr"]
        ty: "TaiheAST.Type"

        def _accept(self, visitor) -> Any:
            return visitor.visit_InterfaceParent(self)

    @dataclass
    class Parameter(any):
        attrs: List["TaiheAST.DeclAttr"]
        name: "TaiheAST.token"
        ty: "TaiheAST.Type"

        def _accept(self, visitor) -> Any:
            return visitor.visit_Parameter(self)

    AttrItem = Union[
        "TaiheAST.SimpleAttrItem",
        "TaiheAST.TupleAttrItem",
    ]

    AttrVal = Union[
        "TaiheAST.FloatAttrVal",
        "TaiheAST.BoolAttrVal",
        "TaiheAST.StringAttrVal",
        "TaiheAST.IntAttrVal",
    ]

    Type = Union[
        "TaiheAST.ShortType",
        "TaiheAST.GenericType",
        "TaiheAST.LongType",
        "TaiheAST.CallbackType",
    ]

    FloatExpr = Union[
        "TaiheAST.ParenthesisFloatExpr",
        "TaiheAST.BinaryFloatExpr",
        "TaiheAST.UnaryFloatExpr",
        "TaiheAST.ConditionalFloatExpr",
        "TaiheAST.LiteralFloatExpr",
    ]

    IntExpr = Union[
        "TaiheAST.ConditionalIntExpr",
        "TaiheAST.ParenthesisIntExpr",
        "TaiheAST.UnaryIntExpr",
        "TaiheAST.BinaryIntExpr",
        "TaiheAST.LiteralIntExpr",
        "TaiheAST.BinaryIntShiftExpr",
    ]

    BoolExpr = Union[
        "TaiheAST.ConditionalBoolExpr",
        "TaiheAST.IntComparisonBoolExpr",
        "TaiheAST.ParenthesisBoolExpr",
        "TaiheAST.UnaryBoolExpr",
        "TaiheAST.LiteralBoolExpr",
        "TaiheAST.FloatComparisonBoolExpr",
        "TaiheAST.BinaryBoolExpr",
    ]

    StringExpr = Union[
        "TaiheAST.LiteralStringExpr",
        "TaiheAST.ParenthesisStringExpr",
    ]

    @dataclass
    class UsePackage(any):
        pkg_name: "TaiheAST.PkgName"
        pkg_alias: Optional["TaiheAST.token"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_UsePackage(self)

    @dataclass
    class UseSymbol(any):
        pkg_name: "TaiheAST.PkgName"
        decl_alias_pairs: List["TaiheAST.DeclAliasPair"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_UseSymbol(self)

    @dataclass
    class Struct(any):
        declattrs: List["TaiheAST.DeclAttr"]
        name: "TaiheAST.token"
        fields: List["TaiheAST.StructField"]
        scopeattrs: List["TaiheAST.ScopeAttr"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_Struct(self)

    @dataclass
    class GlobalFunction(any):
        attrs: List["TaiheAST.DeclAttr"]
        name: "TaiheAST.token"
        parameters: List["TaiheAST.Parameter"]
        return_ty: Optional["TaiheAST.Type"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_GlobalFunction(self)

    @dataclass
    class Union(any):
        declattrs: List["TaiheAST.DeclAttr"]
        name: "TaiheAST.token"
        fields: List["TaiheAST.UnionField"]
        scopeattrs: List["TaiheAST.ScopeAttr"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_Union(self)

    @dataclass
    class Interface(any):
        declattrs: List["TaiheAST.DeclAttr"]
        name: "TaiheAST.token"
        extends: List["TaiheAST.InterfaceParent"]
        fields: List["TaiheAST.InterfaceField"]
        scopeattrs: List["TaiheAST.ScopeAttr"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_Interface(self)

    @dataclass
    class Enum(any):
        declattrs: List["TaiheAST.DeclAttr"]
        name: "TaiheAST.token"
        enum_ty: Optional["TaiheAST.Type"]
        fields: List["TaiheAST.EnumItem"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_Enum(self)

    @dataclass
    class EnumProperty(any):
        attrs: List["TaiheAST.DeclAttr"]
        name: "TaiheAST.token"
        val: Optional["TaiheAST.AttrVal"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_EnumProperty(self)

    @dataclass
    class StructProperty(any):
        attrs: List["TaiheAST.DeclAttr"]
        name: "TaiheAST.token"
        ty: "TaiheAST.Type"

        def _accept(self, visitor) -> Any:
            return visitor.visit_StructProperty(self)

    @dataclass
    class UnionProperty(any):
        attrs: List["TaiheAST.DeclAttr"]
        name: "TaiheAST.token"
        ty: Optional["TaiheAST.Type"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_UnionProperty(self)

    @dataclass
    class InterfaceFunction(any):
        attrs: List["TaiheAST.DeclAttr"]
        name: "TaiheAST.token"
        parameters: List["TaiheAST.Parameter"]
        return_ty: Optional["TaiheAST.Type"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_InterfaceFunction(self)

    @dataclass
    class SimpleAttrItem(any):
        name: "TaiheAST.token"
        val: Optional["TaiheAST.AttrVal"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_SimpleAttrItem(self)

    @dataclass
    class TupleAttrItem(any):
        name: "TaiheAST.token"
        vals: List["TaiheAST.AttrVal"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_TupleAttrItem(self)

    @dataclass
    class FloatAttrVal(any):
        expr: "TaiheAST.FloatExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_FloatAttrVal(self)

    @dataclass
    class BoolAttrVal(any):
        expr: "TaiheAST.BoolExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_BoolAttrVal(self)

    @dataclass
    class StringAttrVal(any):
        expr: "TaiheAST.StringExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_StringAttrVal(self)

    @dataclass
    class IntAttrVal(any):
        expr: "TaiheAST.IntExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_IntAttrVal(self)

    @dataclass
    class ShortType(any):
        decl_name: "TaiheAST.token"

        def _accept(self, visitor) -> Any:
            return visitor.visit_ShortType(self)

    @dataclass
    class GenericType(any):
        decl_name: "TaiheAST.token"
        args: List["TaiheAST.Type"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_GenericType(self)

    @dataclass
    class LongType(any):
        pkg_name: "TaiheAST.PkgName"
        decl_name: "TaiheAST.token"

        def _accept(self, visitor) -> Any:
            return visitor.visit_LongType(self)

    @dataclass
    class CallbackType(any):
        parameters: List["TaiheAST.Parameter"]
        return_ty: Optional["TaiheAST.Type"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_CallbackType(self)

    @dataclass
    class ParenthesisFloatExpr(any):
        expr: "TaiheAST.FloatExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_ParenthesisFloatExpr(self)

    @dataclass
    class BinaryFloatExpr(any):
        left: "TaiheAST.FloatExpr"
        op: "TaiheAST.token"
        right: "TaiheAST.FloatExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_BinaryFloatExpr(self)

    @dataclass
    class UnaryFloatExpr(any):
        op: "TaiheAST.token"
        expr: "TaiheAST.FloatExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_UnaryFloatExpr(self)

    @dataclass
    class ConditionalFloatExpr(any):
        cond: "TaiheAST.BoolExpr"
        then_expr: "TaiheAST.FloatExpr"
        else_expr: "TaiheAST.FloatExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_ConditionalFloatExpr(self)

    @dataclass
    class LiteralFloatExpr(any):
        val: "TaiheAST.token"

        def _accept(self, visitor) -> Any:
            return visitor.visit_LiteralFloatExpr(self)

    @dataclass
    class ConditionalIntExpr(any):
        cond: "TaiheAST.BoolExpr"
        then_expr: "TaiheAST.IntExpr"
        else_expr: "TaiheAST.IntExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_ConditionalIntExpr(self)

    @dataclass
    class ParenthesisIntExpr(any):
        expr: "TaiheAST.IntExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_ParenthesisIntExpr(self)

    @dataclass
    class UnaryIntExpr(any):
        op: "TaiheAST.token"
        expr: "TaiheAST.IntExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_UnaryIntExpr(self)

    @dataclass
    class BinaryIntExpr(any):
        left: "TaiheAST.IntExpr"
        op: "TaiheAST.token"
        right: "TaiheAST.IntExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_BinaryIntExpr(self)

    @dataclass
    class LiteralIntExpr(any):
        val: "TaiheAST.token"

        def _accept(self, visitor) -> Any:
            return visitor.visit_LiteralIntExpr(self)

    @dataclass
    class BinaryIntShiftExpr(any):
        left: "TaiheAST.IntExpr"
        ch: "TaiheAST.token"
        right: "TaiheAST.IntExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_BinaryIntShiftExpr(self)

    @dataclass
    class ConditionalBoolExpr(any):
        cond: "TaiheAST.BoolExpr"
        then_expr: "TaiheAST.BoolExpr"
        else_expr: "TaiheAST.BoolExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_ConditionalBoolExpr(self)

    @dataclass
    class IntComparisonBoolExpr(any):
        left: "TaiheAST.IntExpr"
        op: "TaiheAST.token"
        right: "TaiheAST.IntExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_IntComparisonBoolExpr(self)

    @dataclass
    class ParenthesisBoolExpr(any):
        expr: "TaiheAST.BoolExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_ParenthesisBoolExpr(self)

    @dataclass
    class UnaryBoolExpr(any):
        op: "TaiheAST.token"
        expr: "TaiheAST.BoolExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_UnaryBoolExpr(self)

    @dataclass
    class LiteralBoolExpr(any):
        val: "TaiheAST.token"

        def _accept(self, visitor) -> Any:
            return visitor.visit_LiteralBoolExpr(self)

    @dataclass
    class FloatComparisonBoolExpr(any):
        left: "TaiheAST.FloatExpr"
        op: "TaiheAST.token"
        right: "TaiheAST.FloatExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_FloatComparisonBoolExpr(self)

    @dataclass
    class BinaryBoolExpr(any):
        left: "TaiheAST.BoolExpr"
        op: "TaiheAST.token"
        right: "TaiheAST.BoolExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_BinaryBoolExpr(self)

    @dataclass
    class LiteralStringExpr(any):
        vals: List["TaiheAST.token"]

        def _accept(self, visitor) -> Any:
            return visitor.visit_LiteralStringExpr(self)

    @dataclass
    class ParenthesisStringExpr(any):
        expr: "TaiheAST.StringExpr"

        def _accept(self, visitor) -> Any:
            return visitor.visit_ParenthesisStringExpr(self)

