/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.app.Presentation;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

@TargetApi(value=17)
class SingleViewPresentation
extends Presentation {
    private final PlatformViewFactory viewFactory;
    private final AccessibilityEventsDelegate accessibilityEventsDelegate;
    private final View.OnFocusChangeListener focusChangeListener;
    private int viewId;
    private Object createParams;
    private AccessibilityDelegatingFrameLayout rootView;
    private FrameLayout container;
    private PresentationState state;
    private boolean startFocused = false;

    public SingleViewPresentation(Context outerContext, Display display, PlatformViewFactory viewFactory, AccessibilityEventsDelegate accessibilityEventsDelegate, int viewId, Object createParams, View.OnFocusChangeListener focusChangeListener) {
        super(outerContext, display);
        this.viewFactory = viewFactory;
        this.accessibilityEventsDelegate = accessibilityEventsDelegate;
        this.viewId = viewId;
        this.createParams = createParams;
        this.focusChangeListener = focusChangeListener;
        this.state = new PresentationState();
        this.getWindow().setFlags(8, 8);
    }

    public SingleViewPresentation(Context outerContext, Display display, AccessibilityEventsDelegate accessibilityEventsDelegate, PresentationState state, View.OnFocusChangeListener focusChangeListener, boolean startFocused) {
        super(outerContext, display);
        this.accessibilityEventsDelegate = accessibilityEventsDelegate;
        this.viewFactory = null;
        this.state = state;
        this.focusChangeListener = focusChangeListener;
        this.getWindow().setFlags(8, 8);
        this.startFocused = startFocused;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.state.fakeWindowViewGroup == null) {
            this.state.fakeWindowViewGroup = new FakeWindowViewGroup(this.getContext());
        }
        if (this.state.windowManagerHandler == null) {
            WindowManager windowManagerDelegate = (WindowManager)this.getContext().getSystemService("window");
            this.state.windowManagerHandler = new WindowManagerHandler(windowManagerDelegate, this.state.fakeWindowViewGroup);
        }
        this.container = new FrameLayout(this.getContext());
        PresentationContext context = new PresentationContext(this.getContext(), this.state.windowManagerHandler);
        if (this.state.platformView == null) {
            this.state.platformView = this.viewFactory.create((Context)context, this.viewId, this.createParams);
        }
        View embeddedView = this.state.platformView.getView();
        this.container.addView(embeddedView);
        this.rootView = new AccessibilityDelegatingFrameLayout(this.getContext(), this.accessibilityEventsDelegate, embeddedView);
        this.rootView.addView((View)this.container);
        this.rootView.addView((View)this.state.fakeWindowViewGroup);
        embeddedView.setOnFocusChangeListener(this.focusChangeListener);
        this.rootView.setFocusableInTouchMode(true);
        if (this.startFocused) {
            embeddedView.requestFocus();
        } else {
            this.rootView.requestFocus();
        }
        this.setContentView((View)this.rootView);
    }

    public PresentationState detachState() {
        this.container.removeAllViews();
        this.rootView.removeAllViews();
        return this.state;
    }

    public PlatformView getView() {
        if (this.state.platformView == null) {
            return null;
        }
        return this.state.platformView;
    }

    private static class AccessibilityDelegatingFrameLayout
    extends FrameLayout {
        private final AccessibilityEventsDelegate accessibilityEventsDelegate;
        private final View embeddedView;

        public AccessibilityDelegatingFrameLayout(Context context, AccessibilityEventsDelegate accessibilityEventsDelegate, View embeddedView) {
            super(context);
            this.accessibilityEventsDelegate = accessibilityEventsDelegate;
            this.embeddedView = embeddedView;
        }

        public boolean requestSendAccessibilityEvent(View child, AccessibilityEvent event) {
            return this.accessibilityEventsDelegate.requestSendAccessibilityEvent(this.embeddedView, child, event);
        }
    }

    static class WindowManagerHandler
    implements InvocationHandler {
        private static final String TAG = "PlatformViewsController";
        private final WindowManager delegate;
        FakeWindowViewGroup fakeWindowRootView;

        WindowManagerHandler(WindowManager delegate, FakeWindowViewGroup fakeWindowViewGroup) {
            this.delegate = delegate;
            this.fakeWindowRootView = fakeWindowViewGroup;
        }

        public WindowManager getWindowManager() {
            return (WindowManager)Proxy.newProxyInstance(WindowManager.class.getClassLoader(), new Class[]{WindowManager.class}, (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "addView": {
                    this.addView(args);
                    return null;
                }
                case "removeView": {
                    this.removeView(args);
                    return null;
                }
                case "removeViewImmediate": {
                    this.removeViewImmediate(args);
                    return null;
                }
                case "updateViewLayout": {
                    this.updateViewLayout(args);
                    return null;
                }
            }
            try {
                return method.invoke((Object)this.delegate, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private void addView(Object[] args) {
            if (this.fakeWindowRootView == null) {
                Log.w((String)TAG, (String)"Embedded view called addView while detached from presentation");
                return;
            }
            View view = (View)args[0];
            WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)args[1];
            this.fakeWindowRootView.addView(view, (ViewGroup.LayoutParams)layoutParams);
        }

        private void removeView(Object[] args) {
            if (this.fakeWindowRootView == null) {
                Log.w((String)TAG, (String)"Embedded view called removeView while detached from presentation");
                return;
            }
            View view = (View)args[0];
            this.fakeWindowRootView.removeView(view);
        }

        private void removeViewImmediate(Object[] args) {
            if (this.fakeWindowRootView == null) {
                Log.w((String)TAG, (String)"Embedded view called removeViewImmediate while detached from presentation");
                return;
            }
            View view = (View)args[0];
            view.clearAnimation();
            this.fakeWindowRootView.removeView(view);
        }

        private void updateViewLayout(Object[] args) {
            if (this.fakeWindowRootView == null) {
                Log.w((String)TAG, (String)"Embedded view called updateViewLayout while detached from presentation");
                return;
            }
            View view = (View)args[0];
            WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)args[1];
            this.fakeWindowRootView.updateViewLayout(view, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    static class PresentationContext
    extends ContextWrapper {
        private WindowManager windowManager;
        private final WindowManagerHandler windowManagerHandler;

        PresentationContext(Context base, WindowManagerHandler windowManagerHandler) {
            super(base);
            this.windowManagerHandler = windowManagerHandler;
        }

        public Object getSystemService(String name) {
            if ("window".equals(name)) {
                return this.getWindowManager();
            }
            return super.getSystemService(name);
        }

        private WindowManager getWindowManager() {
            if (this.windowManager == null) {
                this.windowManager = this.windowManagerHandler.getWindowManager();
            }
            return this.windowManager;
        }
    }

    static class FakeWindowViewGroup
    extends ViewGroup {
        private final Rect viewBounds = new Rect();
        private final Rect childRect = new Rect();

        public FakeWindowViewGroup(Context context) {
            super(context);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                WindowManager.LayoutParams params = (WindowManager.LayoutParams)child.getLayoutParams();
                this.viewBounds.set(l, t, r, b);
                Gravity.apply((int)params.gravity, (int)child.getMeasuredWidth(), (int)child.getMeasuredHeight(), (Rect)this.viewBounds, (int)params.x, (int)params.y, (Rect)this.childRect);
                child.layout(this.childRect.left, this.childRect.top, this.childRect.right, this.childRect.bottom);
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                child.measure(FakeWindowViewGroup.atMost(widthMeasureSpec), FakeWindowViewGroup.atMost(heightMeasureSpec));
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }

        private static int atMost(int measureSpec) {
            return View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)measureSpec), (int)Integer.MIN_VALUE);
        }
    }

    static class PresentationState {
        private PlatformView platformView;
        private WindowManagerHandler windowManagerHandler;
        private FakeWindowViewGroup fakeWindowViewGroup;

        PresentationState() {
        }
    }
}

