/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.plugins.shim;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.plugins.shim.ShimRegistrar;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugin.platform.PlatformViewsController;
import io.flutter.view.FlutterView;
import java.util.HashMap;
import java.util.Map;

public class ShimPluginRegistry
implements PluginRegistry {
    private static final String TAG = "ShimPluginRegistry";
    private final FlutterEngine flutterEngine;
    private final PlatformViewsController platformViewsController;
    private final Map<String, Object> pluginMap = new HashMap<String, Object>();
    private final FlutterEngine.EngineLifecycleListener engineLifecycleListener = new FlutterEngine.EngineLifecycleListener(){

        @Override
        public void onPreEngineRestart() {
            Log.v(ShimPluginRegistry.TAG, "onPreEngineRestart()");
            ShimPluginRegistry.this.onPreEngineRestart();
        }
    };

    public ShimPluginRegistry(@NonNull FlutterEngine flutterEngine, @NonNull PlatformViewsController platformViewsController) {
        this.flutterEngine = flutterEngine;
        this.flutterEngine.addEngineLifecycleListener(this.engineLifecycleListener);
        this.platformViewsController = platformViewsController;
    }

    @Override
    public PluginRegistry.Registrar registrarFor(String pluginKey) {
        Log.v(TAG, "Creating plugin Registrar for '" + pluginKey + "'");
        if (this.pluginMap.containsKey(pluginKey)) {
            throw new IllegalStateException("Plugin key " + pluginKey + " is already in use");
        }
        this.pluginMap.put(pluginKey, null);
        ShimRegistrar registrar = new ShimRegistrar(pluginKey, this.pluginMap);
        this.flutterEngine.getPlugins().add(registrar);
        return registrar;
    }

    @Override
    public boolean hasPlugin(String pluginKey) {
        return this.pluginMap.containsKey(pluginKey);
    }

    @Override
    public <T> T valuePublishedByPlugin(String pluginKey) {
        return (T)this.pluginMap.get(pluginKey);
    }

    public void attach(FlutterView flutterView, Activity activity) {
        Log.v(TAG, "Attaching to a FlutterView and an Activity.");
        this.platformViewsController.attach((Context)activity, this.flutterEngine.getRenderer(), this.flutterEngine.getDartExecutor());
    }

    public void detach() {
        Log.v(TAG, "Detaching from a FlutterView and an Activity.");
        this.platformViewsController.detach();
        this.platformViewsController.onFlutterViewDestroyed();
    }

    private void onPreEngineRestart() {
        this.platformViewsController.onPreEngineRestart();
    }

    public PlatformViewsController getPlatformViewsController() {
        return this.platformViewsController;
    }
}

