/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.arch.lifecycle.DefaultLifecycleObserver;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LifecycleRegistry;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

final class FlutterEngineAndroidLifecycle
extends LifecycleRegistry {
    private static final String TAG = "FlutterEngineAndroidLifecycle";
    @Nullable
    private Lifecycle backingLifecycle;
    private boolean isDestroyed = false;
    @NonNull
    private final LifecycleObserver forwardingObserver = new DefaultLifecycleObserver(){

        public void onCreate(@NonNull LifecycleOwner owner) {
        }

        public void onStart(@NonNull LifecycleOwner owner) {
            FlutterEngineAndroidLifecycle.this.handleLifecycleEvent(Lifecycle.Event.ON_START);
        }

        public void onResume(@NonNull LifecycleOwner owner) {
            FlutterEngineAndroidLifecycle.this.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
        }

        public void onPause(@NonNull LifecycleOwner owner) {
            FlutterEngineAndroidLifecycle.this.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
        }

        public void onStop(@NonNull LifecycleOwner owner) {
            FlutterEngineAndroidLifecycle.this.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
        }

        public void onDestroy(@NonNull LifecycleOwner owner) {
        }
    };

    FlutterEngineAndroidLifecycle(@NonNull LifecycleOwner provider) {
        super(provider);
    }

    public void setBackingLifecycle(@Nullable Lifecycle lifecycle) {
        this.ensureNotDestroyed();
        if (this.backingLifecycle != null) {
            this.backingLifecycle.removeObserver(this.forwardingObserver);
        }
        this.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
        this.backingLifecycle = lifecycle;
        if (this.backingLifecycle != null) {
            lifecycle.addObserver(this.forwardingObserver);
        }
    }

    public void handleLifecycleEvent(@NonNull Lifecycle.Event event) {
        this.ensureNotDestroyed();
        super.handleLifecycleEvent(event);
    }

    public void destroy() {
        this.ensureNotDestroyed();
        this.setBackingLifecycle(null);
        this.markState(Lifecycle.State.DESTROYED);
        this.isDestroyed = true;
    }

    private void ensureNotDestroyed() {
        if (this.isDestroyed) {
            throw new IllegalStateException("Tried to invoke a method on a destroyed FlutterEngineAndroidLifecycle.");
        }
    }
}

