/* SPDX-License-Identifier: GPL-2.0-or-later
 * CV1835 ADC driver on CVITEK CV1835
 *
 * Copyright 2019 CVITEK
 *
 * Author: EthanChen
 *
 */

#ifndef __CV182XADAC_H__
#define __CV182XADAC_H__

#include <linux/clk.h>
#include <linux/miscdevice.h>

#define  CV182X_ADC_BASE_OFFSET	0x100

#define  AUDIO_PHY_TXDAC_CTRL0  0x0
#define  AUDIO_PHY_TXDAC_CTRL1  0x4
#define  AUDIO_PHY_TXDAC_STATUS  0x8
#define  AUDIO_PHY_TXDAC_AFE0  0xc
#define  AUDIO_PHY_TXDAC_AFE1  0x10
#define  AUDIO_PHY_TXDAC_ANA0  0x20
#define  AUDIO_PHY_TXDAC_ANA1  0x24
#define  AUDIO_PHY_TXDAC_ANA2  0x28
#define  AUDIO_PHY_TXDAC_ANA3  0x2c
#define  AUDIO_PHY_TXDAC_TEST  0x30
#define  AUDIO_PHY_RXADC_CTRL0  (0x100 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_RXADC_CTRL1  (0x104 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_RXADC_STATUS  (0x108 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_RXADC_ANA0  (0x110 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_RXADC_ANA1  (0x114 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_RXADC_ANA2  (0x118 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_RXADC_ANA3  (0x11c - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_RXADC_ANA4  (0x120 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_RXADC_ANA5  (0x124 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_RXADC_ANA6  (0x128 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_GPIO_ANA  (0x12c - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_SPARE_0  (0xff0 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_SPARE_1  (0xff4 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_SPARE_RO  (0xff8 - CV182X_ADC_BASE_OFFSET)
#define  AUDIO_PHY_DATE_CODE  (0xffc - CV182X_ADC_BASE_OFFSET)

#define  AUDIO_PHY_REG_TXDAC_EN   0x0
#define  AUDIO_PHY_REG_TXDAC_EN_OFFSET 0
#define  AUDIO_PHY_REG_TXDAC_EN_MASK   0x1
#define  AUDIO_PHY_REG_TXDAC_EN_BITS   0x1
#define  AUDIO_PHY_REG_I2S_RX_EN   0x0
#define  AUDIO_PHY_REG_I2S_RX_EN_OFFSET 1
#define  AUDIO_PHY_REG_I2S_RX_EN_MASK   0x2
#define  AUDIO_PHY_REG_I2S_RX_EN_BITS   0x1
#define  AUDIO_PHY_REG_TXDAC_EN_ON		0x1
#define  AUDIO_PHY_REG_TXDAC_EN_OFF		0xFFFFFFFE
#define  AUDIO_PHY_REG_I2S_RX_EN_ON		0x2
#define  AUDIO_PHY_REG_I2S_RX_EN_OFF	0xFFFFFFFD

#define  AUDIO_PHY_REG_TXDAC_CIC_OPT   0x4
#define  AUDIO_PHY_REG_TXDAC_CIC_OPT_OFFSET 0
#define  AUDIO_PHY_REG_TXDAC_CIC_OPT_MASK   0x1
#define  AUDIO_PHY_REG_TXDAC_CIC_OPT_BITS   0x1
#define  TXDAC_CIC_DS_64	0xFFFFFFFE
#define  TXDAC_CIC_DS_128	0x00000001
#define  AUDIO_PHY_REG_TXDAC_FSM_SRC_SEL   0x4
#define  AUDIO_PHY_REG_TXDAC_FSM_SRC_SEL_OFFSET 1
#define  AUDIO_PHY_REG_TXDAC_FSM_SRC_SEL_MASK   0x2
#define  AUDIO_PHY_REG_TXDAC_FSM_SRC_SEL_BITS   0x1
#define  AUDIO_PHY_REG_TXDAC_DEM_TYPE   0x4
#define  AUDIO_PHY_REG_TXDAC_DEM_TYPE_OFFSET 4
#define  AUDIO_PHY_REG_TXDAC_DEM_TYPE_MASK   0x30
#define  AUDIO_PHY_REG_TXDAC_DEM_TYPE_BITS   0x2
#define  AUDIO_PHY_REG_TXDAC_DSM_OPT   0x4
#define  AUDIO_PHY_REG_TXDAC_DSM_OPT_OFFSET 8
#define  AUDIO_PHY_REG_TXDAC_DSM_OPT_MASK   0x100
#define  AUDIO_PHY_REG_TXDAC_DSM_OPT_BITS   0x1
#define  AUDIO_PHY_REG_TXDAC_DITHER_OPT   0x4
#define  AUDIO_PHY_REG_TXDAC_DITHER_OPT_OFFSET 12
#define  AUDIO_PHY_REG_TXDAC_DITHER_OPT_MASK   0x7000
#define  AUDIO_PHY_REG_TXDAC_DITHER_OPT_BITS   0x3

#define  AUDIO_PHY_REG_TXDAC_FSM   0x8
#define  AUDIO_PHY_REG_TXDAC_FSM_OFFSET 0
#define  AUDIO_PHY_REG_TXDAC_FSM_MASK   0x7
#define  AUDIO_PHY_REG_TXDAC_FSM_BITS   0x3
#define  AUDIO_PHY_REG_TXDAC_AFE_FSM   0x8
#define  AUDIO_PHY_REG_TXDAC_AFE_FSM_OFFSET 4
#define  AUDIO_PHY_REG_TXDAC_AFE_FSM_MASK   0x70
#define  AUDIO_PHY_REG_TXDAC_AFE_FSM_BITS   0x3
#define  AUDIO_PHY_REG_TXDAC_GAIN0   0x8
#define  AUDIO_PHY_REG_TXDAC_GAIN0_OFFSET 8
#define  AUDIO_PHY_REG_TXDAC_GAIN0_MASK   0x1ff00
#define  AUDIO_PHY_REG_TXDAC_GAIN0_BITS   0x9
#define  AUDIO_PHY_REG_TXDAC_GAIN1   0x8
#define  AUDIO_PHY_REG_TXDAC_GAIN1_OFFSET 20
#define  AUDIO_PHY_REG_TXDAC_GAIN1_MASK   0x1ff00000
#define  AUDIO_PHY_REG_TXDAC_GAIN1_BITS   0x9
#define  AUDIO_PHY_REG_TXDAC_TICK_NUM   0xc
#define  AUDIO_PHY_REG_TXDAC_TICK_NUM_OFFSET 0
#define  AUDIO_PHY_REG_TXDAC_TICK_NUM_MASK   0xff
#define  AUDIO_PHY_REG_TXDAC_TICK_NUM_BITS   0x8

#define  AUDIO_PHY_REG_TXDAC_GAIN_UB_0   0x10
#define  AUDIO_PHY_REG_TXDAC_GAIN_UB_0_OFFSET 0
#define  AUDIO_PHY_REG_TXDAC_GAIN_UB_0_MASK   0x1ff
#define  AUDIO_PHY_REG_TXDAC_GAIN_UB_0_BITS   0x9
#define  AUDIO_PHY_REG_TXDAC_GAIN_UB_1   0x10
#define  AUDIO_PHY_REG_TXDAC_GAIN_UB_1_OFFSET 16
#define  AUDIO_PHY_REG_TXDAC_GAIN_UB_1_MASK   0x1ff0000
#define  AUDIO_PHY_REG_TXDAC_GAIN_UB_1_BITS   0x9
#define  AUDIO_PHY_REG_TXDAC_RAMP_BP   0x10
#define  AUDIO_PHY_REG_TXDAC_RAMP_BP_OFFSET 28
#define  AUDIO_PHY_REG_TXDAC_RAMP_BP_MASK   0x10000000
#define  AUDIO_PHY_REG_TXDAC_RAMP_BP_BITS   0x1

#define  AUDIO_PHY_REG_ADDI_TXDAC   0x20
#define  AUDIO_PHY_REG_ADDI_TXDAC_OFFSET 0
#define  AUDIO_PHY_REG_ADDI_TXDAC_MASK   0x1
#define  AUDIO_PHY_REG_ADDI_TXDAC_BITS   0x1
#define  ADDI_TXDAC_GAIN_RATIO_1	0xFFFFFFFE
#define  ADDI_TXDAC_GAIN_RATIO_2_5	0x00000001
#define  AUDIO_PHY_REG_TSEL_TXDAC   0x20
#define  AUDIO_PHY_REG_TSEL_TXDAC_OFFSET 4
#define  AUDIO_PHY_REG_TSEL_TXDAC_MASK   0x30
#define  AUDIO_PHY_REG_TSEL_TXDAC_BITS   0x2
#define  AUDIO_PHY_REG_VSEL_TXDAC   0x20
#define  AUDIO_PHY_REG_VSEL_TXDAC_OFFSET 8
#define  AUDIO_PHY_REG_VSEL_TXDAC_MASK   0x300
#define  AUDIO_PHY_REG_VSEL_TXDAC_BITS   0x2

#define  AUDIO_PHY_REG_DA_EN_TXDAC_OW_VAL   0x24
#define  AUDIO_PHY_REG_DA_EN_TXDAC_OW_VAL_OFFSET 0
#define  AUDIO_PHY_REG_DA_EN_TXDAC_OW_VAL_MASK   0x1
#define  AUDIO_PHY_REG_DA_EN_TXDAC_OW_VAL_BITS   0x1
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_OW_VAL   0x24
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_OW_VAL_OFFSET 1
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_OW_VAL_MASK   0x2
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_OW_VAL_BITS   0x1
#define  AUDIO_PHY_REG_DA_EN_TXDAC_OW_EN   0x24
#define  AUDIO_PHY_REG_DA_EN_TXDAC_OW_EN_OFFSET 16
#define  AUDIO_PHY_REG_DA_EN_TXDAC_OW_EN_MASK   0x10000
#define  AUDIO_PHY_REG_DA_EN_TXDAC_OW_EN_BITS   0x1
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_OW_EN   0x24
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_OW_EN_OFFSET 17
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_OW_EN_MASK   0x20000
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_OW_EN_BITS   0x1
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_OW_VAL   0x28
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_OW_VAL_OFFSET 0
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_OW_VAL_MASK   0xff
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_OW_VAL_BITS   0x8

#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_OW_VAL   0x28
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_OW_VAL_OFFSET 8
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_OW_VAL_MASK   0xff00
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_OW_VAL_BITS   0x8
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_OW_EN   0x28
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_OW_EN_OFFSET 16
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_OW_EN_MASK   0x10000
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_OW_EN_BITS   0x1
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_OW_EN   0x28
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_OW_EN_OFFSET 17
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_OW_EN_MASK   0x20000
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_OW_EN_BITS   0x1
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_OW_EN_ON   0x10000
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_OW_EN_OFF  0xFFFEFFFF
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_OW_EN_ON   0x20000
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_OW_EN_OFF  0xFFFDFFFF

#define  AUDIO_PHY_REG_DA_EN_TXDAC_STATUS   0x2c
#define  AUDIO_PHY_REG_DA_EN_TXDAC_STATUS_OFFSET 0
#define  AUDIO_PHY_REG_DA_EN_TXDAC_STATUS_MASK   0x1
#define  AUDIO_PHY_REG_DA_EN_TXDAC_STATUS_BITS   0x1
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_STATUS   0x2c
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_STATUS_OFFSET 1
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_STATUS_MASK   0x2
#define  AUDIO_PHY_REG_DA_END2US_TXDAC_STATUS_BITS   0x1
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_STATUS   0x2c
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_STATUS_OFFSET 16
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_STATUS_MASK   0xff0000
#define  AUDIO_PHY_REG_DA_DEML_TXDAC_STATUS_BITS   0x8
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_STATUS   0x2c
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_STATUS_OFFSET 24
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_STATUS_MASK   0xff000000
#define  AUDIO_PHY_REG_DA_DEMR_TXDAC_STATUS_BITS   0x8
#define  AUDIO_PHY_REG_TXDAC_I2S_BP   0x30
#define  AUDIO_PHY_REG_TXDAC_I2S_BP_OFFSET 0
#define  AUDIO_PHY_REG_TXDAC_I2S_BP_MASK   0x1
#define  AUDIO_PHY_REG_TXDAC_I2S_BP_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_TO_TXDAC   0x30
#define  AUDIO_PHY_REG_RXADC_TO_TXDAC_OFFSET 1
#define  AUDIO_PHY_REG_RXADC_TO_TXDAC_MASK   0x2
#define  AUDIO_PHY_REG_RXADC_TO_TXDAC_BITS   0x1

#define  AUDIO_PHY_REG_RXADC_EN   0x100
#define  AUDIO_PHY_REG_RXADC_EN_OFFSET 0
#define  AUDIO_PHY_REG_RXADC_EN_MASK   0x1
#define  AUDIO_PHY_REG_RXADC_EN_BITS   0x1
#define  AUDIO_PHY_REG_I2S_TX_EN   0x100
#define  AUDIO_PHY_REG_I2S_TX_EN_OFFSET 1
#define  AUDIO_PHY_REG_I2S_TX_EN_MASK   0x2
#define  AUDIO_PHY_REG_I2S_TX_EN_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_EN_ON		0x1
#define  AUDIO_PHY_REG_RXADC_EN_OFF		0xFFFFFFFE
#define  AUDIO_PHY_REG_I2S_TX_EN_ON		0x2
#define  AUDIO_PHY_REG_I2S_TX_EN_OFF	0xFFFFFFFD

#define  AUDIO_PHY_REG_RXADC_CIC_OPT   0x104
#define  AUDIO_PHY_REG_RXADC_CIC_OPT_OFFSET 0
#define  AUDIO_PHY_REG_RXADC_CIC_OPT_MASK   0x1
#define  AUDIO_PHY_REG_RXADC_CIC_OPT_BITS   0x1
#define  RXADC_CIC_DS_64	0xFFFFFFFE
#define  RXADC_CIC_DS_128	0x00000001
#define  AUDIO_PHY_REG_RXADC_FSM_SRC_SEL   0x104
#define  AUDIO_PHY_REG_RXADC_FSM_SRC_SEL_OFFSET 1
#define  AUDIO_PHY_REG_RXADC_FSM_SRC_SEL_MASK   0x2
#define  AUDIO_PHY_REG_RXADC_FSM_SRC_SEL_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_CHN_SWAP   0x104
#define  AUDIO_PHY_REG_RXADC_CHN_SWAP_OFFSET 2
#define  AUDIO_PHY_REG_RXADC_CHN_SWAP_MASK   0x4
#define  AUDIO_PHY_REG_RXADC_CHN_SWAP_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_SINGLE   0x104
#define  AUDIO_PHY_REG_RXADC_SINGLE_OFFSET 3
#define  AUDIO_PHY_REG_RXADC_SINGLE_MASK   0x8
#define  AUDIO_PHY_REG_RXADC_SINGLE_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_DCB_OPT   0x104
#define  AUDIO_PHY_REG_RXADC_DCB_OPT_OFFSET 4
#define  AUDIO_PHY_REG_RXADC_DCB_OPT_MASK   0x70
#define  AUDIO_PHY_REG_RXADC_DCB_OPT_BITS   0x3
#define  AUDIO_PHY_REG_RXADC_IGR_INIT   0x104
#define  AUDIO_PHY_REG_RXADC_IGR_INIT_OFFSET 8
#define  AUDIO_PHY_REG_RXADC_IGR_INIT_MASK   0x100
#define  AUDIO_PHY_REG_RXADC_IGR_INIT_BITS   0x1
#define  AUDIO_ADC_IGR_INIT_EN	0x100
#define  AUDIO_ADC_IGR_INIT_OFF	0xFFFFFEFF
#define  AUDIO_PHY_REG_RXADC_CLK_FORCE_EN   0x104
#define  AUDIO_PHY_REG_RXADC_CLK_FORCE_EN_OFFSET 9
#define  AUDIO_PHY_REG_RXADC_CLK_FORCE_EN_MASK   0x200
#define  AUDIO_PHY_REG_RXADC_CLK_FORCE_EN_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_CIC0_INIT_DONE   0x108
#define  AUDIO_PHY_REG_RXADC_CIC0_INIT_DONE_OFFSET 0
#define  AUDIO_PHY_REG_RXADC_CIC0_INIT_DONE_MASK   0x1
#define  AUDIO_PHY_REG_RXADC_CIC0_INIT_DONE_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_FIR1_0_INIT_DONE   0x108
#define  AUDIO_PHY_REG_RXADC_FIR1_0_INIT_DONE_OFFSET 1
#define  AUDIO_PHY_REG_RXADC_FIR1_0_INIT_DONE_MASK   0x2
#define  AUDIO_PHY_REG_RXADC_FIR1_0_INIT_DONE_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_FIR2_0_INIT_DONE   0x108
#define  AUDIO_PHY_REG_RXADC_FIR2_0_INIT_DONE_OFFSET 2
#define  AUDIO_PHY_REG_RXADC_FIR2_0_INIT_DONE_MASK   0x4
#define  AUDIO_PHY_REG_RXADC_FIR2_0_INIT_DONE_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_CIC1_INIT_DONE   0x108
#define  AUDIO_PHY_REG_RXADC_CIC1_INIT_DONE_OFFSET 4
#define  AUDIO_PHY_REG_RXADC_CIC1_INIT_DONE_MASK   0x10
#define  AUDIO_PHY_REG_RXADC_CIC1_INIT_DONE_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_FIR1_1_INIT_DONE   0x108
#define  AUDIO_PHY_REG_RXADC_FIR1_1_INIT_DONE_OFFSET 5
#define  AUDIO_PHY_REG_RXADC_FIR1_1_INIT_DONE_MASK   0x20
#define  AUDIO_PHY_REG_RXADC_FIR1_1_INIT_DONE_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_FIR2_1_INIT_DONE   0x108
#define  AUDIO_PHY_REG_RXADC_FIR2_1_INIT_DONE_OFFSET 6
#define  AUDIO_PHY_REG_RXADC_FIR2_1_INIT_DONE_MASK   0x40
#define  AUDIO_PHY_REG_RXADC_FIR2_1_INIT_DONE_BITS   0x1
#define  AUDIO_PHY_REG_RXADC_FSM   0x108
#define  AUDIO_PHY_REG_RXADC_FSM_OFFSET 8
#define  AUDIO_PHY_REG_RXADC_FSM_MASK   0x700
#define  AUDIO_PHY_REG_RXADC_FSM_BITS   0x3

#define  AUDIO_PHY_REG_GSTEPL_RXPGA   0x110
#define  AUDIO_PHY_REG_GSTEPL_RXPGA_OFFSET 0
#define  AUDIO_PHY_REG_GSTEPL_RXPGA_MASK   0x1fff
#define  AUDIO_PHY_REG_GSTEPL_RXPGA_BITS   0xd
#define  AUDIO_PHY_REG_G6DBL_RXPGA   0x110
#define  AUDIO_PHY_REG_G6DBL_RXPGA_OFFSET 13
#define  AUDIO_PHY_REG_G6DBL_RXPGA_MASK   0x2000
#define  AUDIO_PHY_REG_G6DBL_RXPGA_BITS   0x1
#define  AUDIO_PHY_REG_GAINL_RXADC   0x110
#define  AUDIO_PHY_REG_GAINL_RXADC_OFFSET 14
#define  AUDIO_PHY_REG_GAINL_RXADC_MASK   0xc000
#define  AUDIO_PHY_REG_GAINL_RXADC_BITS   0x2
#define  AUDIO_PHY_REG_GSTEPR_RXPGA   0x110
#define  AUDIO_PHY_REG_GSTEPR_RXPGA_OFFSET 16
#define  AUDIO_PHY_REG_GSTEPR_RXPGA_MASK   0x1fff0000
#define  AUDIO_PHY_REG_GSTEPR_RXPGA_BITS   0xd
#define  AUDIO_PHY_REG_G6DBR_RXPGA   0x110
#define  AUDIO_PHY_REG_G6DBR_RXPGA_OFFSET 29
#define  AUDIO_PHY_REG_G6DBR_RXPGA_MASK   0x20000000
#define  AUDIO_PHY_REG_G6DBR_RXPGA_BITS   0x1
#define  AUDIO_PHY_REG_GAINR_RXADC   0x110
#define  AUDIO_PHY_REG_GAINR_RXADC_OFFSET 30
#define  AUDIO_PHY_REG_GAINR_RXADC_MASK   0xc0000000
#define  AUDIO_PHY_REG_GAINR_RXADC_BITS   0x2
#define  AUDIO_PHY_REG_ADC_VOLL_MASK	  0xffff
#define  AUDIO_PHY_REG_ADC_VOLR_MASK	  0xffff0000

#define DAC_VOL_L_MASK		0x000001FF
#define CV182x_DAC_VOL_STEP	0x8
#define DAC_VOL_L(V) (V == 0 ? 0 : (V * CV182x_DAC_VOL_STEP) - 1)
#define DAC_VOL_R(V) ((V == 0 ? 0 : (V * CV182x_DAC_VOL_STEP) - 1) << 16)

#define  ADC_VOL_GAIN_0		0x0001 /* 0dB */
#define  ADC_VOL_GAIN_1		0x0002 /* 2dB */
#define  ADC_VOL_GAIN_2		0x0004 /* 4dB */
#define  ADC_VOL_GAIN_3		0x0008 /* 6dB */
#define  ADC_VOL_GAIN_4		0x0010 /* 8dB */
#define  ADC_VOL_GAIN_5		0x0020 /* 10dB */
#define  ADC_VOL_GAIN_6		0x0040 /* 12dB */
#define  ADC_VOL_GAIN_7		0x0080 /* 14dB */
#define  ADC_VOL_GAIN_8		0x0100 /* 16dB */
#define  ADC_VOL_GAIN_9		0x0200 /* 18dB */
#define  ADC_VOL_GAIN_10		0x0400 /* 20dB */
#define  ADC_VOL_GAIN_11		0x0800 /* 22dB */
#define  ADC_VOL_GAIN_12		0x1000 /* 24dB */
#define  ADC_VOL_GAIN_13		0x2400 /* 26dB */
#define  ADC_VOL_GAIN_14		0x2800 /* 28dB */
#define  ADC_VOL_GAIN_15		0x3000 /* 30dB */
#define  ADC_VOL_GAIN_16		0x6400 /* 32dB */
#define  ADC_VOL_GAIN_17		0x6800 /* 34dB */
#define  ADC_VOL_GAIN_18		0x7000 /* 36dB */
#define  ADC_VOL_GAIN_19		0xA400 /* 38dB */
#define  ADC_VOL_GAIN_20		0xA800 /* 40dB */
#define  ADC_VOL_GAIN_21		0xB000 /* 42dB */
#define  ADC_VOL_GAIN_22		0xE400 /* 44dB */
#define  ADC_VOL_GAIN_23		0xE800 /* 46dB */
#define  ADC_VOL_GAIN_24		0xF000 /* 48dB */

#define ADC_VOL_L(V) (ADC_VOL_GAIN_##V)
#define ADC_VOL_R(V) (ADC_VOL_GAIN_##V << 16)

#define  AUDIO_PHY_REG_GAINL_STATUS   0x114
#define  AUDIO_PHY_REG_GAINL_STATUS_OFFSET 0
#define  AUDIO_PHY_REG_GAINL_STATUS_MASK   0xffff
#define  AUDIO_PHY_REG_GAINL_STATUS_BITS   0x10
#define  AUDIO_PHY_REG_GAINR_STATUS   0x114
#define  AUDIO_PHY_REG_GAINR_STATUS_OFFSET 16
#define  AUDIO_PHY_REG_GAINR_STATUS_MASK   0xffff0000
#define  AUDIO_PHY_REG_GAINR_STATUS_BITS   0x10


#define  AUDIO_PHY_REG_MUTEL_RXPGA   0x118
#define  AUDIO_PHY_REG_MUTEL_RXPGA_OFFSET 0
#define  AUDIO_PHY_REG_MUTEL_RXPGA_MASK   0x1
#define  AUDIO_PHY_REG_MUTEL_RXPGA_BITS   0x1
#define  AUDIO_PHY_REG_MUTER_RXPGA   0x118
#define  AUDIO_PHY_REG_MUTER_RXPGA_OFFSET 1
#define  AUDIO_PHY_REG_MUTER_RXPGA_MASK   0x2
#define  AUDIO_PHY_REG_MUTER_RXPGA_BITS   0x1
#define  AUDIO_PHY_REG_DIFF_EN_RXPGA   0x118
#define  AUDIO_PHY_REG_DIFF_EN_RXPGA_OFFSET 16
#define  AUDIO_PHY_REG_DIFF_EN_RXPGA_MASK   0x10000
#define  AUDIO_PHY_REG_DIFF_EN_RXPGA_BITS   0x1
#define  AUDIO_PHY_REG_TRISTATE_RXPGA   0x118
#define  AUDIO_PHY_REG_TRISTATE_RXPGA_OFFSET 17
#define  AUDIO_PHY_REG_TRISTATE_RXPGA_MASK   0x20000
#define  AUDIO_PHY_REG_TRISTATE_RXPGA_BITS   0x1
#define  AUDIO_PHY_REG_MUTEL_ON   0x1
#define  AUDIO_PHY_REG_MUTEL_OFF  0xFFFFFFFE
#define  AUDIO_PHY_REG_MUTER_ON   0x2
#define  AUDIO_PHY_REG_MUTER_OFF  0xFFFFFFFD

#define  AUDIO_PHY_REG_ADDI_RXADC   0x11c
#define  AUDIO_PHY_REG_ADDI_RXADC_OFFSET 0
#define  AUDIO_PHY_REG_ADDI_RXADC_MASK   0x1
#define  AUDIO_PHY_REG_ADDI_RXADC_BITS   0x1
#define  AUDIO_PHY_REG_CKSEL_RXADC   0x11c
#define  AUDIO_PHY_REG_CKSEL_RXADC_OFFSET 1
#define  AUDIO_PHY_REG_CKSEL_RXADC_MASK   0x2
#define  AUDIO_PHY_REG_CKSEL_RXADC_BITS   0x1
#define  AUDIO_PHY_REG_EN_ASAR_I_RXADC   0x11c
#define  AUDIO_PHY_REG_EN_ASAR_I_RXADC_OFFSET 2
#define  AUDIO_PHY_REG_EN_ASAR_I_RXADC_MASK   0x4
#define  AUDIO_PHY_REG_EN_ASAR_I_RXADC_BITS   0x1
#define  AUDIO_PHY_REG_EN_ASAR_Q_RXADC   0x11c
#define  AUDIO_PHY_REG_EN_ASAR_Q_RXADC_OFFSET 3
#define  AUDIO_PHY_REG_EN_ASAR_Q_RXADC_MASK   0x8
#define  AUDIO_PHY_REG_EN_ASAR_Q_RXADC_BITS   0x1
#define  AUDIO_PHY_REG_DEM_TYPE_RXADC   0x11c
#define  AUDIO_PHY_REG_DEM_TYPE_RXADC_OFFSET 4
#define  AUDIO_PHY_REG_DEM_TYPE_RXADC_MASK   0x30
#define  AUDIO_PHY_REG_DEM_TYPE_RXADC_BITS   0x2
#define  AUDIO_PHY_REG_CTUNE_RXADC   0x11c
#define  AUDIO_PHY_REG_CTUNE_RXADC_OFFSET 8
#define  AUDIO_PHY_REG_CTUNE_RXADC_MASK   0xf00
#define  AUDIO_PHY_REG_CTUNE_RXADC_BITS   0x4
#define  RXADC_CTUNE_MCLK_4096	(0xF << AUDIO_PHY_REG_CTUNE_RXADC_OFFSET)
#define  RXADC_CTUNE_MCLK_5644	(0xA << AUDIO_PHY_REG_CTUNE_RXADC_OFFSET)
#define  RXADC_CTUNE_MCLK_8192	(0x4 << AUDIO_PHY_REG_CTUNE_RXADC_OFFSET)
#define  RXADC_CTUNE_MCLK_11298	(0xD << AUDIO_PHY_REG_CTUNE_RXADC_OFFSET)
#define  RXADC_CTUNE_MCLK_12288	(0xC << AUDIO_PHY_REG_CTUNE_RXADC_OFFSET)
#define  RXADC_CTUNE_MCLK_16384	(0x8 << AUDIO_PHY_REG_CTUNE_RXADC_OFFSET)
#define  AUDIO_PHY_REG_EN_DITHER_RXADC   0x11c
#define  AUDIO_PHY_REG_EN_DITHER_RXADC_OFFSET 12
#define  AUDIO_PHY_REG_EN_DITHER_RXADC_MASK   0x1000
#define  AUDIO_PHY_REG_EN_DITHER_RXADC_BITS   0x1
#define  AUDIO_PHY_REG_RSTSDM_RXADC   0x11c
#define  AUDIO_PHY_REG_RSTSDM_RXADC_OFFSET 13
#define  AUDIO_PHY_REG_RSTSDM_RXADC_MASK   0x2000
#define  AUDIO_PHY_REG_RSTSDM_RXADC_BITS   0x1
#define  AUDIO_PHY_REG_EN_VCMT_RXADC   0x11c
#define  AUDIO_PHY_REG_EN_VCMT_RXADC_OFFSET 14
#define  AUDIO_PHY_REG_EN_VCMT_RXADC_MASK   0x4000
#define  AUDIO_PHY_REG_EN_VCMT_RXADC_BITS   0x1
#define  AUDIO_PHY_REG_VLDO0P9_RXADC   0x11c
#define  AUDIO_PHY_REG_VLDO0P9_RXADC_OFFSET 16
#define  AUDIO_PHY_REG_VLDO0P9_RXADC_MASK   0x30000
#define  AUDIO_PHY_REG_VLDO0P9_RXADC_BITS   0x2
#define  AUDIO_PHY_REG_VLDO12_RXADC   0x11c
#define  AUDIO_PHY_REG_VLDO12_RXADC_OFFSET 18
#define  AUDIO_PHY_REG_VLDO12_RXADC_MASK   0xc0000
#define  AUDIO_PHY_REG_VLDO12_RXADC_BITS   0x2
#define  AUDIO_PHY_REG_RNLVL_RXADC   0x11c
#define  AUDIO_PHY_REG_RNLVL_RXADC_OFFSET 20
#define  AUDIO_PHY_REG_RNLVL_RXADC_MASK   0x300000
#define  AUDIO_PHY_REG_RNLVL_RXADC_BITS   0x2
#define  AUDIO_PHY_REG_DA_EN_RXPGA_STATUS   0x120
#define  AUDIO_PHY_REG_DA_EN_RXPGA_STATUS_OFFSET 0
#define  AUDIO_PHY_REG_DA_EN_RXPGA_STATUS_MASK   0x1
#define  AUDIO_PHY_REG_DA_EN_RXPGA_STATUS_BITS   0x1
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_STATUS   0x120
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_STATUS_OFFSET 1
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_STATUS_MASK   0x2
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_STATUS_BITS   0x1
#define  AUDIO_PHY_REG_DA_EN_RXADC_STATUS   0x120
#define  AUDIO_PHY_REG_DA_EN_RXADC_STATUS_OFFSET 2
#define  AUDIO_PHY_REG_DA_EN_RXADC_STATUS_MASK   0x4
#define  AUDIO_PHY_REG_DA_EN_RXADC_STATUS_BITS   0x1
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_STATUS   0x120
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_STATUS_OFFSET 3
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_STATUS_MASK   0x8
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_STATUS_BITS   0x1
#define  AUDIO_PHY_REG_AD_DOL_RXADC   0x120
#define  AUDIO_PHY_REG_AD_DOL_RXADC_OFFSET 16
#define  AUDIO_PHY_REG_AD_DOL_RXADC_MASK   0x70000
#define  AUDIO_PHY_REG_AD_DOL_RXADC_BITS   0x3
#define  AUDIO_PHY_REG_AD_DOR_RXADC   0x120
#define  AUDIO_PHY_REG_AD_DOR_RXADC_OFFSET 20
#define  AUDIO_PHY_REG_AD_DOR_RXADC_MASK   0x700000
#define  AUDIO_PHY_REG_AD_DOR_RXADC_BITS   0x3
#define  AUDIO_PHY_REG_TESTEN_AUDBIAS   0x124
#define  AUDIO_PHY_REG_TESTEN_AUDBIAS_OFFSET 0
#define  AUDIO_PHY_REG_TESTEN_AUDBIAS_MASK   0x1
#define  AUDIO_PHY_REG_TESTEN_AUDBIAS_BITS   0x1
#define  AUDIO_PHY_REG_TESTEN_RXPGA   0x124
#define  AUDIO_PHY_REG_TESTEN_RXPGA_OFFSET 1
#define  AUDIO_PHY_REG_TESTEN_RXPGA_MASK   0x2
#define  AUDIO_PHY_REG_TESTEN_RXPGA_BITS   0x1
#define  AUDIO_PHY_REG_TSEL_RXADC   0x124
#define  AUDIO_PHY_REG_TSEL_RXADC_OFFSET 2
#define  AUDIO_PHY_REG_TSEL_RXADC_MASK   0xc
#define  AUDIO_PHY_REG_TSEL_RXADC_BITS   0x2
#define  AUDIO_PHY_REG_AUD_VREF_FC   0x124
#define  AUDIO_PHY_REG_AUD_VREF_FC_OFFSET 8
#define  AUDIO_PHY_REG_AUD_VREF_FC_MASK   0x100
#define  AUDIO_PHY_REG_AUD_VREF_FC_BITS   0x1
#define  AUDIO_PHY_REG_DA_EN_RXPGA_OW_VAL   0x128
#define  AUDIO_PHY_REG_DA_EN_RXPGA_OW_VAL_OFFSET 0
#define  AUDIO_PHY_REG_DA_EN_RXPGA_OW_VAL_MASK   0x1
#define  AUDIO_PHY_REG_DA_EN_RXPGA_OW_VAL_BITS   0x1
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_OW_VAL   0x128
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_OW_VAL_OFFSET 1
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_OW_VAL_MASK   0x2
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_OW_VAL_BITS   0x1
#define  AUDIO_PHY_REG_DA_EN_RXADC_OW_VAL   0x128
#define  AUDIO_PHY_REG_DA_EN_RXADC_OW_VAL_OFFSET 2
#define  AUDIO_PHY_REG_DA_EN_RXADC_OW_VAL_MASK   0x4
#define  AUDIO_PHY_REG_DA_EN_RXADC_OW_VAL_BITS   0x1
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_OW_VAL   0x128
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_OW_VAL_OFFSET 3
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_OW_VAL_MASK   0x8
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_OW_VAL_BITS   0x1
#define  AUDIO_PHY_REG_DA_EN_RXPGA_OW_EN   0x128
#define  AUDIO_PHY_REG_DA_EN_RXPGA_OW_EN_OFFSET 16
#define  AUDIO_PHY_REG_DA_EN_RXPGA_OW_EN_MASK   0x10000
#define  AUDIO_PHY_REG_DA_EN_RXPGA_OW_EN_BITS   0x1
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_OW_EN   0x128
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_OW_EN_OFFSET 17
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_OW_EN_MASK   0x20000
#define  AUDIO_PHY_REG_DA_END2US_RXPGA_OW_EN_BITS   0x1
#define  AUDIO_PHY_REG_DA_EN_RXADC_OW_EN   0x128
#define  AUDIO_PHY_REG_DA_EN_RXADC_OW_EN_OFFSET 18
#define  AUDIO_PHY_REG_DA_EN_RXADC_OW_EN_MASK   0x40000
#define  AUDIO_PHY_REG_DA_EN_RXADC_OW_EN_BITS   0x1
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_OW_EN   0x128
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_OW_EN_OFFSET 19
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_OW_EN_MASK   0x80000
#define  AUDIO_PHY_REG_DA_EN_AUDBIAS_OW_EN_BITS   0x1
#define  AUDIO_PHY_REG_GPIO_IEN   0x12c
#define  AUDIO_PHY_REG_GPIO_IEN_OFFSET 0
#define  AUDIO_PHY_REG_GPIO_IEN_MASK   0xf
#define  AUDIO_PHY_REG_GPIO_IEN_BITS   0x4
#define  AUDIO_PHY_REG_GPIO_DRV   0x12c
#define  AUDIO_PHY_REG_GPIO_DRV_OFFSET 4
#define  AUDIO_PHY_REG_GPIO_DRV_MASK   0xf0
#define  AUDIO_PHY_REG_GPIO_DRV_BITS   0x4
#define  AUDIO_PHY_REG_GPIO_C   0x12c
#define  AUDIO_PHY_REG_GPIO_C_OFFSET 16
#define  AUDIO_PHY_REG_GPIO_C_MASK   0xf0000
#define  AUDIO_PHY_REG_GPIO_C_BITS   0x4

#define  AUDIO_PHY_REG_SPARE0   0xff0
#define  AUDIO_PHY_REG_SPARE0_OFFSET 0
#define  AUDIO_PHY_REG_SPARE0_MASK   0xffffffff
#define  AUDIO_PHY_REG_SPARE0_BITS   0x20
#define  AUDIO_ADC_SCK_DIV_MASK		0x00ff0000
#define  SPARE_SCK_DIV(l)		((l-1) << 16)

#define  AUDIO_PHY_REG_SPARE1   0xff4
#define  AUDIO_PHY_REG_SPARE1_OFFSET 0
#define  AUDIO_PHY_REG_SPARE1_MASK   0xffff
#define  AUDIO_PHY_REG_SPARE1_BITS   0x10
#define  AUDIO_PHY_REG_SPARE_RO   0xff8
#define  AUDIO_PHY_REG_SPARE_RO_OFFSET 0
#define  AUDIO_PHY_REG_SPARE_RO_MASK   0xffffffff
#define  AUDIO_PHY_REG_SPARE_RO_BITS   0x20
#define  AUDIO_PHY_REG_DATE_CODE   0xffc
#define  AUDIO_PHY_REG_DATE_CODE_OFFSET 0
#define  AUDIO_PHY_REG_DATE_CODE_MASK   0xffffffff
#define  AUDIO_PHY_REG_DATE_CODE_BITS   0x20

#define CVI_I2S_EN						0x18
#define CVI_I2S_CLK_CTRL0				0x60
#define CVI_I2S_CLK_CTRL1				0x64
#define CVI_I2S_MCLK_OUT_EN_MASK		0x00000080
#define CVI_I2S_MCLK_OUT_EN				BIT(7)
#define CVI_I2S_MCLK_OUT_OFF			0xFFFFFF7F
#define CVI_I2S_AU_EN_MASK				0x00000100
#define CVI_I2S_AU_EN					BIT(8)
#define CVI_I2S_AU_OFF					0xFFFFFEFF

#define CVI_I2S_MCLK_MASK		0x0000FFFF
#define CVI_I2S_MCLK_DIV(l)             ((l << 0) & 0x0000FFFF)


#ifdef CONFIG_PM_SLEEP
/* Store GPIO context across system-wide suspend/resume transitions */
struct cv182xadc_context {
	u32 ctl0;
	u32 ctl1;
	u32 status;
	u32 ana0;
	u32 ana2;
	u32 ana3;
};

struct cv182xdac_context {
	u32 ctl0;
	u32 ctl1;
	u32 afe0;
	u32 afe1;
	u32 ana0;
	u32 ana1;
	u32 ana2;
};
#endif

struct cv182xadc {
	void __iomem *adc_base;
	struct clk *clk;
	struct device *dev;
	struct miscdevice miscdev;
	void __iomem *mclk_source;
	struct mutex mutex;
#ifdef CONFIG_PM_SLEEP
	struct cv182xadc_context *reg_ctx;
#endif
};

struct cv182xdac {
	void __iomem *dac_base;
	struct clk *clk;
	struct device *dev;
	struct miscdevice miscdev;
	struct mutex mutex;
#ifdef CONFIG_PM_SLEEP
	struct cv182xdac_context *reg_ctx;
#endif
};

extern struct proc_dir_entry *proc_audio_dir;

#endif  /* __CV182XADAC_H__ */
