// Compiled by ClojureScript 1.9.229 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__26578__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__26578__auto__){
return or__26578__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__26578__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__26578__auto__)){
return or__26578__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__32686_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__32686_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__32691 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__32692 = null;
var count__32693 = (0);
var i__32694 = (0);
while(true){
if((i__32694 < count__32693)){
var n = cljs.core._nth.call(null,chunk__32692,i__32694);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__32695 = seq__32691;
var G__32696 = chunk__32692;
var G__32697 = count__32693;
var G__32698 = (i__32694 + (1));
seq__32691 = G__32695;
chunk__32692 = G__32696;
count__32693 = G__32697;
i__32694 = G__32698;
continue;
} else {
var temp__6747__auto__ = cljs.core.seq.call(null,seq__32691);
if(temp__6747__auto__){
var seq__32691__$1 = temp__6747__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32691__$1)){
var c__27481__auto__ = cljs.core.chunk_first.call(null,seq__32691__$1);
var G__32699 = cljs.core.chunk_rest.call(null,seq__32691__$1);
var G__32700 = c__27481__auto__;
var G__32701 = cljs.core.count.call(null,c__27481__auto__);
var G__32702 = (0);
seq__32691 = G__32699;
chunk__32692 = G__32700;
count__32693 = G__32701;
i__32694 = G__32702;
continue;
} else {
var n = cljs.core.first.call(null,seq__32691__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__32703 = cljs.core.next.call(null,seq__32691__$1);
var G__32704 = null;
var G__32705 = (0);
var G__32706 = (0);
seq__32691 = G__32703;
chunk__32692 = G__32704;
count__32693 = G__32705;
i__32694 = G__32706;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__32757_32768 = cljs.core.seq.call(null,deps);
var chunk__32758_32769 = null;
var count__32759_32770 = (0);
var i__32760_32771 = (0);
while(true){
if((i__32760_32771 < count__32759_32770)){
var dep_32772 = cljs.core._nth.call(null,chunk__32758_32769,i__32760_32771);
topo_sort_helper_STAR_.call(null,dep_32772,(depth + (1)),state);

var G__32773 = seq__32757_32768;
var G__32774 = chunk__32758_32769;
var G__32775 = count__32759_32770;
var G__32776 = (i__32760_32771 + (1));
seq__32757_32768 = G__32773;
chunk__32758_32769 = G__32774;
count__32759_32770 = G__32775;
i__32760_32771 = G__32776;
continue;
} else {
var temp__6747__auto___32777 = cljs.core.seq.call(null,seq__32757_32768);
if(temp__6747__auto___32777){
var seq__32757_32778__$1 = temp__6747__auto___32777;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32757_32778__$1)){
var c__27481__auto___32779 = cljs.core.chunk_first.call(null,seq__32757_32778__$1);
var G__32780 = cljs.core.chunk_rest.call(null,seq__32757_32778__$1);
var G__32781 = c__27481__auto___32779;
var G__32782 = cljs.core.count.call(null,c__27481__auto___32779);
var G__32783 = (0);
seq__32757_32768 = G__32780;
chunk__32758_32769 = G__32781;
count__32759_32770 = G__32782;
i__32760_32771 = G__32783;
continue;
} else {
var dep_32784 = cljs.core.first.call(null,seq__32757_32778__$1);
topo_sort_helper_STAR_.call(null,dep_32784,(depth + (1)),state);

var G__32785 = cljs.core.next.call(null,seq__32757_32778__$1);
var G__32786 = null;
var G__32787 = (0);
var G__32788 = (0);
seq__32757_32768 = G__32785;
chunk__32758_32769 = G__32786;
count__32759_32770 = G__32787;
i__32760_32771 = G__32788;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__32761){
var vec__32765 = p__32761;
var seq__32766 = cljs.core.seq.call(null,vec__32765);
var first__32767 = cljs.core.first.call(null,seq__32766);
var seq__32766__$1 = cljs.core.next.call(null,seq__32766);
var x = first__32767;
var xs = seq__32766__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__32765,seq__32766,first__32767,seq__32766__$1,x,xs,get_deps__$1){
return (function (p1__32707_SHARP_){
return clojure.set.difference.call(null,p1__32707_SHARP_,x);
});})(vec__32765,seq__32766,first__32767,seq__32766__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__32801 = cljs.core.seq.call(null,provides);
var chunk__32802 = null;
var count__32803 = (0);
var i__32804 = (0);
while(true){
if((i__32804 < count__32803)){
var prov = cljs.core._nth.call(null,chunk__32802,i__32804);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__32805_32813 = cljs.core.seq.call(null,requires);
var chunk__32806_32814 = null;
var count__32807_32815 = (0);
var i__32808_32816 = (0);
while(true){
if((i__32808_32816 < count__32807_32815)){
var req_32817 = cljs.core._nth.call(null,chunk__32806_32814,i__32808_32816);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32817,prov);

var G__32818 = seq__32805_32813;
var G__32819 = chunk__32806_32814;
var G__32820 = count__32807_32815;
var G__32821 = (i__32808_32816 + (1));
seq__32805_32813 = G__32818;
chunk__32806_32814 = G__32819;
count__32807_32815 = G__32820;
i__32808_32816 = G__32821;
continue;
} else {
var temp__6747__auto___32822 = cljs.core.seq.call(null,seq__32805_32813);
if(temp__6747__auto___32822){
var seq__32805_32823__$1 = temp__6747__auto___32822;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32805_32823__$1)){
var c__27481__auto___32824 = cljs.core.chunk_first.call(null,seq__32805_32823__$1);
var G__32825 = cljs.core.chunk_rest.call(null,seq__32805_32823__$1);
var G__32826 = c__27481__auto___32824;
var G__32827 = cljs.core.count.call(null,c__27481__auto___32824);
var G__32828 = (0);
seq__32805_32813 = G__32825;
chunk__32806_32814 = G__32826;
count__32807_32815 = G__32827;
i__32808_32816 = G__32828;
continue;
} else {
var req_32829 = cljs.core.first.call(null,seq__32805_32823__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32829,prov);

var G__32830 = cljs.core.next.call(null,seq__32805_32823__$1);
var G__32831 = null;
var G__32832 = (0);
var G__32833 = (0);
seq__32805_32813 = G__32830;
chunk__32806_32814 = G__32831;
count__32807_32815 = G__32832;
i__32808_32816 = G__32833;
continue;
}
} else {
}
}
break;
}

var G__32834 = seq__32801;
var G__32835 = chunk__32802;
var G__32836 = count__32803;
var G__32837 = (i__32804 + (1));
seq__32801 = G__32834;
chunk__32802 = G__32835;
count__32803 = G__32836;
i__32804 = G__32837;
continue;
} else {
var temp__6747__auto__ = cljs.core.seq.call(null,seq__32801);
if(temp__6747__auto__){
var seq__32801__$1 = temp__6747__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32801__$1)){
var c__27481__auto__ = cljs.core.chunk_first.call(null,seq__32801__$1);
var G__32838 = cljs.core.chunk_rest.call(null,seq__32801__$1);
var G__32839 = c__27481__auto__;
var G__32840 = cljs.core.count.call(null,c__27481__auto__);
var G__32841 = (0);
seq__32801 = G__32838;
chunk__32802 = G__32839;
count__32803 = G__32840;
i__32804 = G__32841;
continue;
} else {
var prov = cljs.core.first.call(null,seq__32801__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__32809_32842 = cljs.core.seq.call(null,requires);
var chunk__32810_32843 = null;
var count__32811_32844 = (0);
var i__32812_32845 = (0);
while(true){
if((i__32812_32845 < count__32811_32844)){
var req_32846 = cljs.core._nth.call(null,chunk__32810_32843,i__32812_32845);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32846,prov);

var G__32847 = seq__32809_32842;
var G__32848 = chunk__32810_32843;
var G__32849 = count__32811_32844;
var G__32850 = (i__32812_32845 + (1));
seq__32809_32842 = G__32847;
chunk__32810_32843 = G__32848;
count__32811_32844 = G__32849;
i__32812_32845 = G__32850;
continue;
} else {
var temp__6747__auto___32851__$1 = cljs.core.seq.call(null,seq__32809_32842);
if(temp__6747__auto___32851__$1){
var seq__32809_32852__$1 = temp__6747__auto___32851__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32809_32852__$1)){
var c__27481__auto___32853 = cljs.core.chunk_first.call(null,seq__32809_32852__$1);
var G__32854 = cljs.core.chunk_rest.call(null,seq__32809_32852__$1);
var G__32855 = c__27481__auto___32853;
var G__32856 = cljs.core.count.call(null,c__27481__auto___32853);
var G__32857 = (0);
seq__32809_32842 = G__32854;
chunk__32810_32843 = G__32855;
count__32811_32844 = G__32856;
i__32812_32845 = G__32857;
continue;
} else {
var req_32858 = cljs.core.first.call(null,seq__32809_32852__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32858,prov);

var G__32859 = cljs.core.next.call(null,seq__32809_32852__$1);
var G__32860 = null;
var G__32861 = (0);
var G__32862 = (0);
seq__32809_32842 = G__32859;
chunk__32810_32843 = G__32860;
count__32811_32844 = G__32861;
i__32812_32845 = G__32862;
continue;
}
} else {
}
}
break;
}

var G__32863 = cljs.core.next.call(null,seq__32801__$1);
var G__32864 = null;
var G__32865 = (0);
var G__32866 = (0);
seq__32801 = G__32863;
chunk__32802 = G__32864;
count__32803 = G__32865;
i__32804 = G__32866;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__32871_32875 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__32872_32876 = null;
var count__32873_32877 = (0);
var i__32874_32878 = (0);
while(true){
if((i__32874_32878 < count__32873_32877)){
var ns_32879 = cljs.core._nth.call(null,chunk__32872_32876,i__32874_32878);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_32879);

var G__32880 = seq__32871_32875;
var G__32881 = chunk__32872_32876;
var G__32882 = count__32873_32877;
var G__32883 = (i__32874_32878 + (1));
seq__32871_32875 = G__32880;
chunk__32872_32876 = G__32881;
count__32873_32877 = G__32882;
i__32874_32878 = G__32883;
continue;
} else {
var temp__6747__auto___32884 = cljs.core.seq.call(null,seq__32871_32875);
if(temp__6747__auto___32884){
var seq__32871_32885__$1 = temp__6747__auto___32884;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32871_32885__$1)){
var c__27481__auto___32886 = cljs.core.chunk_first.call(null,seq__32871_32885__$1);
var G__32887 = cljs.core.chunk_rest.call(null,seq__32871_32885__$1);
var G__32888 = c__27481__auto___32886;
var G__32889 = cljs.core.count.call(null,c__27481__auto___32886);
var G__32890 = (0);
seq__32871_32875 = G__32887;
chunk__32872_32876 = G__32888;
count__32873_32877 = G__32889;
i__32874_32878 = G__32890;
continue;
} else {
var ns_32891 = cljs.core.first.call(null,seq__32871_32885__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_32891);

var G__32892 = cljs.core.next.call(null,seq__32871_32885__$1);
var G__32893 = null;
var G__32894 = (0);
var G__32895 = (0);
seq__32871_32875 = G__32892;
chunk__32872_32876 = G__32893;
count__32873_32877 = G__32894;
i__32874_32878 = G__32895;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__26578__auto__ = goog.require__;
if(cljs.core.truth_(or__26578__auto__)){
return or__26578__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__32896__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__32896 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__32897__i = 0, G__32897__a = new Array(arguments.length -  0);
while (G__32897__i < G__32897__a.length) {G__32897__a[G__32897__i] = arguments[G__32897__i + 0]; ++G__32897__i;}
  args = new cljs.core.IndexedSeq(G__32897__a,0);
} 
return G__32896__delegate.call(this,args);};
G__32896.cljs$lang$maxFixedArity = 0;
G__32896.cljs$lang$applyTo = (function (arglist__32898){
var args = cljs.core.seq(arglist__32898);
return G__32896__delegate(args);
});
G__32896.cljs$core$IFn$_invoke$arity$variadic = G__32896__delegate;
return G__32896;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__32900 = cljs.core._EQ_;
var expr__32901 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__32900.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__32901))){
var path_parts = ((function (pred__32900,expr__32901){
return (function (p1__32899_SHARP_){
return clojure.string.split.call(null,p1__32899_SHARP_,/[\/\\]/);
});})(pred__32900,expr__32901))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__32900,expr__32901){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e32903){if((e32903 instanceof Error)){
var e = e32903;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e32903;

}
}})());
});
;})(path_parts,sep,root,pred__32900,expr__32901))
} else {
if(cljs.core.truth_(pred__32900.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__32901))){
return ((function (pred__32900,expr__32901){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__32900,expr__32901){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__32900,expr__32901))
);

return deferred.addErrback(((function (deferred,pred__32900,expr__32901){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__32900,expr__32901))
);
});
;})(pred__32900,expr__32901))
} else {
return ((function (pred__32900,expr__32901){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__32900,expr__32901))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__32904,callback){
var map__32907 = p__32904;
var map__32907__$1 = ((((!((map__32907 == null)))?((((map__32907.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32907.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32907):map__32907);
var file_msg = map__32907__$1;
var request_url = cljs.core.get.call(null,map__32907__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__32907,map__32907__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__32907,map__32907__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__29816__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto__){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto__){
return (function (state_32931){
var state_val_32932 = (state_32931[(1)]);
if((state_val_32932 === (7))){
var inst_32927 = (state_32931[(2)]);
var state_32931__$1 = state_32931;
var statearr_32933_32953 = state_32931__$1;
(statearr_32933_32953[(2)] = inst_32927);

(statearr_32933_32953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32932 === (1))){
var state_32931__$1 = state_32931;
var statearr_32934_32954 = state_32931__$1;
(statearr_32934_32954[(2)] = null);

(statearr_32934_32954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32932 === (4))){
var inst_32911 = (state_32931[(7)]);
var inst_32911__$1 = (state_32931[(2)]);
var state_32931__$1 = (function (){var statearr_32935 = state_32931;
(statearr_32935[(7)] = inst_32911__$1);

return statearr_32935;
})();
if(cljs.core.truth_(inst_32911__$1)){
var statearr_32936_32955 = state_32931__$1;
(statearr_32936_32955[(1)] = (5));

} else {
var statearr_32937_32956 = state_32931__$1;
(statearr_32937_32956[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32932 === (6))){
var state_32931__$1 = state_32931;
var statearr_32938_32957 = state_32931__$1;
(statearr_32938_32957[(2)] = null);

(statearr_32938_32957[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32932 === (3))){
var inst_32929 = (state_32931[(2)]);
var state_32931__$1 = state_32931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32931__$1,inst_32929);
} else {
if((state_val_32932 === (2))){
var state_32931__$1 = state_32931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32931__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_32932 === (11))){
var inst_32923 = (state_32931[(2)]);
var state_32931__$1 = (function (){var statearr_32939 = state_32931;
(statearr_32939[(8)] = inst_32923);

return statearr_32939;
})();
var statearr_32940_32958 = state_32931__$1;
(statearr_32940_32958[(2)] = null);

(statearr_32940_32958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32932 === (9))){
var inst_32917 = (state_32931[(9)]);
var inst_32915 = (state_32931[(10)]);
var inst_32919 = inst_32917.call(null,inst_32915);
var state_32931__$1 = state_32931;
var statearr_32941_32959 = state_32931__$1;
(statearr_32941_32959[(2)] = inst_32919);

(statearr_32941_32959[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32932 === (5))){
var inst_32911 = (state_32931[(7)]);
var inst_32913 = figwheel.client.file_reloading.blocking_load.call(null,inst_32911);
var state_32931__$1 = state_32931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32931__$1,(8),inst_32913);
} else {
if((state_val_32932 === (10))){
var inst_32915 = (state_32931[(10)]);
var inst_32921 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_32915);
var state_32931__$1 = state_32931;
var statearr_32942_32960 = state_32931__$1;
(statearr_32942_32960[(2)] = inst_32921);

(statearr_32942_32960[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32932 === (8))){
var inst_32917 = (state_32931[(9)]);
var inst_32911 = (state_32931[(7)]);
var inst_32915 = (state_32931[(2)]);
var inst_32916 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_32917__$1 = cljs.core.get.call(null,inst_32916,inst_32911);
var state_32931__$1 = (function (){var statearr_32943 = state_32931;
(statearr_32943[(9)] = inst_32917__$1);

(statearr_32943[(10)] = inst_32915);

return statearr_32943;
})();
if(cljs.core.truth_(inst_32917__$1)){
var statearr_32944_32961 = state_32931__$1;
(statearr_32944_32961[(1)] = (9));

} else {
var statearr_32945_32962 = state_32931__$1;
(statearr_32945_32962[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto__))
;
return ((function (switch__29702__auto__,c__29816__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__29703__auto__ = null;
var figwheel$client$file_reloading$state_machine__29703__auto____0 = (function (){
var statearr_32949 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32949[(0)] = figwheel$client$file_reloading$state_machine__29703__auto__);

(statearr_32949[(1)] = (1));

return statearr_32949;
});
var figwheel$client$file_reloading$state_machine__29703__auto____1 = (function (state_32931){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_32931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e32950){if((e32950 instanceof Object)){
var ex__29706__auto__ = e32950;
var statearr_32951_32963 = state_32931;
(statearr_32951_32963[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32931);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32950;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32964 = state_32931;
state_32931 = G__32964;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__29703__auto__ = function(state_32931){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__29703__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__29703__auto____1.call(this,state_32931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__29703__auto____0;
figwheel$client$file_reloading$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__29703__auto____1;
return figwheel$client$file_reloading$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto__))
})();
var state__29818__auto__ = (function (){var statearr_32952 = f__29817__auto__.call(null);
(statearr_32952[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto__);

return statearr_32952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto__))
);

return c__29816__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__32965,callback){
var map__32968 = p__32965;
var map__32968__$1 = ((((!((map__32968 == null)))?((((map__32968.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32968.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32968):map__32968);
var file_msg = map__32968__$1;
var namespace = cljs.core.get.call(null,map__32968__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__32968,map__32968__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__32968,map__32968__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__32970){
var map__32973 = p__32970;
var map__32973__$1 = ((((!((map__32973 == null)))?((((map__32973.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32973.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32973):map__32973);
var file_msg = map__32973__$1;
var namespace = cljs.core.get.call(null,map__32973__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__26566__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__26566__auto__){
var or__26578__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26578__auto__)){
return or__26578__auto__;
} else {
var or__26578__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26578__auto____$1)){
return or__26578__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__26566__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__32975,callback){
var map__32978 = p__32975;
var map__32978__$1 = ((((!((map__32978 == null)))?((((map__32978.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32978.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32978):map__32978);
var file_msg = map__32978__$1;
var request_url = cljs.core.get.call(null,map__32978__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__32978__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__29816__auto___33082 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___33082,out){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___33082,out){
return (function (state_33064){
var state_val_33065 = (state_33064[(1)]);
if((state_val_33065 === (1))){
var inst_33038 = cljs.core.seq.call(null,files);
var inst_33039 = cljs.core.first.call(null,inst_33038);
var inst_33040 = cljs.core.next.call(null,inst_33038);
var inst_33041 = files;
var state_33064__$1 = (function (){var statearr_33066 = state_33064;
(statearr_33066[(7)] = inst_33040);

(statearr_33066[(8)] = inst_33041);

(statearr_33066[(9)] = inst_33039);

return statearr_33066;
})();
var statearr_33067_33083 = state_33064__$1;
(statearr_33067_33083[(2)] = null);

(statearr_33067_33083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33065 === (2))){
var inst_33041 = (state_33064[(8)]);
var inst_33047 = (state_33064[(10)]);
var inst_33046 = cljs.core.seq.call(null,inst_33041);
var inst_33047__$1 = cljs.core.first.call(null,inst_33046);
var inst_33048 = cljs.core.next.call(null,inst_33046);
var inst_33049 = (inst_33047__$1 == null);
var inst_33050 = cljs.core.not.call(null,inst_33049);
var state_33064__$1 = (function (){var statearr_33068 = state_33064;
(statearr_33068[(11)] = inst_33048);

(statearr_33068[(10)] = inst_33047__$1);

return statearr_33068;
})();
if(inst_33050){
var statearr_33069_33084 = state_33064__$1;
(statearr_33069_33084[(1)] = (4));

} else {
var statearr_33070_33085 = state_33064__$1;
(statearr_33070_33085[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33065 === (3))){
var inst_33062 = (state_33064[(2)]);
var state_33064__$1 = state_33064;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33064__$1,inst_33062);
} else {
if((state_val_33065 === (4))){
var inst_33047 = (state_33064[(10)]);
var inst_33052 = figwheel.client.file_reloading.reload_js_file.call(null,inst_33047);
var state_33064__$1 = state_33064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33064__$1,(7),inst_33052);
} else {
if((state_val_33065 === (5))){
var inst_33058 = cljs.core.async.close_BANG_.call(null,out);
var state_33064__$1 = state_33064;
var statearr_33071_33086 = state_33064__$1;
(statearr_33071_33086[(2)] = inst_33058);

(statearr_33071_33086[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33065 === (6))){
var inst_33060 = (state_33064[(2)]);
var state_33064__$1 = state_33064;
var statearr_33072_33087 = state_33064__$1;
(statearr_33072_33087[(2)] = inst_33060);

(statearr_33072_33087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33065 === (7))){
var inst_33048 = (state_33064[(11)]);
var inst_33054 = (state_33064[(2)]);
var inst_33055 = cljs.core.async.put_BANG_.call(null,out,inst_33054);
var inst_33041 = inst_33048;
var state_33064__$1 = (function (){var statearr_33073 = state_33064;
(statearr_33073[(12)] = inst_33055);

(statearr_33073[(8)] = inst_33041);

return statearr_33073;
})();
var statearr_33074_33088 = state_33064__$1;
(statearr_33074_33088[(2)] = null);

(statearr_33074_33088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__29816__auto___33082,out))
;
return ((function (switch__29702__auto__,c__29816__auto___33082,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto____0 = (function (){
var statearr_33078 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33078[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto__);

(statearr_33078[(1)] = (1));

return statearr_33078;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto____1 = (function (state_33064){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_33064);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e33079){if((e33079 instanceof Object)){
var ex__29706__auto__ = e33079;
var statearr_33080_33089 = state_33064;
(statearr_33080_33089[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33064);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33079;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33090 = state_33064;
state_33064 = G__33090;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto__ = function(state_33064){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto____1.call(this,state_33064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___33082,out))
})();
var state__29818__auto__ = (function (){var statearr_33081 = f__29817__auto__.call(null);
(statearr_33081[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___33082);

return statearr_33081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___33082,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__33091,opts){
var map__33095 = p__33091;
var map__33095__$1 = ((((!((map__33095 == null)))?((((map__33095.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33095.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33095):map__33095);
var eval_body__$1 = cljs.core.get.call(null,map__33095__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__33095__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__26566__auto__ = eval_body__$1;
if(cljs.core.truth_(and__26566__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__26566__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e33097){var e = e33097;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6745__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__33098_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33098_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6745__auto__)){
var file_msg = temp__6745__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__33107){
var vec__33108 = p__33107;
var k = cljs.core.nth.call(null,vec__33108,(0),null);
var v = cljs.core.nth.call(null,vec__33108,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__33111){
var vec__33112 = p__33111;
var k = cljs.core.nth.call(null,vec__33112,(0),null);
var v = cljs.core.nth.call(null,vec__33112,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__33118,p__33119){
var map__33366 = p__33118;
var map__33366__$1 = ((((!((map__33366 == null)))?((((map__33366.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33366.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33366):map__33366);
var opts = map__33366__$1;
var before_jsload = cljs.core.get.call(null,map__33366__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__33366__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__33366__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__33367 = p__33119;
var map__33367__$1 = ((((!((map__33367 == null)))?((((map__33367.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33367.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33367):map__33367);
var msg = map__33367__$1;
var files = cljs.core.get.call(null,map__33367__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__33367__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__33367__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__29816__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_33520){
var state_val_33521 = (state_33520[(1)]);
if((state_val_33521 === (7))){
var inst_33383 = (state_33520[(7)]);
var inst_33384 = (state_33520[(8)]);
var inst_33382 = (state_33520[(9)]);
var inst_33381 = (state_33520[(10)]);
var inst_33389 = cljs.core._nth.call(null,inst_33382,inst_33384);
var inst_33390 = figwheel.client.file_reloading.eval_body.call(null,inst_33389,opts);
var inst_33391 = (inst_33384 + (1));
var tmp33522 = inst_33383;
var tmp33523 = inst_33382;
var tmp33524 = inst_33381;
var inst_33381__$1 = tmp33524;
var inst_33382__$1 = tmp33523;
var inst_33383__$1 = tmp33522;
var inst_33384__$1 = inst_33391;
var state_33520__$1 = (function (){var statearr_33525 = state_33520;
(statearr_33525[(7)] = inst_33383__$1);

(statearr_33525[(8)] = inst_33384__$1);

(statearr_33525[(11)] = inst_33390);

(statearr_33525[(9)] = inst_33382__$1);

(statearr_33525[(10)] = inst_33381__$1);

return statearr_33525;
})();
var statearr_33526_33612 = state_33520__$1;
(statearr_33526_33612[(2)] = null);

(statearr_33526_33612[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (20))){
var inst_33424 = (state_33520[(12)]);
var inst_33432 = figwheel.client.file_reloading.sort_files.call(null,inst_33424);
var state_33520__$1 = state_33520;
var statearr_33527_33613 = state_33520__$1;
(statearr_33527_33613[(2)] = inst_33432);

(statearr_33527_33613[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (27))){
var state_33520__$1 = state_33520;
var statearr_33528_33614 = state_33520__$1;
(statearr_33528_33614[(2)] = null);

(statearr_33528_33614[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (1))){
var inst_33373 = (state_33520[(13)]);
var inst_33370 = before_jsload.call(null,files);
var inst_33371 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_33372 = (function (){return ((function (inst_33373,inst_33370,inst_33371,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33115_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__33115_SHARP_);
});
;})(inst_33373,inst_33370,inst_33371,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33373__$1 = cljs.core.filter.call(null,inst_33372,files);
var inst_33374 = cljs.core.not_empty.call(null,inst_33373__$1);
var state_33520__$1 = (function (){var statearr_33529 = state_33520;
(statearr_33529[(14)] = inst_33371);

(statearr_33529[(13)] = inst_33373__$1);

(statearr_33529[(15)] = inst_33370);

return statearr_33529;
})();
if(cljs.core.truth_(inst_33374)){
var statearr_33530_33615 = state_33520__$1;
(statearr_33530_33615[(1)] = (2));

} else {
var statearr_33531_33616 = state_33520__$1;
(statearr_33531_33616[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (24))){
var state_33520__$1 = state_33520;
var statearr_33532_33617 = state_33520__$1;
(statearr_33532_33617[(2)] = null);

(statearr_33532_33617[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (39))){
var inst_33474 = (state_33520[(16)]);
var state_33520__$1 = state_33520;
var statearr_33533_33618 = state_33520__$1;
(statearr_33533_33618[(2)] = inst_33474);

(statearr_33533_33618[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (46))){
var inst_33515 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33534_33619 = state_33520__$1;
(statearr_33534_33619[(2)] = inst_33515);

(statearr_33534_33619[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (4))){
var inst_33418 = (state_33520[(2)]);
var inst_33419 = cljs.core.List.EMPTY;
var inst_33420 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_33419);
var inst_33421 = (function (){return ((function (inst_33418,inst_33419,inst_33420,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33116_SHARP_){
var and__26566__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33116_SHARP_);
if(cljs.core.truth_(and__26566__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__33116_SHARP_));
} else {
return and__26566__auto__;
}
});
;})(inst_33418,inst_33419,inst_33420,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33422 = cljs.core.filter.call(null,inst_33421,files);
var inst_33423 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_33424 = cljs.core.concat.call(null,inst_33422,inst_33423);
var state_33520__$1 = (function (){var statearr_33535 = state_33520;
(statearr_33535[(17)] = inst_33420);

(statearr_33535[(18)] = inst_33418);

(statearr_33535[(12)] = inst_33424);

return statearr_33535;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_33536_33620 = state_33520__$1;
(statearr_33536_33620[(1)] = (16));

} else {
var statearr_33537_33621 = state_33520__$1;
(statearr_33537_33621[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (15))){
var inst_33408 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33538_33622 = state_33520__$1;
(statearr_33538_33622[(2)] = inst_33408);

(statearr_33538_33622[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (21))){
var inst_33434 = (state_33520[(19)]);
var inst_33434__$1 = (state_33520[(2)]);
var inst_33435 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_33434__$1);
var state_33520__$1 = (function (){var statearr_33539 = state_33520;
(statearr_33539[(19)] = inst_33434__$1);

return statearr_33539;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33520__$1,(22),inst_33435);
} else {
if((state_val_33521 === (31))){
var inst_33518 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33520__$1,inst_33518);
} else {
if((state_val_33521 === (32))){
var inst_33474 = (state_33520[(16)]);
var inst_33479 = inst_33474.cljs$lang$protocol_mask$partition0$;
var inst_33480 = (inst_33479 & (64));
var inst_33481 = inst_33474.cljs$core$ISeq$;
var inst_33482 = (inst_33480) || (inst_33481);
var state_33520__$1 = state_33520;
if(cljs.core.truth_(inst_33482)){
var statearr_33540_33623 = state_33520__$1;
(statearr_33540_33623[(1)] = (35));

} else {
var statearr_33541_33624 = state_33520__$1;
(statearr_33541_33624[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (40))){
var inst_33495 = (state_33520[(20)]);
var inst_33494 = (state_33520[(2)]);
var inst_33495__$1 = cljs.core.get.call(null,inst_33494,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_33496 = cljs.core.get.call(null,inst_33494,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_33497 = cljs.core.not_empty.call(null,inst_33495__$1);
var state_33520__$1 = (function (){var statearr_33542 = state_33520;
(statearr_33542[(20)] = inst_33495__$1);

(statearr_33542[(21)] = inst_33496);

return statearr_33542;
})();
if(cljs.core.truth_(inst_33497)){
var statearr_33543_33625 = state_33520__$1;
(statearr_33543_33625[(1)] = (41));

} else {
var statearr_33544_33626 = state_33520__$1;
(statearr_33544_33626[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (33))){
var state_33520__$1 = state_33520;
var statearr_33545_33627 = state_33520__$1;
(statearr_33545_33627[(2)] = false);

(statearr_33545_33627[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (13))){
var inst_33394 = (state_33520[(22)]);
var inst_33398 = cljs.core.chunk_first.call(null,inst_33394);
var inst_33399 = cljs.core.chunk_rest.call(null,inst_33394);
var inst_33400 = cljs.core.count.call(null,inst_33398);
var inst_33381 = inst_33399;
var inst_33382 = inst_33398;
var inst_33383 = inst_33400;
var inst_33384 = (0);
var state_33520__$1 = (function (){var statearr_33546 = state_33520;
(statearr_33546[(7)] = inst_33383);

(statearr_33546[(8)] = inst_33384);

(statearr_33546[(9)] = inst_33382);

(statearr_33546[(10)] = inst_33381);

return statearr_33546;
})();
var statearr_33547_33628 = state_33520__$1;
(statearr_33547_33628[(2)] = null);

(statearr_33547_33628[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (22))){
var inst_33442 = (state_33520[(23)]);
var inst_33437 = (state_33520[(24)]);
var inst_33438 = (state_33520[(25)]);
var inst_33434 = (state_33520[(19)]);
var inst_33437__$1 = (state_33520[(2)]);
var inst_33438__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_33437__$1);
var inst_33439 = (function (){var all_files = inst_33434;
var res_SINGLEQUOTE_ = inst_33437__$1;
var res = inst_33438__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_33442,inst_33437,inst_33438,inst_33434,inst_33437__$1,inst_33438__$1,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33117_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__33117_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_33442,inst_33437,inst_33438,inst_33434,inst_33437__$1,inst_33438__$1,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33440 = cljs.core.filter.call(null,inst_33439,inst_33437__$1);
var inst_33441 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_33442__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_33441);
var inst_33443 = cljs.core.not_empty.call(null,inst_33442__$1);
var state_33520__$1 = (function (){var statearr_33548 = state_33520;
(statearr_33548[(23)] = inst_33442__$1);

(statearr_33548[(24)] = inst_33437__$1);

(statearr_33548[(25)] = inst_33438__$1);

(statearr_33548[(26)] = inst_33440);

return statearr_33548;
})();
if(cljs.core.truth_(inst_33443)){
var statearr_33549_33629 = state_33520__$1;
(statearr_33549_33629[(1)] = (23));

} else {
var statearr_33550_33630 = state_33520__$1;
(statearr_33550_33630[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (36))){
var state_33520__$1 = state_33520;
var statearr_33551_33631 = state_33520__$1;
(statearr_33551_33631[(2)] = false);

(statearr_33551_33631[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (41))){
var inst_33495 = (state_33520[(20)]);
var inst_33499 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_33500 = cljs.core.map.call(null,inst_33499,inst_33495);
var inst_33501 = cljs.core.pr_str.call(null,inst_33500);
var inst_33502 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_33501)].join('');
var inst_33503 = figwheel.client.utils.log.call(null,inst_33502);
var state_33520__$1 = state_33520;
var statearr_33552_33632 = state_33520__$1;
(statearr_33552_33632[(2)] = inst_33503);

(statearr_33552_33632[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (43))){
var inst_33496 = (state_33520[(21)]);
var inst_33506 = (state_33520[(2)]);
var inst_33507 = cljs.core.not_empty.call(null,inst_33496);
var state_33520__$1 = (function (){var statearr_33553 = state_33520;
(statearr_33553[(27)] = inst_33506);

return statearr_33553;
})();
if(cljs.core.truth_(inst_33507)){
var statearr_33554_33633 = state_33520__$1;
(statearr_33554_33633[(1)] = (44));

} else {
var statearr_33555_33634 = state_33520__$1;
(statearr_33555_33634[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (29))){
var inst_33442 = (state_33520[(23)]);
var inst_33474 = (state_33520[(16)]);
var inst_33437 = (state_33520[(24)]);
var inst_33438 = (state_33520[(25)]);
var inst_33440 = (state_33520[(26)]);
var inst_33434 = (state_33520[(19)]);
var inst_33470 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_33473 = (function (){var all_files = inst_33434;
var res_SINGLEQUOTE_ = inst_33437;
var res = inst_33438;
var files_not_loaded = inst_33440;
var dependencies_that_loaded = inst_33442;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33442,inst_33474,inst_33437,inst_33438,inst_33440,inst_33434,inst_33470,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__33472){
var map__33556 = p__33472;
var map__33556__$1 = ((((!((map__33556 == null)))?((((map__33556.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33556.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33556):map__33556);
var namespace = cljs.core.get.call(null,map__33556__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33442,inst_33474,inst_33437,inst_33438,inst_33440,inst_33434,inst_33470,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33474__$1 = cljs.core.group_by.call(null,inst_33473,inst_33440);
var inst_33476 = (inst_33474__$1 == null);
var inst_33477 = cljs.core.not.call(null,inst_33476);
var state_33520__$1 = (function (){var statearr_33558 = state_33520;
(statearr_33558[(16)] = inst_33474__$1);

(statearr_33558[(28)] = inst_33470);

return statearr_33558;
})();
if(inst_33477){
var statearr_33559_33635 = state_33520__$1;
(statearr_33559_33635[(1)] = (32));

} else {
var statearr_33560_33636 = state_33520__$1;
(statearr_33560_33636[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (44))){
var inst_33496 = (state_33520[(21)]);
var inst_33509 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_33496);
var inst_33510 = cljs.core.pr_str.call(null,inst_33509);
var inst_33511 = [cljs.core.str("not required: "),cljs.core.str(inst_33510)].join('');
var inst_33512 = figwheel.client.utils.log.call(null,inst_33511);
var state_33520__$1 = state_33520;
var statearr_33561_33637 = state_33520__$1;
(statearr_33561_33637[(2)] = inst_33512);

(statearr_33561_33637[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (6))){
var inst_33415 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33562_33638 = state_33520__$1;
(statearr_33562_33638[(2)] = inst_33415);

(statearr_33562_33638[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (28))){
var inst_33440 = (state_33520[(26)]);
var inst_33467 = (state_33520[(2)]);
var inst_33468 = cljs.core.not_empty.call(null,inst_33440);
var state_33520__$1 = (function (){var statearr_33563 = state_33520;
(statearr_33563[(29)] = inst_33467);

return statearr_33563;
})();
if(cljs.core.truth_(inst_33468)){
var statearr_33564_33639 = state_33520__$1;
(statearr_33564_33639[(1)] = (29));

} else {
var statearr_33565_33640 = state_33520__$1;
(statearr_33565_33640[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (25))){
var inst_33438 = (state_33520[(25)]);
var inst_33454 = (state_33520[(2)]);
var inst_33455 = cljs.core.not_empty.call(null,inst_33438);
var state_33520__$1 = (function (){var statearr_33566 = state_33520;
(statearr_33566[(30)] = inst_33454);

return statearr_33566;
})();
if(cljs.core.truth_(inst_33455)){
var statearr_33567_33641 = state_33520__$1;
(statearr_33567_33641[(1)] = (26));

} else {
var statearr_33568_33642 = state_33520__$1;
(statearr_33568_33642[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (34))){
var inst_33489 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
if(cljs.core.truth_(inst_33489)){
var statearr_33569_33643 = state_33520__$1;
(statearr_33569_33643[(1)] = (38));

} else {
var statearr_33570_33644 = state_33520__$1;
(statearr_33570_33644[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (17))){
var state_33520__$1 = state_33520;
var statearr_33571_33645 = state_33520__$1;
(statearr_33571_33645[(2)] = recompile_dependents);

(statearr_33571_33645[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (3))){
var state_33520__$1 = state_33520;
var statearr_33572_33646 = state_33520__$1;
(statearr_33572_33646[(2)] = null);

(statearr_33572_33646[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (12))){
var inst_33411 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33573_33647 = state_33520__$1;
(statearr_33573_33647[(2)] = inst_33411);

(statearr_33573_33647[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (2))){
var inst_33373 = (state_33520[(13)]);
var inst_33380 = cljs.core.seq.call(null,inst_33373);
var inst_33381 = inst_33380;
var inst_33382 = null;
var inst_33383 = (0);
var inst_33384 = (0);
var state_33520__$1 = (function (){var statearr_33574 = state_33520;
(statearr_33574[(7)] = inst_33383);

(statearr_33574[(8)] = inst_33384);

(statearr_33574[(9)] = inst_33382);

(statearr_33574[(10)] = inst_33381);

return statearr_33574;
})();
var statearr_33575_33648 = state_33520__$1;
(statearr_33575_33648[(2)] = null);

(statearr_33575_33648[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (23))){
var inst_33442 = (state_33520[(23)]);
var inst_33437 = (state_33520[(24)]);
var inst_33438 = (state_33520[(25)]);
var inst_33440 = (state_33520[(26)]);
var inst_33434 = (state_33520[(19)]);
var inst_33445 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_33447 = (function (){var all_files = inst_33434;
var res_SINGLEQUOTE_ = inst_33437;
var res = inst_33438;
var files_not_loaded = inst_33440;
var dependencies_that_loaded = inst_33442;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33442,inst_33437,inst_33438,inst_33440,inst_33434,inst_33445,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__33446){
var map__33576 = p__33446;
var map__33576__$1 = ((((!((map__33576 == null)))?((((map__33576.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33576.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33576):map__33576);
var request_url = cljs.core.get.call(null,map__33576__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33442,inst_33437,inst_33438,inst_33440,inst_33434,inst_33445,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33448 = cljs.core.reverse.call(null,inst_33442);
var inst_33449 = cljs.core.map.call(null,inst_33447,inst_33448);
var inst_33450 = cljs.core.pr_str.call(null,inst_33449);
var inst_33451 = figwheel.client.utils.log.call(null,inst_33450);
var state_33520__$1 = (function (){var statearr_33578 = state_33520;
(statearr_33578[(31)] = inst_33445);

return statearr_33578;
})();
var statearr_33579_33649 = state_33520__$1;
(statearr_33579_33649[(2)] = inst_33451);

(statearr_33579_33649[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (35))){
var state_33520__$1 = state_33520;
var statearr_33580_33650 = state_33520__$1;
(statearr_33580_33650[(2)] = true);

(statearr_33580_33650[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (19))){
var inst_33424 = (state_33520[(12)]);
var inst_33430 = figwheel.client.file_reloading.expand_files.call(null,inst_33424);
var state_33520__$1 = state_33520;
var statearr_33581_33651 = state_33520__$1;
(statearr_33581_33651[(2)] = inst_33430);

(statearr_33581_33651[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (11))){
var state_33520__$1 = state_33520;
var statearr_33582_33652 = state_33520__$1;
(statearr_33582_33652[(2)] = null);

(statearr_33582_33652[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (9))){
var inst_33413 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33583_33653 = state_33520__$1;
(statearr_33583_33653[(2)] = inst_33413);

(statearr_33583_33653[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (5))){
var inst_33383 = (state_33520[(7)]);
var inst_33384 = (state_33520[(8)]);
var inst_33386 = (inst_33384 < inst_33383);
var inst_33387 = inst_33386;
var state_33520__$1 = state_33520;
if(cljs.core.truth_(inst_33387)){
var statearr_33584_33654 = state_33520__$1;
(statearr_33584_33654[(1)] = (7));

} else {
var statearr_33585_33655 = state_33520__$1;
(statearr_33585_33655[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (14))){
var inst_33394 = (state_33520[(22)]);
var inst_33403 = cljs.core.first.call(null,inst_33394);
var inst_33404 = figwheel.client.file_reloading.eval_body.call(null,inst_33403,opts);
var inst_33405 = cljs.core.next.call(null,inst_33394);
var inst_33381 = inst_33405;
var inst_33382 = null;
var inst_33383 = (0);
var inst_33384 = (0);
var state_33520__$1 = (function (){var statearr_33586 = state_33520;
(statearr_33586[(32)] = inst_33404);

(statearr_33586[(7)] = inst_33383);

(statearr_33586[(8)] = inst_33384);

(statearr_33586[(9)] = inst_33382);

(statearr_33586[(10)] = inst_33381);

return statearr_33586;
})();
var statearr_33587_33656 = state_33520__$1;
(statearr_33587_33656[(2)] = null);

(statearr_33587_33656[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (45))){
var state_33520__$1 = state_33520;
var statearr_33588_33657 = state_33520__$1;
(statearr_33588_33657[(2)] = null);

(statearr_33588_33657[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (26))){
var inst_33442 = (state_33520[(23)]);
var inst_33437 = (state_33520[(24)]);
var inst_33438 = (state_33520[(25)]);
var inst_33440 = (state_33520[(26)]);
var inst_33434 = (state_33520[(19)]);
var inst_33457 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_33459 = (function (){var all_files = inst_33434;
var res_SINGLEQUOTE_ = inst_33437;
var res = inst_33438;
var files_not_loaded = inst_33440;
var dependencies_that_loaded = inst_33442;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33442,inst_33437,inst_33438,inst_33440,inst_33434,inst_33457,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__33458){
var map__33589 = p__33458;
var map__33589__$1 = ((((!((map__33589 == null)))?((((map__33589.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33589.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33589):map__33589);
var namespace = cljs.core.get.call(null,map__33589__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__33589__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33442,inst_33437,inst_33438,inst_33440,inst_33434,inst_33457,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33460 = cljs.core.map.call(null,inst_33459,inst_33438);
var inst_33461 = cljs.core.pr_str.call(null,inst_33460);
var inst_33462 = figwheel.client.utils.log.call(null,inst_33461);
var inst_33463 = (function (){var all_files = inst_33434;
var res_SINGLEQUOTE_ = inst_33437;
var res = inst_33438;
var files_not_loaded = inst_33440;
var dependencies_that_loaded = inst_33442;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33442,inst_33437,inst_33438,inst_33440,inst_33434,inst_33457,inst_33459,inst_33460,inst_33461,inst_33462,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33442,inst_33437,inst_33438,inst_33440,inst_33434,inst_33457,inst_33459,inst_33460,inst_33461,inst_33462,state_val_33521,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33464 = setTimeout(inst_33463,(10));
var state_33520__$1 = (function (){var statearr_33591 = state_33520;
(statearr_33591[(33)] = inst_33462);

(statearr_33591[(34)] = inst_33457);

return statearr_33591;
})();
var statearr_33592_33658 = state_33520__$1;
(statearr_33592_33658[(2)] = inst_33464);

(statearr_33592_33658[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (16))){
var state_33520__$1 = state_33520;
var statearr_33593_33659 = state_33520__$1;
(statearr_33593_33659[(2)] = reload_dependents);

(statearr_33593_33659[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (38))){
var inst_33474 = (state_33520[(16)]);
var inst_33491 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33474);
var state_33520__$1 = state_33520;
var statearr_33594_33660 = state_33520__$1;
(statearr_33594_33660[(2)] = inst_33491);

(statearr_33594_33660[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (30))){
var state_33520__$1 = state_33520;
var statearr_33595_33661 = state_33520__$1;
(statearr_33595_33661[(2)] = null);

(statearr_33595_33661[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (10))){
var inst_33394 = (state_33520[(22)]);
var inst_33396 = cljs.core.chunked_seq_QMARK_.call(null,inst_33394);
var state_33520__$1 = state_33520;
if(inst_33396){
var statearr_33596_33662 = state_33520__$1;
(statearr_33596_33662[(1)] = (13));

} else {
var statearr_33597_33663 = state_33520__$1;
(statearr_33597_33663[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (18))){
var inst_33428 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
if(cljs.core.truth_(inst_33428)){
var statearr_33598_33664 = state_33520__$1;
(statearr_33598_33664[(1)] = (19));

} else {
var statearr_33599_33665 = state_33520__$1;
(statearr_33599_33665[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (42))){
var state_33520__$1 = state_33520;
var statearr_33600_33666 = state_33520__$1;
(statearr_33600_33666[(2)] = null);

(statearr_33600_33666[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (37))){
var inst_33486 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33601_33667 = state_33520__$1;
(statearr_33601_33667[(2)] = inst_33486);

(statearr_33601_33667[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (8))){
var inst_33394 = (state_33520[(22)]);
var inst_33381 = (state_33520[(10)]);
var inst_33394__$1 = cljs.core.seq.call(null,inst_33381);
var state_33520__$1 = (function (){var statearr_33602 = state_33520;
(statearr_33602[(22)] = inst_33394__$1);

return statearr_33602;
})();
if(inst_33394__$1){
var statearr_33603_33668 = state_33520__$1;
(statearr_33603_33668[(1)] = (10));

} else {
var statearr_33604_33669 = state_33520__$1;
(statearr_33604_33669[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__29702__auto__,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto____0 = (function (){
var statearr_33608 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33608[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto__);

(statearr_33608[(1)] = (1));

return statearr_33608;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto____1 = (function (state_33520){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_33520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e33609){if((e33609 instanceof Object)){
var ex__29706__auto__ = e33609;
var statearr_33610_33670 = state_33520;
(statearr_33610_33670[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33520);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33609;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33671 = state_33520;
state_33520 = G__33671;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto__ = function(state_33520){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto____1.call(this,state_33520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__29818__auto__ = (function (){var statearr_33611 = f__29817__auto__.call(null);
(statearr_33611[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto__);

return statearr_33611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto__,map__33366,map__33366__$1,opts,before_jsload,on_jsload,reload_dependents,map__33367,map__33367__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__29816__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__33674,link){
var map__33677 = p__33674;
var map__33677__$1 = ((((!((map__33677 == null)))?((((map__33677.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33677.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33677):map__33677);
var file = cljs.core.get.call(null,map__33677__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6747__auto__ = link.href;
if(cljs.core.truth_(temp__6747__auto__)){
var link_href = temp__6747__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6747__auto__,map__33677,map__33677__$1,file){
return (function (p1__33672_SHARP_,p2__33673_SHARP_){
if(cljs.core._EQ_.call(null,p1__33672_SHARP_,p2__33673_SHARP_)){
return p1__33672_SHARP_;
} else {
return false;
}
});})(link_href,temp__6747__auto__,map__33677,map__33677__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6747__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__33683){
var map__33684 = p__33683;
var map__33684__$1 = ((((!((map__33684 == null)))?((((map__33684.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33684.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33684):map__33684);
var match_length = cljs.core.get.call(null,map__33684__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__33684__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__33679_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__33679_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6747__auto__)){
var res = temp__6747__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args33686 = [];
var len__27761__auto___33689 = arguments.length;
var i__27762__auto___33690 = (0);
while(true){
if((i__27762__auto___33690 < len__27761__auto___33689)){
args33686.push((arguments[i__27762__auto___33690]));

var G__33691 = (i__27762__auto___33690 + (1));
i__27762__auto___33690 = G__33691;
continue;
} else {
}
break;
}

var G__33688 = args33686.length;
switch (G__33688) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33686.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__33693_SHARP_,p2__33694_SHARP_){
return cljs.core.assoc.call(null,p1__33693_SHARP_,cljs.core.get.call(null,p2__33694_SHARP_,key),p2__33694_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__33695){
var map__33698 = p__33695;
var map__33698__$1 = ((((!((map__33698 == null)))?((((map__33698.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33698.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33698):map__33698);
var f_data = map__33698__$1;
var file = cljs.core.get.call(null,map__33698__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6747__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6747__auto__)){
var link = temp__6747__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__33700,p__33701){
var map__33710 = p__33700;
var map__33710__$1 = ((((!((map__33710 == null)))?((((map__33710.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33710.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33710):map__33710);
var opts = map__33710__$1;
var on_cssload = cljs.core.get.call(null,map__33710__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__33711 = p__33701;
var map__33711__$1 = ((((!((map__33711 == null)))?((((map__33711.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33711.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33711):map__33711);
var files_msg = map__33711__$1;
var files = cljs.core.get.call(null,map__33711__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__33714_33718 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__33715_33719 = null;
var count__33716_33720 = (0);
var i__33717_33721 = (0);
while(true){
if((i__33717_33721 < count__33716_33720)){
var f_33722 = cljs.core._nth.call(null,chunk__33715_33719,i__33717_33721);
figwheel.client.file_reloading.reload_css_file.call(null,f_33722);

var G__33723 = seq__33714_33718;
var G__33724 = chunk__33715_33719;
var G__33725 = count__33716_33720;
var G__33726 = (i__33717_33721 + (1));
seq__33714_33718 = G__33723;
chunk__33715_33719 = G__33724;
count__33716_33720 = G__33725;
i__33717_33721 = G__33726;
continue;
} else {
var temp__6747__auto___33727 = cljs.core.seq.call(null,seq__33714_33718);
if(temp__6747__auto___33727){
var seq__33714_33728__$1 = temp__6747__auto___33727;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33714_33728__$1)){
var c__27481__auto___33729 = cljs.core.chunk_first.call(null,seq__33714_33728__$1);
var G__33730 = cljs.core.chunk_rest.call(null,seq__33714_33728__$1);
var G__33731 = c__27481__auto___33729;
var G__33732 = cljs.core.count.call(null,c__27481__auto___33729);
var G__33733 = (0);
seq__33714_33718 = G__33730;
chunk__33715_33719 = G__33731;
count__33716_33720 = G__33732;
i__33717_33721 = G__33733;
continue;
} else {
var f_33734 = cljs.core.first.call(null,seq__33714_33728__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_33734);

var G__33735 = cljs.core.next.call(null,seq__33714_33728__$1);
var G__33736 = null;
var G__33737 = (0);
var G__33738 = (0);
seq__33714_33718 = G__33735;
chunk__33715_33719 = G__33736;
count__33716_33720 = G__33737;
i__33717_33721 = G__33738;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__33710,map__33710__$1,opts,on_cssload,map__33711,map__33711__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__33710,map__33710__$1,opts,on_cssload,map__33711,map__33711__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1479550493326