// Compiled by ClojureScript 1.8.34 {}
goog.provide('elastic_input.core');
goog.require('cljs.core');
goog.require('reagent.core');
elastic_input.core.escape = (function elastic_input$core$escape(txt){
return clojure.string.escape.call(null,txt,new cljs.core.PersistentArrayMap(null, 4, ["<","&lt;",">","&gt;","&","&amp;","\n","<br>"], null));
});
/**
 * Create a handler for component-did-mount and component-did-update
 */
elastic_input.core.focus_ctrl_factory = (function elastic_input$core$focus_ctrl_factory(focus_tracker,reset_scroll){
return (function (this$){
var n = reagent.core.dom_node.call(null,this$);
var _ = reset_scroll.call(null,n);
var map__19692 = cljs.core.deref.call(null,focus_tracker);
var map__19692__$1 = ((((!((map__19692 == null)))?((((map__19692.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19692.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19692):map__19692);
var curr = cljs.core.get.call(null,map__19692__$1,new cljs.core.Keyword(null,"curr","curr",-1092372808));
var prev = cljs.core.get.call(null,map__19692__$1,new cljs.core.Keyword(null,"prev","prev",-1597069226));
if(cljs.core.truth_((function (){var and__18406__auto__ = cljs.core.not.call(null,prev);
if(and__18406__auto__){
return curr;
} else {
return and__18406__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,focus_tracker,((function (n,_,map__19692,map__19692__$1,curr,prev){
return (function (p1__19688_SHARP_){
return cljs.core.assoc.call(null,p1__19688_SHARP_,new cljs.core.Keyword(null,"prev","prev",-1597069226),true);
});})(n,_,map__19692,map__19692__$1,curr,prev))
);

return n.focus();
} else {
if(cljs.core.truth_((function (){var and__18406__auto__ = prev;
if(cljs.core.truth_(and__18406__auto__)){
return cljs.core.not.call(null,curr);
} else {
return and__18406__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,focus_tracker,((function (n,_,map__19692,map__19692__$1,curr,prev){
return (function (p1__19689_SHARP_){
return cljs.core.assoc.call(null,p1__19689_SHARP_,new cljs.core.Keyword(null,"prev","prev",-1597069226),false);
});})(n,_,map__19692,map__19692__$1,curr,prev))
);

return n.blur();
} else {
return true;

}
}
});
});
elastic_input.core.phantom_ctrl_factory = (function elastic_input$core$phantom_ctrl_factory(inspect,report,display_style){
return (function (this$){
var n = reagent.core.dom_node.call(null,this$);
var _ = n.style.display = display_style;
var h = inspect.call(null,n);
var ___$1 = n.style.display = "none";
return report.call(null,h);
});
});
elastic_input.core.phantom_factory = (function elastic_input$core$phantom_factory(inspect,report,visible_style,sentinel_str){
var phantom_ctrl = elastic_input.core.phantom_ctrl_factory.call(null,inspect,report,visible_style);
return ((function (phantom_ctrl){
return (function (opts){
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (phantom_ctrl){
return (function (p__19697){
var map__19698 = p__19697;
var map__19698__$1 = ((((!((map__19698 == null)))?((((map__19698.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19698.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19698):map__19698);
var opts__$1 = map__19698__$1;
var text = cljs.core.get.call(null,map__19698__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var width = cljs.core.get.call(null,map__19698__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.call(null,map__19698__$1,new cljs.core.Keyword(null,"height","height",1025178622));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.phantom","div.phantom",212619045),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),width,new cljs.core.Keyword(null,"height","height",1025178622),height], null),new cljs.core.Keyword(null,"dangerouslySetInnerHTML","dangerouslySetInnerHTML",-554971138),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"__html","__html",674048345),[cljs.core.str(elastic_input.core.escape.call(null,text)),cljs.core.str(sentinel_str)].join('')], null)], null)], null);
});})(phantom_ctrl))
,new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),phantom_ctrl,new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),phantom_ctrl], null));
});
;})(phantom_ctrl))
});
elastic_input.core.scroll_l = (function elastic_input$core$scroll_l(dom_node){
return dom_node.scrollLeft = (0);
});
elastic_input.core.scroll_t = (function elastic_input$core$scroll_t(dom_node){
return dom_node.scrollTop = (0);
});
elastic_input.core.tgt_val = (function elastic_input$core$tgt_val(e){
return e.target.value;
});
elastic_input.core.input = (function elastic_input$core$input(opts){
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (p__19703){
var map__19704 = p__19703;
var map__19704__$1 = ((((!((map__19704 == null)))?((((map__19704.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19704.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19704):map__19704);
var opts__$1 = map__19704__$1;
var input_opts = cljs.core.get.call(null,map__19704__$1,new cljs.core.Keyword(null,"input-opts","input-opts",1688681135));
var text = cljs.core.get.call(null,map__19704__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var placeholder = cljs.core.get.call(null,map__19704__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var width = cljs.core.get.call(null,map__19704__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var on_text_change = cljs.core.get.call(null,map__19704__$1,new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456));
var on_blur = cljs.core.get.call(null,map__19704__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (map__19704,map__19704__$1,opts__$1,input_opts,text,placeholder,width,on_text_change){
return (function (){
return cljs.core.List.EMPTY;
});})(map__19704,map__19704__$1,opts__$1,input_opts,text,placeholder,width,on_text_change))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"value","value",305978217),text,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),width], null),new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.comp.call(null,on_text_change,elastic_input.core.tgt_val),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),cljs.core.comp.call(null,on_blur,elastic_input.core.tgt_val)], null))], null);
}),new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),cljs.core.comp.call(null,elastic_input.core.scroll_l,reagent.core.dom_node)], null));
});
elastic_input.core.textarea = (function elastic_input$core$textarea(opts){
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (p__19709){
var map__19710 = p__19709;
var map__19710__$1 = ((((!((map__19710 == null)))?((((map__19710.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19710.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19710):map__19710);
var opts__$1 = map__19710__$1;
var textarea_opts = cljs.core.get.call(null,map__19710__$1,new cljs.core.Keyword(null,"textarea-opts","textarea-opts",-942779061));
var text = cljs.core.get.call(null,map__19710__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var placeholder = cljs.core.get.call(null,map__19710__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var height = cljs.core.get.call(null,map__19710__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var width = cljs.core.get.call(null,map__19710__$1,new cljs.core.Keyword(null,"width","width",-384071477),null);
var on_text_change = cljs.core.get.call(null,map__19710__$1,new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456));
var on_blur = cljs.core.get.call(null,map__19710__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (map__19710,map__19710__$1,opts__$1,textarea_opts,text,placeholder,height,width,on_text_change){
return (function (){
return cljs.core.List.EMPTY;
});})(map__19710,map__19710__$1,opts__$1,textarea_opts,text,placeholder,height,width,on_text_change))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),cljs.core.merge.call(null,textarea_opts,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"value","value",305978217),text,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"width","width",-384071477),width], null),new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.comp.call(null,on_text_change,elastic_input.core.tgt_val),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),cljs.core.comp.call(null,on_blur,elastic_input.core.tgt_val)], null))], null);
}),new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),cljs.core.comp.call(null,elastic_input.core.scroll_t,reagent.core.dom_node)], null));
});
elastic_input.core.input_foc = (function elastic_input$core$input_foc(opts){
var focus_tracker = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"curr","curr",-1092372808),false,new cljs.core.Keyword(null,"prev","prev",-1597069226),false], null));
var focus_ctrl = elastic_input.core.focus_ctrl_factory.call(null,focus_tracker,elastic_input.core.scroll_l);
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (focus_tracker,focus_ctrl){
return (function (p__19716){
var map__19717 = p__19716;
var map__19717__$1 = ((((!((map__19717 == null)))?((((map__19717.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19717.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19717):map__19717);
var opts__$1 = map__19717__$1;
var focused_QMARK_ = cljs.core.get.call(null,map__19717__$1,new cljs.core.Keyword(null,"focused?","focused?",-1922723333));
if(cljs.core.not_EQ_.call(null,focused_QMARK_,new cljs.core.Keyword(null,"curr","curr",-1092372808).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,focus_tracker)))){
cljs.core.swap_BANG_.call(null,focus_tracker,((function (map__19717,map__19717__$1,opts__$1,focused_QMARK_,focus_tracker,focus_ctrl){
return (function (p1__19712_SHARP_){
return cljs.core.update_in.call(null,p1__19712_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"curr","curr",-1092372808)], null),cljs.core.not);
});})(map__19717,map__19717__$1,opts__$1,focused_QMARK_,focus_tracker,focus_ctrl))
);
} else {
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elastic_input.core.input,cljs.core.merge.call(null,opts__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input-opts","input-opts",1688681135),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(new cljs.core.Keyword(null,"curr","curr",-1092372808).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,focus_tracker)))?"active":"inactive")], null)], null))], null);
});})(focus_tracker,focus_ctrl))
,new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),focus_ctrl,new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),focus_ctrl], null));
});
elastic_input.core.textarea_foc = (function elastic_input$core$textarea_foc(opts){
var focus_tracker = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"prev","prev",-1597069226),false,new cljs.core.Keyword(null,"curr","curr",-1092372808),false], null));
var focus_ctrl = elastic_input.core.focus_ctrl_factory.call(null,focus_tracker,elastic_input.core.scroll_t);
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (focus_tracker,focus_ctrl){
return (function (p__19723){
var map__19724 = p__19723;
var map__19724__$1 = ((((!((map__19724 == null)))?((((map__19724.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19724.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19724):map__19724);
var opts__$1 = map__19724__$1;
var focused_QMARK_ = cljs.core.get.call(null,map__19724__$1,new cljs.core.Keyword(null,"focused?","focused?",-1922723333));
if(cljs.core.not_EQ_.call(null,focused_QMARK_,new cljs.core.Keyword(null,"curr","curr",-1092372808).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,focus_tracker)))){
cljs.core.swap_BANG_.call(null,focus_tracker,((function (map__19724,map__19724__$1,opts__$1,focused_QMARK_,focus_tracker,focus_ctrl){
return (function (p1__19719_SHARP_){
return cljs.core.update_in.call(null,p1__19719_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"curr","curr",-1092372808)], null),cljs.core.not);
});})(map__19724,map__19724__$1,opts__$1,focused_QMARK_,focus_tracker,focus_ctrl))
);
} else {
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elastic_input.core.textarea,cljs.core.merge.call(null,opts__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"textarea-opts","textarea-opts",-942779061),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(focused_QMARK_)?"active":"inactive")], null)], null))], null);
});})(focus_tracker,focus_ctrl))
,new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),focus_ctrl,new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),focus_ctrl], null));
});
/**
 * Minimum width in case of no text
 */
elastic_input.core.min_w = (10);
/**
 * Additional space at the end of text
 */
elastic_input.core.extra_w = (5);
elastic_input.core.input_auto_w = (function elastic_input$core$input_auto_w(opts){
var with_let19732 = reagent.ratom.with_let_values.call(null,new cljs.core.Keyword(null,"with-let19732","with-let19732",-739247359));
var temp__4661__auto___19734 = reagent.ratom._STAR_ratom_context_STAR_;
if((temp__4661__auto___19734 == null)){
} else {
var c__19660__auto___19735 = temp__4661__auto___19734;
if((with_let19732.generation === c__19660__auto___19735.ratomGeneration)){
if(cljs.core.truth_(reagent.debug.has_console)){
(cljs.core.truth_(reagent.debug.tracking)?reagent.debug.track_console:console).error([cljs.core.str("Warning: The same with-let is being used more "),cljs.core.str("than once in the same reactive context.")].join(''));
} else {
}
} else {
}

with_let19732.generation = c__19660__auto___19735.ratomGeneration;
}


var init19733 = (with_let19732.length === (0));
var width = ((init19733)?(with_let19732[(0)] = reagent.core.atom.call(null,elastic_input.core.min_w)):(with_let19732[(0)]));
var min_w = ((init19733)?(with_let19732[(1)] = cljs.core.get.call(null,opts,new cljs.core.Keyword(null,"min-w","min-w",-1698040337),elastic_input.core.min_w)):(with_let19732[(1)]));
var extra_w = ((init19733)?(with_let19732[(2)] = cljs.core.get.call(null,opts,new cljs.core.Keyword(null,"extra-w","extra-w",-1771231663),elastic_input.core.extra_w)):(with_let19732[(2)]));
var phantom = ((init19733)?(with_let19732[(3)] = elastic_input.core.phantom_factory.call(null,((function (init19733,width,min_w,extra_w,with_let19732){
return (function (p1__19726_SHARP_){
return p1__19726_SHARP_.clientWidth;
});})(init19733,width,min_w,extra_w,with_let19732))
,((function (init19733,width,min_w,extra_w,with_let19732){
return (function (p1__19727_SHARP_){
return cljs.core.reset_BANG_.call(null,width,(((p1__19727_SHARP_ < min_w))?(min_w + extra_w):(p1__19727_SHARP_ + extra_w)));
});})(init19733,width,min_w,extra_w,with_let19732))
,"inline-block","")):(with_let19732[(3)]));
var buffer_ratom = ((init19733)?(with_let19732[(4)] = ((cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"buffer?","buffer?",607721787)))?reagent.core.atom.call(null,new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(opts)):null)):(with_let19732[(4)]));
var res__19661__auto__ = (function (){var opts__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"buffer?","buffer?",607721787).cljs$core$IFn$_invoke$arity$1(opts))?cljs.core.merge.call(null,opts,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456),((function (init19733,width,min_w,extra_w,phantom,buffer_ratom,with_let19732){
return (function (p1__19728_SHARP_){
return cljs.core.reset_BANG_.call(null,buffer_ratom,p1__19728_SHARP_);
});})(init19733,width,min_w,extra_w,phantom,buffer_ratom,with_let19732))
,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (init19733,width,min_w,extra_w,phantom,buffer_ratom,with_let19732){
return (function (p1__19729_SHARP_){
return new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456).cljs$core$IFn$_invoke$arity$1(opts).call(null,p1__19729_SHARP_);
});})(init19733,width,min_w,extra_w,phantom,buffer_ratom,with_let19732))
,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.deref.call(null,buffer_ratom)], null)):opts);
var opts__$2 = cljs.core.assoc.call(null,opts__$1,new cljs.core.Keyword(null,"width","width",-384071477),cljs.core.deref.call(null,width));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.elastic-input.input-auto-w","div.elastic-input.input-auto-w",204019944),new cljs.core.Keyword(null,"container","container",-1736937707).cljs$core$IFn$_invoke$arity$1(opts__$2),((cljs.core.contains_QMARK_.call(null,opts__$2,new cljs.core.Keyword(null,"focused?","focused?",-1922723333)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elastic_input.core.input_foc,opts__$2], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elastic_input.core.input,opts__$2], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [phantom,cljs.core.select_keys.call(null,opts__$2,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697)], null))], null)], null);
})();

return res__19661__auto__;
});
elastic_input.core.textarea_auto_h = (function elastic_input$core$textarea_auto_h(opts){
var with_let19742 = reagent.ratom.with_let_values.call(null,new cljs.core.Keyword(null,"with-let19742","with-let19742",-578122989));
var temp__4661__auto___19744 = reagent.ratom._STAR_ratom_context_STAR_;
if((temp__4661__auto___19744 == null)){
} else {
var c__19660__auto___19745 = temp__4661__auto___19744;
if((with_let19742.generation === c__19660__auto___19745.ratomGeneration)){
if(cljs.core.truth_(reagent.debug.has_console)){
(cljs.core.truth_(reagent.debug.tracking)?reagent.debug.track_console:console).error([cljs.core.str("Warning: The same with-let is being used more "),cljs.core.str("than once in the same reactive context.")].join(''));
} else {
}
} else {
}

with_let19742.generation = c__19660__auto___19745.ratomGeneration;
}


var init19743 = (with_let19742.length === (0));
var height = ((init19743)?(with_let19742[(0)] = reagent.core.atom.call(null,(25))):(with_let19742[(0)]));
var phantom = ((init19743)?(with_let19742[(1)] = elastic_input.core.phantom_factory.call(null,((function (init19743,height,with_let19742){
return (function (p1__19736_SHARP_){
return p1__19736_SHARP_.clientHeight;
});})(init19743,height,with_let19742))
,((function (init19743,height,with_let19742){
return (function (p1__19737_SHARP_){
return cljs.core.reset_BANG_.call(null,height,p1__19737_SHARP_);
});})(init19743,height,with_let19742))
,"block","<br class='lbr'>")):(with_let19742[(1)]));
var buffer_ratom = ((init19743)?(with_let19742[(2)] = ((cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"buffer?","buffer?",607721787)))?reagent.core.atom.call(null,new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(opts)):null)):(with_let19742[(2)]));
var res__19661__auto__ = (function (){var opts__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"buffer?","buffer?",607721787).cljs$core$IFn$_invoke$arity$1(opts))?cljs.core.merge.call(null,opts,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456),((function (init19743,height,phantom,buffer_ratom,with_let19742){
return (function (p1__19738_SHARP_){
return cljs.core.reset_BANG_.call(null,buffer_ratom,p1__19738_SHARP_);
});})(init19743,height,phantom,buffer_ratom,with_let19742))
,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (init19743,height,phantom,buffer_ratom,with_let19742){
return (function (p1__19739_SHARP_){
return new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456).cljs$core$IFn$_invoke$arity$1(opts).call(null,p1__19739_SHARP_);
});})(init19743,height,phantom,buffer_ratom,with_let19742))
,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.deref.call(null,buffer_ratom)], null)):opts);
var opts__$2 = cljs.core.assoc.call(null,opts__$1,new cljs.core.Keyword(null,"height","height",1025178622),cljs.core.deref.call(null,height));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.elastic-input.textarea-auto-h","div.elastic-input.textarea-auto-h",946392344),new cljs.core.Keyword(null,"container","container",-1736937707).cljs$core$IFn$_invoke$arity$1(opts__$2),((cljs.core.contains_QMARK_.call(null,opts__$2,new cljs.core.Keyword(null,"focused?","focused?",-1922723333)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elastic_input.core.textarea_foc,opts__$2], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elastic_input.core.textarea,opts__$2], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [phantom,cljs.core.select_keys.call(null,opts__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"width","width",-384071477)], null))], null)], null);
})();

return res__19661__auto__;
});

//# sourceMappingURL=core.js.map