(ns carousel-demo.index
  (:require [reagent.core  :as r]
            [carousel.core :as c]
            [carousel-demo.util :as util]
            [carousel-demo.data :as data]))

(defn quote-view [{:keys [text author source date]}]
  [:div.quote
    [:div.text text]
    [:div.info {:style {:text-align "right"}}
      " —" author " (" source ", " date ")"]])

(defn photo-thumb
  [{:as photo-map
    :keys [src-orig url_c width_c height_c datetaken title id tags]}]
  (let [theme "dark"]
    ^{:key url_c}
    [:div.photo-thumb
      [:a {:href (str "http://flickr.com/photos/71688597@N05/" id)}
        [:img {:width width_c :height height_c :src url_c}]]
      [:div.photo-info {:class theme}
        [:span.date (str "Taken " (util/conv-time-str datetaken))]
        [:span.caption title]]]))

(defn demo []
  (r/with-let [idx-model1 (r/atom 0)
               idx-model2 (r/atom 0)]
    [:div.demo
      [:h1 "Carousel Demo (0.2.1)"]
      [:div
        [:h3 "Quotes"
          [:span.badge (str (inc @idx-model1) " of " (count data/quotes))]]
        [c/carousel
          :item-seq (map quote-view data/quotes)
          :idx-model idx-model1
          :arrow-style :zmdi]

        (if @data/flickr-response
          [:div
            [:h3 "Mars photos"
              [:span.badge (str (inc @idx-model2) " of " (count @data/flickr-response))]]
             [c/carousel
               :item-seq (map photo-thumb @data/flickr-response)
               :idx-model idx-model2
               :slide? true
               :arrow-style :zmdi]]
          [:div "loading..."])]]))

(defn mount-root [] (r/render [demo] (.getElementById js/document "root")))
(defn init! [] (data/request-flickr) (mount-root))
(defonce init_ (init!))
(defn on-js-reload [] (mount-root))
