(ns carousel-demo.data
  (:require-macros [carousel-demo.env :refer [cljs-env]])
  (:require [clojure.string :refer [join split]]
            [reagent.core :as r]
            [ajax.core :as ajax]))

(def mill-on-liberty {:author "John Stuart Mill" :source "On Liberty" :date "1859"})

(def quotes-text
  ["The peculiar evil of silencing the expression of an opinion is, that it is robbing the human race; posterity as well as the existing generation; those who dissent from the opinion, still more than those who hold it.  If the opinion is right, they are deprived of the opportunity of exchanging error for truth:  if wrong, they lose, what is almost as great a benefit, the clearer perception and livelier impression of truth, produced by its collision with error."
   "We can never be sure that the opinion we are endeavoring to stifle is a false opinion; and if we were sure, stifling it would be an evil still."
   "If all mankind minus one were of one opinion, mankind would be no more justified in silencing that one person than he, if he had the power, would be justified in silencing mankind."
   "The greatest orator, save one, of antiquity, has left it on record that he always studied his adversary’s case with as great, if not with still greater, intensity than even his own. What Cicero practised as the means of forensic success, requires to be imitated by all who study any subject in order to arrive at the truth. He who knows only his own side of the case, knows little of that. His reasons may be good, and no one may have been able to refute them. But if he is equally unable to refute the reasons on the opposite side; if he does not so much as know what they are, he has no ground for preferring either opinion."])

(def quotes (map #(merge mill-on-liberty {:text %}) quotes-text))

(defonce flickr-response (r/atom nil))

(defn request-flickr []
  (ajax/GET "https://api.flickr.com/services/rest/?"
    {:handler #(reset! flickr-response (get-in % [:photoset :photo]))
     :response-format :json
     :keywords? true
     :params
     {:format "json"
      :nojsoncallback 1
      :per_page 100
      :api_key (cljs-env :flickr-api-key)
      :method  "flickr.photosets.getPhotos"
      :user_id "71688597@N05"
      :photoset_id "72157633359968647"
      :extras (->> [:description :url_c :url_l :date_taken :tags]
                   (map name) (join ","))}}))
