/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.concurrent.atomic.AtomicInteger;
import zmq.YQueue;

public class YPipe<T> {
    private final YQueue<T> queue;
    private int w;
    private int r;
    private int f;
    private final AtomicInteger c;

    public YPipe(Class<T> klass, int qsize) {
        this.queue = new YQueue<T>(klass, qsize);
        this.r = this.f = this.queue.back_pos();
        this.w = this.f;
        this.c = new AtomicInteger(this.queue.back_pos());
    }

    public final void write(T value_, boolean incomplete_) {
        this.queue.push(value_);
        if (!incomplete_) {
            this.f = this.queue.back_pos();
        }
    }

    public T unwrite() {
        if (this.f == this.queue.back_pos()) {
            return null;
        }
        this.queue.unpush();
        return this.queue.back();
    }

    public final boolean flush() {
        if (this.w == this.f) {
            return true;
        }
        if (!this.c.compareAndSet(this.w, this.f)) {
            this.c.set(this.f);
            this.w = this.f;
            return false;
        }
        this.w = this.f;
        return true;
    }

    public final boolean check_read() {
        int h = this.queue.front_pos();
        if (h != this.r) {
            return true;
        }
        if (!this.c.compareAndSet(h, -1)) {
            this.r = this.c.get();
        }
        return h != this.r && this.r != -1;
    }

    public final T read() {
        if (!this.check_read()) {
            return null;
        }
        T value_ = this.queue.pop();
        return value_;
    }

    public final T probe() {
        boolean rc = this.check_read();
        assert (rc);
        T value = this.queue.front();
        return value;
    }
}

