/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import zmq.Address;
import zmq.Blob;
import zmq.Ctx;
import zmq.FQ;
import zmq.IOThread;
import zmq.Msg;
import zmq.Options;
import zmq.Pipe;
import zmq.SessionBase;
import zmq.SocketBase;
import zmq.Utils;
import zmq.ValueReference;

public class Router
extends SocketBase {
    private final FQ fq;
    private boolean prefetched = false;
    private boolean identity_sent = false;
    private Msg prefetched_id;
    private Msg prefetched_msg;
    private boolean more_in = false;
    private final Set<Pipe> anonymous_pipes;
    private final Map<Blob, Outpipe> outpipes;
    private Pipe current_out = null;
    private boolean more_out = false;
    private int next_peer_id = Utils.generate_random();
    private boolean mandatory = false;

    public Router(Ctx parent_, int tid_, int sid_) {
        super(parent_, tid_, sid_);
        this.options.type = 6;
        this.fq = new FQ();
        this.prefetched_id = new Msg();
        this.prefetched_msg = new Msg();
        this.anonymous_pipes = new HashSet<Pipe>();
        this.outpipes = new HashMap<Blob, Outpipe>();
        this.options.recv_identity = true;
    }

    @Override
    public void xattach_pipe(Pipe pipe_, boolean icanhasall_) {
        assert (pipe_ != null);
        boolean identity_ok = this.identify_peer(pipe_);
        if (identity_ok) {
            this.fq.attach(pipe_);
        } else {
            this.anonymous_pipes.add(pipe_);
        }
    }

    @Override
    public boolean xsetsockopt(int option_, Object optval_) {
        if (option_ != 33) {
            return false;
        }
        this.mandatory = (Integer)optval_ == 1;
        return true;
    }

    @Override
    public void xterminated(Pipe pipe_) {
        if (!this.anonymous_pipes.remove(pipe_)) {
            Outpipe old = this.outpipes.remove(pipe_.get_identity());
            assert (old != null);
            this.fq.terminated(pipe_);
            if (pipe_ == this.current_out) {
                this.current_out = null;
            }
        }
    }

    @Override
    public void xread_activated(Pipe pipe_) {
        if (!this.anonymous_pipes.contains(pipe_)) {
            this.fq.activated(pipe_);
        } else {
            boolean identity_ok = this.identify_peer(pipe_);
            if (identity_ok) {
                this.anonymous_pipes.remove(pipe_);
                this.fq.attach(pipe_);
            }
        }
    }

    @Override
    public void xwrite_activated(Pipe pipe_) {
        for (Map.Entry<Blob, Outpipe> it : this.outpipes.entrySet()) {
            if (it.getValue().pipe != pipe_) continue;
            assert (!it.getValue().active);
            it.getValue().active = true;
            break;
        }
        assert (false);
    }

    @Override
    protected boolean xsend(Msg msg_) {
        if (!this.more_out) {
            assert (this.current_out == null);
            if (msg_.has_more()) {
                this.more_out = true;
                Blob identity = new Blob(msg_.data());
                Outpipe op = this.outpipes.get(identity);
                if (op != null) {
                    this.current_out = op.pipe;
                    if (!this.current_out.check_write()) {
                        op.active = false;
                        this.current_out = null;
                        if (this.mandatory) {
                            this.more_out = false;
                            this.errno.set(35);
                            return false;
                        }
                    }
                } else if (this.mandatory) {
                    this.more_out = false;
                    this.errno.set(65);
                    return false;
                }
            }
            return true;
        }
        this.more_out = msg_.has_more();
        if (this.current_out != null) {
            boolean ok = this.current_out.write(msg_);
            if (!ok) {
                this.current_out = null;
            } else if (!this.more_out) {
                this.current_out.flush();
                this.current_out = null;
            }
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        Msg msg_ = null;
        if (this.prefetched) {
            if (!this.identity_sent) {
                msg_ = this.prefetched_id;
                this.prefetched_id = null;
                this.identity_sent = true;
            } else {
                msg_ = this.prefetched_msg;
                this.prefetched_msg = null;
                this.prefetched = false;
            }
            this.more_in = msg_.has_more();
            return msg_;
        }
        ValueReference<Pipe> pipe = new ValueReference<Pipe>();
        msg_ = this.fq.recvpipe(this.errno, pipe);
        while (msg_ != null && msg_.is_identity()) {
            msg_ = this.fq.recvpipe(this.errno, pipe);
        }
        if (msg_ == null) {
            return null;
        }
        assert (pipe.get() != null);
        if (this.more_in) {
            this.more_in = msg_.has_more();
        } else {
            this.prefetched_msg = msg_;
            this.prefetched = true;
            Blob identity = pipe.get().get_identity();
            msg_ = new Msg(identity.data());
            msg_.set_flags(1);
            this.identity_sent = true;
        }
        return msg_;
    }

    protected void rollback() {
        if (this.current_out != null) {
            this.current_out.rollback();
            this.current_out = null;
            this.more_out = false;
        }
    }

    @Override
    protected boolean xhas_in() {
        if (this.more_in) {
            return true;
        }
        if (this.prefetched) {
            return true;
        }
        ValueReference<Pipe> pipe = new ValueReference<Pipe>();
        this.prefetched_msg = this.fq.recvpipe(this.errno, pipe);
        while (this.prefetched_msg != null && this.prefetched_msg.is_identity()) {
            this.prefetched_msg = this.fq.recvpipe(this.errno, pipe);
        }
        if (this.prefetched_msg == null) {
            return false;
        }
        assert (pipe.get() != null);
        Blob identity = pipe.get().get_identity();
        this.prefetched_id = new Msg(identity.data());
        this.prefetched_id.set_flags(1);
        this.prefetched = true;
        this.identity_sent = false;
        return true;
    }

    @Override
    protected boolean xhas_out() {
        return true;
    }

    private boolean identify_peer(Pipe pipe_) {
        Blob identity;
        Msg msg = pipe_.read();
        if (msg == null) {
            return false;
        }
        if (msg.size() == 0) {
            ByteBuffer buf = ByteBuffer.allocate(5);
            buf.put((byte)0);
            buf.putInt(this.next_peer_id++);
            buf.flip();
            identity = new Blob(buf);
        } else {
            identity = new Blob(msg.data());
            if (this.outpipes.containsKey(identity)) {
                this.xterminated(this.outpipes.get(identity).pipe);
            }
        }
        pipe_.set_identity(identity);
        Outpipe outpipe = new Outpipe(pipe_, true);
        this.outpipes.put(identity, outpipe);
        return true;
    }

    class Outpipe {
        private Pipe pipe;
        private boolean active;

        public Outpipe(Pipe pipe_, boolean active_) {
            this.pipe = pipe_;
            this.active = active_;
        }
    }

    public static class RouterSession
    extends SessionBase {
        public RouterSession(IOThread io_thread_, boolean connect_, SocketBase socket_, Options options_, Address addr_) {
            super(io_thread_, connect_, socket_, options_, addr_);
        }
    }
}

