/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.ArrayList;
import java.util.List;
import zmq.Msg;
import zmq.Pipe;
import zmq.Utils;
import zmq.ValueReference;

public class FQ {
    private final List<Pipe> pipes = new ArrayList<Pipe>();
    private int active = 0;
    private int current = 0;
    private boolean more = false;

    public void attach(Pipe pipe_) {
        this.pipes.add(pipe_);
        Utils.swap(this.pipes, this.active, this.pipes.size() - 1);
        ++this.active;
    }

    public void terminated(Pipe pipe_) {
        int index = this.pipes.indexOf(pipe_);
        if (index < this.active) {
            --this.active;
            Utils.swap(this.pipes, index, this.active);
            if (this.current == this.active) {
                this.current = 0;
            }
        }
        this.pipes.remove(pipe_);
    }

    public void activated(Pipe pipe_) {
        Utils.swap(this.pipes, this.pipes.indexOf(pipe_), this.active);
        ++this.active;
    }

    public Msg recv(ValueReference<Integer> errno) {
        return this.recvpipe(errno, null);
    }

    public Msg recvpipe(ValueReference<Integer> errno, ValueReference<Pipe> pipe_) {
        while (this.active > 0) {
            boolean fetched;
            Msg msg_ = this.pipes.get(this.current).read();
            boolean bl = fetched = msg_ != null;
            if (fetched) {
                if (pipe_ != null) {
                    pipe_.set(this.pipes.get(this.current));
                }
                this.more = msg_.has_more();
                if (!this.more) {
                    this.current = (this.current + 1) % this.active;
                }
                return msg_;
            }
            assert (!this.more);
            --this.active;
            Utils.swap(this.pipes, this.current, this.active);
            if (this.current != this.active) continue;
            this.current = 0;
        }
        errno.set(35);
        return null;
    }

    public boolean has_in() {
        if (this.more) {
            return true;
        }
        while (this.active > 0) {
            if (this.pipes.get(this.current).check_read()) {
                return true;
            }
            --this.active;
            Utils.swap(this.pipes, this.current, this.active);
            if (this.current != this.active) continue;
            this.current = 0;
        }
        return false;
    }
}

