/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.IDecoder;
import zmq.Msg;

public abstract class DecoderBase
implements IDecoder {
    private byte[] read_buf;
    private int read_pos;
    protected int to_read = 0;
    private int bufsize;
    private ByteBuffer buf;
    private int state = -1;
    boolean zero_copy;

    public DecoderBase(int bufsize_) {
        this.bufsize = bufsize_;
        if (bufsize_ > 0) {
            this.buf = ByteBuffer.allocateDirect(bufsize_);
        }
        this.read_buf = null;
        this.zero_copy = false;
    }

    @Override
    public ByteBuffer get_buffer() {
        ByteBuffer b;
        if (this.to_read >= this.bufsize) {
            this.zero_copy = true;
            b = ByteBuffer.wrap(this.read_buf);
            b.position(this.read_pos);
        } else {
            this.zero_copy = false;
            b = this.buf;
            b.clear();
        }
        return b;
    }

    @Override
    public int process_buffer(ByteBuffer buf_, int size_) {
        if (this.state() < 0) {
            return -1;
        }
        if (this.zero_copy) {
            this.read_pos += size_;
            this.to_read -= size_;
            while (this.to_read == 0) {
                if (this.next()) continue;
                if (this.state() < 0) {
                    return -1;
                }
                return size_;
            }
            return size_;
        }
        int pos = 0;
        while (true) {
            if (this.to_read == 0) {
                if (this.next()) continue;
                if (this.state() < 0) {
                    return -1;
                }
                return pos;
            }
            if (pos == size_) {
                return pos;
            }
            int to_copy = Math.min(this.to_read, size_ - pos);
            buf_.get(this.read_buf, this.read_pos, to_copy);
            this.read_pos += to_copy;
            pos += to_copy;
            this.to_read -= to_copy;
        }
    }

    protected void next_step(Msg msg_, int state_) {
        this.next_step(msg_.data(), msg_.size(), state_);
    }

    protected void next_step(byte[] buf_, int to_read_, int state_) {
        this.read_buf = buf_;
        this.read_pos = 0;
        this.to_read = to_read_;
        this.state = state_;
    }

    protected int state() {
        return this.state;
    }

    protected void state(int state_) {
        this.state = state_;
    }

    protected void decoding_error() {
        this.state(-1);
    }

    @Override
    public boolean stalled() {
        if (!this.next()) {
            return false;
        }
        while (this.to_read == 0) {
            if (this.next()) continue;
            return this.next();
        }
        return false;
    }

    protected abstract boolean next();
}

