/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.ml.jdbcodbc.jdbc3;

import ianywhere.ml.jdbcodbc.IResource;
import ianywhere.ml.jdbcodbc.jdbc3.IIStatement;
import ianywhere.ml.jdbcodbc.jdbc3.IResultSetMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public final class IColumnsResultSetMetaData
extends IResultSetMetaData {
    private ResultSetMetaData rsmd;
    private final String[] extraColumns = new String[]{"SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
    private final int[] extraColumnsIndexes = new int[]{19, 20, 21, 22};
    private final int firstExtraColumnIndex = 19;
    private final int lastExtraColumnIndex = 22;

    IColumnsResultSetMetaData(IIStatement iIStatement, ResultSetMetaData resultSetMetaData) {
        super(iIStatement);
        this.rsmd = resultSetMetaData;
    }

    protected synchronized void finalize() {
        this.rsmd = null;
    }

    private int extraColumnIndex(String string) {
        for (int i = 0; i < this.extraColumns.length; ++i) {
            if (string.compareToIgnoreCase(this.extraColumns[i]) != 0) continue;
            return this.extraColumnsIndexes[i];
        }
        return 0;
    }

    private boolean isExtraColumn(int n) {
        return n >= 19 && n <= 22;
    }

    public String getCatalogName(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return this.rsmd.getCatalogName(1);
        }
        return this.rsmd.getCatalogName(n);
    }

    public String getColumnClassName(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public int getColumnCount() throws SQLException {
        return 22;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return this.rsmd.getColumnDisplaySize(1);
        }
        return this.rsmd.getColumnDisplaySize(n);
    }

    public String getColumnLabel(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return this.extraColumns[n - 19];
        }
        return this.rsmd.getColumnLabel(n);
    }

    public String getColumnName(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return this.extraColumns[n - 19];
        }
        return this.rsmd.getColumnName(n);
    }

    public int getColumnType(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return this.rsmd.getColumnType(1);
        }
        return this.rsmd.getColumnType(n);
    }

    public String getColumnTypeName(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return this.rsmd.getColumnTypeName(1);
        }
        return this.rsmd.getColumnTypeName(n);
    }

    public int getPrecision(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return this.rsmd.getPrecision(1);
        }
        return this.rsmd.getPrecision(n);
    }

    public int getScale(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return this.rsmd.getScale(1);
        }
        return this.rsmd.getScale(n);
    }

    public String getSchemaName(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return this.rsmd.getSchemaName(1);
        }
        return this.rsmd.getSchemaName(n);
    }

    public String getTableName(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return this.rsmd.getTableName(1);
        }
        return this.rsmd.getTableName(n);
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return false;
        }
        return this.rsmd.isAutoIncrement(n);
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return true;
        }
        return this.rsmd.isCaseSensitive(n);
    }

    public boolean isCurrency(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return false;
        }
        return this.rsmd.isCurrency(n);
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    public int isNullable(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return 2;
        }
        return this.rsmd.isNullable(n);
    }

    public boolean isReadOnly(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return true;
        }
        return this.rsmd.isReadOnly(n);
    }

    public boolean isSearchable(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return false;
        }
        return this.rsmd.isSearchable(n);
    }

    public boolean isSigned(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return false;
        }
        return this.rsmd.isSigned(n);
    }

    public boolean isWritable(int n) throws SQLException {
        if (this.isExtraColumn(n)) {
            return false;
        }
        return this.rsmd.isWritable(n);
    }
}

