/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.ml.jdbcodbc;

import ianywhere.ml.jdbcodbc.IIStatement;
import ianywhere.ml.jdbcodbc.IResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class IStatement
implements Statement {
    private IIStatement stmt;
    private Connection con = null;
    public boolean initFailed = false;

    public IStatement(Statement statement) {
        try {
            this.stmt = (IIStatement)statement;
        }
        catch (ClassCastException classCastException) {
            this.initFailed = true;
            return;
        }
        try {
            this.con = this.stmt.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected synchronized void finalize() {
        this.stmt.release();
        this.con = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String string) throws SQLException {
        IResultSet iResultSet = null;
        ResultSet resultSet = null;
        IIStatement iIStatement = this.stmt;
        synchronized (iIStatement) {
            resultSet = this.stmt.executeQuery(string);
        }
        if (resultSet != null) {
            iResultSet = new IResultSet(resultSet);
            if (iResultSet.initFailed) {
                iResultSet = null;
            } else {
                iResultSet.setStatementHandle(this);
            }
        }
        return iResultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        return this.stmt.executeUpdate(string);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    public int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    public boolean execute(String string) throws SQLException {
        return this.stmt.execute(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet() throws SQLException {
        IResultSet iResultSet = null;
        ResultSet resultSet = null;
        IIStatement iIStatement = this.stmt;
        synchronized (iIStatement) {
            resultSet = this.stmt.getResultSet();
        }
        if (resultSet != null) {
            iResultSet = new IResultSet(resultSet);
            if (iResultSet.initFailed) {
                iResultSet = null;
            } else {
                iResultSet.setStatementHandle(this);
            }
        }
        return iResultSet;
    }

    public int getUpdateCount() throws SQLException {
        return this.stmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.stmt.getMoreResults();
    }

    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    public int[] executeBatch() throws SQLException {
        return this.stmt.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.stmt.getConnection();
    }

    public void close() throws SQLException {
        this.stmt.clearBatch();
        this.stmt.close();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.stmt.setMaxFieldSize(n);
    }

    public void setMaxRows(int n) throws SQLException {
        this.stmt.setMaxRows(n);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.stmt.setEscapeProcessing(bl);
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.stmt.setQueryTimeout(n);
    }

    public void cancel() throws SQLException {
        this.stmt.cancel();
    }

    public void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    public void setCursorName(String string) throws SQLException {
        this.stmt.setCursorName(string);
    }

    public void setFetchDirection(int n) throws SQLException {
        this.stmt.setFetchDirection(n);
    }

    public void setFetchSize(int n) throws SQLException {
        this.stmt.setFetchSize(n);
    }

    public void addBatch(String string) throws SQLException {
        this.stmt.addBatch(string);
    }

    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    public static boolean isSelectStatement(String string) {
        return IIStatement.isSelectStatement(string);
    }

    public static boolean isInsertStatement(String string) {
        return IIStatement.isInsertStatement(string);
    }

    public String getColStrAttr(int n, int n2) throws SQLException {
        return this.stmt.getColStrAttr(n, n2);
    }

    public int getColNumAttr(int n, int n2) throws SQLException {
        return this.stmt.getColNumAttr(n, n2);
    }

    public ResultSetMetaData describe() throws SQLException {
        return this.stmt.describe();
    }

    public boolean getMoreResults(int n) throws SQLException {
        return this.stmt.getMoreResults(n);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.stmt.getGeneratedKeys();
    }

    public int executeUpdate(String string, int n) throws SQLException {
        return this.stmt.executeUpdate(string, n);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return this.stmt.executeUpdate(string, nArray);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return this.stmt.executeUpdate(string, stringArray);
    }

    public boolean execute(String string, int n) throws SQLException {
        return this.stmt.execute(string, n);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        return this.stmt.execute(string, nArray);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        return this.stmt.execute(string, stringArray);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.stmt.getResultSetHoldability();
    }
}

