/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.ml.jdbcodbc;

import ianywhere.ml.jdbcodbc.IBlob;
import ianywhere.ml.jdbcodbc.ICharacterStreamReader;
import ianywhere.ml.jdbcodbc.IClob;
import ianywhere.ml.jdbcodbc.IDriver;
import ianywhere.ml.jdbcodbc.IIStatement;
import ianywhere.ml.jdbcodbc.INative;
import ianywhere.ml.jdbcodbc.IResource;
import ianywhere.ml.jdbcodbc.IResultSet;
import ianywhere.ml.jdbcodbc.IResultSetMetaData;
import ianywhere.ml.jdbcodbc.IStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

class IIResultSet
extends INative
implements ResultSet {
    private ResultSetMetaData metaData = null;
    private IStatement istmt = null;
    private Calendar tsInstance = null;
    private Calendar dtInstance = null;
    private Calendar timInstance = null;

    private IIResultSet(long l) {
        super(l);
    }

    public void setStatementHandle(IStatement iStatement) {
        this.istmt = iStatement;
    }

    public Timestamp computeTimestampInMillis(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.tsInstance == null) {
            this.tsInstance = Calendar.getInstance();
        }
        this.tsInstance.set(n, n2, n3, n4, n5, n6);
        this.tsInstance.set(14, n7 / 1000000);
        Timestamp timestamp = new Timestamp(this.tsInstance.getTimeInMillis());
        timestamp.setNanos(n7);
        return timestamp;
    }

    public Time computeTimeInMillis(int n, int n2, int n3) {
        if (this.timInstance == null) {
            this.timInstance = Calendar.getInstance();
            this.timInstance.set(14, 0);
        }
        this.timInstance.set(1970, 0, 1, n, n2, n3);
        return new Time(this.timInstance.getTimeInMillis());
    }

    public Date computeDateInMillis(int n, int n2, int n3) {
        if (this.dtInstance == null) {
            this.dtInstance = Calendar.getInstance();
            this.dtInstance.set(n, n2, n3, 0, 0, 0);
            this.dtInstance.set(14, 0);
            return new Date(this.dtInstance.getTimeInMillis());
        }
        this.dtInstance.set(n, n2, n3);
        return new Date(this.dtInstance.getTimeInMillis());
    }

    protected native void nFree();

    public native boolean absolute(int var1) throws SQLException;

    public native void afterLast() throws SQLException;

    public native void beforeFirst() throws SQLException;

    public native void cancelRowUpdates() throws SQLException;

    public native void clearWarnings() throws SQLException;

    public native boolean isClosed() throws SQLException;

    public native void doClose() throws SQLException;

    public void close() throws SQLException {
        this.doClose();
        this.istmt = null;
    }

    public synchronized void release() {
        this.istmt = null;
    }

    public native void deleteRow() throws SQLException;

    public native int findColumn(String var1) throws SQLException;

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native InputStream getAsciiStream(int var1) throws SQLException;

    public native InputStream getAsciiStream(String var1) throws SQLException;

    public native BigDecimal getBigDecimal(int var1) throws SQLException;

    public native BigDecimal getBigDecimal(int var1, int var2) throws SQLException;

    public native BigDecimal getBigDecimal(String var1) throws SQLException;

    public native BigDecimal getBigDecimal(String var1, int var2) throws SQLException;

    public native InputStream getBinaryStream(int var1) throws SQLException;

    public native InputStream getBinaryStream(String var1) throws SQLException;

    public native long getBlobLength(int var1) throws SQLException;

    public native byte[] getBlobBytes(int var1, int var2) throws SQLException;

    public Blob getBlob(int n) throws SQLException {
        long l = this.getBlobLength(n);
        if (l == -1L) {
            return null;
        }
        IBlob iBlob = new IBlob(n, this, l);
        if (iBlob.length() == -3L) {
            return null;
        }
        return iBlob;
    }

    public Blob getBlob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBlob(n);
    }

    public native boolean getBoolean(int var1) throws SQLException;

    public native boolean getBoolean(String var1) throws SQLException;

    public native byte getByte(int var1) throws SQLException;

    public native byte getByte(String var1) throws SQLException;

    public native byte[] getBytes(int var1) throws SQLException;

    public native byte[] getBytes(String var1) throws SQLException;

    public native Reader getCharacterStream(int var1) throws SQLException;

    public native Reader getCharacterStream(String var1) throws SQLException;

    public native ICharacterStreamReader getClobCharacterStream(int var1) throws SQLException;

    public native ICharacterStreamReader getClobCharacterStream(String var1) throws SQLException;

    public Clob getClob(int n) throws SQLException {
        ICharacterStreamReader iCharacterStreamReader = this.getClobCharacterStream(n);
        if (iCharacterStreamReader == null) {
            return null;
        }
        iCharacterStreamReader.setResultSetAndIndex(this, n);
        return new IClob(iCharacterStreamReader);
    }

    public Clob getClob(String string) throws SQLException {
        ICharacterStreamReader iCharacterStreamReader = this.getClobCharacterStream(string);
        if (iCharacterStreamReader == null) {
            return null;
        }
        iCharacterStreamReader.setResultSetAndName(this, string);
        return new IClob(iCharacterStreamReader);
    }

    public native String getNextClobPiece(int var1) throws SQLException;

    public native String getNextClobPiece(String var1) throws SQLException;

    public native int getConcurrency() throws SQLException;

    public native String getCursorName() throws SQLException;

    public native Date getDate(int var1) throws SQLException;

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return IDriver.calendarizeFrom(this.getDate(n), calendar);
    }

    public native Date getDate(String var1) throws SQLException;

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return IDriver.calendarizeFrom(this.getDate(string), calendar);
    }

    public native double getDouble(int var1) throws SQLException;

    public native double getDouble(String var1) throws SQLException;

    public native int getFetchDirection() throws SQLException;

    public native int getFetchSize() throws SQLException;

    public native float getFloat(int var1) throws SQLException;

    public native float getFloat(String var1) throws SQLException;

    public native int getInt(int var1) throws SQLException;

    public native int getInt(String var1) throws SQLException;

    public native long getLong(int var1) throws SQLException;

    public native long getLong(String var1) throws SQLException;

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.metaData != null) {
            return this.metaData;
        }
        this.metaData = new IResultSetMetaData((IIStatement)this.getStatement());
        return this.metaData;
    }

    public Object getObject(int n) throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.getMetaData();
        }
        switch (this.metaData.getColumnType(n)) {
            case -7: {
                boolean bl = this.getBoolean(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Boolean(bl);
            }
            case -6: {
                short s = this.getShort(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Short(s);
            }
            case 5: {
                if (this.metaData.isSigned(n)) {
                    short s = this.getShort(n);
                    if (this.wasNull()) {
                        return null;
                    }
                    return new Short(s);
                }
                int n2 = this.getInt(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Integer(n2);
            }
            case 4: {
                if (this.metaData.isSigned(n)) {
                    int n3 = this.getInt(n);
                    if (this.wasNull()) {
                        return null;
                    }
                    return new Integer(n3);
                }
                long l = this.getLong(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Long(l);
            }
            case -5: {
                if (this.metaData.isSigned(n)) {
                    long l = this.getLong(n);
                    if (this.wasNull()) {
                        return null;
                    }
                    return new Long(l);
                }
                return this.getBigDecimal(n);
            }
            case 6: 
            case 7: {
                float f = this.getFloat(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Float(f);
            }
            case 8: {
                double d = this.getDouble(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Double(d);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBlob(n);
            }
        }
        throw new SQLException(IResource.getString("CANNOT_MAP_CLASS", String.valueOf(n)));
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native int getRow() throws SQLException;

    public native short getShort(int var1) throws SQLException;

    public native short getShort(String var1) throws SQLException;

    public native Statement getStatement() throws SQLException;

    public native String getString(int var1) throws SQLException;

    public native String getString(String var1) throws SQLException;

    public native Time getTime(int var1) throws SQLException;

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return IDriver.calendarizeFrom(this.getTime(n), calendar);
    }

    public native Time getTime(String var1) throws SQLException;

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return IDriver.calendarizeFrom(this.getTime(string), calendar);
    }

    public native Timestamp getTimestamp(int var1) throws SQLException;

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return IDriver.calendarizeFrom(this.getTimestamp(n), calendar);
    }

    public native Timestamp getTimestamp(String var1) throws SQLException;

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return IDriver.calendarizeFrom(this.getTimestamp(string), calendar);
    }

    public native int getType() throws SQLException;

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native SQLWarning getWarnings() throws SQLException;

    public native void insertRow() throws SQLException;

    public native boolean isAfterLast() throws SQLException;

    public native boolean isBeforeFirst() throws SQLException;

    public native boolean isFirst() throws SQLException;

    public native boolean isLast() throws SQLException;

    public native boolean last() throws SQLException;

    public native void moveToCurrentRow() throws SQLException;

    public native void moveToInsertRow() throws SQLException;

    public native boolean next() throws SQLException;

    public native boolean previous() throws SQLException;

    public native void refreshRow() throws SQLException;

    public native boolean relative(int var1) throws SQLException;

    public native boolean rowInserted() throws SQLException;

    public native boolean rowDeleted() throws SQLException;

    public native boolean rowUpdated() throws SQLException;

    public native void setFetchDirection(int var1) throws SQLException;

    public native void setFetchSize(int var1) throws SQLException;

    public native void updateAsciiStream(int var1, InputStream var2, int var3) throws SQLException;

    public native void updateAsciiStream(String var1, InputStream var2, int var3) throws SQLException;

    public native void updateBigDecimal(int var1, BigDecimal var2) throws SQLException;

    public native void updateBigDecimal(String var1, BigDecimal var2) throws SQLException;

    public native void updateBinaryStream(int var1, InputStream var2, int var3) throws SQLException;

    public native void updateBinaryStream(String var1, InputStream var2, int var3) throws SQLException;

    public native void updateBoolean(int var1, boolean var2) throws SQLException;

    public native void updateBoolean(String var1, boolean var2) throws SQLException;

    public native void updateByte(int var1, byte var2) throws SQLException;

    public native void updateByte(String var1, byte var2) throws SQLException;

    public native void updateBytes(int var1, byte[] var2) throws SQLException;

    public native void updateBytes(String var1, byte[] var2) throws SQLException;

    public native void updateCharacterStream(int var1, Reader var2, int var3) throws SQLException;

    public native void updateCharacterStream(String var1, Reader var2, int var3) throws SQLException;

    public native void updateDate(int var1, Date var2) throws SQLException;

    public native void updateDate(String var1, Date var2) throws SQLException;

    public native void updateDouble(int var1, double var2) throws SQLException;

    public native void updateDouble(String var1, double var2) throws SQLException;

    public native void updateFloat(int var1, float var2) throws SQLException;

    public native void updateFloat(String var1, float var2) throws SQLException;

    public native void updateInt(int var1, int var2) throws SQLException;

    public native void updateInt(String var1, int var2) throws SQLException;

    public native void updateLong(int var1, long var2) throws SQLException;

    public native void updateLong(String var1, long var2) throws SQLException;

    public native void updateNull(int var1) throws SQLException;

    public native void updateNull(String var1) throws SQLException;

    public void updateObject(int n, Object object) throws SQLException {
        if (object instanceof Boolean) {
            this.updateBoolean(n, (boolean)((Boolean)object));
        } else if (object instanceof Byte) {
            this.updateByte(n, (byte)((Byte)object));
        } else if (object instanceof Short) {
            this.updateShort(n, (short)((Short)object));
        } else if (object instanceof Integer) {
            this.updateInt(n, (int)((Integer)object));
        } else if (object instanceof Float) {
            this.updateFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.updateDouble(n, (double)((Double)object));
        } else if (object instanceof BigDecimal) {
            this.updateBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof String) {
            this.updateString(n, (String)object);
        } else if (object instanceof Date) {
            this.updateDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.updateTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.updateTimestamp(n, (Timestamp)object);
        } else if (object instanceof byte[]) {
            this.updateBytes(n, (byte[])object);
        } else {
            this.updateString(n, object.toString());
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (object instanceof BigDecimal) {
            this.updateBigDecimal(n, ((BigDecimal)object).setScale(n2));
            return;
        }
        this.updateObject(n, object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        if (object instanceof BigDecimal) {
            this.updateBigDecimal(this.findColumn(string), ((BigDecimal)object).setScale(n));
            return;
        }
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        if (object instanceof BigDecimal) {
            this.updateBigDecimal(this.findColumn(string), (BigDecimal)object);
            return;
        }
        this.updateObject(this.findColumn(string), object);
    }

    public native void updateRow() throws SQLException;

    public native void updateShort(int var1, short var2) throws SQLException;

    public native void updateShort(String var1, short var2) throws SQLException;

    public native void updateString(int var1, String var2) throws SQLException;

    public native void updateString(String var1, String var2) throws SQLException;

    public native void updateTime(int var1, Time var2) throws SQLException;

    public native void updateTime(String var1, Time var2) throws SQLException;

    public native void updateTimestamp(int var1, Timestamp var2) throws SQLException;

    public native void updateTimestamp(String var1, Timestamp var2) throws SQLException;

    public native boolean wasNull() throws SQLException;

    public native void getNativeRowReader(long var1);

    public boolean equals(Object object) {
        return object instanceof IResultSet;
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }
}

