(ns {{namespace}}.handler.main
  (:require [zou.web.handler :as h]
            [zou.web.response :as res]{{#hiccup?}}
            [zou.web.view.hiccup :as hic]{{/hiccup?}}))

(h/defhandler home [$view]
  (-> ($view :main/home)
      res/ok
      res/html)){{#hiccup?}}

(h/defhandler greet-hiccup [$view people]
  (-> ($view :main/hiccup
             {:header "Hiccup test"
              :messages [(list "Hello, " [:b people] "!")
                         "normal text"
                         [:b "<b>bold text</b>"]
                         "<b>non bold text</b>"
                         (hic/raw "<b>bold text</b>")]})
      res/ok
      res/html)){{/hiccup?}}{{#enlive?}}

(h/defhandler greet-enlive [$view people]
  (-> ($view :main/enlive
             {:header "Enlive test"
              :message (str "Hello, " people)})
      res/ok
      res/html)){{/enlive?}}
