(ns {{namespace}}.view.main
  (:require [zou.util :as u]{{#hiccup?}}
            [zou.web.view.hiccup :as h]{{/hiccup?}}{{#enlive?}}
            [clojure.java.io :as io]
            [net.cgrand.enlive-html :as html]{{/enlive?}}
            [clojure.string :as str]))

(u/defnk home [app-name {javascripts []} {stylesheets []}]
  (str "<html><head>"
       "<title>" app-name "</title>"
       (str/join (for [[_ href] stylesheets]
                   (str "<link rel=\"stylesheet\" href=\"" href "\">")))
       "</head><body>"
       "<h1>" app-name "</h1>"
       "<p>Welcome to Zou!</p>"
       (str/join (for [[_ src] javascripts]
                   (str "<script src=\"" src "\">")))
       "</body></html>")){{#hiccup?}}

(h/defhiccup hiccup [app-name header messages {javascripts []} {stylesheets []}]
  (h/html5
   [:head
    [:title app-name]
    (apply h/include-css (map last stylesheets))]
   [:body
    [:h1 header]
    (for [m messages]
      [:p m])
    (apply h/include-js (map last javascripts))])){{/hiccup?}}{{#enlive?}}

(html/deftemplate enlive (io/resource "templates/layout.html")
  [{:keys [app-name header message javascripts stylesheets]}]
  [:title] (html/content app-name)
  [:head] (html/append (html/html (for [[_ href] stylesheets]
                                    [:link {:rel "stylesheet" :href href}])))
  [:body] (html/append (html/html (for [[_ src] javascripts]
                                    [:script {:src src}])))
  [:h1] (html/content header)
  [:#content] (html/content message)){{/enlive?}}
