(ns clj-index.impl.common
  (:import (java.util Collections)))

(defprotocol Matcher
  (match [this data]))

(defn count-match
  "counts number of matching items from the beginning"
  [str1 str2]
  (or (last (take-while identity
                        (map (fn [c1 c2 i] (if (= c1 c2) i))
                             str1 str2 (iterate inc 1))))
      0))

(defn find-z
  "Returns an array of substring lengths that are propper prefixes of the string.
   Positions in the array correspond to the positions of the first characters
   of these substrings."
  [pattern]
  (when (seq pattern)
    (loop [k 1, zs (transient [0]), l 0, r 0, tail (rest pattern)]
      (cond
        ;;done
        (empty? tail) (persistent! zs)
        ;;outside of the envelope
        (> k r) (let [zk (count-match pattern tail)]
                  (recur (inc k) (conj! zs zk) k (+ k zk -1) (rest tail)))
        ;;in the envelope
        :else
        (let [zkp (nth zs (- k l)) betta (- r k -1)]
          (cond
            ;;zk-prime is less than betta, then zk=zkp
            (< zkp betta) (recur (inc k) (conj! zs zkp) l r (rest tail))
            ;;zk-prime is greater than betta, then zk=betta and l=k
            (> zkp betta) (recur (inc k) (conj! zs betta) k r (rest tail))
            ;;zkp stopped exactly at the border of zl new character at the end of betta may match
            :else (let [zk (+ betta (count-match (drop betta pattern) (drop betta tail)))]
                    (recur (inc k) (conj! zs zk) k (+ k zk -1) (rest tail)))))))))

(defn find-sp*
  "Converts Z(i) values to sp(i)."
  [z-values]
  (when (seq z-values)
    (let [length (count z-values)]
      (persistent!
        (reduce (fn [so-far [z-value j]]
                  (assoc! so-far (+ j z-value -1) z-value))
                (transient (into [] (repeat length 0)))
                (map list
                     (reverse z-values)
                     (range (dec length) 0 -1)))))))

(defn find-sp
  "Returns sp(i) values for the Knuth-Morris-Pratt method."
  [pattern]
  (find-sp* (find-z pattern)))


(defn drop-indexed
  "Applies predicate to the items of the given collections
   until it returns false. Returns a tuple with
   index of the last check and the values at this postion."
  [pred & collections]
  (drop-while #(apply pred (drop 1 %))
              (apply map vector
                     (iterate inc 0)
                     collections)))

(defn binary-search
  "Returns the searched item or if it's not in the seq its predecessor"
  [coll value default]
  (if (seq coll)
    (let [res (Collections/binarySearch coll value)
          res (if (< res 0)
                (- -2 res) ;;return previous item's index
                res)	   ;;return found item's index
          ]
      (get coll res default))
    default))