(ns clj-index.core
  (:require [clj-index.impl.aho-corasick :refer [->ACIndex add-word! add-links! get-max-length ]]
            [clj-index.impl.boyer-moore :refer [->BMIndex find-reverse-N find-char-idx find-L find-li]]
            [clj-index.impl.knuth-morris-pratt :refer [->KMP-Index]]
            [clj-index.impl.common :as common :refer [find-sp]]
            [clj-index.impl.mutable.mbox :refer [mbox]])
  (:import (cljindex.mutable Box)
           (clj_index.impl.common Matcher)))


(defn ac-index
  ""
  [patterns]
  (let [tree (mbox)]
    (doseq [pattern patterns]
      (add-word! tree pattern))
    (add-links! tree)
    (->ACIndex tree (get-max-length tree))))


(defn bm-index
  ""
  [pattern]
  (let [reverse-n (find-reverse-N pattern)]
    (->BMIndex
      pattern
      (count pattern)
      (find-char-idx pattern)
      (find-L reverse-n)
      (find-li reverse-n))))


(defn kmp-index
  ""
  [pattern]
  (->KMP-Index pattern
               (count pattern)
               (find-sp pattern)))

;; re-export protocol to callers
(defn match
  ""
  [^Matcher index data]
  (common/match index data))