
(ns clojstrap.core
  (:use-macros [dommy.macros :only [sel sel1 node deftemplate]])
  (:require [dommy.core :as d]))

(def close "×")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Dropdown generalization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Tabpane
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn- tabpane-entry [tabroot {:keys [type title content]}]
  (let [id (str "tab_" (+ (hash title) (.now js/Date)))
        entry (node [:li {:id id} [:a {:href "javascript:void(0);"} title]])
        cont-atom (atom content)]
    (-> (sel1 entry [:li :a])
        (d/listen! :click
                   (fn [_]
                     (let [domnodes (sel [(str "#" tabroot) ".active"])]
                       (if (> (count domnodes) 0)
                         (d/remove-class! (first domnodes) :active)))
                     (d/add-class! (sel1 (str "#" id)) :active)
                     (d/replace-contents! (sel1 [(str "#" tabroot) :.tab-content])
                                          (do
                                            (if (fn? @cont-atom)
                                              (swap! cont-atom (@cont-atom)))
                                            @cont-atom)))))
    entry))

(defn- tabpane-subdropdown [tabroot {:keys [type title content]}]
  (let [id (+ (hash title) (.now js/Date))]
    (node [:li.dropdown-submenu
           [:a {:tabindex "-1" :href "javascript:void(0);"} title]
           [:ul.dropdown-menu
            (for [child-content content]
              (if (= (:type child-content) :nav/entry)
                (tabpane-entry tabroot child-content)
                (if (= (:type child-content) :nav/dropdown)
                  (tabpane-subdropdown tabroot child-content)
                  child-content)))]])))

(defn- tabpane-dropdown [tabroot {:keys [type title content]}]
  (let [id (str "dropdown_" (+ (hash title) (.now js/Date)))]
    (node [:li.dropdown
           [:a.dropdown-toggle {:data-toggle "dropdown" :href "#"} title " " [:b.caret]]
           [:ul.dropdown-menu
            (for [child-content content]
              (if (= (:type child-content) :nav/entry)
                (tabpane-entry tabroot child-content)
                (if (= (:type child-content) :nav/dropdown)
                  (tabpane-subdropdown tabroot child-content)
                  child-content)))]])))

(defn nav
  "Creates a tab-pane with content out of a vector with maps of data.
The structure has to be structured as follows:
* A top-level vector containing maps
* Each map has three keys:
** :type can be:
   - :nav/entry - this will create a top level entry
   - :nav/dropdown - this will assume the entries in the content key
** :title The text shown as the tab name
** :content If the :type is :nav/entry, this contains the tab content. Can also be a zero-argument function.
            If it's :nav/dropdown, this contains the tab entries for the dropdown.
* The entries for :nav/dropdown are structured exactly the same as the top-level entries.
Options: Takes a map with the keys navtype and/or stacked? and/or tabdir.
navtype takes either :tabs, :pills or :list."
  [content & {:keys [navtype stacked? tabdir] :or {navtype :tabs stacked? false}}]
  (let [uid (.now js/Date)
        id (str "tabpane_" uid)
        tabdir (if (nil? tabdir) "" (str "tabs-" tabdir))]
    (node [:div {:id id :class (str "tabbable " tabdir)}
           [:ul {:class (str "nav nav-" (name navtype))}
            (for [entry content]
              (if (= (:type entry) :nav/entry)
                (tabpane-entry id entry)
                (tabpane-dropdown id entry)))]
           [:div.tab-content]])))

