(ns zero-one.geni.core
  (:refer-clojure :exclude [*
                            +
                            -
                            /
                            <
                            <=
                            =
                            >
                            >=
                            alias
                            assoc
                            boolean
                            byte
                            case
                            cast
                            concat
                            cond
                            condp
                            count
                            dec
                            dissoc
                            distinct
                            double
                            drop
                            empty?
                            even?
                            filter
                            first
                            flatten
                            float
                            group-by
                            hash
                            if
                            inc
                            int
                            keys
                            last
                            long
                            map
                            max
                            merge
                            merge-with
                            min
                            mod
                            neg?
                            not
                            odd?
                            partition-by
                            pos?
                            rand
                            rand-int
                            rand-nth
                            range
                            remove
                            rename-keys
                            replace
                            reverse
                            second
                            select-keys
                            sequence
                            short
                            shuffle
                            sort
                            str
                            struct
                            take
                            update
                            vals
                            when
                            zero?
                            zipmap])
  (:require
   [potemkin :refer [import-fn import-vars]]
   [zero-one.geni.arrow]
   [zero-one.geni.core.clojure-idioms]
   [zero-one.geni.core.column]
   [zero-one.geni.core.data-sources]
   [zero-one.geni.core.dataset-creation]
   [zero-one.geni.core.dataset]
   [zero-one.geni.core.foreign-idioms]
   [zero-one.geni.core.functions]
   [zero-one.geni.core.polymorphic]
   [zero-one.geni.core.window]
   [zero-one.geni.interop]
   [zero-one.geni.spark-context]
   [zero-one.geni.spark]
   [zero-one.geni.storage]))

(import-vars
 [zero-one.geni.interop
  dense
  row
  sparse])

(import-vars
 [zero-one.geni.spark
  create-spark-session
  spark-conf
  sql])

(import-vars
 [zero-one.geni.spark-context
  app-name
  binary-files
  checkpoint-dir
  conf
  default-min-partitions
  default-parallelism
  get-checkpoint-dir
  get-conf
  get-local-property
  get-persistent-rdds
  get-spark-home
  jars
  java-spark-context
  master
  resources
  sc
  spark-context
  spark-home
  version])

(import-vars
 [zero-one.geni.core.column
  %
  &
  &&
  *
  +
  -
  ->col-array
  ->column
  /
  <
  <=
  <=>
  =!=
  ===
  >
  >=
  asc
  asc-nulls-first
  asc-nulls-last
  between
  bitwise-and
  bitwise-or
  bitwise-xor
  cast
  col
  contains
  desc
  desc-nulls-first
  desc-nulls-last
  ends-with
  get-field
  get-item
  hash-code
  is-in-collection
  is-nan
  is-not-null
  is-null
  isin
  like
  lit
  mod
  nan?
  not-null?
  null-count
  null-rate
  null?
  rlike
  starts-with
  |
  ||])

(import-vars
 [zero-one.geni.core.functions
  !
  **
  ->date-col
  ->timestamp-col
  ->utc-timestamp
   ;bucket
   ;days
   ;hours
   ;months
   ;years
  abs
  acos
  add-months
  aggregate
  approx-count-distinct
  array
  array-contains
  array-distinct
  array-except
  array-intersect
  array-join
  array-max
  array-min
  array-position
  array-remove
  array-repeat
  array-sort
  array-union
  arrays-overlap
  arrays-zip
  ascii
  asin
  atan
  atan-2
  atan2
  base-64
  base64
  bin
  bitwise-not
  broadcast
  bround
  cbrt
  ceil
  collect-list
  collect-set
  concat
  concat-ws
  conv
  cos
  cosh
  count-distinct
  covar
  covar-pop
  covar-samp
  crc-32
  crc32
  cube-root
  cume-dist
  current-date
  current-timestamp
  date-add
  date-diff
  date-format
  date-sub
  date-trunc
  datediff
  day-of-month
  day-of-week
  day-of-year
  dayofmonth
  dayofweek
  dayofyear
  decode
  degrees
  dense-rank
  element-at
  encode
  exists
  exp
  explode
  expm-1
  expm1
  expr
  factorial
  flatten
  floor
  forall
  format-number
  format-string
  from-csv
  from-json
  from-unixtime
  greatest
  grouping
  grouping-id
  hash
  hex
  hour
  hypot
  initcap
  input-file-name
  instr
  kurtosis
  lag
  last-day
  lead
  least
  length
  levenshtein
  locate
  log
  log-10
  log-1p
  log-2
  log10
  log1p
  log2
  lower
  lpad
  ltrim
  map
  map-concat
  map-entries
  map-filter
  map-from-arrays
  map-from-entries
  map-keys
  map-values
  map-zip-with
  md-5
  md5
  minute
  monotonically-increasing-id
  month
  months-between
  nanvl
  negate
  next-day
  not
  ntile
  overlay
  percent-rank
  pi
  pmod
  posexplode
  posexplode-outer
  pow
  quarter
  radians
  rand
  randn
  rank
  regexp-extract
  regexp-replace
  reverse
  rint
  round
  row-number
  rpad
  rtrim
  schema-of-csv
  schema-of-json
  second
  sequence
  sha-1
  sha-2
  sha1
  sha2
  shift-left
  shift-right
  shift-right-unsigned
  signum
  sin
  sinh
  size
  skewness
  slice
  sort-array
  soundex
  spark-partition-id
  split
  sqr
  sqrt
  std
  stddev
  stddev-pop
  stddev-samp
  struct
  substring
  substring-index
  sum-distinct
  tan
  tanh
  time-window
  to-csv
  to-date
  to-timestamp
  to-utc-timestamp
  transform
  transform-keys
  transform-values
  translate
  trim
  unbase-64
  unbase64
  unhex
  unix-timestamp
  upper
  var-pop
  var-samp
  variance
  weekofyear
  week-of-year
  when
  xxhash-64
  xxhash64
  year
  zip-with])

(import-vars
 [zero-one.geni.core.dataset-creation
  ->schema
  array-type
  create-dataframe
  map->dataset
  map-type
  range
  records->dataset
  struct-field
  struct-type
  table->dataset])

(import-vars
 [zero-one.geni.core.dataset
  add
  agg
  agg-all
  approx-quantile
  bit-size
  bloom-filter
  cache
  checkpoint
  col-regex
  collect
  collect-col
  collect-vals
  column-names
  columns
  compatible?
  confidence
  count-min-sketch
  cov
  cross-join
  crosstab
  cube
  depth
  describe
  distinct
  drop
  drop-duplicates
  drop-na
  dtypes
  empty?
  estimate-count
  except
  except-all
  expected-fpp
  fill-na
  first-vals
  freq-items
  group-by
  head
  head-vals
  hint
  input-files
  intersect
  intersect-all
  is-compatible
  is-empty
  is-local
  is-streaming
  join
  join-with
  last-vals
  limit
  local?
  merge-in-place
  might-contain
  order-by
  partitions
  persist
  pivot
  print-schema
  put
  random-split
  rdd
  relative-error
  rename-columns
  repartition
  repartition-by-range
  replace-na
  rollup
  sample
  sample-by
  select
  select-expr
  show
  show-vertical
  sort
  sort-within-partitions
  spark-session
  sql-context
  storage-level
  streaming?
  summary
  tail
  tail-vals
  take
  take-vals
  to-byte-array
  total-count
  union
  union-by-name
  unpersist
  width
  with-column
  with-column-renamed])

(import-vars
 [zero-one.geni.core.window
  over
  unbounded-following
  unbounded-preceding
  window
  windowed])

(import-vars
 [zero-one.geni.core.data-sources
  ->kebab-columns
  create-temp-view!
  create-or-replace-temp-view!
  create-global-temp-view!
  create-or-replace-global-temp-view!
  read-avro!
  read-binary!
  read-csv!
  read-edn!
  read-jdbc!
  read-json!
  read-libsvm!
  read-parquet!
  read-table!
  read-text!
  read-xlsx!
  write-avro!
  write-csv!
  write-edn!
  write-jdbc!
  write-json!
  write-libsvm!
  write-parquet!
  write-table!
  write-text!
  write-xlsx!])

(import-vars
 [zero-one.geni.core.polymorphic
  alias
  as
  assoc
  coalesce
  corr
  count
  dissoc
  explain
  filter
  first
  interquartile-range
  iqr
  last
  max
  mean
  median
  min
  quantile
  shuffle
  sum
  to-df
  to-json
  update
  where])

(import-vars
 [zero-one.geni.storage
  disk-only
  disk-only-2
  memory-and-disk
  memory-and-disk-2
  memory-and-disk-ser
  memory-and-disk-ser-2
  memory-only
  memory-only-2
  memory-only-ser
  memory-only-ser-2
  none
  off-heap])

(import-vars
 [zero-one.geni.core.clojure-idioms
  =
  boolean
  byte
  case
  cond
  condp
  dec
  double
  even?
  float
  if
  inc
  int
  keys
  long
  merge
  merge-with
  neg?
  odd?
  pos?
  rand-nth
  remove
  rename-keys
  select-keys
  short
  str
  vals
  zero?
  zipmap])

(import-vars
 [zero-one.geni.core.foreign-idioms
  ->dataset
  clip
  cut
  name-value-seq->dataset
  nlargest
  nsmallest
  nunique
  qcut
  random-choice
  random-exp
  random-int
  random-norm
  random-uniform
  rchoice
  replace
  rexp
  rnorm
  runif
  runiform
  select-columns
  shape
  value-counts])

(import-vars
 [zero-one.geni.arrow
  collect-to-arrow])

(def to-string
  "Coerce to string."
  (memfn toString))
(import-fn to-string ->string)

(def to-debug-string
  "Coerce to string useful for debugging."
  (memfn toDebugString))
(import-fn to-debug-string ->debug-string)

(comment
  (require '[zero-one.geni.docs :as docs])
  (docs/invalid-doc-vars *ns*)
  (docs/docless-vars *ns*))
