(ns leiningen.new.zenweb
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "zenweb"))

(defn zenweb
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
["src/{{sanitized}}/util.clj" (render "util.clj" data)]
["src/{{sanitized}}/session_manager.clj" (render "session_manager.clj" data)]
["src/{{sanitized}}/layout.clj" (render "layout.clj" data)]
["src/{{sanitized}}/routes.clj" (render "routes.clj" data)]
["test/{{sanitized}}/test/handler.clj" (render "handler.clj" data)]
["src/{{sanitized}}/handler.clj" (render "handler.clj" data)]
["src/{{sanitized}}/repl.clj" (render "repl.clj" data)]
["src/{{sanitized}}/middleware.clj" (render "middleware.clj" data)]
["project.clj" (render "project.clj" data)]
["src/{{sanitized}}/dbase.clj" (render "dbase.clj" data)]
["resources/public/css/main-style.css" (render "main_style.css")]
["resources/public/css/.DS_Store" (render ".DS_Store")]
["resources/public/css/main-style.scss" (render "main_style.scss")]
["resources/public/assets/foundation.min.css" (render "foundation.min.css")]
["resources/public/assets/normalize.css" (render "normalize.css")]
["resources/public/js/.DS_Store" (render ".DS_Store")]
["resources/public/js/app.js" (render "app.js")]
["resources/selmer/base.html" (render "base.html")]
["resources/public/assets/react.min.js" (render "react.min.js")]
)))