(ns yin.test.checker.collection)

(defmacro contains-in
  "shorthand for checking nested maps and vectors
 
   ((contains-in {:a {:b {:c odd?}}}) {:a {:b {:c 1 :d 2}}})
   => true
 
   ((contains-in [odd? {:a {:b even?}}]) [3 {:a {:b 4 :c 5}}])
   => true"
  {:added "2.4"}
  [x]
  "A macro for nested checking of data in the `contains` form"
  (cond (map? x)
        `(yin.test.checker.collection/contains 
           ~(reduce-kv (fn [out k v]
                         (assoc out k `(yin.test.checker.collection/contains-in ~v)))
                       {}
                       x))
        (set? x)
        `(yin.test.checker.collection/contains
          ~(reduce (fn [out v]
                     (conj out `(yin.test.checker.collection/contains-in ~v)))
                   []
                   x)
          :in-any-order)
        
        (vector? x)
        `(yin.test.checker.collection/contains
          ~(reduce (fn [out v]
                     (conj out `(yin.test.checker.collection/contains-in ~v)))
                   []
                   x))
        :else x))

(defmacro just-in
  "shorthand for exactly checking nested maps and vectors
 
   ((just-in {:a {:b {:c odd?}}}) {:a {:b {:c 1 :d 2}}})
   => false
 
   ((just-in [odd? {:a {:b even?}}]) [3 {:a {:b 4}}])
 
   ((just-in [odd? {:a {:b even?}}]) [3 {:a {:b 4}}])
   => true"
  {:added "2.4"}
  [x]
  "A macro for nested checking of data in the `just` form"
  (cond (map? x)
        `(yin.test.checker.collection/just 
           ~(reduce-kv (fn [out k v]
                          (assoc out k `(yin.test.checker.collection/just-in ~v)))
                          {}
                          x))
        (set? x)
        `(yin.test.checker.collection/just
           ~(reduce (fn [out v]
                      (conj out `(yin.test.checker.collection/just-in ~v)))
                      []
                      x)
                     :in-any-order)
        
        (vector? x)
        `(yin.test.checker.collection/just
           ~(reduce (fn [out v]
                      (conj out `(yin.test.checker.collection/just-in ~v)))
                      []
                      x))
        :else x))
