(ns yin.package
  (:require [lucid.package :as package]
            [hara.io.project :as project]
            [hara.io.file :as fs]))

(def ^:dynamic *shadow-file* "shadow-cljs.edn")

(defn package-artifact [full]
  (let [group    (or (namespace full)
                     (str full))
        artifact (name full)]
    {:name full
     :artifact artifact
     :group group}))

(defn prepare
  [key shadow-file]
  (if-let [package (-> shadow-file
                       slurp
                       read-string
                       :packages
                       (get key))]
    (let [root    (-> (fs/path shadow-file) (.getParent))
          package (-> package
                      (assoc :root root)
                      (merge (package-artifact (:name package))))]
      package)
    (throw (ex-info ":key not present in shadow-file" {:key key}))))

(defn install
  ([key] (install key *shadow-file*))
  ([key shadow-file]
   (let [package (prepare key shadow-file)]
     (package/install-project package))))

(defn deploy
  ([key] (install key *shadow-file*))
  ([key shadow-file]
   (let [package (prepare key shadow-file)]
     (package/deploy-project package))))

(comment
  (install :artifact))
