goog.provide('yin.test.runner');
goog.require('cljs.core');
goog.require('yin.test.common');
goog.require('yin.test.checker.base');
goog.require('yin.io.ansii');
goog.require('yin.event');
/**
 * helper function for accumulating results over disparate facts and files
 */
yin.test.runner.accumulate = (function yin$test$runner$accumulate(var_args){
var G__36756 = arguments.length;
switch (G__36756) {
case 1:
return yin.test.runner.accumulate.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return yin.test.runner.accumulate.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.test.runner.accumulate.cljs$core$IFn$_invoke$arity$1 = (function (func){
return yin.test.runner.accumulate.cljs$core$IFn$_invoke$arity$3(func,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid())].join('')),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
});

yin.test.runner.accumulate.cljs$core$IFn$_invoke$arity$3 = (function (func,id,sink){
var source = yin.test.common._STAR_accumulator_STAR_;
cljs.core.add_watch(source,id,((function (source){
return (function (_,___$1,___$2,n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(n),id)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(sink,cljs.core.conj,n);
} else {
return null;
}
});})(source))
);

var _STAR_id_STAR_36763_36775 = yin.test.common._STAR_id_STAR_;
yin.test.common._STAR_id_STAR_ = id;

try{(func.cljs$core$IFn$_invoke$arity$2 ? func.cljs$core$IFn$_invoke$arity$2(id,sink) : func.call(null,id,sink));
}finally {yin.test.common._STAR_id_STAR_ = _STAR_id_STAR_36763_36775;
}
cljs.core.remove_watch(source,id);

return cljs.core.deref(sink);
});

yin.test.runner.accumulate.cljs$lang$maxFixedArity = 3;

/**
 * summary function for accumulated results
 */
yin.test.runner.interim = (function yin$test$runner$interim(facts){
var results = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"results","results",-1134170113),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([facts], 0));
var checks = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (results){
return (function (p1__36794_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(p1__36794_SHARP_),new cljs.core.Keyword(null,"verify","verify",-1196899752));
});})(results))
,results);
var forms = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (results,checks){
return (function (p1__36795_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(p1__36795_SHARP_),new cljs.core.Keyword(null,"evaluate","evaluate",1525218437));
});})(results,checks))
,results);
var thrown = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (results,checks,forms){
return (function (p1__36796_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(p1__36796_SHARP_),new cljs.core.Keyword(null,"exception","exception",-335277064));
});})(results,checks,forms))
,forms);
var passed = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(yin.test.checker.base.succeeded_QMARK_,checks);
var failed = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.not,yin.test.checker.base.succeeded_QMARK_),checks);
var facts__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$3(cljs.core.not,cljs.core.empty_QMARK_,new cljs.core.Keyword(null,"results","results",-1134170113)),facts);
var files = cljs.core.keys(cljs.core.frequencies(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword(null,"meta","meta",1499536964)),checks)));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"files","files",-472457450),files,new cljs.core.Keyword(null,"thrown","thrown",-978456523),thrown,new cljs.core.Keyword(null,"facts","facts",-1734543718),facts__$1,new cljs.core.Keyword(null,"checks","checks",526134637),checks,new cljs.core.Keyword(null,"passed","passed",-28165278),passed,new cljs.core.Keyword(null,"failed","failed",-1397425762),failed], null);
});
/**
 * run tests for namespace
 *  
 * (run-namespace 'hara.class.checks-test)
 * => {:files 1, :thrown 0, :facts 5, :checks 9, :passed 9, :failed 0}
 * 
 * ;; ---- Namespace (hara.class.checks-test) ----
 * ;;
 * ;; Summary (1)
 * ;;   Files  1
 * ;;   Facts  5
 * ;;  Checks  9
 * ;;  Passed  9
 * ;;  Thrown  0
 * ;;
 * ;; Success (9)
 * 
 */
yin.test.runner.run_tests = (function yin$test$runner$run_tests(tests){
var _STAR_errors_STAR_36807 = yin.test.common._STAR_errors_STAR_;
yin.test.common._STAR_errors_STAR_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);

try{var facts = yin.test.runner.accumulate.cljs$core$IFn$_invoke$arity$1(((function (_STAR_errors_STAR_36807){
return (function (id,sink){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (_STAR_errors_STAR_36807){
return (function (t){
return (t.cljs$core$IFn$_invoke$arity$0 ? t.cljs$core$IFn$_invoke$arity$0() : t.call(null));
});})(_STAR_errors_STAR_36807))
,tests);
});})(_STAR_errors_STAR_36807))
);
var results = yin.test.runner.interim(facts);
yin.event.signal.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword(null,"bulk","bulk",2034521319),new cljs.core.Keyword(null,"results","results",-1134170113),results], null));

return cljs.core.reduce_kv(((function (facts,results,_STAR_errors_STAR_36807){
return (function (out,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,k,cljs.core.count(v));
});})(facts,results,_STAR_errors_STAR_36807))
,cljs.core.PersistentArrayMap.EMPTY,results);
}finally {yin.test.common._STAR_errors_STAR_ = _STAR_errors_STAR_36807;
}});
/**
 * run tests for namespace
 *  
 * (run-namespace 'hara.class.checks-test)
 * => {:files 1, :thrown 0, :facts 5, :checks 9, :passed 9, :failed 0}
 * 
 * ;; ---- Namespace (hara.class.checks-test) ----
 * ;;
 * ;; Summary (1)
 * ;;   Files  1
 * ;;   Facts  5
 * ;;  Checks  9
 * ;;  Passed  9
 * ;;  Thrown  0
 * ;;
 * ;; Success (9)
 * 
 */
yin.test.runner.run_namespace_tests = (function yin$test$runner$run_namespace_tests(inputs){
var _STAR_errors_STAR_36811 = yin.test.common._STAR_errors_STAR_;
yin.test.common._STAR_errors_STAR_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);

try{var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid())].join(''));
var sink = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
var _ = (function (){var seq__36815 = cljs.core.seq(inputs);
var chunk__36816 = null;
var count__36817 = (0);
var i__36818 = (0);
while(true){
if((i__36818 < count__36817)){
var vec__36819 = chunk__36816.cljs$core$IIndexed$_nth$arity$2(null,i__36818);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36819,(0),null);
var tests = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36819,(1),null);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([yin.io.ansii.style(ns,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"green","green",-945526839),null], null), null))], 0));

yin.test.runner.accumulate.cljs$core$IFn$_invoke$arity$3(((function (seq__36815,chunk__36816,count__36817,i__36818,vec__36819,ns,tests,id,sink,_STAR_errors_STAR_36811){
return (function (id__$1,sink__$1){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (seq__36815,chunk__36816,count__36817,i__36818,vec__36819,ns,tests,id,sink,_STAR_errors_STAR_36811){
return (function (t){
return (t.cljs$core$IFn$_invoke$arity$0 ? t.cljs$core$IFn$_invoke$arity$0() : t.call(null));
});})(seq__36815,chunk__36816,count__36817,i__36818,vec__36819,ns,tests,id,sink,_STAR_errors_STAR_36811))
,tests);
});})(seq__36815,chunk__36816,count__36817,i__36818,vec__36819,ns,tests,id,sink,_STAR_errors_STAR_36811))
,id,sink);


var G__36825 = seq__36815;
var G__36826 = chunk__36816;
var G__36827 = count__36817;
var G__36828 = (i__36818 + (1));
seq__36815 = G__36825;
chunk__36816 = G__36826;
count__36817 = G__36827;
i__36818 = G__36828;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__36815);
if(temp__5457__auto__){
var seq__36815__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__36815__$1)){
var c__4338__auto__ = cljs.core.chunk_first(seq__36815__$1);
var G__36829 = cljs.core.chunk_rest(seq__36815__$1);
var G__36830 = c__4338__auto__;
var G__36831 = cljs.core.count(c__4338__auto__);
var G__36832 = (0);
seq__36815 = G__36829;
chunk__36816 = G__36830;
count__36817 = G__36831;
i__36818 = G__36832;
continue;
} else {
var vec__36822 = cljs.core.first(seq__36815__$1);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36822,(0),null);
var tests = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36822,(1),null);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([yin.io.ansii.style(ns,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"green","green",-945526839),null], null), null))], 0));

yin.test.runner.accumulate.cljs$core$IFn$_invoke$arity$3(((function (seq__36815,chunk__36816,count__36817,i__36818,vec__36822,ns,tests,seq__36815__$1,temp__5457__auto__,id,sink,_STAR_errors_STAR_36811){
return (function (id__$1,sink__$1){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (seq__36815,chunk__36816,count__36817,i__36818,vec__36822,ns,tests,seq__36815__$1,temp__5457__auto__,id,sink,_STAR_errors_STAR_36811){
return (function (t){
return (t.cljs$core$IFn$_invoke$arity$0 ? t.cljs$core$IFn$_invoke$arity$0() : t.call(null));
});})(seq__36815,chunk__36816,count__36817,i__36818,vec__36822,ns,tests,seq__36815__$1,temp__5457__auto__,id,sink,_STAR_errors_STAR_36811))
,tests);
});})(seq__36815,chunk__36816,count__36817,i__36818,vec__36822,ns,tests,seq__36815__$1,temp__5457__auto__,id,sink,_STAR_errors_STAR_36811))
,id,sink);


var G__36833 = cljs.core.next(seq__36815__$1);
var G__36834 = null;
var G__36835 = (0);
var G__36836 = (0);
seq__36815 = G__36833;
chunk__36816 = G__36834;
count__36817 = G__36835;
i__36818 = G__36836;
continue;
}
} else {
return null;
}
}
break;
}
})();
var results = yin.test.runner.interim(cljs.core.deref(sink));
yin.event.signal.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword(null,"bulk","bulk",2034521319),new cljs.core.Keyword(null,"results","results",-1134170113),results], null));

return cljs.core.reduce_kv(((function (id,sink,_,results,_STAR_errors_STAR_36811){
return (function (out,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,k,cljs.core.count(v));
});})(id,sink,_,results,_STAR_errors_STAR_36811))
,cljs.core.PersistentArrayMap.EMPTY,results);
}finally {yin.test.common._STAR_errors_STAR_ = _STAR_errors_STAR_36811;
}});

//# sourceMappingURL=yin.test.runner.js.map
