goog.provide('yin.test.checker.util');
goog.require('cljs.core');
/**
 * checks if a sequence matches exactly
 * (contains-exact [0 1 2 3] (map checker/->checker [1 2 3]))
 * => true
 *  
 * (contains-exact [0 1 2 3] (map checker/->checker [1 3]))
 * => false
 */
yin.test.checker.util.contains_exact = (function yin$test$checker$util$contains_exact(seq,pattern){
var len = cljs.core.count(pattern);
var n = (cljs.core.count(seq) - len);
var seq__$1 = cljs.core.vec(seq);
var or__3936__auto__ = cljs.core.some(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (len,n,seq__$1){
return (function (i){
return cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (len,n,seq__$1){
return (function (p1__29675_SHARP_,p2__29676_SHARP_){
return (p1__29675_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29675_SHARP_.cljs$core$IFn$_invoke$arity$1(p2__29676_SHARP_) : p1__29675_SHARP_.call(null,p2__29676_SHARP_));
});})(len,n,seq__$1))
,pattern,cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(seq__$1,i,(i + len))));
});})(len,n,seq__$1))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1((n + (1)))));
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return false;
}
});
/**
 * checks if a sequence matches the pattern, with gaps allowed
 * (contains-with-gaps [0 1 2 3] (map checker/->checker [1 2 3]))
 * => true
 *  
 * (contains-with-gaps [0 1 2 3] (map checker/->checker [1 3]))
 * => true
 *  
 * (contains-with-gaps [0 1 2 3] (map checker/->checker [2 0]))
 * => false
 */
yin.test.checker.util.contains_with_gaps = (function yin$test$checker$util$contains_with_gaps(seq,pattern){
while(true){
if(cljs.core.empty_QMARK_(pattern)){
return true;
} else {
if(cljs.core.empty_QMARK_(seq)){
return false;
} else {
if(cljs.core.truth_((function (){var G__29683 = cljs.core.first(seq);
var fexpr__29682 = cljs.core.first(pattern);
return (fexpr__29682.cljs$core$IFn$_invoke$arity$1 ? fexpr__29682.cljs$core$IFn$_invoke$arity$1(G__29683) : fexpr__29682.call(null,G__29683));
})())){
var G__29684 = cljs.core.next(seq);
var G__29685 = cljs.core.next(pattern);
seq = G__29684;
pattern = G__29685;
continue;
} else {
var G__29686 = cljs.core.next(seq);
var G__29687 = pattern;
seq = G__29686;
pattern = G__29687;
continue;

}
}
}
break;
}
});
/**
 * decide if a given vector of perms are appropriately matched
 * (perm-check [#{0 1 2} #{2} #{0 2}] #{0 1 2})
 * => true
 *  
 * (perm-check [#{2} #{0 1 2} #{2}] #{0 1 2})
 * => false
 *  
 * (perm-check [#{1} #{1 0} #{0 2 1} #{1 0} #{0 2 1}] #{0 1 2})
 * => true
 */
yin.test.checker.util.perm_check = (function yin$test$checker$util$perm_check(var_args){
var G__29690 = arguments.length;
switch (G__29690) {
case 2:
return yin.test.checker.util.perm_check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return yin.test.checker.util.perm_check.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.test.checker.util.perm_check.cljs$core$IFn$_invoke$arity$2 = (function (perm,all){
return yin.test.checker.util.perm_check.cljs$core$IFn$_invoke$arity$3(perm,all,cljs.core.zipmap(all,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)));
});

yin.test.checker.util.perm_check.cljs$core$IFn$_invoke$arity$3 = (function (perm,all,selection){
while(true){
if(cljs.core.empty_QMARK_(all)){
return true;
} else {
if(cljs.core.every_QMARK_(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.not),cljs.core.vals(selection))){
return true;
} else {
var stats = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (perm,all,selection){
return (function (out,v){
var cnt = cljs.core.set(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(((function (perm,all,selection){
return (function (i,set){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(set,v))){
return i;
} else {
return null;
}
});})(perm,all,selection))
,perm));
return cljs.core.assoc_in(out,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),cnt);
});})(perm,all,selection))
,cljs.core.PersistentArrayMap.EMPTY,all);
var order = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.count,cljs.core.second),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,stats));
var vec__29694 = cljs.core.first(order);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29694,(0),null);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29694,(1),null);
var col = cljs.core.first(matches);
if((col == null)){
return false;
} else {
var G__29708 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (perm,all,selection,stats,order,vec__29694,i,matches,col){
return (function (p1__29688_SHARP_){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(p1__29688_SHARP_,i);
});})(perm,all,selection,stats,order,vec__29694,i,matches,col))
,perm),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.empty);
var G__29709 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(all,i);
var G__29710 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(selection,i,col);
perm = G__29708;
all = G__29709;
selection = G__29710;
continue;
}

}
}
break;
}
});

yin.test.checker.util.perm_check.cljs$lang$maxFixedArity = 3;

/**
 * builds a perm out of a sequence and checks
 * (perm-build [0 1 2 3] (map checker/->checker [1 3]))
 * => [#{} #{0} #{} #{1}]
 *  
 * (perm-build [0 1 2 3] (map checker/->checker [odd? 3 number?]))
 * => [#{2} #{0 2} #{2} #{0 1 2}]
 */
yin.test.checker.util.perm_build = (function yin$test$checker$util$perm_build(seq,pattern){
var idx = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,pat){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,pat], null);
}),pattern));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (idx){
return (function (ele){
return cljs.core.reduce_kv(((function (idx){
return (function (acc,k,v){
if(cljs.core.truth_((v.cljs$core$IFn$_invoke$arity$1 ? v.cljs$core$IFn$_invoke$arity$1(ele) : v.call(null,ele)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,k);
} else {
return acc;
}
});})(idx))
,cljs.core.PersistentHashSet.EMPTY,idx);
});})(idx))
,seq);
});
/**
 * checks if a sequence matches the pattern, with any order allowed
 * (contains-any-order [0 1 2 3] (map checker/->checker [2 1 3]))
 * => true
 *  
 * (contains-any-order [0 1 2 3] (map checker/->checker [2 0 3]))
 * => false
 */
yin.test.checker.util.contains_any_order = (function yin$test$checker$util$contains_any_order(seq,pattern){
var seq__$1 = cljs.core.vec(seq);
var len = cljs.core.count(pattern);
var n = (cljs.core.count(seq__$1) - len);
var indices = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (seq__$1,len,n){
return (function (i){
return yin.test.checker.util.perm_build(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(seq__$1,i,(i + len)),pattern);
});})(seq__$1,len,n))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1((n + (1))));
var or__3936__auto__ = cljs.core.some(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (seq__$1,len,n,indices){
return (function (p1__29711_SHARP_){
return yin.test.checker.util.perm_check.cljs$core$IFn$_invoke$arity$2(p1__29711_SHARP_,cljs.core.set(cljs.core.range.cljs$core$IFn$_invoke$arity$1(len)));
});})(seq__$1,len,n,indices))
,indices));
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return false;
}
});
/**
 * checks if a sequence matches any of the checks
 * (contains-all [0 1 2 3] (map checker/->checker [2 1 3]))
 * => true
 *  
 * (contains-all [0 1 2 3] (map checker/->checker [2 0 3]))
 * => true
 *  
 * (contains-all [0 1 2 3] (map checker/->checker [0 0]))
 * => false
 */
yin.test.checker.util.contains_all = (function yin$test$checker$util$contains_all(seq,pattern){
var index = yin.test.checker.util.perm_build(seq,pattern);
return yin.test.checker.util.perm_check.cljs$core$IFn$_invoke$arity$2(index,cljs.core.set(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(pattern))));
});

//# sourceMappingURL=yin.test.checker.util.js.map
