goog.provide('yin.test.checker.collection');
goog.require('cljs.core');
goog.require('yin.test.common');
goog.require('yin.test.checker.base');
goog.require('yin.test.checker.util');
/**
 * takes two maps and determines if they fit
 * (verify-map {:a (base/satisfies odd?)
 *              :b (base/satisfies even?)}
 *             {:a 1 :b 2})
 * => true
 */
yin.test.checker.collection.verify_map = (function yin$test$checker$collection$verify_map(ck,data){
return cljs.core.every_QMARK_(yin.test.checker.base.succeeded_QMARK_,cljs.core.reduce_kv((function (out,k,sck){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,yin.test.checker.base.verify(sck,cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,k)));
}),cljs.core.PersistentVector.EMPTY,ck));
});
/**
 * takes two seqs and determines if they fit
 * (verify-seq [(base/satisfies 1) (base/satisfies 2)]
 *             [2 1]
 *             #{:in-any-order})
 * => true
 *  
 * (verify-seq [(base/satisfies 1) (base/satisfies 2)]
 *             [2 3 1]
 *             #{:in-any-order :gaps-ok})
 * => true
 */
yin.test.checker.collection.verify_seq = (function yin$test$checker$collection$verify_seq(ck,data,modifiers){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,modifiers)){
return yin.test.checker.util.contains_exact(data,ck);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"in-any-order","in-any-order",-751831450),null], null), null),modifiers)){
return yin.test.checker.util.contains_any_order(data,ck);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"gaps-ok","gaps-ok",-115900561),null], null), null),modifiers)){
return yin.test.checker.util.contains_with_gaps(data,ck);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"in-any-order","in-any-order",-751831450),null,new cljs.core.Keyword(null,"gaps-ok","gaps-ok",-115900561),null], null), null),modifiers)){
return yin.test.checker.util.contains_all(data,ck);
} else {
throw (new Error("modifiers can only be :gaps-only and :in-any-order"));

}
}
}
}
});
/**
 * map check helper function for `contains`
 */
yin.test.checker.collection.contains_map = (function yin$test$checker$collection$contains_map(x){
var ck = cljs.core.reduce_kv((function (out,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,k,yin.test.checker.base.__GT_checker(v));
}),cljs.core.PersistentArrayMap.EMPTY,x);
return yin.test.common.map__GT_Checker(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"contains","contains",676899812),new cljs.core.Keyword(null,"doc","doc",1913296891),"Checks if the result is a map having the following conditions:",new cljs.core.Keyword(null,"fn","fn",-1175266204),((function (ck){
return (function (res){
var data = yin.test.common.__GT_data(res);
var and__3925__auto__ = cljs.core.map_QMARK_(data);
if(and__3925__auto__){
return yin.test.checker.collection.verify_map(ck,data);
} else {
return and__3925__auto__;
}
});})(ck))
,new cljs.core.Keyword(null,"expect","expect",-1170127352),ck], null));
});
/**
 * vector check helper function for `contains`
 */
yin.test.checker.collection.contains_vector = (function yin$test$checker$collection$contains_vector(var_args){
var G__36806 = arguments.length;
switch (G__36806) {
case 1:
return yin.test.checker.collection.contains_vector.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return yin.test.checker.collection.contains_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.test.checker.collection.contains_vector.cljs$core$IFn$_invoke$arity$1 = (function (x){
return yin.test.checker.collection.contains_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.core.PersistentHashSet.EMPTY);
});

yin.test.checker.collection.contains_vector.cljs$core$IFn$_invoke$arity$2 = (function (x,modifiers){
var ck = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(yin.test.checker.base.__GT_checker,x);
return yin.test.common.map__GT_Checker(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"contains","contains",676899812),new cljs.core.Keyword(null,"doc","doc",1913296891),"Checks if the result is a sequential",new cljs.core.Keyword(null,"fn","fn",-1175266204),((function (ck){
return (function (res){
var data = yin.test.common.__GT_data(res);
if(cljs.core.set_QMARK_(data)){
return yin.test.checker.collection.verify_seq(ck,data,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(modifiers,new cljs.core.Keyword(null,"in-any-order","in-any-order",-751831450)));
} else {
if(cljs.core.sequential_QMARK_(data)){
return yin.test.checker.collection.verify_seq(ck,data,modifiers);
} else {
return null;
}
}
});})(ck))
,new cljs.core.Keyword(null,"expect","expect",-1170127352),ck], null));
});

yin.test.checker.collection.contains_vector.cljs$lang$maxFixedArity = 2;

/**
 * set check helper function for `contains`
 *  
 * ((contains-set #{1 2 3}) [1 2 3 4 5])
 * => true
 *  
 * ((contains-set #{1 2 4}) [1 2 3 4 5])
 * => false
 */
yin.test.checker.collection.contains_set = (function yin$test$checker$collection$contains_set(x){
return yin.test.checker.collection.contains_vector.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"in-any-order","in-any-order",-751831450),null], null), null));
});
/**
 * checker for maps and vectors
 *  
 * ((contains {:a odd? :b even?}) {:a 1 :b 4})
 * => true
 *  
 * ((contains {:a 1 :b even?}) {:a 2 :b 4})
 * => false
 *  
 * ((contains [1 2 3]) [1 2 3 4])
 * => true
 *  
 * ((contains [1 3]) [1 2 3 4])
 * => false
 *  
 * 
 */
yin.test.checker.collection.contains = (function yin$test$checker$collection$contains(var_args){
var args__4521__auto__ = [];
var len__4518__auto___36812 = arguments.length;
var i__4519__auto___36813 = (0);
while(true){
if((i__4519__auto___36813 < len__4518__auto___36812)){
args__4521__auto__.push((arguments[i__4519__auto___36813]));

var G__36814 = (i__4519__auto___36813 + (1));
i__4519__auto___36813 = G__36814;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((1) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((1)),(0),null)):null);
return yin.test.checker.collection.contains.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4522__auto__);
});

yin.test.checker.collection.contains.cljs$core$IFn$_invoke$arity$variadic = (function (x,modifiers){
if(cljs.core.map_QMARK_(x)){
return yin.test.checker.collection.contains_map(x);
} else {
if(cljs.core.set_QMARK_(x)){
return yin.test.checker.collection.contains_set(x);
} else {
if(cljs.core.sequential_QMARK_(x)){
return yin.test.checker.collection.contains_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.core.set(modifiers));
} else {
throw Error("Cannot create contains checker");

}
}
}
});

yin.test.checker.collection.contains.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
yin.test.checker.collection.contains.cljs$lang$applyTo = (function (seq36809){
var G__36810 = cljs.core.first(seq36809);
var seq36809__$1 = cljs.core.next(seq36809);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36810,seq36809__$1);
});

/**
 * map check helper function for `just`
 */
yin.test.checker.collection.just_map = (function yin$test$checker$collection$just_map(x){
var ck = cljs.core.reduce_kv((function (out,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,k,yin.test.checker.base.__GT_checker(v));
}),cljs.core.PersistentArrayMap.EMPTY,x);
return yin.test.common.map__GT_Checker(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"just","just",466318146),new cljs.core.Keyword(null,"doc","doc",1913296891),"Checks if the result is a map having strictly the following conditions:",new cljs.core.Keyword(null,"fn","fn",-1175266204),((function (ck){
return (function (res){
var data = yin.test.common.__GT_data(res);
var and__3925__auto__ = cljs.core.map_QMARK_(data);
if(and__3925__auto__){
var and__3925__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.keys(data)),cljs.core.set(cljs.core.keys(ck)));
if(and__3925__auto____$1){
return yin.test.checker.collection.verify_map(ck,data);
} else {
return and__3925__auto____$1;
}
} else {
return and__3925__auto__;
}
});})(ck))
,new cljs.core.Keyword(null,"expect","expect",-1170127352),ck], null));
});
/**
 * vector check helper function for `just`
 */
yin.test.checker.collection.just_vector = (function yin$test$checker$collection$just_vector(var_args){
var G__36838 = arguments.length;
switch (G__36838) {
case 1:
return yin.test.checker.collection.just_vector.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return yin.test.checker.collection.just_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.test.checker.collection.just_vector.cljs$core$IFn$_invoke$arity$1 = (function (x){
return yin.test.checker.collection.just_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.core.PersistentHashSet.EMPTY);
});

yin.test.checker.collection.just_vector.cljs$core$IFn$_invoke$arity$2 = (function (x,modifiers){
var ck = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(yin.test.checker.base.__GT_checker,x);
return yin.test.common.map__GT_Checker(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"just","just",466318146),new cljs.core.Keyword(null,"doc","doc",1913296891),"Checks if the result is a sequential having strictly the following conditions:",new cljs.core.Keyword(null,"fn","fn",-1175266204),((function (ck){
return (function (res){
var data = yin.test.common.__GT_data(res);
var and__3925__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(data),cljs.core.count(ck));
if(and__3925__auto__){
if(cljs.core.set_QMARK_(data)){
return yin.test.checker.collection.verify_seq(ck,data,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(modifiers,new cljs.core.Keyword(null,"in-any-order","in-any-order",-751831450)));
} else {
if(cljs.core.sequential_QMARK_(data)){
return yin.test.checker.collection.verify_seq(ck,data,modifiers);
} else {
return null;
}
}
} else {
return and__3925__auto__;
}
});})(ck))
,new cljs.core.Keyword(null,"expect","expect",-1170127352),ck], null));
});

yin.test.checker.collection.just_vector.cljs$lang$maxFixedArity = 2;

/**
 * set check helper function for `just`
 *  
 * ((just-set #{1 2 3}) [1 2 3])
 * => true
 */
yin.test.checker.collection.just_set = (function yin$test$checker$collection$just_set(x){
return yin.test.checker.collection.just_vector.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"in-any-order","in-any-order",-751831450),null], null), null));
});
/**
 * combination checker for both maps and vectors
 *  
 * ((just {:a odd? :b even?}) {:a 1 :b 4})
 * => true
 *  
 * ((just {:a 1 :b even?}) {:a 1 :b 2 :c 3})
 * => false
 *  
 * ((just [1 2 3 4]) [1 2 3 4])
 * => true
 * 
 * ((just [1 2 3]) [1 2 3 4])
 * => false
 *  
 * ((just [3 2 4 1] :in-any-order) [1 2 3 4])
 * => true
 */
yin.test.checker.collection.just = (function yin$test$checker$collection$just(var_args){
var args__4521__auto__ = [];
var len__4518__auto___36842 = arguments.length;
var i__4519__auto___36843 = (0);
while(true){
if((i__4519__auto___36843 < len__4518__auto___36842)){
args__4521__auto__.push((arguments[i__4519__auto___36843]));

var G__36844 = (i__4519__auto___36843 + (1));
i__4519__auto___36843 = G__36844;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((1) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((1)),(0),null)):null);
return yin.test.checker.collection.just.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4522__auto__);
});

yin.test.checker.collection.just.cljs$core$IFn$_invoke$arity$variadic = (function (x,modifiers){
if(cljs.core.map_QMARK_(x)){
return yin.test.checker.collection.just_map(x);
} else {
if(cljs.core.set_QMARK_(x)){
return yin.test.checker.collection.just_set(x);
} else {
if(cljs.core.vector_QMARK_(x)){
return yin.test.checker.collection.just_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.core.set(modifiers));
} else {
throw (new Error("Cannot create just checker"));

}
}
}
});

yin.test.checker.collection.just.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
yin.test.checker.collection.just.cljs$lang$applyTo = (function (seq36840){
var G__36841 = cljs.core.first(seq36840);
var seq36840__$1 = cljs.core.next(seq36840);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36841,seq36840__$1);
});


//# sourceMappingURL=yin.test.checker.collection.js.map
