goog.provide('yin.io.ansii');
goog.require('cljs.core');
goog.require('clojure.string');
if((typeof yin !== 'undefined') && (typeof yin.io !== 'undefined') && (typeof yin.io.ansii !== 'undefined') && (typeof yin.io.ansii.colors !== 'undefined')){
} else {
yin.io.ansii.colors = new cljs.core.PersistentArrayMap(null, 8, [(30),new cljs.core.Keyword(null,"grey","grey",1875582333),(31),new cljs.core.Keyword(null,"red","red",-969428204),(32),new cljs.core.Keyword(null,"green","green",-945526839),(33),new cljs.core.Keyword(null,"yellow","yellow",-881035449),(34),new cljs.core.Keyword(null,"blue","blue",-622100620),(35),new cljs.core.Keyword(null,"magenta","magenta",1687937081),(36),new cljs.core.Keyword(null,"cyan","cyan",1118839274),(37),new cljs.core.Keyword(null,"white","white",-483998618)], null);
}
if((typeof yin !== 'undefined') && (typeof yin.io !== 'undefined') && (typeof yin.io.ansii !== 'undefined') && (typeof yin.io.ansii.highlights !== 'undefined')){
} else {
yin.io.ansii.highlights = new cljs.core.PersistentArrayMap(null, 8, [(40),new cljs.core.Keyword(null,"on-grey","on-grey",86059902),(41),new cljs.core.Keyword(null,"on-red","on-red",235486605),(42),new cljs.core.Keyword(null,"on-green","on-green",1186282472),(43),new cljs.core.Keyword(null,"on-yellow","on-yellow",511523329),(44),new cljs.core.Keyword(null,"on-blue","on-blue",1739199119),(45),new cljs.core.Keyword(null,"on-magenta","on-magenta",-313518587),(46),new cljs.core.Keyword(null,"on-cyan","on-cyan",-387596994),(47),new cljs.core.Keyword(null,"on-white","on-white",937340120)], null);
}
if((typeof yin !== 'undefined') && (typeof yin.io !== 'undefined') && (typeof yin.io.ansii !== 'undefined') && (typeof yin.io.ansii.attributes !== 'undefined')){
} else {
yin.io.ansii.attributes = new cljs.core.PersistentArrayMap(null, 7, [(0),new cljs.core.Keyword(null,"reset","reset",-800929946),(1),new cljs.core.Keyword(null,"bold","bold",-116809535),(2),new cljs.core.Keyword(null,"dark","dark",1818973999),(4),new cljs.core.Keyword(null,"underline","underline",2018066703),(5),new cljs.core.Keyword(null,"blink","blink",-271985917),(7),new cljs.core.Keyword(null,"reverse-color","reverse-color",-1488435503),(8),new cljs.core.Keyword(null,"concealed","concealed",-593821536)], null);
}
if((typeof yin !== 'undefined') && (typeof yin.io !== 'undefined') && (typeof yin.io.ansii !== 'undefined') && (typeof yin.io.ansii.lookup !== 'undefined')){
} else {
yin.io.ansii.lookup = cljs.core.reduce_kv((function (out,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,v,k);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([yin.io.ansii.colors,yin.io.ansii.highlights,yin.io.ansii.attributes], 0)));
}
/**
 * encodes the ansii characters for modifiers
 * (encode :bold)
 * => "[1m"
 * 
 * (encode :red)
 * => "[31m"
 */
yin.io.ansii.encode = (function yin$io$ansii$encode(modifier){
var temp__5455__auto__ = (yin.io.ansii.lookup.cljs$core$IFn$_invoke$arity$1 ? yin.io.ansii.lookup.cljs$core$IFn$_invoke$arity$1(modifier) : yin.io.ansii.lookup.call(null,modifier));
if(cljs.core.truth_(temp__5455__auto__)){
var i = temp__5455__auto__;
return ["\u001B[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i),"m"].join('');
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Modifier not available: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(modifier)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});
/**
 * styles the text according to the modifiers
 *  
 * (style "hello" [:bold :red])
 * => "[1m[31mhello[0m"
 */
yin.io.ansii.style = (function yin$io$ansii$style(text,modifiers){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(yin.io.ansii.encode,modifiers))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.encode(new cljs.core.Keyword(null,"reset","reset",-800929946)))].join('');
});
yin.io.ansii.ansii_form = (function yin$io$ansii$ansii_form(modifier){
var prefix = yin.io.ansii.encode(modifier);
var func = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.name(modifier));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","defn","clojure.core/defn",-1504648747,null),null,(1),null)),(new cljs.core.List(null,func,null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol(null,"&","&",-2144855648,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"args","args",-1338879193,null),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","->","clojure.core/->",1452757553,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"args","args",-1338879193,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","->>","clojure.core/->>",-1104981692,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","map","clojure.core/map",-505055043,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","fn","clojure.core/fn",-980152636,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,new cljs.core.Symbol(null,"x","x",-555367584,null),null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","str","clojure.core/str",-1801552045,null),null,(1),null)),(new cljs.core.List(null,prefix,null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,new cljs.core.Symbol(null,"x","x",-555367584,null),null,(1),null))], 0)))),null,(1),null))], 0)))),null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,new cljs.core.Symbol("clojure.string","join","clojure.string/join",-539723360,null),null,(1),null))))),null,(1),null))], 0)))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("clojure.core","str","clojure.core/str",-1801552045,null),null,(1),null)),(new cljs.core.List(null,yin.io.ansii.encode(new cljs.core.Keyword(null,"reset","reset",-800929946)),null,(1),null))))),null,(1),null))], 0)))),null,(1),null))], 0))));
});
new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
yin.io.ansii.concealed = (function yin$io$ansii$concealed(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26227 = arguments.length;
var i__4519__auto___26228 = (0);
while(true){
if((i__4519__auto___26228 < len__4518__auto___26227)){
args__4521__auto__.push((arguments[i__4519__auto___26228]));

var G__26229 = (i__4519__auto___26228 + (1));
i__4519__auto___26228 = G__26229;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.concealed.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.concealed.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[8m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.concealed.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.concealed.cljs$lang$applyTo = (function (seq26205){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26205));
});

return null;
})()
,(function (){
yin.io.ansii.bold = (function yin$io$ansii$bold(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26230 = arguments.length;
var i__4519__auto___26231 = (0);
while(true){
if((i__4519__auto___26231 < len__4518__auto___26230)){
args__4521__auto__.push((arguments[i__4519__auto___26231]));

var G__26232 = (i__4519__auto___26231 + (1));
i__4519__auto___26231 = G__26232;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.bold.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.bold.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[1m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.bold.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.bold.cljs$lang$applyTo = (function (seq26206){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26206));
});

return null;
})()
,(function (){
yin.io.ansii.on_yellow = (function yin$io$ansii$on_yellow(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26233 = arguments.length;
var i__4519__auto___26234 = (0);
while(true){
if((i__4519__auto___26234 < len__4518__auto___26233)){
args__4521__auto__.push((arguments[i__4519__auto___26234]));

var G__26235 = (i__4519__auto___26234 + (1));
i__4519__auto___26234 = G__26235;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.on_yellow.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.on_yellow.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[43m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.on_yellow.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.on_yellow.cljs$lang$applyTo = (function (seq26207){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26207));
});

return null;
})()
,(function (){
yin.io.ansii.blink = (function yin$io$ansii$blink(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26236 = arguments.length;
var i__4519__auto___26237 = (0);
while(true){
if((i__4519__auto___26237 < len__4518__auto___26236)){
args__4521__auto__.push((arguments[i__4519__auto___26237]));

var G__26238 = (i__4519__auto___26237 + (1));
i__4519__auto___26237 = G__26238;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.blink.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.blink.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[5m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.blink.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.blink.cljs$lang$applyTo = (function (seq26208){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26208));
});

return null;
})()
,(function (){
yin.io.ansii.on_magenta = (function yin$io$ansii$on_magenta(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26239 = arguments.length;
var i__4519__auto___26240 = (0);
while(true){
if((i__4519__auto___26240 < len__4518__auto___26239)){
args__4521__auto__.push((arguments[i__4519__auto___26240]));

var G__26241 = (i__4519__auto___26240 + (1));
i__4519__auto___26240 = G__26241;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.on_magenta.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.on_magenta.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[45m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.on_magenta.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.on_magenta.cljs$lang$applyTo = (function (seq26209){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26209));
});

return null;
})()
,(function (){
yin.io.ansii.white = (function yin$io$ansii$white(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26242 = arguments.length;
var i__4519__auto___26243 = (0);
while(true){
if((i__4519__auto___26243 < len__4518__auto___26242)){
args__4521__auto__.push((arguments[i__4519__auto___26243]));

var G__26244 = (i__4519__auto___26243 + (1));
i__4519__auto___26243 = G__26244;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[37m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.white.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.white.cljs$lang$applyTo = (function (seq26210){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26210));
});

return null;
})()
,(function (){
yin.io.ansii.yellow = (function yin$io$ansii$yellow(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26245 = arguments.length;
var i__4519__auto___26246 = (0);
while(true){
if((i__4519__auto___26246 < len__4518__auto___26245)){
args__4521__auto__.push((arguments[i__4519__auto___26246]));

var G__26247 = (i__4519__auto___26246 + (1));
i__4519__auto___26246 = G__26247;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.yellow.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.yellow.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[33m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.yellow.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.yellow.cljs$lang$applyTo = (function (seq26211){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26211));
});

return null;
})()
,(function (){
yin.io.ansii.on_green = (function yin$io$ansii$on_green(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26248 = arguments.length;
var i__4519__auto___26249 = (0);
while(true){
if((i__4519__auto___26249 < len__4518__auto___26248)){
args__4521__auto__.push((arguments[i__4519__auto___26249]));

var G__26250 = (i__4519__auto___26249 + (1));
i__4519__auto___26249 = G__26250;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.on_green.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.on_green.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[42m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.on_green.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.on_green.cljs$lang$applyTo = (function (seq26212){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26212));
});

return null;
})()
,(function (){
yin.io.ansii.green = (function yin$io$ansii$green(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26251 = arguments.length;
var i__4519__auto___26252 = (0);
while(true){
if((i__4519__auto___26252 < len__4518__auto___26251)){
args__4521__auto__.push((arguments[i__4519__auto___26252]));

var G__26253 = (i__4519__auto___26252 + (1));
i__4519__auto___26252 = G__26253;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.green.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.green.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[32m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.green.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.green.cljs$lang$applyTo = (function (seq26213){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26213));
});

return null;
})()
,(function (){
yin.io.ansii.cyan = (function yin$io$ansii$cyan(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26254 = arguments.length;
var i__4519__auto___26255 = (0);
while(true){
if((i__4519__auto___26255 < len__4518__auto___26254)){
args__4521__auto__.push((arguments[i__4519__auto___26255]));

var G__26256 = (i__4519__auto___26255 + (1));
i__4519__auto___26255 = G__26256;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.cyan.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.cyan.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[36m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.cyan.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.cyan.cljs$lang$applyTo = (function (seq26214){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26214));
});

return null;
})()
,(function (){
yin.io.ansii.on_red = (function yin$io$ansii$on_red(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26257 = arguments.length;
var i__4519__auto___26258 = (0);
while(true){
if((i__4519__auto___26258 < len__4518__auto___26257)){
args__4521__auto__.push((arguments[i__4519__auto___26258]));

var G__26259 = (i__4519__auto___26258 + (1));
i__4519__auto___26258 = G__26259;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.on_red.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.on_red.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[41m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.on_red.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.on_red.cljs$lang$applyTo = (function (seq26215){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26215));
});

return null;
})()
,(function (){
yin.io.ansii.underline = (function yin$io$ansii$underline(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26260 = arguments.length;
var i__4519__auto___26261 = (0);
while(true){
if((i__4519__auto___26261 < len__4518__auto___26260)){
args__4521__auto__.push((arguments[i__4519__auto___26261]));

var G__26262 = (i__4519__auto___26261 + (1));
i__4519__auto___26261 = G__26262;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.underline.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.underline.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[4m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.underline.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.underline.cljs$lang$applyTo = (function (seq26216){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26216));
});

return null;
})()
,(function (){
yin.io.ansii.on_blue = (function yin$io$ansii$on_blue(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26263 = arguments.length;
var i__4519__auto___26264 = (0);
while(true){
if((i__4519__auto___26264 < len__4518__auto___26263)){
args__4521__auto__.push((arguments[i__4519__auto___26264]));

var G__26265 = (i__4519__auto___26264 + (1));
i__4519__auto___26264 = G__26265;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.on_blue.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.on_blue.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[44m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.on_blue.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.on_blue.cljs$lang$applyTo = (function (seq26217){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26217));
});

return null;
})()
,(function (){
yin.io.ansii.dark = (function yin$io$ansii$dark(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26266 = arguments.length;
var i__4519__auto___26267 = (0);
while(true){
if((i__4519__auto___26267 < len__4518__auto___26266)){
args__4521__auto__.push((arguments[i__4519__auto___26267]));

var G__26268 = (i__4519__auto___26267 + (1));
i__4519__auto___26267 = G__26268;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.dark.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.dark.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[2m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.dark.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.dark.cljs$lang$applyTo = (function (seq26218){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26218));
});

return null;
})()
,(function (){
yin.io.ansii.reverse_color = (function yin$io$ansii$reverse_color(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26269 = arguments.length;
var i__4519__auto___26270 = (0);
while(true){
if((i__4519__auto___26270 < len__4518__auto___26269)){
args__4521__auto__.push((arguments[i__4519__auto___26270]));

var G__26271 = (i__4519__auto___26270 + (1));
i__4519__auto___26270 = G__26271;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.reverse_color.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.reverse_color.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[7m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.reverse_color.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.reverse_color.cljs$lang$applyTo = (function (seq26219){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26219));
});

return null;
})()
,(function (){
yin.io.ansii.red = (function yin$io$ansii$red(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26272 = arguments.length;
var i__4519__auto___26273 = (0);
while(true){
if((i__4519__auto___26273 < len__4518__auto___26272)){
args__4521__auto__.push((arguments[i__4519__auto___26273]));

var G__26274 = (i__4519__auto___26273 + (1));
i__4519__auto___26273 = G__26274;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.red.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.red.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[31m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.red.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.red.cljs$lang$applyTo = (function (seq26220){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26220));
});

return null;
})()
,(function (){
yin.io.ansii.blue = (function yin$io$ansii$blue(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26275 = arguments.length;
var i__4519__auto___26276 = (0);
while(true){
if((i__4519__auto___26276 < len__4518__auto___26275)){
args__4521__auto__.push((arguments[i__4519__auto___26276]));

var G__26277 = (i__4519__auto___26276 + (1));
i__4519__auto___26276 = G__26277;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.blue.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.blue.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[34m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.blue.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.blue.cljs$lang$applyTo = (function (seq26221){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26221));
});

return null;
})()
,(function (){
yin.io.ansii.on_white = (function yin$io$ansii$on_white(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26278 = arguments.length;
var i__4519__auto___26279 = (0);
while(true){
if((i__4519__auto___26279 < len__4518__auto___26278)){
args__4521__auto__.push((arguments[i__4519__auto___26279]));

var G__26280 = (i__4519__auto___26279 + (1));
i__4519__auto___26279 = G__26280;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.on_white.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.on_white.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[47m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.on_white.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.on_white.cljs$lang$applyTo = (function (seq26222){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26222));
});

return null;
})()
,(function (){
yin.io.ansii.magenta = (function yin$io$ansii$magenta(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26281 = arguments.length;
var i__4519__auto___26282 = (0);
while(true){
if((i__4519__auto___26282 < len__4518__auto___26281)){
args__4521__auto__.push((arguments[i__4519__auto___26282]));

var G__26283 = (i__4519__auto___26282 + (1));
i__4519__auto___26282 = G__26283;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.magenta.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.magenta.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[35m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.magenta.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.magenta.cljs$lang$applyTo = (function (seq26223){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26223));
});

return null;
})()
,(function (){
yin.io.ansii.grey = (function yin$io$ansii$grey(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26284 = arguments.length;
var i__4519__auto___26285 = (0);
while(true){
if((i__4519__auto___26285 < len__4518__auto___26284)){
args__4521__auto__.push((arguments[i__4519__auto___26285]));

var G__26286 = (i__4519__auto___26285 + (1));
i__4519__auto___26285 = G__26286;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.grey.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.grey.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[30m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.grey.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.grey.cljs$lang$applyTo = (function (seq26224){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26224));
});

return null;
})()
,(function (){
yin.io.ansii.on_cyan = (function yin$io$ansii$on_cyan(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26287 = arguments.length;
var i__4519__auto___26288 = (0);
while(true){
if((i__4519__auto___26288 < len__4518__auto___26287)){
args__4521__auto__.push((arguments[i__4519__auto___26288]));

var G__26289 = (i__4519__auto___26288 + (1));
i__4519__auto___26288 = G__26289;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.on_cyan.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.on_cyan.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[46m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.on_cyan.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.on_cyan.cljs$lang$applyTo = (function (seq26225){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26225));
});

return null;
})()
,(function (){
yin.io.ansii.on_grey = (function yin$io$ansii$on_grey(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26290 = arguments.length;
var i__4519__auto___26291 = (0);
while(true){
if((i__4519__auto___26291 < len__4518__auto___26290)){
args__4521__auto__.push((arguments[i__4519__auto___26291]));

var G__26292 = (i__4519__auto___26291 + (1));
i__4519__auto___26291 = G__26292;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.io.ansii.on_grey.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.io.ansii.on_grey.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return ["\u001B[40m",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),args))),"\u001B[0m"].join('');
});

yin.io.ansii.on_grey.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.io.ansii.on_grey.cljs$lang$applyTo = (function (seq26226){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26226));
});

return null;
})()
], null);

//# sourceMappingURL=yin.io.ansii.js.map
