goog.provide('yin.event.common');
goog.require('cljs.core');
goog.require('yin.common.primitives');
goog.require('yin.data.map');
goog.require('yin.data.seq');
/**
 * creates a random id with a keyword base
 * (new-id)
 * ;;=> :06679506-1f87-4be8-8cfb-c48f8579bc00
 * 
 */
yin.event.common.new_id = (function yin$event$common$new_id(){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid())].join(''));
});
/**
 * expands shorthand data into a map
 *  
 * (expand-data :hello)
 * => {:hello true}
 *  
 * (expand-data [:hello {:world "foo"}])
 * => {:world "foo", :hello true}
 */
yin.event.common.expand_data = (function yin$event$common$expand_data(data){
if(cljs.core.map_QMARK_(data)){
return data;
} else {
if((data instanceof cljs.core.Keyword)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([data,true]);
} else {
if(cljs.core.vector_QMARK_(data)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.map.cljs$core$IFn$_invoke$arity$2(yin.event.common.expand_data,data));
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(data)," should be a keyword, hash-map or vector"].join('')));

}
}
}
});
/**
 * checks to see if the data corresponds to a template
 *  
 * (check-data {:hello true} :hello)
 * => true
 *  
 * (check-data {:hello true} {:hello true?})
 * => true
 *  
 * (check-data {:hello true} '_)
 * => true
 *  
 * (check-data {:hello true} #{:hello})
 * => true
 */
yin.event.common.check_data = (function yin$event$common$check_data(data,chk){
if(cljs.core.map_QMARK_(chk)){
return cljs.core.every_QMARK_((function (p__26218){
var vec__26219 = p__26218;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26219,(0),null);
var vchk = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26219,(1),null);
var vcnt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,k);
if((vchk instanceof cljs.core.Keyword)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(vchk,vcnt);
} else {
if(cljs.core.fn_QMARK_(vchk)){
return (vchk.cljs$core$IFn$_invoke$arity$1 ? vchk.cljs$core$IFn$_invoke$arity$1(vcnt) : vchk.call(null,vcnt));
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(vchk,vcnt);

}
}
}),chk);
} else {
if(cljs.core.vector_QMARK_(chk)){
return cljs.core.every_QMARK_((function (p1__26215_SHARP_){
return (yin.event.common.check_data.cljs$core$IFn$_invoke$arity$2 ? yin.event.common.check_data.cljs$core$IFn$_invoke$arity$2(data,p1__26215_SHARP_) : yin.event.common.check_data.call(null,data,p1__26215_SHARP_));
}),chk);
} else {
if(((cljs.core.fn_QMARK_(chk)) || ((chk instanceof cljs.core.Keyword)))){
return (chk.cljs$core$IFn$_invoke$arity$1 ? chk.cljs$core$IFn$_invoke$arity$1(data) : chk.call(null,data));
} else {
if(cljs.core.set_QMARK_(chk)){
return cljs.core.some((function (p1__26216_SHARP_){
return (yin.event.common.check_data.cljs$core$IFn$_invoke$arity$2 ? yin.event.common.check_data.cljs$core$IFn$_invoke$arity$2(data,p1__26216_SHARP_) : yin.event.common.check_data.call(null,data,p1__26216_SHARP_));
}),chk);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"_","_",-1201019570,null),chk)){
return true;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(chk)," is not a valid checker"].join('')));

}
}
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
yin.event.common.Manager = (function (id,store,options,__meta,__extmap,__hash){
this.id = id;
this.store = store;
this.options = options;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
yin.event.common.Manager.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__12001__auto__,k__12002__auto__){
var self__ = this;
var this__12001__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__12001__auto____$1,k__12002__auto__,null);
});

yin.event.common.Manager.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__12003__auto__,k26224,else__12004__auto__){
var self__ = this;
var this__12003__auto____$1 = this;
var G__26228 = k26224;
var G__26228__$1 = (((G__26228 instanceof cljs.core.Keyword))?G__26228.fqn:null);
switch (G__26228__$1) {
case "id":
return self__.id;

break;
case "store":
return self__.store;

break;
case "options":
return self__.options;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26224,else__12004__auto__);

}
});

yin.event.common.Manager.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__12015__auto__,writer__12016__auto__,opts__12017__auto__){
var self__ = this;
var this__12015__auto____$1 = this;
var pr_pair__12018__auto__ = ((function (this__12015__auto____$1){
return (function (keyval__12019__auto__){
return cljs.core.pr_sequential_writer(writer__12016__auto__,cljs.core.pr_writer,""," ","",opts__12017__auto__,keyval__12019__auto__);
});})(this__12015__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__12016__auto__,pr_pair__12018__auto__,"#yin.event.common.Manager{",", ","}",opts__12017__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"store","store",1512230022),self__.store],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"options","options",99638489),self__.options],null))], null),self__.__extmap));
});

yin.event.common.Manager.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26223){
var self__ = this;
var G__26223__$1 = this;
return (new cljs.core.RecordIter((0),G__26223__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"store","store",1512230022),new cljs.core.Keyword(null,"options","options",99638489)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

yin.event.common.Manager.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__11999__auto__){
var self__ = this;
var this__11999__auto____$1 = this;
return self__.__meta;
});

yin.event.common.Manager.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__11996__auto__){
var self__ = this;
var this__11996__auto____$1 = this;
return (new yin.event.common.Manager(self__.id,self__.store,self__.options,self__.__meta,self__.__extmap,self__.__hash));
});

yin.event.common.Manager.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__12005__auto__){
var self__ = this;
var this__12005__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
});

yin.event.common.Manager.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__11997__auto__){
var self__ = this;
var this__11997__auto____$1 = this;
var h__4048__auto__ = self__.__hash;
if(!((h__4048__auto__ == null))){
return h__4048__auto__;
} else {
var h__4048__auto____$1 = (function (){var fexpr__26229 = ((function (h__4048__auto__,this__11997__auto____$1){
return (function (coll__11998__auto__){
return (1612629626 ^ cljs.core.hash_unordered_coll(coll__11998__auto__));
});})(h__4048__auto__,this__11997__auto____$1))
;
return fexpr__26229(this__11997__auto____$1);
})();
self__.__hash = h__4048__auto____$1;

return h__4048__auto____$1;
}
});

yin.event.common.Manager.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26225,other26226){
var self__ = this;
var this26225__$1 = this;
return ((!((other26226 == null))) && ((this26225__$1.constructor === other26226.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26225__$1.id,other26226.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26225__$1.store,other26226.store)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26225__$1.options,other26226.options)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26225__$1.__extmap,other26226.__extmap)));
});

yin.event.common.Manager.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__12010__auto__,k__12011__auto__){
var self__ = this;
var this__12010__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"store","store",1512230022),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"options","options",99638489),null], null), null),k__12011__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__12010__auto____$1),self__.__meta),k__12011__auto__);
} else {
return (new yin.event.common.Manager(self__.id,self__.store,self__.options,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__12011__auto__)),null));
}
});

yin.event.common.Manager.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__12008__auto__,k__12009__auto__,G__26223){
var self__ = this;
var this__12008__auto____$1 = this;
var pred__26230 = cljs.core.keyword_identical_QMARK_;
var expr__26231 = k__12009__auto__;
if(cljs.core.truth_((function (){var G__26233 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__26234 = expr__26231;
return (pred__26230.cljs$core$IFn$_invoke$arity$2 ? pred__26230.cljs$core$IFn$_invoke$arity$2(G__26233,G__26234) : pred__26230.call(null,G__26233,G__26234));
})())){
return (new yin.event.common.Manager(G__26223,self__.store,self__.options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26235 = new cljs.core.Keyword(null,"store","store",1512230022);
var G__26236 = expr__26231;
return (pred__26230.cljs$core$IFn$_invoke$arity$2 ? pred__26230.cljs$core$IFn$_invoke$arity$2(G__26235,G__26236) : pred__26230.call(null,G__26235,G__26236));
})())){
return (new yin.event.common.Manager(self__.id,G__26223,self__.options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26237 = new cljs.core.Keyword(null,"options","options",99638489);
var G__26238 = expr__26231;
return (pred__26230.cljs$core$IFn$_invoke$arity$2 ? pred__26230.cljs$core$IFn$_invoke$arity$2(G__26237,G__26238) : pred__26230.call(null,G__26237,G__26238));
})())){
return (new yin.event.common.Manager(self__.id,self__.store,G__26223,self__.__meta,self__.__extmap,null));
} else {
return (new yin.event.common.Manager(self__.id,self__.store,self__.options,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__12009__auto__,G__26223),null));
}
}
}
});

yin.event.common.Manager.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__12013__auto__){
var self__ = this;
var this__12013__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"store","store",1512230022),self__.store],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"options","options",99638489),self__.options],null))], null),self__.__extmap));
});

yin.event.common.Manager.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__12000__auto__,G__26223){
var self__ = this;
var this__12000__auto____$1 = this;
return (new yin.event.common.Manager(self__.id,self__.store,self__.options,G__26223,self__.__extmap,self__.__hash));
});

yin.event.common.Manager.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__12006__auto__,entry__12007__auto__){
var self__ = this;
var this__12006__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__12007__auto__)){
return cljs.core._assoc(this__12006__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__12006__auto____$1,entry__12007__auto__);
}
});

yin.event.common.Manager.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"store","store",-1142205747,null),new cljs.core.Symbol(null,"options","options",1740170016,null)], null);
});

yin.event.common.Manager.cljs$lang$type = true;

yin.event.common.Manager.cljs$lang$ctorPrSeq = (function (this__4227__auto__){
return (new cljs.core.List(null,"yin.event.common/Manager",null,(1),null));
});

yin.event.common.Manager.cljs$lang$ctorPrWriter = (function (this__4227__auto__,writer__4228__auto__){
return cljs.core._write(writer__4228__auto__,"yin.event.common/Manager");
});

/**
 * Positional factory function for yin.event.common/Manager.
 */
yin.event.common.__GT_Manager = (function yin$event$common$__GT_Manager(id,store,options){
return (new yin.event.common.Manager(id,store,options,null,null,null));
});

/**
 * Factory function for yin.event.common/Manager, taking a map of keywords to field values.
 */
yin.event.common.map__GT_Manager = (function yin$event$common$map__GT_Manager(G__26227){
var extmap__4223__auto__ = (function (){var G__26239 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26227,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"store","store",1512230022),new cljs.core.Keyword(null,"options","options",99638489)], 0));
if(cljs.core.record_QMARK_(G__26227)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26239);
} else {
return G__26239;
}
})();
return (new yin.event.common.Manager(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__26227),new cljs.core.Keyword(null,"store","store",1512230022).cljs$core$IFn$_invoke$arity$1(G__26227),new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(G__26227),null,cljs.core.not_empty(extmap__4223__auto__),null));
});

/**
 * creates a new manager
 * (manager)
 * ;; => #hara.event.common.Manager{:id :b56eb2c9-8d21-4680-b3e1-0023ae685d2b,
 * ;;                               :store [], :options {}}
 * 
 */
yin.event.common.manager = (function yin$event$common$manager(var_args){
var G__26246 = arguments.length;
switch (G__26246) {
case 0:
return yin.event.common.manager.cljs$core$IFn$_invoke$arity$0();

break;
case 3:
return yin.event.common.manager.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.event.common.manager.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new yin.event.common.Manager(yin.event.common.new_id(),cljs.core.PersistentVector.EMPTY,cljs.core.PersistentArrayMap.EMPTY,null,null,null));
});

yin.event.common.manager.cljs$core$IFn$_invoke$arity$3 = (function (id,store,options){
return (new yin.event.common.Manager(id,store,options,null,null,null));
});

yin.event.common.manager.cljs$lang$maxFixedArity = 3;

/**
 * adds a handler to the manager
 * (-> (add-handler (manager) :hello {:id :hello
 *                                    :handler identity})
 *     (remove-handler :hello)
 *     (match-handlers {:hello "world"}))
 * => ()
 */
yin.event.common.remove_handler = (function yin$event$common$remove_handler(manager,id){
var temp__5455__auto__ = cljs.core.first(yin.data.seq.positions((function (p1__26248_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(p1__26248_SHARP_),id);
}),new cljs.core.Keyword(null,"store","store",1512230022).cljs$core$IFn$_invoke$arity$1(manager)));
if(cljs.core.truth_(temp__5455__auto__)){
var position = temp__5455__auto__;
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(manager,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"store","store",1512230022)], null),yin.data.seq.remove_index,position);
} else {
return manager;
}
});
/**
 * adds a handler to the manager
 * (-> (add-handler (manager) :hello {:id :hello
 *                                    :handler identity})
 *     (match-handlers {:hello "world"})
 *     (count))
 * => 1
 */
yin.event.common.add_handler = (function yin$event$common$add_handler(var_args){
var G__26251 = arguments.length;
switch (G__26251) {
case 2:
return yin.event.common.add_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return yin.event.common.add_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.event.common.add_handler.cljs$core$IFn$_invoke$arity$2 = (function (manager,handler){
var handler__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(handler))?handler:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(handler,new cljs.core.Keyword(null,"id","id",-1388402092),yin.event.common.new_id()));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(yin.event.common.remove_handler(manager,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(handler__$1)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"store","store",1512230022)], null),cljs.core.conj,handler__$1);
});

yin.event.common.add_handler.cljs$core$IFn$_invoke$arity$3 = (function (manager,checker,handler){
var handler__$1 = ((cljs.core.fn_QMARK_(handler))?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"checker","checker",413112880),checker,new cljs.core.Keyword(null,"fn","fn",-1175266204),handler], null):((cljs.core.map_QMARK_(handler))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(handler,new cljs.core.Keyword(null,"checker","checker",413112880),checker):null));
return yin.event.common.add_handler.cljs$core$IFn$_invoke$arity$2(manager,handler__$1);
});

yin.event.common.add_handler.cljs$lang$maxFixedArity = 3;

/**
 * list handlers that are present for a given manager
 *  
 * (list-handlers (manager))
 * => []
 */
yin.event.common.list_handlers = (function yin$event$common$list_handlers(var_args){
var G__26263 = arguments.length;
switch (G__26263) {
case 1:
return yin.event.common.list_handlers.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return yin.event.common.list_handlers.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.event.common.list_handlers.cljs$core$IFn$_invoke$arity$1 = (function (manager){
return new cljs.core.Keyword(null,"store","store",1512230022).cljs$core$IFn$_invoke$arity$1(manager);
});

yin.event.common.list_handlers.cljs$core$IFn$_invoke$arity$2 = (function (manager,checker){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__26261_SHARP_){
return yin.event.common.check_data(new cljs.core.Keyword(null,"checker","checker",413112880).cljs$core$IFn$_invoke$arity$1(p1__26261_SHARP_),checker);
}),yin.event.common.list_handlers.cljs$core$IFn$_invoke$arity$1(manager));
});

yin.event.common.list_handlers.cljs$lang$maxFixedArity = 2;

/**
 * match handlers for a given manager
 * 
 * (-> (add-handler (manager) :hello {:id :hello
 *                                    :handler identity})
 *     (match-handlers {:hello "world"}))
 * => (contains-in [{:id :hello
 *                   :handler fn?
 *                   :checker :hello}])
 */
yin.event.common.match_handlers = (function yin$event$common$match_handlers(manager,data){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__26266_SHARP_){
return yin.event.common.check_data(data,new cljs.core.Keyword(null,"checker","checker",413112880).cljs$core$IFn$_invoke$arity$1(p1__26266_SHARP_));
}),new cljs.core.Keyword(null,"store","store",1512230022).cljs$core$IFn$_invoke$arity$1(manager));
});

//# sourceMappingURL=yin.event.common.js.map
