goog.provide('yin.data.seq');
goog.require('cljs.core');
/**
 * find positions of elements matching the predicate
 *  
 * (positions even? [5 5 4 4 3 3 2 2])
 * => [2 3 6 7]
 */
yin.data.seq.positions = (function yin$data$seq$positions(pred,coll){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,x){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(x) : pred.call(null,x)))){
return idx;
} else {
return null;
}
}),coll);
});
/**
 * removes element at the specified index
 *  
 * (remove-index [:a :b :c :d] 2)
 * => [:a :b :d]
 */
yin.data.seq.remove_index = (function yin$data$seq$remove_index(coll,i){
if(cljs.core.vector_QMARK_(coll)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(coll,(0),i),cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(coll,(i + (1)),cljs.core.count(coll)));
} else {
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (p1__26110_SHARP_,p2__26111_SHARP_){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(p1__26110_SHARP_,i)){
return p2__26111_SHARP_;
} else {
return null;
}
}),coll);

}
});

//# sourceMappingURL=yin.data.seq.js.map
