goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$IElement$_to_dom$arity$1 == null))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4230__auto__ = (((this$ == null))?null:this$);
var m__4231__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4231__auto__.call(null,this$));
} else {
var m__4231__auto____$1 = (shadow.dom._to_dom["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4231__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4230__auto__ = (((this$ == null))?null:this$);
var m__4231__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4231__auto__.call(null,this$));
} else {
var m__4231__auto____$1 = (shadow.dom._to_svg["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4231__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__38834 = coll;
var G__38835 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__38834,G__38835) : shadow.dom.lazy_native_coll_seq.call(null,G__38834,G__38835));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__3936__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return not_found;
}
});

shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
});

shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
});

shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

shadow.dom.NativeColl.cljs$lang$type = true;

shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl";

shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"shadow.dom/NativeColl");
});

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode([cljs.core.str.cljs$core$IFn$_invoke$arity$1(el)].join(''));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__38845 = arguments.length;
switch (G__38845) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
});

shadow.dom.query_one.cljs$lang$maxFixedArity = 2;

shadow.dom.query = (function shadow$dom$query(var_args){
var G__38848 = arguments.length;
switch (G__38848) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
});

shadow.dom.query.cljs$lang$maxFixedArity = 2;

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__38851 = arguments.length;
switch (G__38851) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
});

shadow.dom.by_id.cljs$lang$maxFixedArity = 2;

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__38854 = arguments.length;
switch (G__38854) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
e.cancelBubble = true;

e.returnValue = false;
}

return e;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4;

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__38857 = arguments.length;
switch (G__38857) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__38858 = document;
var G__38859 = shadow.dom.dom_node(el);
return goog.dom.contains(G__38858,G__38859);
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
var G__38860 = shadow.dom.dom_node(parent);
var G__38861 = shadow.dom.dom_node(el);
return goog.dom.contains(G__38860,G__38861);
});

shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2;

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
var G__38863 = shadow.dom.dom_node(el);
var G__38864 = cls;
return goog.dom.classlist.add(G__38863,G__38864);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
var G__38865 = shadow.dom.dom_node(el);
var G__38866 = cls;
return goog.dom.classlist.remove(G__38865,G__38866);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__38868 = arguments.length;
switch (G__38868) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
var G__38869 = shadow.dom.dom_node(el);
var G__38870 = cls;
return goog.dom.classlist.toggle(G__38869,G__38870);
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
});

shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3;

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__3936__auto__ = !((typeof document !== 'undefined'));
if(or__3936__auto__){
return or__3936__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e38872){if((e38872 instanceof Object)){
var e = e38872;
return console.log("didnt support attachEvent",el,e);
} else {
throw e38872;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__3936__auto__ = !((typeof document !== 'undefined'));
if(or__3936__auto__){
return or__3936__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__38873 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__38874 = null;
var count__38875 = (0);
var i__38876 = (0);
while(true){
if((i__38876 < count__38875)){
var el = chunk__38874.cljs$core$IIndexed$_nth$arity$2(null,i__38876);
var handler_38883__$1 = ((function (seq__38873,chunk__38874,count__38875,i__38876,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__38873,chunk__38874,count__38875,i__38876,el))
;
var G__38877_38884 = el;
var G__38878_38885 = cljs.core.name(ev);
var G__38879_38886 = handler_38883__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__38877_38884,G__38878_38885,G__38879_38886) : shadow.dom.dom_listen.call(null,G__38877_38884,G__38878_38885,G__38879_38886));


var G__38887 = seq__38873;
var G__38888 = chunk__38874;
var G__38889 = count__38875;
var G__38890 = (i__38876 + (1));
seq__38873 = G__38887;
chunk__38874 = G__38888;
count__38875 = G__38889;
i__38876 = G__38890;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__38873);
if(temp__5457__auto__){
var seq__38873__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38873__$1)){
var c__4338__auto__ = cljs.core.chunk_first(seq__38873__$1);
var G__38891 = cljs.core.chunk_rest(seq__38873__$1);
var G__38892 = c__4338__auto__;
var G__38893 = cljs.core.count(c__4338__auto__);
var G__38894 = (0);
seq__38873 = G__38891;
chunk__38874 = G__38892;
count__38875 = G__38893;
i__38876 = G__38894;
continue;
} else {
var el = cljs.core.first(seq__38873__$1);
var handler_38895__$1 = ((function (seq__38873,chunk__38874,count__38875,i__38876,el,seq__38873__$1,temp__5457__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__38873,chunk__38874,count__38875,i__38876,el,seq__38873__$1,temp__5457__auto__))
;
var G__38880_38896 = el;
var G__38881_38897 = cljs.core.name(ev);
var G__38882_38898 = handler_38895__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__38880_38896,G__38881_38897,G__38882_38898) : shadow.dom.dom_listen.call(null,G__38880_38896,G__38881_38897,G__38882_38898));


var G__38899 = cljs.core.next(seq__38873__$1);
var G__38900 = null;
var G__38901 = (0);
var G__38902 = (0);
seq__38873 = G__38899;
chunk__38874 = G__38900;
count__38875 = G__38901;
i__38876 = G__38902;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__38904 = arguments.length;
switch (G__38904) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
var G__38905 = shadow.dom.dom_node(el);
var G__38906 = cljs.core.name(ev);
var G__38907 = handler__$1;
return (shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__38905,G__38906,G__38907) : shadow.dom.dom_listen.call(null,G__38905,G__38906,G__38907));
}
});

shadow.dom.on.cljs$lang$maxFixedArity = 4;

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
var G__38909 = shadow.dom.dom_node(el);
var G__38910 = cljs.core.name(ev);
var G__38911 = handler;
return (shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3(G__38909,G__38910,G__38911) : shadow.dom.dom_listen_remove.call(null,G__38909,G__38910,G__38911));
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__38912 = cljs.core.seq(events);
var chunk__38913 = null;
var count__38914 = (0);
var i__38915 = (0);
while(true){
if((i__38915 < count__38914)){
var vec__38916 = chunk__38913.cljs$core$IIndexed$_nth$arity$2(null,i__38915);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38916,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38916,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__38922 = seq__38912;
var G__38923 = chunk__38913;
var G__38924 = count__38914;
var G__38925 = (i__38915 + (1));
seq__38912 = G__38922;
chunk__38913 = G__38923;
count__38914 = G__38924;
i__38915 = G__38925;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__38912);
if(temp__5457__auto__){
var seq__38912__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38912__$1)){
var c__4338__auto__ = cljs.core.chunk_first(seq__38912__$1);
var G__38926 = cljs.core.chunk_rest(seq__38912__$1);
var G__38927 = c__4338__auto__;
var G__38928 = cljs.core.count(c__4338__auto__);
var G__38929 = (0);
seq__38912 = G__38926;
chunk__38913 = G__38927;
count__38914 = G__38928;
i__38915 = G__38929;
continue;
} else {
var vec__38919 = cljs.core.first(seq__38912__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38919,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38919,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__38930 = cljs.core.next(seq__38912__$1);
var G__38931 = null;
var G__38932 = (0);
var G__38933 = (0);
seq__38912 = G__38930;
chunk__38913 = G__38931;
count__38914 = G__38932;
i__38915 = G__38933;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__38934 = cljs.core.seq(styles);
var chunk__38935 = null;
var count__38936 = (0);
var i__38937 = (0);
while(true){
if((i__38937 < count__38936)){
var vec__38938 = chunk__38935.cljs$core$IIndexed$_nth$arity$2(null,i__38937);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38938,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38938,(1),null);
var G__38941_38950 = dom;
var G__38942_38951 = cljs.core.name(k);
var G__38943_38952 = (((v == null))?"":v);
goog.style.setStyle(G__38941_38950,G__38942_38951,G__38943_38952);


var G__38953 = seq__38934;
var G__38954 = chunk__38935;
var G__38955 = count__38936;
var G__38956 = (i__38937 + (1));
seq__38934 = G__38953;
chunk__38935 = G__38954;
count__38936 = G__38955;
i__38937 = G__38956;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__38934);
if(temp__5457__auto__){
var seq__38934__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38934__$1)){
var c__4338__auto__ = cljs.core.chunk_first(seq__38934__$1);
var G__38957 = cljs.core.chunk_rest(seq__38934__$1);
var G__38958 = c__4338__auto__;
var G__38959 = cljs.core.count(c__4338__auto__);
var G__38960 = (0);
seq__38934 = G__38957;
chunk__38935 = G__38958;
count__38936 = G__38959;
i__38937 = G__38960;
continue;
} else {
var vec__38944 = cljs.core.first(seq__38934__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38944,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38944,(1),null);
var G__38947_38961 = dom;
var G__38948_38962 = cljs.core.name(k);
var G__38949_38963 = (((v == null))?"":v);
goog.style.setStyle(G__38947_38961,G__38948_38962,G__38949_38963);


var G__38964 = cljs.core.next(seq__38934__$1);
var G__38965 = null;
var G__38966 = (0);
var G__38967 = (0);
seq__38934 = G__38964;
chunk__38935 = G__38965;
count__38936 = G__38966;
i__38937 = G__38967;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__38968_38969 = key;
var G__38968_38970__$1 = (((G__38968_38969 instanceof cljs.core.Keyword))?G__38968_38969.fqn:null);
switch (G__38968_38970__$1) {
case "id":
el.id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "class":
el.className = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "for":
el.htmlFor = value;

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_38972 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__3936__auto__ = goog.string.startsWith(ks_38972,"data-");
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return goog.string.startsWith(ks_38972,"aria-");
}
})())){
el.setAttribute(ks_38972,value);
} else {
(el[ks_38972] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
var G__38973 = shadow.dom.dom_node(el);
var G__38974 = cls;
return goog.dom.classlist.contains(G__38973,G__38974);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec__$1)].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__38975){
var map__38976 = p__38975;
var map__38976__$1 = ((((!((map__38976 == null)))?(((((map__38976.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38976.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38976):map__38976);
var props = map__38976__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38976__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__38978 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38978,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__38981 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__38981,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__38981;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__38983 = arguments.length;
switch (G__38983) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$lang$maxFixedArity = 2;

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__38985){
var vec__38986 = p__38985;
var seq__38987 = cljs.core.seq(vec__38986);
var first__38988 = cljs.core.first(seq__38987);
var seq__38987__$1 = cljs.core.next(seq__38987);
var nn = first__38988;
var first__38988__$1 = cljs.core.first(seq__38987__$1);
var seq__38987__$2 = cljs.core.next(seq__38987__$1);
var np = first__38988__$1;
var nc = seq__38987__$2;
var node = vec__38986;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__38989 = nn;
var G__38990 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__38989,G__38990) : create_fn.call(null,G__38989,G__38990));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__38991 = nn;
var G__38992 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__38991,G__38992) : create_fn.call(null,G__38991,G__38992));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__38993 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38993,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38993,(1),null);
var seq__38996_39012 = cljs.core.seq(node_children);
var chunk__38997_39013 = null;
var count__38998_39014 = (0);
var i__38999_39015 = (0);
while(true){
if((i__38999_39015 < count__38998_39014)){
var child_struct_39016 = chunk__38997_39013.cljs$core$IIndexed$_nth$arity$2(null,i__38999_39015);
var children_39017 = shadow.dom.dom_node(child_struct_39016);
if(cljs.core.seq_QMARK_(children_39017)){
var seq__39000_39018 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_39017));
var chunk__39002_39019 = null;
var count__39003_39020 = (0);
var i__39004_39021 = (0);
while(true){
if((i__39004_39021 < count__39003_39020)){
var child_39022 = chunk__39002_39019.cljs$core$IIndexed$_nth$arity$2(null,i__39004_39021);
if(cljs.core.truth_(child_39022)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39022);


var G__39023 = seq__39000_39018;
var G__39024 = chunk__39002_39019;
var G__39025 = count__39003_39020;
var G__39026 = (i__39004_39021 + (1));
seq__39000_39018 = G__39023;
chunk__39002_39019 = G__39024;
count__39003_39020 = G__39025;
i__39004_39021 = G__39026;
continue;
} else {
var G__39027 = seq__39000_39018;
var G__39028 = chunk__39002_39019;
var G__39029 = count__39003_39020;
var G__39030 = (i__39004_39021 + (1));
seq__39000_39018 = G__39027;
chunk__39002_39019 = G__39028;
count__39003_39020 = G__39029;
i__39004_39021 = G__39030;
continue;
}
} else {
var temp__5457__auto___39031 = cljs.core.seq(seq__39000_39018);
if(temp__5457__auto___39031){
var seq__39000_39032__$1 = temp__5457__auto___39031;
if(cljs.core.chunked_seq_QMARK_(seq__39000_39032__$1)){
var c__4338__auto___39033 = cljs.core.chunk_first(seq__39000_39032__$1);
var G__39034 = cljs.core.chunk_rest(seq__39000_39032__$1);
var G__39035 = c__4338__auto___39033;
var G__39036 = cljs.core.count(c__4338__auto___39033);
var G__39037 = (0);
seq__39000_39018 = G__39034;
chunk__39002_39019 = G__39035;
count__39003_39020 = G__39036;
i__39004_39021 = G__39037;
continue;
} else {
var child_39038 = cljs.core.first(seq__39000_39032__$1);
if(cljs.core.truth_(child_39038)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39038);


var G__39039 = cljs.core.next(seq__39000_39032__$1);
var G__39040 = null;
var G__39041 = (0);
var G__39042 = (0);
seq__39000_39018 = G__39039;
chunk__39002_39019 = G__39040;
count__39003_39020 = G__39041;
i__39004_39021 = G__39042;
continue;
} else {
var G__39043 = cljs.core.next(seq__39000_39032__$1);
var G__39044 = null;
var G__39045 = (0);
var G__39046 = (0);
seq__39000_39018 = G__39043;
chunk__39002_39019 = G__39044;
count__39003_39020 = G__39045;
i__39004_39021 = G__39046;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_39017);
}


var G__39047 = seq__38996_39012;
var G__39048 = chunk__38997_39013;
var G__39049 = count__38998_39014;
var G__39050 = (i__38999_39015 + (1));
seq__38996_39012 = G__39047;
chunk__38997_39013 = G__39048;
count__38998_39014 = G__39049;
i__38999_39015 = G__39050;
continue;
} else {
var temp__5457__auto___39051 = cljs.core.seq(seq__38996_39012);
if(temp__5457__auto___39051){
var seq__38996_39052__$1 = temp__5457__auto___39051;
if(cljs.core.chunked_seq_QMARK_(seq__38996_39052__$1)){
var c__4338__auto___39053 = cljs.core.chunk_first(seq__38996_39052__$1);
var G__39054 = cljs.core.chunk_rest(seq__38996_39052__$1);
var G__39055 = c__4338__auto___39053;
var G__39056 = cljs.core.count(c__4338__auto___39053);
var G__39057 = (0);
seq__38996_39012 = G__39054;
chunk__38997_39013 = G__39055;
count__38998_39014 = G__39056;
i__38999_39015 = G__39057;
continue;
} else {
var child_struct_39058 = cljs.core.first(seq__38996_39052__$1);
var children_39059 = shadow.dom.dom_node(child_struct_39058);
if(cljs.core.seq_QMARK_(children_39059)){
var seq__39006_39060 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_39059));
var chunk__39008_39061 = null;
var count__39009_39062 = (0);
var i__39010_39063 = (0);
while(true){
if((i__39010_39063 < count__39009_39062)){
var child_39064 = chunk__39008_39061.cljs$core$IIndexed$_nth$arity$2(null,i__39010_39063);
if(cljs.core.truth_(child_39064)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39064);


var G__39065 = seq__39006_39060;
var G__39066 = chunk__39008_39061;
var G__39067 = count__39009_39062;
var G__39068 = (i__39010_39063 + (1));
seq__39006_39060 = G__39065;
chunk__39008_39061 = G__39066;
count__39009_39062 = G__39067;
i__39010_39063 = G__39068;
continue;
} else {
var G__39069 = seq__39006_39060;
var G__39070 = chunk__39008_39061;
var G__39071 = count__39009_39062;
var G__39072 = (i__39010_39063 + (1));
seq__39006_39060 = G__39069;
chunk__39008_39061 = G__39070;
count__39009_39062 = G__39071;
i__39010_39063 = G__39072;
continue;
}
} else {
var temp__5457__auto___39073__$1 = cljs.core.seq(seq__39006_39060);
if(temp__5457__auto___39073__$1){
var seq__39006_39074__$1 = temp__5457__auto___39073__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39006_39074__$1)){
var c__4338__auto___39075 = cljs.core.chunk_first(seq__39006_39074__$1);
var G__39076 = cljs.core.chunk_rest(seq__39006_39074__$1);
var G__39077 = c__4338__auto___39075;
var G__39078 = cljs.core.count(c__4338__auto___39075);
var G__39079 = (0);
seq__39006_39060 = G__39076;
chunk__39008_39061 = G__39077;
count__39009_39062 = G__39078;
i__39010_39063 = G__39079;
continue;
} else {
var child_39080 = cljs.core.first(seq__39006_39074__$1);
if(cljs.core.truth_(child_39080)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_39080);


var G__39081 = cljs.core.next(seq__39006_39074__$1);
var G__39082 = null;
var G__39083 = (0);
var G__39084 = (0);
seq__39006_39060 = G__39081;
chunk__39008_39061 = G__39082;
count__39009_39062 = G__39083;
i__39010_39063 = G__39084;
continue;
} else {
var G__39085 = cljs.core.next(seq__39006_39074__$1);
var G__39086 = null;
var G__39087 = (0);
var G__39088 = (0);
seq__39006_39060 = G__39085;
chunk__39008_39061 = G__39086;
count__39009_39062 = G__39087;
i__39010_39063 = G__39088;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_39059);
}


var G__39089 = cljs.core.next(seq__38996_39052__$1);
var G__39090 = null;
var G__39091 = (0);
var G__39092 = (0);
seq__38996_39012 = G__39089;
chunk__38997_39013 = G__39090;
count__38998_39014 = G__39091;
i__38999_39015 = G__39092;
continue;
}
} else {
}
}
break;
}

return node;
});
cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
});

cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
});
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
var G__39093 = shadow.dom.dom_node(node);
return goog.dom.removeChildren(G__39093);
});
shadow.dom.remove = (function shadow$dom$remove(node){
if(((!((node == null)))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__39095 = cljs.core.seq(node);
var chunk__39096 = null;
var count__39097 = (0);
var i__39098 = (0);
while(true){
if((i__39098 < count__39097)){
var n = chunk__39096.cljs$core$IIndexed$_nth$arity$2(null,i__39098);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__39099 = seq__39095;
var G__39100 = chunk__39096;
var G__39101 = count__39097;
var G__39102 = (i__39098 + (1));
seq__39095 = G__39099;
chunk__39096 = G__39100;
count__39097 = G__39101;
i__39098 = G__39102;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__39095);
if(temp__5457__auto__){
var seq__39095__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39095__$1)){
var c__4338__auto__ = cljs.core.chunk_first(seq__39095__$1);
var G__39103 = cljs.core.chunk_rest(seq__39095__$1);
var G__39104 = c__4338__auto__;
var G__39105 = cljs.core.count(c__4338__auto__);
var G__39106 = (0);
seq__39095 = G__39103;
chunk__39096 = G__39104;
count__39097 = G__39105;
i__39098 = G__39106;
continue;
} else {
var n = cljs.core.first(seq__39095__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__39107 = cljs.core.next(seq__39095__$1);
var G__39108 = null;
var G__39109 = (0);
var G__39110 = (0);
seq__39095 = G__39107;
chunk__39096 = G__39108;
count__39097 = G__39109;
i__39098 = G__39110;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
var G__39111 = shadow.dom.dom_node(new$);
var G__39112 = shadow.dom.dom_node(old);
return goog.dom.replaceNode(G__39111,G__39112);
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__39114 = arguments.length;
switch (G__39114) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return shadow.dom.dom_node(el).innerText = new_text;
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
});

shadow.dom.text.cljs$lang$maxFixedArity = 2;

shadow.dom.check = (function shadow$dom$check(var_args){
var G__39117 = arguments.length;
switch (G__39117) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return shadow.dom.dom_node(el).checked = checked;
});

shadow.dom.check.cljs$lang$maxFixedArity = 2;

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__39120 = arguments.length;
switch (G__39120) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__3936__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return default$;
}
});

shadow.dom.attr.cljs$lang$maxFixedArity = 3;

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return shadow.dom.dom_node(node).innerHTML = text;
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4521__auto__ = [];
var len__4518__auto___39127 = arguments.length;
var i__4519__auto___39128 = (0);
while(true){
if((i__4519__auto___39128 < len__4518__auto___39127)){
args__4521__auto__.push((arguments[i__4519__auto___39128]));

var G__39129 = (i__4519__auto___39128 + (1));
i__4519__auto___39128 = G__39129;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__39123_39130 = cljs.core.seq(nodes);
var chunk__39124_39131 = null;
var count__39125_39132 = (0);
var i__39126_39133 = (0);
while(true){
if((i__39126_39133 < count__39125_39132)){
var node_39134 = chunk__39124_39131.cljs$core$IIndexed$_nth$arity$2(null,i__39126_39133);
fragment.appendChild(shadow.dom._to_dom(node_39134));


var G__39135 = seq__39123_39130;
var G__39136 = chunk__39124_39131;
var G__39137 = count__39125_39132;
var G__39138 = (i__39126_39133 + (1));
seq__39123_39130 = G__39135;
chunk__39124_39131 = G__39136;
count__39125_39132 = G__39137;
i__39126_39133 = G__39138;
continue;
} else {
var temp__5457__auto___39139 = cljs.core.seq(seq__39123_39130);
if(temp__5457__auto___39139){
var seq__39123_39140__$1 = temp__5457__auto___39139;
if(cljs.core.chunked_seq_QMARK_(seq__39123_39140__$1)){
var c__4338__auto___39141 = cljs.core.chunk_first(seq__39123_39140__$1);
var G__39142 = cljs.core.chunk_rest(seq__39123_39140__$1);
var G__39143 = c__4338__auto___39141;
var G__39144 = cljs.core.count(c__4338__auto___39141);
var G__39145 = (0);
seq__39123_39130 = G__39142;
chunk__39124_39131 = G__39143;
count__39125_39132 = G__39144;
i__39126_39133 = G__39145;
continue;
} else {
var node_39146 = cljs.core.first(seq__39123_39140__$1);
fragment.appendChild(shadow.dom._to_dom(node_39146));


var G__39147 = cljs.core.next(seq__39123_39140__$1);
var G__39148 = null;
var G__39149 = (0);
var G__39150 = (0);
seq__39123_39130 = G__39147;
chunk__39124_39131 = G__39148;
count__39125_39132 = G__39149;
i__39126_39133 = G__39150;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
});

shadow.dom.fragment.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.dom.fragment.cljs$lang$applyTo = (function (seq39122){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39122));
});

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__39151_39165 = cljs.core.seq(scripts);
var chunk__39152_39166 = null;
var count__39153_39167 = (0);
var i__39154_39168 = (0);
while(true){
if((i__39154_39168 < count__39153_39167)){
var vec__39155_39169 = chunk__39152_39166.cljs$core$IIndexed$_nth$arity$2(null,i__39154_39168);
var script_tag_39170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39155_39169,(0),null);
var script_body_39171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39155_39169,(1),null);
eval(script_body_39171);


var G__39172 = seq__39151_39165;
var G__39173 = chunk__39152_39166;
var G__39174 = count__39153_39167;
var G__39175 = (i__39154_39168 + (1));
seq__39151_39165 = G__39172;
chunk__39152_39166 = G__39173;
count__39153_39167 = G__39174;
i__39154_39168 = G__39175;
continue;
} else {
var temp__5457__auto___39176 = cljs.core.seq(seq__39151_39165);
if(temp__5457__auto___39176){
var seq__39151_39177__$1 = temp__5457__auto___39176;
if(cljs.core.chunked_seq_QMARK_(seq__39151_39177__$1)){
var c__4338__auto___39178 = cljs.core.chunk_first(seq__39151_39177__$1);
var G__39179 = cljs.core.chunk_rest(seq__39151_39177__$1);
var G__39180 = c__4338__auto___39178;
var G__39181 = cljs.core.count(c__4338__auto___39178);
var G__39182 = (0);
seq__39151_39165 = G__39179;
chunk__39152_39166 = G__39180;
count__39153_39167 = G__39181;
i__39154_39168 = G__39182;
continue;
} else {
var vec__39158_39183 = cljs.core.first(seq__39151_39177__$1);
var script_tag_39184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39158_39183,(0),null);
var script_body_39185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39158_39183,(1),null);
eval(script_body_39185);


var G__39186 = cljs.core.next(seq__39151_39177__$1);
var G__39187 = null;
var G__39188 = (0);
var G__39189 = (0);
seq__39151_39165 = G__39186;
chunk__39152_39166 = G__39187;
count__39153_39167 = G__39188;
i__39154_39168 = G__39189;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (scripts){
return (function (s__$1,p__39161){
var vec__39162 = p__39161;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39162,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39162,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
});})(scripts))
,s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
el.innerHTML = s;

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
var G__39190 = shadow.dom.dom_node(el);
var G__39191 = cls;
return goog.dom.getAncestorByClass(G__39190,G__39191);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__39193 = arguments.length;
switch (G__39193) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
var G__39194 = shadow.dom.dom_node(el);
var G__39195 = cljs.core.name(tag);
return goog.dom.getAncestorByTagNameAndClass(G__39194,G__39195);
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
var G__39196 = shadow.dom.dom_node(el);
var G__39197 = cljs.core.name(tag);
var G__39198 = cljs.core.name(cls);
return goog.dom.getAncestorByTagNameAndClass(G__39196,G__39197,G__39198);
});

shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3;

shadow.dom.get_value = (function shadow$dom$get_value(dom){
var G__39200 = shadow.dom.dom_node(dom);
return goog.dom.forms.getValue(G__39200);
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
var G__39201 = shadow.dom.dom_node(dom);
var G__39202 = value;
return goog.dom.forms.setValue(G__39201,G__39202);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__39203 = cljs.core.seq(style_keys);
var chunk__39204 = null;
var count__39205 = (0);
var i__39206 = (0);
while(true){
if((i__39206 < count__39205)){
var it = chunk__39204.cljs$core$IIndexed$_nth$arity$2(null,i__39206);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__39207 = seq__39203;
var G__39208 = chunk__39204;
var G__39209 = count__39205;
var G__39210 = (i__39206 + (1));
seq__39203 = G__39207;
chunk__39204 = G__39208;
count__39205 = G__39209;
i__39206 = G__39210;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__39203);
if(temp__5457__auto__){
var seq__39203__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39203__$1)){
var c__4338__auto__ = cljs.core.chunk_first(seq__39203__$1);
var G__39211 = cljs.core.chunk_rest(seq__39203__$1);
var G__39212 = c__4338__auto__;
var G__39213 = cljs.core.count(c__4338__auto__);
var G__39214 = (0);
seq__39203 = G__39211;
chunk__39204 = G__39212;
count__39205 = G__39213;
i__39206 = G__39214;
continue;
} else {
var it = cljs.core.first(seq__39203__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__39215 = cljs.core.next(seq__39203__$1);
var G__39216 = null;
var G__39217 = (0);
var G__39218 = (0);
seq__39203 = G__39215;
chunk__39204 = G__39216;
count__39205 = G__39217;
i__39206 = G__39218;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__12001__auto__,k__12002__auto__){
var self__ = this;
var this__12001__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__12001__auto____$1,k__12002__auto__,null);
});

shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__12003__auto__,k39220,else__12004__auto__){
var self__ = this;
var this__12003__auto____$1 = this;
var G__39224 = k39220;
var G__39224__$1 = (((G__39224 instanceof cljs.core.Keyword))?G__39224.fqn:null);
switch (G__39224__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39220,else__12004__auto__);

}
});

shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__12015__auto__,writer__12016__auto__,opts__12017__auto__){
var self__ = this;
var this__12015__auto____$1 = this;
var pr_pair__12018__auto__ = ((function (this__12015__auto____$1){
return (function (keyval__12019__auto__){
return cljs.core.pr_sequential_writer(writer__12016__auto__,cljs.core.pr_writer,""," ","",opts__12017__auto__,keyval__12019__auto__);
});})(this__12015__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__12016__auto__,pr_pair__12018__auto__,"#shadow.dom.Coordinate{",", ","}",opts__12017__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39219){
var self__ = this;
var G__39219__$1 = this;
return (new cljs.core.RecordIter((0),G__39219__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__11999__auto__){
var self__ = this;
var this__11999__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__11996__auto__){
var self__ = this;
var this__11996__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__12005__auto__){
var self__ = this;
var this__12005__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__11997__auto__){
var self__ = this;
var this__11997__auto____$1 = this;
var h__4048__auto__ = self__.__hash;
if(!((h__4048__auto__ == null))){
return h__4048__auto__;
} else {
var h__4048__auto____$1 = (function (){var fexpr__39225 = ((function (h__4048__auto__,this__11997__auto____$1){
return (function (coll__11998__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__11998__auto__));
});})(h__4048__auto__,this__11997__auto____$1))
;
return fexpr__39225(this__11997__auto____$1);
})();
self__.__hash = h__4048__auto____$1;

return h__4048__auto____$1;
}
});

shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39221,other39222){
var self__ = this;
var this39221__$1 = this;
return ((!((other39222 == null))) && ((this39221__$1.constructor === other39222.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39221__$1.x,other39222.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39221__$1.y,other39222.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39221__$1.__extmap,other39222.__extmap)));
});

shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__12010__auto__,k__12011__auto__){
var self__ = this;
var this__12010__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__12011__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__12010__auto____$1),self__.__meta),k__12011__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__12011__auto__)),null));
}
});

shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__12008__auto__,k__12009__auto__,G__39219){
var self__ = this;
var this__12008__auto____$1 = this;
var pred__39226 = cljs.core.keyword_identical_QMARK_;
var expr__39227 = k__12009__auto__;
if(cljs.core.truth_((function (){var G__39229 = new cljs.core.Keyword(null,"x","x",2099068185);
var G__39230 = expr__39227;
return (pred__39226.cljs$core$IFn$_invoke$arity$2 ? pred__39226.cljs$core$IFn$_invoke$arity$2(G__39229,G__39230) : pred__39226.call(null,G__39229,G__39230));
})())){
return (new shadow.dom.Coordinate(G__39219,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39231 = new cljs.core.Keyword(null,"y","y",-1757859776);
var G__39232 = expr__39227;
return (pred__39226.cljs$core$IFn$_invoke$arity$2 ? pred__39226.cljs$core$IFn$_invoke$arity$2(G__39231,G__39232) : pred__39226.call(null,G__39231,G__39232));
})())){
return (new shadow.dom.Coordinate(self__.x,G__39219,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__12009__auto__,G__39219),null));
}
}
});

shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__12013__auto__){
var self__ = this;
var this__12013__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__12000__auto__,G__39219){
var self__ = this;
var this__12000__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__39219,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__12006__auto__,entry__12007__auto__){
var self__ = this;
var this__12006__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__12007__auto__)){
return cljs.core._assoc(this__12006__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__12006__auto____$1,entry__12007__auto__);
}
});

shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
});

shadow.dom.Coordinate.cljs$lang$type = true;

shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4227__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
});

shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4227__auto__,writer__4228__auto__){
return cljs.core._write(writer__4228__auto__,"shadow.dom/Coordinate");
});

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__39223){
var extmap__4223__auto__ = (function (){var G__39233 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39223,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__39223)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39233);
} else {
return G__39233;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__39223),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__39223),null,cljs.core.not_empty(extmap__4223__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = (function (){var G__39235 = shadow.dom.dom_node(el);
return goog.style.getPosition(G__39235);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = (function (){var G__39236 = shadow.dom.dom_node(el);
return goog.style.getClientPosition(G__39236);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = (function (){var G__39237 = shadow.dom.dom_node(el);
return goog.style.getPageOffset(G__39237);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__12001__auto__,k__12002__auto__){
var self__ = this;
var this__12001__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__12001__auto____$1,k__12002__auto__,null);
});

shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__12003__auto__,k39239,else__12004__auto__){
var self__ = this;
var this__12003__auto____$1 = this;
var G__39243 = k39239;
var G__39243__$1 = (((G__39243 instanceof cljs.core.Keyword))?G__39243.fqn:null);
switch (G__39243__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39239,else__12004__auto__);

}
});

shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__12015__auto__,writer__12016__auto__,opts__12017__auto__){
var self__ = this;
var this__12015__auto____$1 = this;
var pr_pair__12018__auto__ = ((function (this__12015__auto____$1){
return (function (keyval__12019__auto__){
return cljs.core.pr_sequential_writer(writer__12016__auto__,cljs.core.pr_writer,""," ","",opts__12017__auto__,keyval__12019__auto__);
});})(this__12015__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__12016__auto__,pr_pair__12018__auto__,"#shadow.dom.Size{",", ","}",opts__12017__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39238){
var self__ = this;
var G__39238__$1 = this;
return (new cljs.core.RecordIter((0),G__39238__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__11999__auto__){
var self__ = this;
var this__11999__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__11996__auto__){
var self__ = this;
var this__11996__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__12005__auto__){
var self__ = this;
var this__12005__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__11997__auto__){
var self__ = this;
var this__11997__auto____$1 = this;
var h__4048__auto__ = self__.__hash;
if(!((h__4048__auto__ == null))){
return h__4048__auto__;
} else {
var h__4048__auto____$1 = (function (){var fexpr__39244 = ((function (h__4048__auto__,this__11997__auto____$1){
return (function (coll__11998__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__11998__auto__));
});})(h__4048__auto__,this__11997__auto____$1))
;
return fexpr__39244(this__11997__auto____$1);
})();
self__.__hash = h__4048__auto____$1;

return h__4048__auto____$1;
}
});

shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39240,other39241){
var self__ = this;
var this39240__$1 = this;
return ((!((other39241 == null))) && ((this39240__$1.constructor === other39241.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39240__$1.w,other39241.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39240__$1.h,other39241.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39240__$1.__extmap,other39241.__extmap)));
});

shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__12010__auto__,k__12011__auto__){
var self__ = this;
var this__12010__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__12011__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__12010__auto____$1),self__.__meta),k__12011__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__12011__auto__)),null));
}
});

shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__12008__auto__,k__12009__auto__,G__39238){
var self__ = this;
var this__12008__auto____$1 = this;
var pred__39245 = cljs.core.keyword_identical_QMARK_;
var expr__39246 = k__12009__auto__;
if(cljs.core.truth_((function (){var G__39248 = new cljs.core.Keyword(null,"w","w",354169001);
var G__39249 = expr__39246;
return (pred__39245.cljs$core$IFn$_invoke$arity$2 ? pred__39245.cljs$core$IFn$_invoke$arity$2(G__39248,G__39249) : pred__39245.call(null,G__39248,G__39249));
})())){
return (new shadow.dom.Size(G__39238,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39250 = new cljs.core.Keyword(null,"h","h",1109658740);
var G__39251 = expr__39246;
return (pred__39245.cljs$core$IFn$_invoke$arity$2 ? pred__39245.cljs$core$IFn$_invoke$arity$2(G__39250,G__39251) : pred__39245.call(null,G__39250,G__39251));
})())){
return (new shadow.dom.Size(self__.w,G__39238,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__12009__auto__,G__39238),null));
}
}
});

shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__12013__auto__){
var self__ = this;
var this__12013__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__12000__auto__,G__39238){
var self__ = this;
var this__12000__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__39238,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__12006__auto__,entry__12007__auto__){
var self__ = this;
var this__12006__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__12007__auto__)){
return cljs.core._assoc(this__12006__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__12006__auto____$1,entry__12007__auto__);
}
});

shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
});

shadow.dom.Size.cljs$lang$type = true;

shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4227__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
});

shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4227__auto__,writer__4228__auto__){
return cljs.core._write(writer__4228__auto__,"shadow.dom/Size");
});

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__39242){
var extmap__4223__auto__ = (function (){var G__39252 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39242,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__39242)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39252);
} else {
return G__39252;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__39242),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__39242),null,cljs.core.not_empty(extmap__4223__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj((function (){var G__39254 = shadow.dom.dom_node(el);
return goog.style.getSize(G__39254);
})());
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(shadow.dom.get_size(el));
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4392__auto__ = opts;
var l__4393__auto__ = a__4392__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4393__auto__)){
var G__39255 = (i + (1));
var G__39256 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__39255;
ret = G__39256;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__39257){
var vec__39258 = p__39257;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39258,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39258,(1),null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(k)),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent([cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
}),query_params)))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__39262 = arguments.length;
switch (G__39262) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
});

shadow.dom.redirect.cljs$lang$maxFixedArity = 2;

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return document.location.href = document.location.href;
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__39264_39266 = new_node;
var G__39265_39267 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingAfter(G__39264_39266,G__39265_39267);

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__39268_39270 = new_node;
var G__39269_39271 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingBefore(G__39268_39270,G__39269_39271);

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5455__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5455__auto__)){
var child = temp__5455__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__39272 = ps;
var G__39273 = (i + (1));
el__$1 = G__39272;
i = G__39273;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
var G__39274 = shadow.dom.dom_node(el);
return goog.dom.getParentElement(G__39274);
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,((function (parent){
return (function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
});})(parent))
,null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
var G__39275 = shadow.dom.dom_node(el);
return goog.dom.getNextElementSibling(G__39275);
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
var G__39276 = shadow.dom.dom_node(el);
return goog.dom.getPreviousElementSibling(G__39276);
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__39277 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39277,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39277,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39277,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__39280_39290 = cljs.core.seq(props);
var chunk__39281_39291 = null;
var count__39282_39292 = (0);
var i__39283_39293 = (0);
while(true){
if((i__39283_39293 < count__39282_39292)){
var vec__39284_39294 = chunk__39281_39291.cljs$core$IIndexed$_nth$arity$2(null,i__39283_39293);
var k_39295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39284_39294,(0),null);
var v_39296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39284_39294,(1),null);
el.setAttributeNS((function (){var temp__5457__auto__ = cljs.core.namespace(k_39295);
if(cljs.core.truth_(temp__5457__auto__)){
var ns = temp__5457__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_39295),v_39296);


var G__39297 = seq__39280_39290;
var G__39298 = chunk__39281_39291;
var G__39299 = count__39282_39292;
var G__39300 = (i__39283_39293 + (1));
seq__39280_39290 = G__39297;
chunk__39281_39291 = G__39298;
count__39282_39292 = G__39299;
i__39283_39293 = G__39300;
continue;
} else {
var temp__5457__auto___39301 = cljs.core.seq(seq__39280_39290);
if(temp__5457__auto___39301){
var seq__39280_39302__$1 = temp__5457__auto___39301;
if(cljs.core.chunked_seq_QMARK_(seq__39280_39302__$1)){
var c__4338__auto___39303 = cljs.core.chunk_first(seq__39280_39302__$1);
var G__39304 = cljs.core.chunk_rest(seq__39280_39302__$1);
var G__39305 = c__4338__auto___39303;
var G__39306 = cljs.core.count(c__4338__auto___39303);
var G__39307 = (0);
seq__39280_39290 = G__39304;
chunk__39281_39291 = G__39305;
count__39282_39292 = G__39306;
i__39283_39293 = G__39307;
continue;
} else {
var vec__39287_39308 = cljs.core.first(seq__39280_39302__$1);
var k_39309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39287_39308,(0),null);
var v_39310 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39287_39308,(1),null);
el.setAttributeNS((function (){var temp__5457__auto____$1 = cljs.core.namespace(k_39309);
if(cljs.core.truth_(temp__5457__auto____$1)){
var ns = temp__5457__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_39309),v_39310);


var G__39311 = cljs.core.next(seq__39280_39302__$1);
var G__39312 = null;
var G__39313 = (0);
var G__39314 = (0);
seq__39280_39290 = G__39311;
chunk__39281_39291 = G__39312;
count__39282_39292 = G__39313;
i__39283_39293 = G__39314;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__39316 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39316,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39316,(1),null);
var seq__39319_39337 = cljs.core.seq(node_children);
var chunk__39321_39338 = null;
var count__39322_39339 = (0);
var i__39323_39340 = (0);
while(true){
if((i__39323_39340 < count__39322_39339)){
var child_struct_39341 = chunk__39321_39338.cljs$core$IIndexed$_nth$arity$2(null,i__39323_39340);
if(!((child_struct_39341 == null))){
if(typeof child_struct_39341 === 'string'){
var text_39342 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_39342),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_39341)].join(''));
} else {
var children_39343 = shadow.dom.svg_node(child_struct_39341);
if(cljs.core.seq_QMARK_(children_39343)){
var seq__39325_39344 = cljs.core.seq(children_39343);
var chunk__39327_39345 = null;
var count__39328_39346 = (0);
var i__39329_39347 = (0);
while(true){
if((i__39329_39347 < count__39328_39346)){
var child_39348 = chunk__39327_39345.cljs$core$IIndexed$_nth$arity$2(null,i__39329_39347);
if(cljs.core.truth_(child_39348)){
node.appendChild(child_39348);


var G__39349 = seq__39325_39344;
var G__39350 = chunk__39327_39345;
var G__39351 = count__39328_39346;
var G__39352 = (i__39329_39347 + (1));
seq__39325_39344 = G__39349;
chunk__39327_39345 = G__39350;
count__39328_39346 = G__39351;
i__39329_39347 = G__39352;
continue;
} else {
var G__39353 = seq__39325_39344;
var G__39354 = chunk__39327_39345;
var G__39355 = count__39328_39346;
var G__39356 = (i__39329_39347 + (1));
seq__39325_39344 = G__39353;
chunk__39327_39345 = G__39354;
count__39328_39346 = G__39355;
i__39329_39347 = G__39356;
continue;
}
} else {
var temp__5457__auto___39357 = cljs.core.seq(seq__39325_39344);
if(temp__5457__auto___39357){
var seq__39325_39358__$1 = temp__5457__auto___39357;
if(cljs.core.chunked_seq_QMARK_(seq__39325_39358__$1)){
var c__4338__auto___39359 = cljs.core.chunk_first(seq__39325_39358__$1);
var G__39360 = cljs.core.chunk_rest(seq__39325_39358__$1);
var G__39361 = c__4338__auto___39359;
var G__39362 = cljs.core.count(c__4338__auto___39359);
var G__39363 = (0);
seq__39325_39344 = G__39360;
chunk__39327_39345 = G__39361;
count__39328_39346 = G__39362;
i__39329_39347 = G__39363;
continue;
} else {
var child_39364 = cljs.core.first(seq__39325_39358__$1);
if(cljs.core.truth_(child_39364)){
node.appendChild(child_39364);


var G__39365 = cljs.core.next(seq__39325_39358__$1);
var G__39366 = null;
var G__39367 = (0);
var G__39368 = (0);
seq__39325_39344 = G__39365;
chunk__39327_39345 = G__39366;
count__39328_39346 = G__39367;
i__39329_39347 = G__39368;
continue;
} else {
var G__39369 = cljs.core.next(seq__39325_39358__$1);
var G__39370 = null;
var G__39371 = (0);
var G__39372 = (0);
seq__39325_39344 = G__39369;
chunk__39327_39345 = G__39370;
count__39328_39346 = G__39371;
i__39329_39347 = G__39372;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_39343);
}
}


var G__39373 = seq__39319_39337;
var G__39374 = chunk__39321_39338;
var G__39375 = count__39322_39339;
var G__39376 = (i__39323_39340 + (1));
seq__39319_39337 = G__39373;
chunk__39321_39338 = G__39374;
count__39322_39339 = G__39375;
i__39323_39340 = G__39376;
continue;
} else {
var G__39377 = seq__39319_39337;
var G__39378 = chunk__39321_39338;
var G__39379 = count__39322_39339;
var G__39380 = (i__39323_39340 + (1));
seq__39319_39337 = G__39377;
chunk__39321_39338 = G__39378;
count__39322_39339 = G__39379;
i__39323_39340 = G__39380;
continue;
}
} else {
var temp__5457__auto___39381 = cljs.core.seq(seq__39319_39337);
if(temp__5457__auto___39381){
var seq__39319_39382__$1 = temp__5457__auto___39381;
if(cljs.core.chunked_seq_QMARK_(seq__39319_39382__$1)){
var c__4338__auto___39383 = cljs.core.chunk_first(seq__39319_39382__$1);
var G__39384 = cljs.core.chunk_rest(seq__39319_39382__$1);
var G__39385 = c__4338__auto___39383;
var G__39386 = cljs.core.count(c__4338__auto___39383);
var G__39387 = (0);
seq__39319_39337 = G__39384;
chunk__39321_39338 = G__39385;
count__39322_39339 = G__39386;
i__39323_39340 = G__39387;
continue;
} else {
var child_struct_39388 = cljs.core.first(seq__39319_39382__$1);
if(!((child_struct_39388 == null))){
if(typeof child_struct_39388 === 'string'){
var text_39389 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_39389),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_39388)].join(''));
} else {
var children_39390 = shadow.dom.svg_node(child_struct_39388);
if(cljs.core.seq_QMARK_(children_39390)){
var seq__39331_39391 = cljs.core.seq(children_39390);
var chunk__39333_39392 = null;
var count__39334_39393 = (0);
var i__39335_39394 = (0);
while(true){
if((i__39335_39394 < count__39334_39393)){
var child_39395 = chunk__39333_39392.cljs$core$IIndexed$_nth$arity$2(null,i__39335_39394);
if(cljs.core.truth_(child_39395)){
node.appendChild(child_39395);


var G__39396 = seq__39331_39391;
var G__39397 = chunk__39333_39392;
var G__39398 = count__39334_39393;
var G__39399 = (i__39335_39394 + (1));
seq__39331_39391 = G__39396;
chunk__39333_39392 = G__39397;
count__39334_39393 = G__39398;
i__39335_39394 = G__39399;
continue;
} else {
var G__39400 = seq__39331_39391;
var G__39401 = chunk__39333_39392;
var G__39402 = count__39334_39393;
var G__39403 = (i__39335_39394 + (1));
seq__39331_39391 = G__39400;
chunk__39333_39392 = G__39401;
count__39334_39393 = G__39402;
i__39335_39394 = G__39403;
continue;
}
} else {
var temp__5457__auto___39404__$1 = cljs.core.seq(seq__39331_39391);
if(temp__5457__auto___39404__$1){
var seq__39331_39405__$1 = temp__5457__auto___39404__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39331_39405__$1)){
var c__4338__auto___39406 = cljs.core.chunk_first(seq__39331_39405__$1);
var G__39407 = cljs.core.chunk_rest(seq__39331_39405__$1);
var G__39408 = c__4338__auto___39406;
var G__39409 = cljs.core.count(c__4338__auto___39406);
var G__39410 = (0);
seq__39331_39391 = G__39407;
chunk__39333_39392 = G__39408;
count__39334_39393 = G__39409;
i__39335_39394 = G__39410;
continue;
} else {
var child_39411 = cljs.core.first(seq__39331_39405__$1);
if(cljs.core.truth_(child_39411)){
node.appendChild(child_39411);


var G__39412 = cljs.core.next(seq__39331_39405__$1);
var G__39413 = null;
var G__39414 = (0);
var G__39415 = (0);
seq__39331_39391 = G__39412;
chunk__39333_39392 = G__39413;
count__39334_39393 = G__39414;
i__39335_39394 = G__39415;
continue;
} else {
var G__39416 = cljs.core.next(seq__39331_39405__$1);
var G__39417 = null;
var G__39418 = (0);
var G__39419 = (0);
seq__39331_39391 = G__39416;
chunk__39333_39392 = G__39417;
count__39334_39393 = G__39418;
i__39335_39394 = G__39419;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_39390);
}
}


var G__39420 = cljs.core.next(seq__39319_39382__$1);
var G__39421 = null;
var G__39422 = (0);
var G__39423 = (0);
seq__39319_39337 = G__39420;
chunk__39321_39338 = G__39421;
count__39322_39339 = G__39422;
i__39323_39340 = G__39423;
continue;
} else {
var G__39424 = cljs.core.next(seq__39319_39382__$1);
var G__39425 = null;
var G__39426 = (0);
var G__39427 = (0);
seq__39319_39337 = G__39424;
chunk__39321_39338 = G__39425;
count__39322_39339 = G__39426;
i__39323_39340 = G__39427;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

var G__39428_39434 = shadow.dom._to_svg;
var G__39429_39435 = "string";
var G__39430_39436 = ((function (G__39428_39434,G__39429_39435){
return (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
});})(G__39428_39434,G__39429_39435))
;
goog.object.set(G__39428_39434,G__39429_39435,G__39430_39436);

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
});

goog.object.set(shadow.dom.SVGElement,"null",true);

var G__39431_39437 = shadow.dom._to_svg;
var G__39432_39438 = "null";
var G__39433_39439 = ((function (G__39431_39437,G__39432_39438){
return (function (_){
return null;
});})(G__39431_39437,G__39432_39438))
;
goog.object.set(G__39431_39437,G__39432_39438,G__39433_39439);
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4521__auto__ = [];
var len__4518__auto___39442 = arguments.length;
var i__4519__auto___39443 = (0);
while(true){
if((i__4519__auto___39443 < len__4518__auto___39442)){
args__4521__auto__.push((arguments[i__4519__auto___39443]));

var G__39444 = (i__4519__auto___39443 + (1));
i__4519__auto___39443 = G__39444;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((1) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4522__auto__);
});

shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
});

shadow.dom.svg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.dom.svg.cljs$lang$applyTo = (function (seq39440){
var G__39441 = cljs.core.first(seq39440);
var seq39440__$1 = cljs.core.next(seq39440);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39441,seq39440__$1);
});

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__39446 = arguments.length;
switch (G__39446) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = ((function (buf,chan){
return (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});})(buf,chan))
;
var G__39447_39462 = shadow.dom.dom_node(el);
var G__39448_39463 = cljs.core.name(event);
var G__39449_39464 = event_fn;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__39447_39462,G__39448_39463,G__39449_39464) : shadow.dom.dom_listen.call(null,G__39447_39462,G__39448_39463,G__39449_39464));

if(cljs.core.truth_((function (){var and__3925__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__3925__auto__)){
return !(once_or_cleanup === true);
} else {
return and__3925__auto__;
}
})())){
var c__36819__auto___39465 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___39465,buf,chan,event_fn){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___39465,buf,chan,event_fn){
return (function (state_39454){
var state_val_39455 = (state_39454[(1)]);
if((state_val_39455 === (1))){
var state_39454__$1 = state_39454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39454__$1,(2),once_or_cleanup);
} else {
if((state_val_39455 === (2))){
var inst_39451 = (state_39454[(2)]);
var inst_39452 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_39454__$1 = (function (){var statearr_39456 = state_39454;
(statearr_39456[(7)] = inst_39451);

return statearr_39456;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_39454__$1,inst_39452);
} else {
return null;
}
}
});})(c__36819__auto___39465,buf,chan,event_fn))
;
return ((function (switch__36644__auto__,c__36819__auto___39465,buf,chan,event_fn){
return (function() {
var shadow$dom$state_machine__36645__auto__ = null;
var shadow$dom$state_machine__36645__auto____0 = (function (){
var statearr_39457 = [null,null,null,null,null,null,null,null];
(statearr_39457[(0)] = shadow$dom$state_machine__36645__auto__);

(statearr_39457[(1)] = (1));

return statearr_39457;
});
var shadow$dom$state_machine__36645__auto____1 = (function (state_39454){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_39454);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e39458){if((e39458 instanceof Object)){
var ex__36648__auto__ = e39458;
var statearr_39459_39466 = state_39454;
(statearr_39459_39466[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39454);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39458;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39467 = state_39454;
state_39454 = G__39467;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
shadow$dom$state_machine__36645__auto__ = function(state_39454){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__36645__auto____0.call(this);
case 1:
return shadow$dom$state_machine__36645__auto____1.call(this,state_39454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__36645__auto____0;
shadow$dom$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__36645__auto____1;
return shadow$dom$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___39465,buf,chan,event_fn))
})();
var state__36821__auto__ = (function (){var statearr_39460 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_39460[(6)] = c__36819__auto___39465);

return statearr_39460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___39465,buf,chan,event_fn))
);

} else {
}

return chan;
});

shadow.dom.event_chan.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=shadow.dom.js.map
