goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__36877 = arguments.length;
switch (G__36877) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async36878 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36878 = (function (f,blockable,meta36879){
this.f = f;
this.blockable = blockable;
this.meta36879 = meta36879;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async36878.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36880,meta36879__$1){
var self__ = this;
var _36880__$1 = this;
return (new cljs.core.async.t_cljs$core$async36878(self__.f,self__.blockable,meta36879__$1));
});

cljs.core.async.t_cljs$core$async36878.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36880){
var self__ = this;
var _36880__$1 = this;
return self__.meta36879;
});

cljs.core.async.t_cljs$core$async36878.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36878.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async36878.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async36878.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async36878.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta36879","meta36879",1576118045,null)], null);
});

cljs.core.async.t_cljs$core$async36878.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36878.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36878";

cljs.core.async.t_cljs$core$async36878.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"cljs.core.async/t_cljs$core$async36878");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async36878.
 */
cljs.core.async.__GT_t_cljs$core$async36878 = (function cljs$core$async$__GT_t_cljs$core$async36878(f__$1,blockable__$1,meta36879){
return (new cljs.core.async.t_cljs$core$async36878(f__$1,blockable__$1,meta36879));
});

}

return (new cljs.core.async.t_cljs$core$async36878(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__36884 = arguments.length;
switch (G__36884) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__36887 = arguments.length;
switch (G__36887) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__36890 = arguments.length;
switch (G__36890) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_36892 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36892) : fn1.call(null,val_36892));
} else {
cljs.core.async.impl.dispatch.run(((function (val_36892,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36892) : fn1.call(null,val_36892));
});})(val_36892,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__36894 = arguments.length;
switch (G__36894) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4395__auto___36896 = n;
var x_36897 = (0);
while(true){
if((x_36897 < n__4395__auto___36896)){
(a[x_36897] = (0));

var G__36898 = (x_36897 + (1));
x_36897 = G__36898;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__36899 = (i + (1));
i = G__36899;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async36900 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36900 = (function (flag,meta36901){
this.flag = flag;
this.meta36901 = meta36901;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async36900.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_36902,meta36901__$1){
var self__ = this;
var _36902__$1 = this;
return (new cljs.core.async.t_cljs$core$async36900(self__.flag,meta36901__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async36900.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_36902){
var self__ = this;
var _36902__$1 = this;
return self__.meta36901;
});})(flag))
;

cljs.core.async.t_cljs$core$async36900.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36900.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async36900.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async36900.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async36900.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta36901","meta36901",-242059838,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async36900.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36900.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36900";

cljs.core.async.t_cljs$core$async36900.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"cljs.core.async/t_cljs$core$async36900");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async36900.
 */
cljs.core.async.__GT_t_cljs$core$async36900 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async36900(flag__$1,meta36901){
return (new cljs.core.async.t_cljs$core$async36900(flag__$1,meta36901));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async36900(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async36903 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36903 = (function (flag,cb,meta36904){
this.flag = flag;
this.cb = cb;
this.meta36904 = meta36904;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async36903.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36905,meta36904__$1){
var self__ = this;
var _36905__$1 = this;
return (new cljs.core.async.t_cljs$core$async36903(self__.flag,self__.cb,meta36904__$1));
});

cljs.core.async.t_cljs$core$async36903.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36905){
var self__ = this;
var _36905__$1 = this;
return self__.meta36904;
});

cljs.core.async.t_cljs$core$async36903.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36903.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async36903.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async36903.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async36903.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta36904","meta36904",-1709277460,null)], null);
});

cljs.core.async.t_cljs$core$async36903.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36903.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36903";

cljs.core.async.t_cljs$core$async36903.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"cljs.core.async/t_cljs$core$async36903");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async36903.
 */
cljs.core.async.__GT_t_cljs$core$async36903 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async36903(flag__$1,cb__$1,meta36904){
return (new cljs.core.async.t_cljs$core$async36903(flag__$1,cb__$1,meta36904));
});

}

return (new cljs.core.async.t_cljs$core$async36903(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36906_SHARP_){
var G__36908 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36906_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__36908) : fret.call(null,G__36908));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36907_SHARP_){
var G__36909 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36907_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__36909) : fret.call(null,G__36909));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__3936__auto__ = wport;
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return port;
}
})()], null));
} else {
var G__36910 = (i + (1));
i = G__36910;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3936__auto__ = ret;
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3925__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__3925__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__3925__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4521__auto__ = [];
var len__4518__auto___36916 = arguments.length;
var i__4519__auto___36917 = (0);
while(true){
if((i__4519__auto___36917 < len__4518__auto___36916)){
args__4521__auto__.push((arguments[i__4519__auto___36917]));

var G__36918 = (i__4519__auto___36917 + (1));
i__4519__auto___36917 = G__36918;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((1) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4522__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__36913){
var map__36914 = p__36913;
var map__36914__$1 = ((((!((map__36914 == null)))?(((((map__36914.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36914.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36914):map__36914);
var opts = map__36914__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq36911){
var G__36912 = cljs.core.first(seq36911);
var seq36911__$1 = cljs.core.next(seq36911);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36912,seq36911__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__36920 = arguments.length;
switch (G__36920) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__36819__auto___36966 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___36966){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___36966){
return (function (state_36944){
var state_val_36945 = (state_36944[(1)]);
if((state_val_36945 === (7))){
var inst_36940 = (state_36944[(2)]);
var state_36944__$1 = state_36944;
var statearr_36946_36967 = state_36944__$1;
(statearr_36946_36967[(2)] = inst_36940);

(statearr_36946_36967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (1))){
var state_36944__$1 = state_36944;
var statearr_36947_36968 = state_36944__$1;
(statearr_36947_36968[(2)] = null);

(statearr_36947_36968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (4))){
var inst_36923 = (state_36944[(7)]);
var inst_36923__$1 = (state_36944[(2)]);
var inst_36924 = (inst_36923__$1 == null);
var state_36944__$1 = (function (){var statearr_36948 = state_36944;
(statearr_36948[(7)] = inst_36923__$1);

return statearr_36948;
})();
if(cljs.core.truth_(inst_36924)){
var statearr_36949_36969 = state_36944__$1;
(statearr_36949_36969[(1)] = (5));

} else {
var statearr_36950_36970 = state_36944__$1;
(statearr_36950_36970[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (13))){
var state_36944__$1 = state_36944;
var statearr_36951_36971 = state_36944__$1;
(statearr_36951_36971[(2)] = null);

(statearr_36951_36971[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (6))){
var inst_36923 = (state_36944[(7)]);
var state_36944__$1 = state_36944;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36944__$1,(11),to,inst_36923);
} else {
if((state_val_36945 === (3))){
var inst_36942 = (state_36944[(2)]);
var state_36944__$1 = state_36944;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36944__$1,inst_36942);
} else {
if((state_val_36945 === (12))){
var state_36944__$1 = state_36944;
var statearr_36952_36972 = state_36944__$1;
(statearr_36952_36972[(2)] = null);

(statearr_36952_36972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (2))){
var state_36944__$1 = state_36944;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36944__$1,(4),from);
} else {
if((state_val_36945 === (11))){
var inst_36933 = (state_36944[(2)]);
var state_36944__$1 = state_36944;
if(cljs.core.truth_(inst_36933)){
var statearr_36953_36973 = state_36944__$1;
(statearr_36953_36973[(1)] = (12));

} else {
var statearr_36954_36974 = state_36944__$1;
(statearr_36954_36974[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (9))){
var state_36944__$1 = state_36944;
var statearr_36955_36975 = state_36944__$1;
(statearr_36955_36975[(2)] = null);

(statearr_36955_36975[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (5))){
var state_36944__$1 = state_36944;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36956_36976 = state_36944__$1;
(statearr_36956_36976[(1)] = (8));

} else {
var statearr_36957_36977 = state_36944__$1;
(statearr_36957_36977[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (14))){
var inst_36938 = (state_36944[(2)]);
var state_36944__$1 = state_36944;
var statearr_36958_36978 = state_36944__$1;
(statearr_36958_36978[(2)] = inst_36938);

(statearr_36958_36978[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (10))){
var inst_36930 = (state_36944[(2)]);
var state_36944__$1 = state_36944;
var statearr_36959_36979 = state_36944__$1;
(statearr_36959_36979[(2)] = inst_36930);

(statearr_36959_36979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (8))){
var inst_36927 = cljs.core.async.close_BANG_(to);
var state_36944__$1 = state_36944;
var statearr_36960_36980 = state_36944__$1;
(statearr_36960_36980[(2)] = inst_36927);

(statearr_36960_36980[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___36966))
;
return ((function (switch__36644__auto__,c__36819__auto___36966){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_36961 = [null,null,null,null,null,null,null,null];
(statearr_36961[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_36961[(1)] = (1));

return statearr_36961;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_36944){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_36944);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e36962){if((e36962 instanceof Object)){
var ex__36648__auto__ = e36962;
var statearr_36963_36981 = state_36944;
(statearr_36963_36981[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36944);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36962;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36982 = state_36944;
state_36944 = G__36982;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_36944){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_36944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___36966))
})();
var state__36821__auto__ = (function (){var statearr_36964 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_36964[(6)] = c__36819__auto___36966);

return statearr_36964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___36966))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__36983){
var vec__36984 = p__36983;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36984,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36984,(1),null);
var job = vec__36984;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__36819__auto___37155 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___37155,res,vec__36984,v,p,job,jobs,results){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___37155,res,vec__36984,v,p,job,jobs,results){
return (function (state_36991){
var state_val_36992 = (state_36991[(1)]);
if((state_val_36992 === (1))){
var state_36991__$1 = state_36991;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36991__$1,(2),res,v);
} else {
if((state_val_36992 === (2))){
var inst_36988 = (state_36991[(2)]);
var inst_36989 = cljs.core.async.close_BANG_(res);
var state_36991__$1 = (function (){var statearr_36993 = state_36991;
(statearr_36993[(7)] = inst_36988);

return statearr_36993;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36991__$1,inst_36989);
} else {
return null;
}
}
});})(c__36819__auto___37155,res,vec__36984,v,p,job,jobs,results))
;
return ((function (switch__36644__auto__,c__36819__auto___37155,res,vec__36984,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0 = (function (){
var statearr_36994 = [null,null,null,null,null,null,null,null];
(statearr_36994[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__);

(statearr_36994[(1)] = (1));

return statearr_36994;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1 = (function (state_36991){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_36991);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e36995){if((e36995 instanceof Object)){
var ex__36648__auto__ = e36995;
var statearr_36996_37156 = state_36991;
(statearr_36996_37156[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36991);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36995;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37157 = state_36991;
state_36991 = G__37157;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__ = function(state_36991){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1.call(this,state_36991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___37155,res,vec__36984,v,p,job,jobs,results))
})();
var state__36821__auto__ = (function (){var statearr_36997 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_36997[(6)] = c__36819__auto___37155);

return statearr_36997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___37155,res,vec__36984,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__36998){
var vec__36999 = p__36998;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36999,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36999,(1),null);
var job = vec__36999;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4395__auto___37158 = n;
var __37159 = (0);
while(true){
if((__37159 < n__4395__auto___37158)){
var G__37002_37160 = type;
var G__37002_37161__$1 = (((G__37002_37160 instanceof cljs.core.Keyword))?G__37002_37160.fqn:null);
switch (G__37002_37161__$1) {
case "compute":
var c__36819__auto___37163 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__37159,c__36819__auto___37163,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (__37159,c__36819__auto___37163,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async){
return (function (state_37015){
var state_val_37016 = (state_37015[(1)]);
if((state_val_37016 === (1))){
var state_37015__$1 = state_37015;
var statearr_37017_37164 = state_37015__$1;
(statearr_37017_37164[(2)] = null);

(statearr_37017_37164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37016 === (2))){
var state_37015__$1 = state_37015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37015__$1,(4),jobs);
} else {
if((state_val_37016 === (3))){
var inst_37013 = (state_37015[(2)]);
var state_37015__$1 = state_37015;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37015__$1,inst_37013);
} else {
if((state_val_37016 === (4))){
var inst_37005 = (state_37015[(2)]);
var inst_37006 = process(inst_37005);
var state_37015__$1 = state_37015;
if(cljs.core.truth_(inst_37006)){
var statearr_37018_37165 = state_37015__$1;
(statearr_37018_37165[(1)] = (5));

} else {
var statearr_37019_37166 = state_37015__$1;
(statearr_37019_37166[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37016 === (5))){
var state_37015__$1 = state_37015;
var statearr_37020_37167 = state_37015__$1;
(statearr_37020_37167[(2)] = null);

(statearr_37020_37167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37016 === (6))){
var state_37015__$1 = state_37015;
var statearr_37021_37168 = state_37015__$1;
(statearr_37021_37168[(2)] = null);

(statearr_37021_37168[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37016 === (7))){
var inst_37011 = (state_37015[(2)]);
var state_37015__$1 = state_37015;
var statearr_37022_37169 = state_37015__$1;
(statearr_37022_37169[(2)] = inst_37011);

(statearr_37022_37169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__37159,c__36819__auto___37163,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async))
;
return ((function (__37159,switch__36644__auto__,c__36819__auto___37163,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0 = (function (){
var statearr_37023 = [null,null,null,null,null,null,null];
(statearr_37023[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__);

(statearr_37023[(1)] = (1));

return statearr_37023;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1 = (function (state_37015){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_37015);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e37024){if((e37024 instanceof Object)){
var ex__36648__auto__ = e37024;
var statearr_37025_37170 = state_37015;
(statearr_37025_37170[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37015);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37024;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37171 = state_37015;
state_37015 = G__37171;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__ = function(state_37015){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1.call(this,state_37015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__;
})()
;})(__37159,switch__36644__auto__,c__36819__auto___37163,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async))
})();
var state__36821__auto__ = (function (){var statearr_37026 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_37026[(6)] = c__36819__auto___37163);

return statearr_37026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(__37159,c__36819__auto___37163,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async))
);


break;
case "async":
var c__36819__auto___37172 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__37159,c__36819__auto___37172,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (__37159,c__36819__auto___37172,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async){
return (function (state_37039){
var state_val_37040 = (state_37039[(1)]);
if((state_val_37040 === (1))){
var state_37039__$1 = state_37039;
var statearr_37041_37173 = state_37039__$1;
(statearr_37041_37173[(2)] = null);

(statearr_37041_37173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37040 === (2))){
var state_37039__$1 = state_37039;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37039__$1,(4),jobs);
} else {
if((state_val_37040 === (3))){
var inst_37037 = (state_37039[(2)]);
var state_37039__$1 = state_37039;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37039__$1,inst_37037);
} else {
if((state_val_37040 === (4))){
var inst_37029 = (state_37039[(2)]);
var inst_37030 = async(inst_37029);
var state_37039__$1 = state_37039;
if(cljs.core.truth_(inst_37030)){
var statearr_37042_37174 = state_37039__$1;
(statearr_37042_37174[(1)] = (5));

} else {
var statearr_37043_37175 = state_37039__$1;
(statearr_37043_37175[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37040 === (5))){
var state_37039__$1 = state_37039;
var statearr_37044_37176 = state_37039__$1;
(statearr_37044_37176[(2)] = null);

(statearr_37044_37176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37040 === (6))){
var state_37039__$1 = state_37039;
var statearr_37045_37177 = state_37039__$1;
(statearr_37045_37177[(2)] = null);

(statearr_37045_37177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37040 === (7))){
var inst_37035 = (state_37039[(2)]);
var state_37039__$1 = state_37039;
var statearr_37046_37178 = state_37039__$1;
(statearr_37046_37178[(2)] = inst_37035);

(statearr_37046_37178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__37159,c__36819__auto___37172,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async))
;
return ((function (__37159,switch__36644__auto__,c__36819__auto___37172,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0 = (function (){
var statearr_37047 = [null,null,null,null,null,null,null];
(statearr_37047[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__);

(statearr_37047[(1)] = (1));

return statearr_37047;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1 = (function (state_37039){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_37039);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e37048){if((e37048 instanceof Object)){
var ex__36648__auto__ = e37048;
var statearr_37049_37179 = state_37039;
(statearr_37049_37179[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37039);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37048;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37180 = state_37039;
state_37039 = G__37180;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__ = function(state_37039){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1.call(this,state_37039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__;
})()
;})(__37159,switch__36644__auto__,c__36819__auto___37172,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async))
})();
var state__36821__auto__ = (function (){var statearr_37050 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_37050[(6)] = c__36819__auto___37172);

return statearr_37050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(__37159,c__36819__auto___37172,G__37002_37160,G__37002_37161__$1,n__4395__auto___37158,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37002_37161__$1)].join('')));

}

var G__37181 = (__37159 + (1));
__37159 = G__37181;
continue;
} else {
}
break;
}

var c__36819__auto___37182 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___37182,jobs,results,process,async){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___37182,jobs,results,process,async){
return (function (state_37072){
var state_val_37073 = (state_37072[(1)]);
if((state_val_37073 === (1))){
var state_37072__$1 = state_37072;
var statearr_37074_37183 = state_37072__$1;
(statearr_37074_37183[(2)] = null);

(statearr_37074_37183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37073 === (2))){
var state_37072__$1 = state_37072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37072__$1,(4),from);
} else {
if((state_val_37073 === (3))){
var inst_37070 = (state_37072[(2)]);
var state_37072__$1 = state_37072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37072__$1,inst_37070);
} else {
if((state_val_37073 === (4))){
var inst_37053 = (state_37072[(7)]);
var inst_37053__$1 = (state_37072[(2)]);
var inst_37054 = (inst_37053__$1 == null);
var state_37072__$1 = (function (){var statearr_37075 = state_37072;
(statearr_37075[(7)] = inst_37053__$1);

return statearr_37075;
})();
if(cljs.core.truth_(inst_37054)){
var statearr_37076_37184 = state_37072__$1;
(statearr_37076_37184[(1)] = (5));

} else {
var statearr_37077_37185 = state_37072__$1;
(statearr_37077_37185[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37073 === (5))){
var inst_37056 = cljs.core.async.close_BANG_(jobs);
var state_37072__$1 = state_37072;
var statearr_37078_37186 = state_37072__$1;
(statearr_37078_37186[(2)] = inst_37056);

(statearr_37078_37186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37073 === (6))){
var inst_37053 = (state_37072[(7)]);
var inst_37058 = (state_37072[(8)]);
var inst_37058__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_37059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37060 = [inst_37053,inst_37058__$1];
var inst_37061 = (new cljs.core.PersistentVector(null,2,(5),inst_37059,inst_37060,null));
var state_37072__$1 = (function (){var statearr_37079 = state_37072;
(statearr_37079[(8)] = inst_37058__$1);

return statearr_37079;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37072__$1,(8),jobs,inst_37061);
} else {
if((state_val_37073 === (7))){
var inst_37068 = (state_37072[(2)]);
var state_37072__$1 = state_37072;
var statearr_37080_37187 = state_37072__$1;
(statearr_37080_37187[(2)] = inst_37068);

(statearr_37080_37187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37073 === (8))){
var inst_37058 = (state_37072[(8)]);
var inst_37063 = (state_37072[(2)]);
var state_37072__$1 = (function (){var statearr_37081 = state_37072;
(statearr_37081[(9)] = inst_37063);

return statearr_37081;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37072__$1,(9),results,inst_37058);
} else {
if((state_val_37073 === (9))){
var inst_37065 = (state_37072[(2)]);
var state_37072__$1 = (function (){var statearr_37082 = state_37072;
(statearr_37082[(10)] = inst_37065);

return statearr_37082;
})();
var statearr_37083_37188 = state_37072__$1;
(statearr_37083_37188[(2)] = null);

(statearr_37083_37188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___37182,jobs,results,process,async))
;
return ((function (switch__36644__auto__,c__36819__auto___37182,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0 = (function (){
var statearr_37084 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37084[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__);

(statearr_37084[(1)] = (1));

return statearr_37084;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1 = (function (state_37072){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_37072);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e37085){if((e37085 instanceof Object)){
var ex__36648__auto__ = e37085;
var statearr_37086_37189 = state_37072;
(statearr_37086_37189[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37072);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37085;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37190 = state_37072;
state_37072 = G__37190;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__ = function(state_37072){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1.call(this,state_37072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___37182,jobs,results,process,async))
})();
var state__36821__auto__ = (function (){var statearr_37087 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_37087[(6)] = c__36819__auto___37182);

return statearr_37087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___37182,jobs,results,process,async))
);


var c__36819__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto__,jobs,results,process,async){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto__,jobs,results,process,async){
return (function (state_37125){
var state_val_37126 = (state_37125[(1)]);
if((state_val_37126 === (7))){
var inst_37121 = (state_37125[(2)]);
var state_37125__$1 = state_37125;
var statearr_37127_37191 = state_37125__$1;
(statearr_37127_37191[(2)] = inst_37121);

(statearr_37127_37191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (20))){
var state_37125__$1 = state_37125;
var statearr_37128_37192 = state_37125__$1;
(statearr_37128_37192[(2)] = null);

(statearr_37128_37192[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (1))){
var state_37125__$1 = state_37125;
var statearr_37129_37193 = state_37125__$1;
(statearr_37129_37193[(2)] = null);

(statearr_37129_37193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (4))){
var inst_37090 = (state_37125[(7)]);
var inst_37090__$1 = (state_37125[(2)]);
var inst_37091 = (inst_37090__$1 == null);
var state_37125__$1 = (function (){var statearr_37130 = state_37125;
(statearr_37130[(7)] = inst_37090__$1);

return statearr_37130;
})();
if(cljs.core.truth_(inst_37091)){
var statearr_37131_37194 = state_37125__$1;
(statearr_37131_37194[(1)] = (5));

} else {
var statearr_37132_37195 = state_37125__$1;
(statearr_37132_37195[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (15))){
var inst_37103 = (state_37125[(8)]);
var state_37125__$1 = state_37125;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37125__$1,(18),to,inst_37103);
} else {
if((state_val_37126 === (21))){
var inst_37116 = (state_37125[(2)]);
var state_37125__$1 = state_37125;
var statearr_37133_37196 = state_37125__$1;
(statearr_37133_37196[(2)] = inst_37116);

(statearr_37133_37196[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (13))){
var inst_37118 = (state_37125[(2)]);
var state_37125__$1 = (function (){var statearr_37134 = state_37125;
(statearr_37134[(9)] = inst_37118);

return statearr_37134;
})();
var statearr_37135_37197 = state_37125__$1;
(statearr_37135_37197[(2)] = null);

(statearr_37135_37197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (6))){
var inst_37090 = (state_37125[(7)]);
var state_37125__$1 = state_37125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37125__$1,(11),inst_37090);
} else {
if((state_val_37126 === (17))){
var inst_37111 = (state_37125[(2)]);
var state_37125__$1 = state_37125;
if(cljs.core.truth_(inst_37111)){
var statearr_37136_37198 = state_37125__$1;
(statearr_37136_37198[(1)] = (19));

} else {
var statearr_37137_37199 = state_37125__$1;
(statearr_37137_37199[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (3))){
var inst_37123 = (state_37125[(2)]);
var state_37125__$1 = state_37125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37125__$1,inst_37123);
} else {
if((state_val_37126 === (12))){
var inst_37100 = (state_37125[(10)]);
var state_37125__$1 = state_37125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37125__$1,(14),inst_37100);
} else {
if((state_val_37126 === (2))){
var state_37125__$1 = state_37125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37125__$1,(4),results);
} else {
if((state_val_37126 === (19))){
var state_37125__$1 = state_37125;
var statearr_37138_37200 = state_37125__$1;
(statearr_37138_37200[(2)] = null);

(statearr_37138_37200[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (11))){
var inst_37100 = (state_37125[(2)]);
var state_37125__$1 = (function (){var statearr_37139 = state_37125;
(statearr_37139[(10)] = inst_37100);

return statearr_37139;
})();
var statearr_37140_37201 = state_37125__$1;
(statearr_37140_37201[(2)] = null);

(statearr_37140_37201[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (9))){
var state_37125__$1 = state_37125;
var statearr_37141_37202 = state_37125__$1;
(statearr_37141_37202[(2)] = null);

(statearr_37141_37202[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (5))){
var state_37125__$1 = state_37125;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37142_37203 = state_37125__$1;
(statearr_37142_37203[(1)] = (8));

} else {
var statearr_37143_37204 = state_37125__$1;
(statearr_37143_37204[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (14))){
var inst_37105 = (state_37125[(11)]);
var inst_37103 = (state_37125[(8)]);
var inst_37103__$1 = (state_37125[(2)]);
var inst_37104 = (inst_37103__$1 == null);
var inst_37105__$1 = cljs.core.not(inst_37104);
var state_37125__$1 = (function (){var statearr_37144 = state_37125;
(statearr_37144[(11)] = inst_37105__$1);

(statearr_37144[(8)] = inst_37103__$1);

return statearr_37144;
})();
if(inst_37105__$1){
var statearr_37145_37205 = state_37125__$1;
(statearr_37145_37205[(1)] = (15));

} else {
var statearr_37146_37206 = state_37125__$1;
(statearr_37146_37206[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (16))){
var inst_37105 = (state_37125[(11)]);
var state_37125__$1 = state_37125;
var statearr_37147_37207 = state_37125__$1;
(statearr_37147_37207[(2)] = inst_37105);

(statearr_37147_37207[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (10))){
var inst_37097 = (state_37125[(2)]);
var state_37125__$1 = state_37125;
var statearr_37148_37208 = state_37125__$1;
(statearr_37148_37208[(2)] = inst_37097);

(statearr_37148_37208[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (18))){
var inst_37108 = (state_37125[(2)]);
var state_37125__$1 = state_37125;
var statearr_37149_37209 = state_37125__$1;
(statearr_37149_37209[(2)] = inst_37108);

(statearr_37149_37209[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37126 === (8))){
var inst_37094 = cljs.core.async.close_BANG_(to);
var state_37125__$1 = state_37125;
var statearr_37150_37210 = state_37125__$1;
(statearr_37150_37210[(2)] = inst_37094);

(statearr_37150_37210[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto__,jobs,results,process,async))
;
return ((function (switch__36644__auto__,c__36819__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0 = (function (){
var statearr_37151 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37151[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__);

(statearr_37151[(1)] = (1));

return statearr_37151;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1 = (function (state_37125){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_37125);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e37152){if((e37152 instanceof Object)){
var ex__36648__auto__ = e37152;
var statearr_37153_37211 = state_37125;
(statearr_37153_37211[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37125);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37152;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37212 = state_37125;
state_37125 = G__37212;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__ = function(state_37125){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1.call(this,state_37125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36645__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto__,jobs,results,process,async))
})();
var state__36821__auto__ = (function (){var statearr_37154 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_37154[(6)] = c__36819__auto__);

return statearr_37154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto__,jobs,results,process,async))
);

return c__36819__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__37214 = arguments.length;
switch (G__37214) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__37217 = arguments.length;
switch (G__37217) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__37220 = arguments.length;
switch (G__37220) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__36819__auto___37269 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___37269,tc,fc){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___37269,tc,fc){
return (function (state_37246){
var state_val_37247 = (state_37246[(1)]);
if((state_val_37247 === (7))){
var inst_37242 = (state_37246[(2)]);
var state_37246__$1 = state_37246;
var statearr_37248_37270 = state_37246__$1;
(statearr_37248_37270[(2)] = inst_37242);

(statearr_37248_37270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37247 === (1))){
var state_37246__$1 = state_37246;
var statearr_37249_37271 = state_37246__$1;
(statearr_37249_37271[(2)] = null);

(statearr_37249_37271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37247 === (4))){
var inst_37223 = (state_37246[(7)]);
var inst_37223__$1 = (state_37246[(2)]);
var inst_37224 = (inst_37223__$1 == null);
var state_37246__$1 = (function (){var statearr_37250 = state_37246;
(statearr_37250[(7)] = inst_37223__$1);

return statearr_37250;
})();
if(cljs.core.truth_(inst_37224)){
var statearr_37251_37272 = state_37246__$1;
(statearr_37251_37272[(1)] = (5));

} else {
var statearr_37252_37273 = state_37246__$1;
(statearr_37252_37273[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37247 === (13))){
var state_37246__$1 = state_37246;
var statearr_37253_37274 = state_37246__$1;
(statearr_37253_37274[(2)] = null);

(statearr_37253_37274[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37247 === (6))){
var inst_37223 = (state_37246[(7)]);
var inst_37229 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_37223) : p.call(null,inst_37223));
var state_37246__$1 = state_37246;
if(cljs.core.truth_(inst_37229)){
var statearr_37254_37275 = state_37246__$1;
(statearr_37254_37275[(1)] = (9));

} else {
var statearr_37255_37276 = state_37246__$1;
(statearr_37255_37276[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37247 === (3))){
var inst_37244 = (state_37246[(2)]);
var state_37246__$1 = state_37246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37246__$1,inst_37244);
} else {
if((state_val_37247 === (12))){
var state_37246__$1 = state_37246;
var statearr_37256_37277 = state_37246__$1;
(statearr_37256_37277[(2)] = null);

(statearr_37256_37277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37247 === (2))){
var state_37246__$1 = state_37246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37246__$1,(4),ch);
} else {
if((state_val_37247 === (11))){
var inst_37223 = (state_37246[(7)]);
var inst_37233 = (state_37246[(2)]);
var state_37246__$1 = state_37246;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37246__$1,(8),inst_37233,inst_37223);
} else {
if((state_val_37247 === (9))){
var state_37246__$1 = state_37246;
var statearr_37257_37278 = state_37246__$1;
(statearr_37257_37278[(2)] = tc);

(statearr_37257_37278[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37247 === (5))){
var inst_37226 = cljs.core.async.close_BANG_(tc);
var inst_37227 = cljs.core.async.close_BANG_(fc);
var state_37246__$1 = (function (){var statearr_37258 = state_37246;
(statearr_37258[(8)] = inst_37226);

return statearr_37258;
})();
var statearr_37259_37279 = state_37246__$1;
(statearr_37259_37279[(2)] = inst_37227);

(statearr_37259_37279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37247 === (14))){
var inst_37240 = (state_37246[(2)]);
var state_37246__$1 = state_37246;
var statearr_37260_37280 = state_37246__$1;
(statearr_37260_37280[(2)] = inst_37240);

(statearr_37260_37280[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37247 === (10))){
var state_37246__$1 = state_37246;
var statearr_37261_37281 = state_37246__$1;
(statearr_37261_37281[(2)] = fc);

(statearr_37261_37281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37247 === (8))){
var inst_37235 = (state_37246[(2)]);
var state_37246__$1 = state_37246;
if(cljs.core.truth_(inst_37235)){
var statearr_37262_37282 = state_37246__$1;
(statearr_37262_37282[(1)] = (12));

} else {
var statearr_37263_37283 = state_37246__$1;
(statearr_37263_37283[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___37269,tc,fc))
;
return ((function (switch__36644__auto__,c__36819__auto___37269,tc,fc){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_37264 = [null,null,null,null,null,null,null,null,null];
(statearr_37264[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_37264[(1)] = (1));

return statearr_37264;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_37246){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_37246);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e37265){if((e37265 instanceof Object)){
var ex__36648__auto__ = e37265;
var statearr_37266_37284 = state_37246;
(statearr_37266_37284[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37246);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37265;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37285 = state_37246;
state_37246 = G__37285;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_37246){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_37246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___37269,tc,fc))
})();
var state__36821__auto__ = (function (){var statearr_37267 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_37267[(6)] = c__36819__auto___37269);

return statearr_37267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___37269,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__36819__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto__){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto__){
return (function (state_37306){
var state_val_37307 = (state_37306[(1)]);
if((state_val_37307 === (7))){
var inst_37302 = (state_37306[(2)]);
var state_37306__$1 = state_37306;
var statearr_37308_37326 = state_37306__$1;
(statearr_37308_37326[(2)] = inst_37302);

(statearr_37308_37326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37307 === (1))){
var inst_37286 = init;
var state_37306__$1 = (function (){var statearr_37309 = state_37306;
(statearr_37309[(7)] = inst_37286);

return statearr_37309;
})();
var statearr_37310_37327 = state_37306__$1;
(statearr_37310_37327[(2)] = null);

(statearr_37310_37327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37307 === (4))){
var inst_37289 = (state_37306[(8)]);
var inst_37289__$1 = (state_37306[(2)]);
var inst_37290 = (inst_37289__$1 == null);
var state_37306__$1 = (function (){var statearr_37311 = state_37306;
(statearr_37311[(8)] = inst_37289__$1);

return statearr_37311;
})();
if(cljs.core.truth_(inst_37290)){
var statearr_37312_37328 = state_37306__$1;
(statearr_37312_37328[(1)] = (5));

} else {
var statearr_37313_37329 = state_37306__$1;
(statearr_37313_37329[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37307 === (6))){
var inst_37289 = (state_37306[(8)]);
var inst_37293 = (state_37306[(9)]);
var inst_37286 = (state_37306[(7)]);
var inst_37293__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_37286,inst_37289) : f.call(null,inst_37286,inst_37289));
var inst_37294 = cljs.core.reduced_QMARK_(inst_37293__$1);
var state_37306__$1 = (function (){var statearr_37314 = state_37306;
(statearr_37314[(9)] = inst_37293__$1);

return statearr_37314;
})();
if(inst_37294){
var statearr_37315_37330 = state_37306__$1;
(statearr_37315_37330[(1)] = (8));

} else {
var statearr_37316_37331 = state_37306__$1;
(statearr_37316_37331[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37307 === (3))){
var inst_37304 = (state_37306[(2)]);
var state_37306__$1 = state_37306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37306__$1,inst_37304);
} else {
if((state_val_37307 === (2))){
var state_37306__$1 = state_37306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37306__$1,(4),ch);
} else {
if((state_val_37307 === (9))){
var inst_37293 = (state_37306[(9)]);
var inst_37286 = inst_37293;
var state_37306__$1 = (function (){var statearr_37317 = state_37306;
(statearr_37317[(7)] = inst_37286);

return statearr_37317;
})();
var statearr_37318_37332 = state_37306__$1;
(statearr_37318_37332[(2)] = null);

(statearr_37318_37332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37307 === (5))){
var inst_37286 = (state_37306[(7)]);
var state_37306__$1 = state_37306;
var statearr_37319_37333 = state_37306__$1;
(statearr_37319_37333[(2)] = inst_37286);

(statearr_37319_37333[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37307 === (10))){
var inst_37300 = (state_37306[(2)]);
var state_37306__$1 = state_37306;
var statearr_37320_37334 = state_37306__$1;
(statearr_37320_37334[(2)] = inst_37300);

(statearr_37320_37334[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37307 === (8))){
var inst_37293 = (state_37306[(9)]);
var inst_37296 = cljs.core.deref(inst_37293);
var state_37306__$1 = state_37306;
var statearr_37321_37335 = state_37306__$1;
(statearr_37321_37335[(2)] = inst_37296);

(statearr_37321_37335[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto__))
;
return ((function (switch__36644__auto__,c__36819__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__36645__auto__ = null;
var cljs$core$async$reduce_$_state_machine__36645__auto____0 = (function (){
var statearr_37322 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37322[(0)] = cljs$core$async$reduce_$_state_machine__36645__auto__);

(statearr_37322[(1)] = (1));

return statearr_37322;
});
var cljs$core$async$reduce_$_state_machine__36645__auto____1 = (function (state_37306){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_37306);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e37323){if((e37323 instanceof Object)){
var ex__36648__auto__ = e37323;
var statearr_37324_37336 = state_37306;
(statearr_37324_37336[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37306);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37323;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37337 = state_37306;
state_37306 = G__37337;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__36645__auto__ = function(state_37306){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__36645__auto____1.call(this,state_37306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__36645__auto____0;
cljs$core$async$reduce_$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__36645__auto____1;
return cljs$core$async$reduce_$_state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto__))
})();
var state__36821__auto__ = (function (){var statearr_37325 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_37325[(6)] = c__36819__auto__);

return statearr_37325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto__))
);

return c__36819__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__36819__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto__,f__$1){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto__,f__$1){
return (function (state_37343){
var state_val_37344 = (state_37343[(1)]);
if((state_val_37344 === (1))){
var inst_37338 = cljs.core.async.reduce(f__$1,init,ch);
var state_37343__$1 = state_37343;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37343__$1,(2),inst_37338);
} else {
if((state_val_37344 === (2))){
var inst_37340 = (state_37343[(2)]);
var inst_37341 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_37340) : f__$1.call(null,inst_37340));
var state_37343__$1 = state_37343;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37343__$1,inst_37341);
} else {
return null;
}
}
});})(c__36819__auto__,f__$1))
;
return ((function (switch__36644__auto__,c__36819__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__36645__auto__ = null;
var cljs$core$async$transduce_$_state_machine__36645__auto____0 = (function (){
var statearr_37345 = [null,null,null,null,null,null,null];
(statearr_37345[(0)] = cljs$core$async$transduce_$_state_machine__36645__auto__);

(statearr_37345[(1)] = (1));

return statearr_37345;
});
var cljs$core$async$transduce_$_state_machine__36645__auto____1 = (function (state_37343){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_37343);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e37346){if((e37346 instanceof Object)){
var ex__36648__auto__ = e37346;
var statearr_37347_37349 = state_37343;
(statearr_37347_37349[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37343);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37346;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37350 = state_37343;
state_37343 = G__37350;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__36645__auto__ = function(state_37343){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__36645__auto____1.call(this,state_37343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__36645__auto____0;
cljs$core$async$transduce_$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__36645__auto____1;
return cljs$core$async$transduce_$_state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto__,f__$1))
})();
var state__36821__auto__ = (function (){var statearr_37348 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_37348[(6)] = c__36819__auto__);

return statearr_37348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto__,f__$1))
);

return c__36819__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__37352 = arguments.length;
switch (G__37352) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__36819__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto__){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto__){
return (function (state_37377){
var state_val_37378 = (state_37377[(1)]);
if((state_val_37378 === (7))){
var inst_37359 = (state_37377[(2)]);
var state_37377__$1 = state_37377;
var statearr_37379_37400 = state_37377__$1;
(statearr_37379_37400[(2)] = inst_37359);

(statearr_37379_37400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37378 === (1))){
var inst_37353 = cljs.core.seq(coll);
var inst_37354 = inst_37353;
var state_37377__$1 = (function (){var statearr_37380 = state_37377;
(statearr_37380[(7)] = inst_37354);

return statearr_37380;
})();
var statearr_37381_37401 = state_37377__$1;
(statearr_37381_37401[(2)] = null);

(statearr_37381_37401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37378 === (4))){
var inst_37354 = (state_37377[(7)]);
var inst_37357 = cljs.core.first(inst_37354);
var state_37377__$1 = state_37377;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37377__$1,(7),ch,inst_37357);
} else {
if((state_val_37378 === (13))){
var inst_37371 = (state_37377[(2)]);
var state_37377__$1 = state_37377;
var statearr_37382_37402 = state_37377__$1;
(statearr_37382_37402[(2)] = inst_37371);

(statearr_37382_37402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37378 === (6))){
var inst_37362 = (state_37377[(2)]);
var state_37377__$1 = state_37377;
if(cljs.core.truth_(inst_37362)){
var statearr_37383_37403 = state_37377__$1;
(statearr_37383_37403[(1)] = (8));

} else {
var statearr_37384_37404 = state_37377__$1;
(statearr_37384_37404[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37378 === (3))){
var inst_37375 = (state_37377[(2)]);
var state_37377__$1 = state_37377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37377__$1,inst_37375);
} else {
if((state_val_37378 === (12))){
var state_37377__$1 = state_37377;
var statearr_37385_37405 = state_37377__$1;
(statearr_37385_37405[(2)] = null);

(statearr_37385_37405[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37378 === (2))){
var inst_37354 = (state_37377[(7)]);
var state_37377__$1 = state_37377;
if(cljs.core.truth_(inst_37354)){
var statearr_37386_37406 = state_37377__$1;
(statearr_37386_37406[(1)] = (4));

} else {
var statearr_37387_37407 = state_37377__$1;
(statearr_37387_37407[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37378 === (11))){
var inst_37368 = cljs.core.async.close_BANG_(ch);
var state_37377__$1 = state_37377;
var statearr_37388_37408 = state_37377__$1;
(statearr_37388_37408[(2)] = inst_37368);

(statearr_37388_37408[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37378 === (9))){
var state_37377__$1 = state_37377;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37389_37409 = state_37377__$1;
(statearr_37389_37409[(1)] = (11));

} else {
var statearr_37390_37410 = state_37377__$1;
(statearr_37390_37410[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37378 === (5))){
var inst_37354 = (state_37377[(7)]);
var state_37377__$1 = state_37377;
var statearr_37391_37411 = state_37377__$1;
(statearr_37391_37411[(2)] = inst_37354);

(statearr_37391_37411[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37378 === (10))){
var inst_37373 = (state_37377[(2)]);
var state_37377__$1 = state_37377;
var statearr_37392_37412 = state_37377__$1;
(statearr_37392_37412[(2)] = inst_37373);

(statearr_37392_37412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37378 === (8))){
var inst_37354 = (state_37377[(7)]);
var inst_37364 = cljs.core.next(inst_37354);
var inst_37354__$1 = inst_37364;
var state_37377__$1 = (function (){var statearr_37393 = state_37377;
(statearr_37393[(7)] = inst_37354__$1);

return statearr_37393;
})();
var statearr_37394_37413 = state_37377__$1;
(statearr_37394_37413[(2)] = null);

(statearr_37394_37413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto__))
;
return ((function (switch__36644__auto__,c__36819__auto__){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_37395 = [null,null,null,null,null,null,null,null];
(statearr_37395[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_37395[(1)] = (1));

return statearr_37395;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_37377){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_37377);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e37396){if((e37396 instanceof Object)){
var ex__36648__auto__ = e37396;
var statearr_37397_37414 = state_37377;
(statearr_37397_37414[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37377);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37396;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37415 = state_37377;
state_37377 = G__37415;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_37377){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_37377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto__))
})();
var state__36821__auto__ = (function (){var statearr_37398 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_37398[(6)] = c__36819__auto__);

return statearr_37398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto__))
);

return c__36819__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4230__auto__ = (((_ == null))?null:_);
var m__4231__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4231__auto__.call(null,_));
} else {
var m__4231__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4231__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4230__auto__ = (((m == null))?null:m);
var m__4231__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4231__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4231__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4231__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4230__auto__ = (((m == null))?null:m);
var m__4231__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4231__auto__.call(null,m,ch));
} else {
var m__4231__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4231__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4230__auto__ = (((m == null))?null:m);
var m__4231__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4231__auto__.call(null,m));
} else {
var m__4231__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4231__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37416 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37416 = (function (ch,cs,meta37417){
this.ch = ch;
this.cs = cs;
this.meta37417 = meta37417;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async37416.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_37418,meta37417__$1){
var self__ = this;
var _37418__$1 = this;
return (new cljs.core.async.t_cljs$core$async37416(self__.ch,self__.cs,meta37417__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async37416.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_37418){
var self__ = this;
var _37418__$1 = this;
return self__.meta37417;
});})(cs))
;

cljs.core.async.t_cljs$core$async37416.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37416.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async37416.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37416.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37416.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37416.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37416.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta37417","meta37417",1371267439,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async37416.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37416.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37416";

cljs.core.async.t_cljs$core$async37416.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"cljs.core.async/t_cljs$core$async37416");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37416.
 */
cljs.core.async.__GT_t_cljs$core$async37416 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async37416(ch__$1,cs__$1,meta37417){
return (new cljs.core.async.t_cljs$core$async37416(ch__$1,cs__$1,meta37417));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async37416(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__36819__auto___37638 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___37638,cs,m,dchan,dctr,done){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___37638,cs,m,dchan,dctr,done){
return (function (state_37553){
var state_val_37554 = (state_37553[(1)]);
if((state_val_37554 === (7))){
var inst_37549 = (state_37553[(2)]);
var state_37553__$1 = state_37553;
var statearr_37555_37639 = state_37553__$1;
(statearr_37555_37639[(2)] = inst_37549);

(statearr_37555_37639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (20))){
var inst_37452 = (state_37553[(7)]);
var inst_37464 = cljs.core.first(inst_37452);
var inst_37465 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37464,(0),null);
var inst_37466 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37464,(1),null);
var state_37553__$1 = (function (){var statearr_37556 = state_37553;
(statearr_37556[(8)] = inst_37465);

return statearr_37556;
})();
if(cljs.core.truth_(inst_37466)){
var statearr_37557_37640 = state_37553__$1;
(statearr_37557_37640[(1)] = (22));

} else {
var statearr_37558_37641 = state_37553__$1;
(statearr_37558_37641[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (27))){
var inst_37421 = (state_37553[(9)]);
var inst_37501 = (state_37553[(10)]);
var inst_37496 = (state_37553[(11)]);
var inst_37494 = (state_37553[(12)]);
var inst_37501__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37494,inst_37496);
var inst_37502 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37501__$1,inst_37421,done);
var state_37553__$1 = (function (){var statearr_37559 = state_37553;
(statearr_37559[(10)] = inst_37501__$1);

return statearr_37559;
})();
if(cljs.core.truth_(inst_37502)){
var statearr_37560_37642 = state_37553__$1;
(statearr_37560_37642[(1)] = (30));

} else {
var statearr_37561_37643 = state_37553__$1;
(statearr_37561_37643[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (1))){
var state_37553__$1 = state_37553;
var statearr_37562_37644 = state_37553__$1;
(statearr_37562_37644[(2)] = null);

(statearr_37562_37644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (24))){
var inst_37452 = (state_37553[(7)]);
var inst_37471 = (state_37553[(2)]);
var inst_37472 = cljs.core.next(inst_37452);
var inst_37430 = inst_37472;
var inst_37431 = null;
var inst_37432 = (0);
var inst_37433 = (0);
var state_37553__$1 = (function (){var statearr_37563 = state_37553;
(statearr_37563[(13)] = inst_37431);

(statearr_37563[(14)] = inst_37430);

(statearr_37563[(15)] = inst_37433);

(statearr_37563[(16)] = inst_37432);

(statearr_37563[(17)] = inst_37471);

return statearr_37563;
})();
var statearr_37564_37645 = state_37553__$1;
(statearr_37564_37645[(2)] = null);

(statearr_37564_37645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (39))){
var state_37553__$1 = state_37553;
var statearr_37568_37646 = state_37553__$1;
(statearr_37568_37646[(2)] = null);

(statearr_37568_37646[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (4))){
var inst_37421 = (state_37553[(9)]);
var inst_37421__$1 = (state_37553[(2)]);
var inst_37422 = (inst_37421__$1 == null);
var state_37553__$1 = (function (){var statearr_37569 = state_37553;
(statearr_37569[(9)] = inst_37421__$1);

return statearr_37569;
})();
if(cljs.core.truth_(inst_37422)){
var statearr_37570_37647 = state_37553__$1;
(statearr_37570_37647[(1)] = (5));

} else {
var statearr_37571_37648 = state_37553__$1;
(statearr_37571_37648[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (15))){
var inst_37431 = (state_37553[(13)]);
var inst_37430 = (state_37553[(14)]);
var inst_37433 = (state_37553[(15)]);
var inst_37432 = (state_37553[(16)]);
var inst_37448 = (state_37553[(2)]);
var inst_37449 = (inst_37433 + (1));
var tmp37565 = inst_37431;
var tmp37566 = inst_37430;
var tmp37567 = inst_37432;
var inst_37430__$1 = tmp37566;
var inst_37431__$1 = tmp37565;
var inst_37432__$1 = tmp37567;
var inst_37433__$1 = inst_37449;
var state_37553__$1 = (function (){var statearr_37572 = state_37553;
(statearr_37572[(13)] = inst_37431__$1);

(statearr_37572[(14)] = inst_37430__$1);

(statearr_37572[(18)] = inst_37448);

(statearr_37572[(15)] = inst_37433__$1);

(statearr_37572[(16)] = inst_37432__$1);

return statearr_37572;
})();
var statearr_37573_37649 = state_37553__$1;
(statearr_37573_37649[(2)] = null);

(statearr_37573_37649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (21))){
var inst_37475 = (state_37553[(2)]);
var state_37553__$1 = state_37553;
var statearr_37577_37650 = state_37553__$1;
(statearr_37577_37650[(2)] = inst_37475);

(statearr_37577_37650[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (31))){
var inst_37501 = (state_37553[(10)]);
var inst_37505 = done(null);
var inst_37506 = cljs.core.async.untap_STAR_(m,inst_37501);
var state_37553__$1 = (function (){var statearr_37578 = state_37553;
(statearr_37578[(19)] = inst_37505);

return statearr_37578;
})();
var statearr_37579_37651 = state_37553__$1;
(statearr_37579_37651[(2)] = inst_37506);

(statearr_37579_37651[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (32))){
var inst_37495 = (state_37553[(20)]);
var inst_37496 = (state_37553[(11)]);
var inst_37493 = (state_37553[(21)]);
var inst_37494 = (state_37553[(12)]);
var inst_37508 = (state_37553[(2)]);
var inst_37509 = (inst_37496 + (1));
var tmp37574 = inst_37495;
var tmp37575 = inst_37493;
var tmp37576 = inst_37494;
var inst_37493__$1 = tmp37575;
var inst_37494__$1 = tmp37576;
var inst_37495__$1 = tmp37574;
var inst_37496__$1 = inst_37509;
var state_37553__$1 = (function (){var statearr_37580 = state_37553;
(statearr_37580[(20)] = inst_37495__$1);

(statearr_37580[(22)] = inst_37508);

(statearr_37580[(11)] = inst_37496__$1);

(statearr_37580[(21)] = inst_37493__$1);

(statearr_37580[(12)] = inst_37494__$1);

return statearr_37580;
})();
var statearr_37581_37652 = state_37553__$1;
(statearr_37581_37652[(2)] = null);

(statearr_37581_37652[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (40))){
var inst_37521 = (state_37553[(23)]);
var inst_37525 = done(null);
var inst_37526 = cljs.core.async.untap_STAR_(m,inst_37521);
var state_37553__$1 = (function (){var statearr_37582 = state_37553;
(statearr_37582[(24)] = inst_37525);

return statearr_37582;
})();
var statearr_37583_37653 = state_37553__$1;
(statearr_37583_37653[(2)] = inst_37526);

(statearr_37583_37653[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (33))){
var inst_37512 = (state_37553[(25)]);
var inst_37514 = cljs.core.chunked_seq_QMARK_(inst_37512);
var state_37553__$1 = state_37553;
if(inst_37514){
var statearr_37584_37654 = state_37553__$1;
(statearr_37584_37654[(1)] = (36));

} else {
var statearr_37585_37655 = state_37553__$1;
(statearr_37585_37655[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (13))){
var inst_37442 = (state_37553[(26)]);
var inst_37445 = cljs.core.async.close_BANG_(inst_37442);
var state_37553__$1 = state_37553;
var statearr_37586_37656 = state_37553__$1;
(statearr_37586_37656[(2)] = inst_37445);

(statearr_37586_37656[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (22))){
var inst_37465 = (state_37553[(8)]);
var inst_37468 = cljs.core.async.close_BANG_(inst_37465);
var state_37553__$1 = state_37553;
var statearr_37587_37657 = state_37553__$1;
(statearr_37587_37657[(2)] = inst_37468);

(statearr_37587_37657[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (36))){
var inst_37512 = (state_37553[(25)]);
var inst_37516 = cljs.core.chunk_first(inst_37512);
var inst_37517 = cljs.core.chunk_rest(inst_37512);
var inst_37518 = cljs.core.count(inst_37516);
var inst_37493 = inst_37517;
var inst_37494 = inst_37516;
var inst_37495 = inst_37518;
var inst_37496 = (0);
var state_37553__$1 = (function (){var statearr_37588 = state_37553;
(statearr_37588[(20)] = inst_37495);

(statearr_37588[(11)] = inst_37496);

(statearr_37588[(21)] = inst_37493);

(statearr_37588[(12)] = inst_37494);

return statearr_37588;
})();
var statearr_37589_37658 = state_37553__$1;
(statearr_37589_37658[(2)] = null);

(statearr_37589_37658[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (41))){
var inst_37512 = (state_37553[(25)]);
var inst_37528 = (state_37553[(2)]);
var inst_37529 = cljs.core.next(inst_37512);
var inst_37493 = inst_37529;
var inst_37494 = null;
var inst_37495 = (0);
var inst_37496 = (0);
var state_37553__$1 = (function (){var statearr_37590 = state_37553;
(statearr_37590[(20)] = inst_37495);

(statearr_37590[(11)] = inst_37496);

(statearr_37590[(21)] = inst_37493);

(statearr_37590[(27)] = inst_37528);

(statearr_37590[(12)] = inst_37494);

return statearr_37590;
})();
var statearr_37591_37659 = state_37553__$1;
(statearr_37591_37659[(2)] = null);

(statearr_37591_37659[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (43))){
var state_37553__$1 = state_37553;
var statearr_37592_37660 = state_37553__$1;
(statearr_37592_37660[(2)] = null);

(statearr_37592_37660[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (29))){
var inst_37537 = (state_37553[(2)]);
var state_37553__$1 = state_37553;
var statearr_37593_37661 = state_37553__$1;
(statearr_37593_37661[(2)] = inst_37537);

(statearr_37593_37661[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (44))){
var inst_37546 = (state_37553[(2)]);
var state_37553__$1 = (function (){var statearr_37594 = state_37553;
(statearr_37594[(28)] = inst_37546);

return statearr_37594;
})();
var statearr_37595_37662 = state_37553__$1;
(statearr_37595_37662[(2)] = null);

(statearr_37595_37662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (6))){
var inst_37485 = (state_37553[(29)]);
var inst_37484 = cljs.core.deref(cs);
var inst_37485__$1 = cljs.core.keys(inst_37484);
var inst_37486 = cljs.core.count(inst_37485__$1);
var inst_37487 = cljs.core.reset_BANG_(dctr,inst_37486);
var inst_37492 = cljs.core.seq(inst_37485__$1);
var inst_37493 = inst_37492;
var inst_37494 = null;
var inst_37495 = (0);
var inst_37496 = (0);
var state_37553__$1 = (function (){var statearr_37596 = state_37553;
(statearr_37596[(20)] = inst_37495);

(statearr_37596[(29)] = inst_37485__$1);

(statearr_37596[(11)] = inst_37496);

(statearr_37596[(30)] = inst_37487);

(statearr_37596[(21)] = inst_37493);

(statearr_37596[(12)] = inst_37494);

return statearr_37596;
})();
var statearr_37597_37663 = state_37553__$1;
(statearr_37597_37663[(2)] = null);

(statearr_37597_37663[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (28))){
var inst_37512 = (state_37553[(25)]);
var inst_37493 = (state_37553[(21)]);
var inst_37512__$1 = cljs.core.seq(inst_37493);
var state_37553__$1 = (function (){var statearr_37598 = state_37553;
(statearr_37598[(25)] = inst_37512__$1);

return statearr_37598;
})();
if(inst_37512__$1){
var statearr_37599_37664 = state_37553__$1;
(statearr_37599_37664[(1)] = (33));

} else {
var statearr_37600_37665 = state_37553__$1;
(statearr_37600_37665[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (25))){
var inst_37495 = (state_37553[(20)]);
var inst_37496 = (state_37553[(11)]);
var inst_37498 = (inst_37496 < inst_37495);
var inst_37499 = inst_37498;
var state_37553__$1 = state_37553;
if(cljs.core.truth_(inst_37499)){
var statearr_37601_37666 = state_37553__$1;
(statearr_37601_37666[(1)] = (27));

} else {
var statearr_37602_37667 = state_37553__$1;
(statearr_37602_37667[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (34))){
var state_37553__$1 = state_37553;
var statearr_37603_37668 = state_37553__$1;
(statearr_37603_37668[(2)] = null);

(statearr_37603_37668[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (17))){
var state_37553__$1 = state_37553;
var statearr_37604_37669 = state_37553__$1;
(statearr_37604_37669[(2)] = null);

(statearr_37604_37669[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (3))){
var inst_37551 = (state_37553[(2)]);
var state_37553__$1 = state_37553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37553__$1,inst_37551);
} else {
if((state_val_37554 === (12))){
var inst_37480 = (state_37553[(2)]);
var state_37553__$1 = state_37553;
var statearr_37605_37670 = state_37553__$1;
(statearr_37605_37670[(2)] = inst_37480);

(statearr_37605_37670[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (2))){
var state_37553__$1 = state_37553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37553__$1,(4),ch);
} else {
if((state_val_37554 === (23))){
var state_37553__$1 = state_37553;
var statearr_37606_37671 = state_37553__$1;
(statearr_37606_37671[(2)] = null);

(statearr_37606_37671[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (35))){
var inst_37535 = (state_37553[(2)]);
var state_37553__$1 = state_37553;
var statearr_37607_37672 = state_37553__$1;
(statearr_37607_37672[(2)] = inst_37535);

(statearr_37607_37672[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (19))){
var inst_37452 = (state_37553[(7)]);
var inst_37456 = cljs.core.chunk_first(inst_37452);
var inst_37457 = cljs.core.chunk_rest(inst_37452);
var inst_37458 = cljs.core.count(inst_37456);
var inst_37430 = inst_37457;
var inst_37431 = inst_37456;
var inst_37432 = inst_37458;
var inst_37433 = (0);
var state_37553__$1 = (function (){var statearr_37608 = state_37553;
(statearr_37608[(13)] = inst_37431);

(statearr_37608[(14)] = inst_37430);

(statearr_37608[(15)] = inst_37433);

(statearr_37608[(16)] = inst_37432);

return statearr_37608;
})();
var statearr_37609_37673 = state_37553__$1;
(statearr_37609_37673[(2)] = null);

(statearr_37609_37673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (11))){
var inst_37430 = (state_37553[(14)]);
var inst_37452 = (state_37553[(7)]);
var inst_37452__$1 = cljs.core.seq(inst_37430);
var state_37553__$1 = (function (){var statearr_37610 = state_37553;
(statearr_37610[(7)] = inst_37452__$1);

return statearr_37610;
})();
if(inst_37452__$1){
var statearr_37611_37674 = state_37553__$1;
(statearr_37611_37674[(1)] = (16));

} else {
var statearr_37612_37675 = state_37553__$1;
(statearr_37612_37675[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (9))){
var inst_37482 = (state_37553[(2)]);
var state_37553__$1 = state_37553;
var statearr_37613_37676 = state_37553__$1;
(statearr_37613_37676[(2)] = inst_37482);

(statearr_37613_37676[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (5))){
var inst_37428 = cljs.core.deref(cs);
var inst_37429 = cljs.core.seq(inst_37428);
var inst_37430 = inst_37429;
var inst_37431 = null;
var inst_37432 = (0);
var inst_37433 = (0);
var state_37553__$1 = (function (){var statearr_37614 = state_37553;
(statearr_37614[(13)] = inst_37431);

(statearr_37614[(14)] = inst_37430);

(statearr_37614[(15)] = inst_37433);

(statearr_37614[(16)] = inst_37432);

return statearr_37614;
})();
var statearr_37615_37677 = state_37553__$1;
(statearr_37615_37677[(2)] = null);

(statearr_37615_37677[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (14))){
var state_37553__$1 = state_37553;
var statearr_37616_37678 = state_37553__$1;
(statearr_37616_37678[(2)] = null);

(statearr_37616_37678[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (45))){
var inst_37543 = (state_37553[(2)]);
var state_37553__$1 = state_37553;
var statearr_37617_37679 = state_37553__$1;
(statearr_37617_37679[(2)] = inst_37543);

(statearr_37617_37679[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (26))){
var inst_37485 = (state_37553[(29)]);
var inst_37539 = (state_37553[(2)]);
var inst_37540 = cljs.core.seq(inst_37485);
var state_37553__$1 = (function (){var statearr_37618 = state_37553;
(statearr_37618[(31)] = inst_37539);

return statearr_37618;
})();
if(inst_37540){
var statearr_37619_37680 = state_37553__$1;
(statearr_37619_37680[(1)] = (42));

} else {
var statearr_37620_37681 = state_37553__$1;
(statearr_37620_37681[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (16))){
var inst_37452 = (state_37553[(7)]);
var inst_37454 = cljs.core.chunked_seq_QMARK_(inst_37452);
var state_37553__$1 = state_37553;
if(inst_37454){
var statearr_37621_37682 = state_37553__$1;
(statearr_37621_37682[(1)] = (19));

} else {
var statearr_37622_37683 = state_37553__$1;
(statearr_37622_37683[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (38))){
var inst_37532 = (state_37553[(2)]);
var state_37553__$1 = state_37553;
var statearr_37623_37684 = state_37553__$1;
(statearr_37623_37684[(2)] = inst_37532);

(statearr_37623_37684[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (30))){
var state_37553__$1 = state_37553;
var statearr_37624_37685 = state_37553__$1;
(statearr_37624_37685[(2)] = null);

(statearr_37624_37685[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (10))){
var inst_37431 = (state_37553[(13)]);
var inst_37433 = (state_37553[(15)]);
var inst_37441 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37431,inst_37433);
var inst_37442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37441,(0),null);
var inst_37443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37441,(1),null);
var state_37553__$1 = (function (){var statearr_37625 = state_37553;
(statearr_37625[(26)] = inst_37442);

return statearr_37625;
})();
if(cljs.core.truth_(inst_37443)){
var statearr_37626_37686 = state_37553__$1;
(statearr_37626_37686[(1)] = (13));

} else {
var statearr_37627_37687 = state_37553__$1;
(statearr_37627_37687[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (18))){
var inst_37478 = (state_37553[(2)]);
var state_37553__$1 = state_37553;
var statearr_37628_37688 = state_37553__$1;
(statearr_37628_37688[(2)] = inst_37478);

(statearr_37628_37688[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (42))){
var state_37553__$1 = state_37553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37553__$1,(45),dchan);
} else {
if((state_val_37554 === (37))){
var inst_37421 = (state_37553[(9)]);
var inst_37512 = (state_37553[(25)]);
var inst_37521 = (state_37553[(23)]);
var inst_37521__$1 = cljs.core.first(inst_37512);
var inst_37522 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37521__$1,inst_37421,done);
var state_37553__$1 = (function (){var statearr_37629 = state_37553;
(statearr_37629[(23)] = inst_37521__$1);

return statearr_37629;
})();
if(cljs.core.truth_(inst_37522)){
var statearr_37630_37689 = state_37553__$1;
(statearr_37630_37689[(1)] = (39));

} else {
var statearr_37631_37690 = state_37553__$1;
(statearr_37631_37690[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37554 === (8))){
var inst_37433 = (state_37553[(15)]);
var inst_37432 = (state_37553[(16)]);
var inst_37435 = (inst_37433 < inst_37432);
var inst_37436 = inst_37435;
var state_37553__$1 = state_37553;
if(cljs.core.truth_(inst_37436)){
var statearr_37632_37691 = state_37553__$1;
(statearr_37632_37691[(1)] = (10));

} else {
var statearr_37633_37692 = state_37553__$1;
(statearr_37633_37692[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___37638,cs,m,dchan,dctr,done))
;
return ((function (switch__36644__auto__,c__36819__auto___37638,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__36645__auto__ = null;
var cljs$core$async$mult_$_state_machine__36645__auto____0 = (function (){
var statearr_37634 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37634[(0)] = cljs$core$async$mult_$_state_machine__36645__auto__);

(statearr_37634[(1)] = (1));

return statearr_37634;
});
var cljs$core$async$mult_$_state_machine__36645__auto____1 = (function (state_37553){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_37553);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e37635){if((e37635 instanceof Object)){
var ex__36648__auto__ = e37635;
var statearr_37636_37693 = state_37553;
(statearr_37636_37693[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37553);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37635;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37694 = state_37553;
state_37553 = G__37694;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__36645__auto__ = function(state_37553){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__36645__auto____1.call(this,state_37553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__36645__auto____0;
cljs$core$async$mult_$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__36645__auto____1;
return cljs$core$async$mult_$_state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___37638,cs,m,dchan,dctr,done))
})();
var state__36821__auto__ = (function (){var statearr_37637 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_37637[(6)] = c__36819__auto___37638);

return statearr_37637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___37638,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__37696 = arguments.length;
switch (G__37696) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4230__auto__ = (((m == null))?null:m);
var m__4231__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4231__auto__.call(null,m,ch));
} else {
var m__4231__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4231__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4230__auto__ = (((m == null))?null:m);
var m__4231__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4231__auto__.call(null,m,ch));
} else {
var m__4231__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4231__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4230__auto__ = (((m == null))?null:m);
var m__4231__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4231__auto__.call(null,m));
} else {
var m__4231__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4231__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4230__auto__ = (((m == null))?null:m);
var m__4231__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4231__auto__.call(null,m,state_map));
} else {
var m__4231__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4231__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4230__auto__ = (((m == null))?null:m);
var m__4231__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4231__auto__.call(null,m,mode));
} else {
var m__4231__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4231__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4521__auto__ = [];
var len__4518__auto___37708 = arguments.length;
var i__4519__auto___37709 = (0);
while(true){
if((i__4519__auto___37709 < len__4518__auto___37708)){
args__4521__auto__.push((arguments[i__4519__auto___37709]));

var G__37710 = (i__4519__auto___37709 + (1));
i__4519__auto___37709 = G__37710;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((3) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4522__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__37702){
var map__37703 = p__37702;
var map__37703__$1 = ((((!((map__37703 == null)))?(((((map__37703.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37703.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37703):map__37703);
var opts = map__37703__$1;
var statearr_37705_37711 = state;
(statearr_37705_37711[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__37703,map__37703__$1,opts){
return (function (val){
var statearr_37706_37712 = state;
(statearr_37706_37712[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__37703,map__37703__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_37707_37713 = state;
(statearr_37707_37713[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq37698){
var G__37699 = cljs.core.first(seq37698);
var seq37698__$1 = cljs.core.next(seq37698);
var G__37700 = cljs.core.first(seq37698__$1);
var seq37698__$2 = cljs.core.next(seq37698__$1);
var G__37701 = cljs.core.first(seq37698__$2);
var seq37698__$3 = cljs.core.next(seq37698__$2);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37699,G__37700,G__37701,seq37698__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_(solos)))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37714 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37714 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta37715){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta37715 = meta37715;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async37714.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37716,meta37715__$1){
var self__ = this;
var _37716__$1 = this;
return (new cljs.core.async.t_cljs$core$async37714(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta37715__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37714.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37716){
var self__ = this;
var _37716__$1 = this;
return self__.meta37715;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37714.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37714.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37714.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37714.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37714.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37714.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37714.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37714.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37714.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta37715","meta37715",-1290146726,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37714.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37714.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37714";

cljs.core.async.t_cljs$core$async37714.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"cljs.core.async/t_cljs$core$async37714");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37714.
 */
cljs.core.async.__GT_t_cljs$core$async37714 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async37714(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta37715){
return (new cljs.core.async.t_cljs$core$async37714(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta37715));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async37714(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__36819__auto___37878 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___37878,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___37878,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_37818){
var state_val_37819 = (state_37818[(1)]);
if((state_val_37819 === (7))){
var inst_37733 = (state_37818[(2)]);
var state_37818__$1 = state_37818;
var statearr_37820_37879 = state_37818__$1;
(statearr_37820_37879[(2)] = inst_37733);

(statearr_37820_37879[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (20))){
var inst_37745 = (state_37818[(7)]);
var state_37818__$1 = state_37818;
var statearr_37821_37880 = state_37818__$1;
(statearr_37821_37880[(2)] = inst_37745);

(statearr_37821_37880[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (27))){
var state_37818__$1 = state_37818;
var statearr_37822_37881 = state_37818__$1;
(statearr_37822_37881[(2)] = null);

(statearr_37822_37881[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (1))){
var inst_37720 = (state_37818[(8)]);
var inst_37720__$1 = calc_state();
var inst_37722 = (inst_37720__$1 == null);
var inst_37723 = cljs.core.not(inst_37722);
var state_37818__$1 = (function (){var statearr_37823 = state_37818;
(statearr_37823[(8)] = inst_37720__$1);

return statearr_37823;
})();
if(inst_37723){
var statearr_37824_37882 = state_37818__$1;
(statearr_37824_37882[(1)] = (2));

} else {
var statearr_37825_37883 = state_37818__$1;
(statearr_37825_37883[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (24))){
var inst_37778 = (state_37818[(9)]);
var inst_37769 = (state_37818[(10)]);
var inst_37792 = (state_37818[(11)]);
var inst_37792__$1 = (inst_37769.cljs$core$IFn$_invoke$arity$1 ? inst_37769.cljs$core$IFn$_invoke$arity$1(inst_37778) : inst_37769.call(null,inst_37778));
var state_37818__$1 = (function (){var statearr_37826 = state_37818;
(statearr_37826[(11)] = inst_37792__$1);

return statearr_37826;
})();
if(cljs.core.truth_(inst_37792__$1)){
var statearr_37827_37884 = state_37818__$1;
(statearr_37827_37884[(1)] = (29));

} else {
var statearr_37828_37885 = state_37818__$1;
(statearr_37828_37885[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (4))){
var inst_37736 = (state_37818[(2)]);
var state_37818__$1 = state_37818;
if(cljs.core.truth_(inst_37736)){
var statearr_37829_37886 = state_37818__$1;
(statearr_37829_37886[(1)] = (8));

} else {
var statearr_37830_37887 = state_37818__$1;
(statearr_37830_37887[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (15))){
var inst_37763 = (state_37818[(2)]);
var state_37818__$1 = state_37818;
if(cljs.core.truth_(inst_37763)){
var statearr_37831_37888 = state_37818__$1;
(statearr_37831_37888[(1)] = (19));

} else {
var statearr_37832_37889 = state_37818__$1;
(statearr_37832_37889[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (21))){
var inst_37768 = (state_37818[(12)]);
var inst_37768__$1 = (state_37818[(2)]);
var inst_37769 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37768__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_37770 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37768__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_37771 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37768__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_37818__$1 = (function (){var statearr_37833 = state_37818;
(statearr_37833[(13)] = inst_37770);

(statearr_37833[(10)] = inst_37769);

(statearr_37833[(12)] = inst_37768__$1);

return statearr_37833;
})();
return cljs.core.async.ioc_alts_BANG_(state_37818__$1,(22),inst_37771);
} else {
if((state_val_37819 === (31))){
var inst_37800 = (state_37818[(2)]);
var state_37818__$1 = state_37818;
if(cljs.core.truth_(inst_37800)){
var statearr_37834_37890 = state_37818__$1;
(statearr_37834_37890[(1)] = (32));

} else {
var statearr_37835_37891 = state_37818__$1;
(statearr_37835_37891[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (32))){
var inst_37777 = (state_37818[(14)]);
var state_37818__$1 = state_37818;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37818__$1,(35),out,inst_37777);
} else {
if((state_val_37819 === (33))){
var inst_37768 = (state_37818[(12)]);
var inst_37745 = inst_37768;
var state_37818__$1 = (function (){var statearr_37836 = state_37818;
(statearr_37836[(7)] = inst_37745);

return statearr_37836;
})();
var statearr_37837_37892 = state_37818__$1;
(statearr_37837_37892[(2)] = null);

(statearr_37837_37892[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (13))){
var inst_37745 = (state_37818[(7)]);
var inst_37752 = inst_37745.cljs$lang$protocol_mask$partition0$;
var inst_37753 = (inst_37752 & (64));
var inst_37754 = inst_37745.cljs$core$ISeq$;
var inst_37755 = (cljs.core.PROTOCOL_SENTINEL === inst_37754);
var inst_37756 = ((inst_37753) || (inst_37755));
var state_37818__$1 = state_37818;
if(cljs.core.truth_(inst_37756)){
var statearr_37838_37893 = state_37818__$1;
(statearr_37838_37893[(1)] = (16));

} else {
var statearr_37839_37894 = state_37818__$1;
(statearr_37839_37894[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (22))){
var inst_37778 = (state_37818[(9)]);
var inst_37777 = (state_37818[(14)]);
var inst_37776 = (state_37818[(2)]);
var inst_37777__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37776,(0),null);
var inst_37778__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37776,(1),null);
var inst_37779 = (inst_37777__$1 == null);
var inst_37780 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37778__$1,change);
var inst_37781 = ((inst_37779) || (inst_37780));
var state_37818__$1 = (function (){var statearr_37840 = state_37818;
(statearr_37840[(9)] = inst_37778__$1);

(statearr_37840[(14)] = inst_37777__$1);

return statearr_37840;
})();
if(cljs.core.truth_(inst_37781)){
var statearr_37841_37895 = state_37818__$1;
(statearr_37841_37895[(1)] = (23));

} else {
var statearr_37842_37896 = state_37818__$1;
(statearr_37842_37896[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (36))){
var inst_37768 = (state_37818[(12)]);
var inst_37745 = inst_37768;
var state_37818__$1 = (function (){var statearr_37843 = state_37818;
(statearr_37843[(7)] = inst_37745);

return statearr_37843;
})();
var statearr_37844_37897 = state_37818__$1;
(statearr_37844_37897[(2)] = null);

(statearr_37844_37897[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (29))){
var inst_37792 = (state_37818[(11)]);
var state_37818__$1 = state_37818;
var statearr_37845_37898 = state_37818__$1;
(statearr_37845_37898[(2)] = inst_37792);

(statearr_37845_37898[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (6))){
var state_37818__$1 = state_37818;
var statearr_37846_37899 = state_37818__$1;
(statearr_37846_37899[(2)] = false);

(statearr_37846_37899[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (28))){
var inst_37788 = (state_37818[(2)]);
var inst_37789 = calc_state();
var inst_37745 = inst_37789;
var state_37818__$1 = (function (){var statearr_37847 = state_37818;
(statearr_37847[(15)] = inst_37788);

(statearr_37847[(7)] = inst_37745);

return statearr_37847;
})();
var statearr_37848_37900 = state_37818__$1;
(statearr_37848_37900[(2)] = null);

(statearr_37848_37900[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (25))){
var inst_37814 = (state_37818[(2)]);
var state_37818__$1 = state_37818;
var statearr_37849_37901 = state_37818__$1;
(statearr_37849_37901[(2)] = inst_37814);

(statearr_37849_37901[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (34))){
var inst_37812 = (state_37818[(2)]);
var state_37818__$1 = state_37818;
var statearr_37850_37902 = state_37818__$1;
(statearr_37850_37902[(2)] = inst_37812);

(statearr_37850_37902[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (17))){
var state_37818__$1 = state_37818;
var statearr_37851_37903 = state_37818__$1;
(statearr_37851_37903[(2)] = false);

(statearr_37851_37903[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (3))){
var state_37818__$1 = state_37818;
var statearr_37852_37904 = state_37818__$1;
(statearr_37852_37904[(2)] = false);

(statearr_37852_37904[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (12))){
var inst_37816 = (state_37818[(2)]);
var state_37818__$1 = state_37818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37818__$1,inst_37816);
} else {
if((state_val_37819 === (2))){
var inst_37720 = (state_37818[(8)]);
var inst_37725 = inst_37720.cljs$lang$protocol_mask$partition0$;
var inst_37726 = (inst_37725 & (64));
var inst_37727 = inst_37720.cljs$core$ISeq$;
var inst_37728 = (cljs.core.PROTOCOL_SENTINEL === inst_37727);
var inst_37729 = ((inst_37726) || (inst_37728));
var state_37818__$1 = state_37818;
if(cljs.core.truth_(inst_37729)){
var statearr_37853_37905 = state_37818__$1;
(statearr_37853_37905[(1)] = (5));

} else {
var statearr_37854_37906 = state_37818__$1;
(statearr_37854_37906[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (23))){
var inst_37777 = (state_37818[(14)]);
var inst_37783 = (inst_37777 == null);
var state_37818__$1 = state_37818;
if(cljs.core.truth_(inst_37783)){
var statearr_37855_37907 = state_37818__$1;
(statearr_37855_37907[(1)] = (26));

} else {
var statearr_37856_37908 = state_37818__$1;
(statearr_37856_37908[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (35))){
var inst_37803 = (state_37818[(2)]);
var state_37818__$1 = state_37818;
if(cljs.core.truth_(inst_37803)){
var statearr_37857_37909 = state_37818__$1;
(statearr_37857_37909[(1)] = (36));

} else {
var statearr_37858_37910 = state_37818__$1;
(statearr_37858_37910[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (19))){
var inst_37745 = (state_37818[(7)]);
var inst_37765 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37745);
var state_37818__$1 = state_37818;
var statearr_37859_37911 = state_37818__$1;
(statearr_37859_37911[(2)] = inst_37765);

(statearr_37859_37911[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (11))){
var inst_37745 = (state_37818[(7)]);
var inst_37749 = (inst_37745 == null);
var inst_37750 = cljs.core.not(inst_37749);
var state_37818__$1 = state_37818;
if(inst_37750){
var statearr_37860_37912 = state_37818__$1;
(statearr_37860_37912[(1)] = (13));

} else {
var statearr_37861_37913 = state_37818__$1;
(statearr_37861_37913[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (9))){
var inst_37720 = (state_37818[(8)]);
var state_37818__$1 = state_37818;
var statearr_37862_37914 = state_37818__$1;
(statearr_37862_37914[(2)] = inst_37720);

(statearr_37862_37914[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (5))){
var state_37818__$1 = state_37818;
var statearr_37863_37915 = state_37818__$1;
(statearr_37863_37915[(2)] = true);

(statearr_37863_37915[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (14))){
var state_37818__$1 = state_37818;
var statearr_37864_37916 = state_37818__$1;
(statearr_37864_37916[(2)] = false);

(statearr_37864_37916[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (26))){
var inst_37778 = (state_37818[(9)]);
var inst_37785 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_37778);
var state_37818__$1 = state_37818;
var statearr_37865_37917 = state_37818__$1;
(statearr_37865_37917[(2)] = inst_37785);

(statearr_37865_37917[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (16))){
var state_37818__$1 = state_37818;
var statearr_37866_37918 = state_37818__$1;
(statearr_37866_37918[(2)] = true);

(statearr_37866_37918[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (38))){
var inst_37808 = (state_37818[(2)]);
var state_37818__$1 = state_37818;
var statearr_37867_37919 = state_37818__$1;
(statearr_37867_37919[(2)] = inst_37808);

(statearr_37867_37919[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (30))){
var inst_37778 = (state_37818[(9)]);
var inst_37770 = (state_37818[(13)]);
var inst_37769 = (state_37818[(10)]);
var inst_37795 = cljs.core.empty_QMARK_(inst_37769);
var inst_37796 = (inst_37770.cljs$core$IFn$_invoke$arity$1 ? inst_37770.cljs$core$IFn$_invoke$arity$1(inst_37778) : inst_37770.call(null,inst_37778));
var inst_37797 = cljs.core.not(inst_37796);
var inst_37798 = ((inst_37795) && (inst_37797));
var state_37818__$1 = state_37818;
var statearr_37868_37920 = state_37818__$1;
(statearr_37868_37920[(2)] = inst_37798);

(statearr_37868_37920[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (10))){
var inst_37720 = (state_37818[(8)]);
var inst_37741 = (state_37818[(2)]);
var inst_37742 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37741,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_37743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37741,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_37744 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37741,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_37745 = inst_37720;
var state_37818__$1 = (function (){var statearr_37869 = state_37818;
(statearr_37869[(16)] = inst_37742);

(statearr_37869[(17)] = inst_37743);

(statearr_37869[(18)] = inst_37744);

(statearr_37869[(7)] = inst_37745);

return statearr_37869;
})();
var statearr_37870_37921 = state_37818__$1;
(statearr_37870_37921[(2)] = null);

(statearr_37870_37921[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (18))){
var inst_37760 = (state_37818[(2)]);
var state_37818__$1 = state_37818;
var statearr_37871_37922 = state_37818__$1;
(statearr_37871_37922[(2)] = inst_37760);

(statearr_37871_37922[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (37))){
var state_37818__$1 = state_37818;
var statearr_37872_37923 = state_37818__$1;
(statearr_37872_37923[(2)] = null);

(statearr_37872_37923[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37819 === (8))){
var inst_37720 = (state_37818[(8)]);
var inst_37738 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37720);
var state_37818__$1 = state_37818;
var statearr_37873_37924 = state_37818__$1;
(statearr_37873_37924[(2)] = inst_37738);

(statearr_37873_37924[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___37878,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__36644__auto__,c__36819__auto___37878,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__36645__auto__ = null;
var cljs$core$async$mix_$_state_machine__36645__auto____0 = (function (){
var statearr_37874 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37874[(0)] = cljs$core$async$mix_$_state_machine__36645__auto__);

(statearr_37874[(1)] = (1));

return statearr_37874;
});
var cljs$core$async$mix_$_state_machine__36645__auto____1 = (function (state_37818){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_37818);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e37875){if((e37875 instanceof Object)){
var ex__36648__auto__ = e37875;
var statearr_37876_37925 = state_37818;
(statearr_37876_37925[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37818);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37875;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37926 = state_37818;
state_37818 = G__37926;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__36645__auto__ = function(state_37818){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__36645__auto____1.call(this,state_37818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__36645__auto____0;
cljs$core$async$mix_$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__36645__auto____1;
return cljs$core$async$mix_$_state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___37878,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__36821__auto__ = (function (){var statearr_37877 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_37877[(6)] = c__36819__auto___37878);

return statearr_37877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___37878,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4230__auto__ = (((p == null))?null:p);
var m__4231__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4231__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4231__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4231__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4230__auto__ = (((p == null))?null:p);
var m__4231__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4231__auto__.call(null,p,v,ch));
} else {
var m__4231__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4231__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__37928 = arguments.length;
switch (G__37928) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4230__auto__ = (((p == null))?null:p);
var m__4231__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4231__auto__.call(null,p));
} else {
var m__4231__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__4231__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4230__auto__ = (((p == null))?null:p);
var m__4231__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4230__auto__)]);
if(!((m__4231__auto__ == null))){
return (m__4231__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4231__auto__.call(null,p,v));
} else {
var m__4231__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4231__auto____$1 == null))){
return (m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4231__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__4231__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__37932 = arguments.length;
switch (G__37932) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3936__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__3936__auto__,mults){
return (function (p1__37930_SHARP_){
if(cljs.core.truth_((p1__37930_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__37930_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__37930_SHARP_.call(null,topic)))){
return p1__37930_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__37930_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__3936__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37933 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37933 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta37934){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta37934 = meta37934;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async37933.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_37935,meta37934__$1){
var self__ = this;
var _37935__$1 = this;
return (new cljs.core.async.t_cljs$core$async37933(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta37934__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37933.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_37935){
var self__ = this;
var _37935__$1 = this;
return self__.meta37934;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37933.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37933.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37933.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37933.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37933.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37933.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37933.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37933.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta37934","meta37934",-1630352297,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37933.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37933.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37933";

cljs.core.async.t_cljs$core$async37933.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"cljs.core.async/t_cljs$core$async37933");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37933.
 */
cljs.core.async.__GT_t_cljs$core$async37933 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async37933(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37934){
return (new cljs.core.async.t_cljs$core$async37933(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37934));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async37933(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__36819__auto___38053 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___38053,mults,ensure_mult,p){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___38053,mults,ensure_mult,p){
return (function (state_38007){
var state_val_38008 = (state_38007[(1)]);
if((state_val_38008 === (7))){
var inst_38003 = (state_38007[(2)]);
var state_38007__$1 = state_38007;
var statearr_38009_38054 = state_38007__$1;
(statearr_38009_38054[(2)] = inst_38003);

(statearr_38009_38054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (20))){
var state_38007__$1 = state_38007;
var statearr_38010_38055 = state_38007__$1;
(statearr_38010_38055[(2)] = null);

(statearr_38010_38055[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (1))){
var state_38007__$1 = state_38007;
var statearr_38011_38056 = state_38007__$1;
(statearr_38011_38056[(2)] = null);

(statearr_38011_38056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (24))){
var inst_37986 = (state_38007[(7)]);
var inst_37995 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_37986);
var state_38007__$1 = state_38007;
var statearr_38012_38057 = state_38007__$1;
(statearr_38012_38057[(2)] = inst_37995);

(statearr_38012_38057[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (4))){
var inst_37938 = (state_38007[(8)]);
var inst_37938__$1 = (state_38007[(2)]);
var inst_37939 = (inst_37938__$1 == null);
var state_38007__$1 = (function (){var statearr_38013 = state_38007;
(statearr_38013[(8)] = inst_37938__$1);

return statearr_38013;
})();
if(cljs.core.truth_(inst_37939)){
var statearr_38014_38058 = state_38007__$1;
(statearr_38014_38058[(1)] = (5));

} else {
var statearr_38015_38059 = state_38007__$1;
(statearr_38015_38059[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (15))){
var inst_37980 = (state_38007[(2)]);
var state_38007__$1 = state_38007;
var statearr_38016_38060 = state_38007__$1;
(statearr_38016_38060[(2)] = inst_37980);

(statearr_38016_38060[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (21))){
var inst_38000 = (state_38007[(2)]);
var state_38007__$1 = (function (){var statearr_38017 = state_38007;
(statearr_38017[(9)] = inst_38000);

return statearr_38017;
})();
var statearr_38018_38061 = state_38007__$1;
(statearr_38018_38061[(2)] = null);

(statearr_38018_38061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (13))){
var inst_37962 = (state_38007[(10)]);
var inst_37964 = cljs.core.chunked_seq_QMARK_(inst_37962);
var state_38007__$1 = state_38007;
if(inst_37964){
var statearr_38019_38062 = state_38007__$1;
(statearr_38019_38062[(1)] = (16));

} else {
var statearr_38020_38063 = state_38007__$1;
(statearr_38020_38063[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (22))){
var inst_37992 = (state_38007[(2)]);
var state_38007__$1 = state_38007;
if(cljs.core.truth_(inst_37992)){
var statearr_38021_38064 = state_38007__$1;
(statearr_38021_38064[(1)] = (23));

} else {
var statearr_38022_38065 = state_38007__$1;
(statearr_38022_38065[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (6))){
var inst_37986 = (state_38007[(7)]);
var inst_37988 = (state_38007[(11)]);
var inst_37938 = (state_38007[(8)]);
var inst_37986__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_37938) : topic_fn.call(null,inst_37938));
var inst_37987 = cljs.core.deref(mults);
var inst_37988__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37987,inst_37986__$1);
var state_38007__$1 = (function (){var statearr_38023 = state_38007;
(statearr_38023[(7)] = inst_37986__$1);

(statearr_38023[(11)] = inst_37988__$1);

return statearr_38023;
})();
if(cljs.core.truth_(inst_37988__$1)){
var statearr_38024_38066 = state_38007__$1;
(statearr_38024_38066[(1)] = (19));

} else {
var statearr_38025_38067 = state_38007__$1;
(statearr_38025_38067[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (25))){
var inst_37997 = (state_38007[(2)]);
var state_38007__$1 = state_38007;
var statearr_38026_38068 = state_38007__$1;
(statearr_38026_38068[(2)] = inst_37997);

(statearr_38026_38068[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (17))){
var inst_37962 = (state_38007[(10)]);
var inst_37971 = cljs.core.first(inst_37962);
var inst_37972 = cljs.core.async.muxch_STAR_(inst_37971);
var inst_37973 = cljs.core.async.close_BANG_(inst_37972);
var inst_37974 = cljs.core.next(inst_37962);
var inst_37948 = inst_37974;
var inst_37949 = null;
var inst_37950 = (0);
var inst_37951 = (0);
var state_38007__$1 = (function (){var statearr_38027 = state_38007;
(statearr_38027[(12)] = inst_37949);

(statearr_38027[(13)] = inst_37950);

(statearr_38027[(14)] = inst_37948);

(statearr_38027[(15)] = inst_37973);

(statearr_38027[(16)] = inst_37951);

return statearr_38027;
})();
var statearr_38028_38069 = state_38007__$1;
(statearr_38028_38069[(2)] = null);

(statearr_38028_38069[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (3))){
var inst_38005 = (state_38007[(2)]);
var state_38007__$1 = state_38007;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38007__$1,inst_38005);
} else {
if((state_val_38008 === (12))){
var inst_37982 = (state_38007[(2)]);
var state_38007__$1 = state_38007;
var statearr_38029_38070 = state_38007__$1;
(statearr_38029_38070[(2)] = inst_37982);

(statearr_38029_38070[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (2))){
var state_38007__$1 = state_38007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38007__$1,(4),ch);
} else {
if((state_val_38008 === (23))){
var state_38007__$1 = state_38007;
var statearr_38030_38071 = state_38007__$1;
(statearr_38030_38071[(2)] = null);

(statearr_38030_38071[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (19))){
var inst_37988 = (state_38007[(11)]);
var inst_37938 = (state_38007[(8)]);
var inst_37990 = cljs.core.async.muxch_STAR_(inst_37988);
var state_38007__$1 = state_38007;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38007__$1,(22),inst_37990,inst_37938);
} else {
if((state_val_38008 === (11))){
var inst_37962 = (state_38007[(10)]);
var inst_37948 = (state_38007[(14)]);
var inst_37962__$1 = cljs.core.seq(inst_37948);
var state_38007__$1 = (function (){var statearr_38031 = state_38007;
(statearr_38031[(10)] = inst_37962__$1);

return statearr_38031;
})();
if(inst_37962__$1){
var statearr_38032_38072 = state_38007__$1;
(statearr_38032_38072[(1)] = (13));

} else {
var statearr_38033_38073 = state_38007__$1;
(statearr_38033_38073[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (9))){
var inst_37984 = (state_38007[(2)]);
var state_38007__$1 = state_38007;
var statearr_38034_38074 = state_38007__$1;
(statearr_38034_38074[(2)] = inst_37984);

(statearr_38034_38074[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (5))){
var inst_37945 = cljs.core.deref(mults);
var inst_37946 = cljs.core.vals(inst_37945);
var inst_37947 = cljs.core.seq(inst_37946);
var inst_37948 = inst_37947;
var inst_37949 = null;
var inst_37950 = (0);
var inst_37951 = (0);
var state_38007__$1 = (function (){var statearr_38035 = state_38007;
(statearr_38035[(12)] = inst_37949);

(statearr_38035[(13)] = inst_37950);

(statearr_38035[(14)] = inst_37948);

(statearr_38035[(16)] = inst_37951);

return statearr_38035;
})();
var statearr_38036_38075 = state_38007__$1;
(statearr_38036_38075[(2)] = null);

(statearr_38036_38075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (14))){
var state_38007__$1 = state_38007;
var statearr_38040_38076 = state_38007__$1;
(statearr_38040_38076[(2)] = null);

(statearr_38040_38076[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (16))){
var inst_37962 = (state_38007[(10)]);
var inst_37966 = cljs.core.chunk_first(inst_37962);
var inst_37967 = cljs.core.chunk_rest(inst_37962);
var inst_37968 = cljs.core.count(inst_37966);
var inst_37948 = inst_37967;
var inst_37949 = inst_37966;
var inst_37950 = inst_37968;
var inst_37951 = (0);
var state_38007__$1 = (function (){var statearr_38041 = state_38007;
(statearr_38041[(12)] = inst_37949);

(statearr_38041[(13)] = inst_37950);

(statearr_38041[(14)] = inst_37948);

(statearr_38041[(16)] = inst_37951);

return statearr_38041;
})();
var statearr_38042_38077 = state_38007__$1;
(statearr_38042_38077[(2)] = null);

(statearr_38042_38077[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (10))){
var inst_37949 = (state_38007[(12)]);
var inst_37950 = (state_38007[(13)]);
var inst_37948 = (state_38007[(14)]);
var inst_37951 = (state_38007[(16)]);
var inst_37956 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37949,inst_37951);
var inst_37957 = cljs.core.async.muxch_STAR_(inst_37956);
var inst_37958 = cljs.core.async.close_BANG_(inst_37957);
var inst_37959 = (inst_37951 + (1));
var tmp38037 = inst_37949;
var tmp38038 = inst_37950;
var tmp38039 = inst_37948;
var inst_37948__$1 = tmp38039;
var inst_37949__$1 = tmp38037;
var inst_37950__$1 = tmp38038;
var inst_37951__$1 = inst_37959;
var state_38007__$1 = (function (){var statearr_38043 = state_38007;
(statearr_38043[(12)] = inst_37949__$1);

(statearr_38043[(13)] = inst_37950__$1);

(statearr_38043[(17)] = inst_37958);

(statearr_38043[(14)] = inst_37948__$1);

(statearr_38043[(16)] = inst_37951__$1);

return statearr_38043;
})();
var statearr_38044_38078 = state_38007__$1;
(statearr_38044_38078[(2)] = null);

(statearr_38044_38078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (18))){
var inst_37977 = (state_38007[(2)]);
var state_38007__$1 = state_38007;
var statearr_38045_38079 = state_38007__$1;
(statearr_38045_38079[(2)] = inst_37977);

(statearr_38045_38079[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38008 === (8))){
var inst_37950 = (state_38007[(13)]);
var inst_37951 = (state_38007[(16)]);
var inst_37953 = (inst_37951 < inst_37950);
var inst_37954 = inst_37953;
var state_38007__$1 = state_38007;
if(cljs.core.truth_(inst_37954)){
var statearr_38046_38080 = state_38007__$1;
(statearr_38046_38080[(1)] = (10));

} else {
var statearr_38047_38081 = state_38007__$1;
(statearr_38047_38081[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___38053,mults,ensure_mult,p))
;
return ((function (switch__36644__auto__,c__36819__auto___38053,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_38048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38048[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_38048[(1)] = (1));

return statearr_38048;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_38007){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_38007);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e38049){if((e38049 instanceof Object)){
var ex__36648__auto__ = e38049;
var statearr_38050_38082 = state_38007;
(statearr_38050_38082[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38007);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38049;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38083 = state_38007;
state_38007 = G__38083;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_38007){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_38007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___38053,mults,ensure_mult,p))
})();
var state__36821__auto__ = (function (){var statearr_38051 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_38051[(6)] = c__36819__auto___38053);

return statearr_38051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___38053,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__38085 = arguments.length;
switch (G__38085) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__38088 = arguments.length;
switch (G__38088) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__38091 = arguments.length;
switch (G__38091) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__36819__auto___38158 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___38158,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___38158,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_38130){
var state_val_38131 = (state_38130[(1)]);
if((state_val_38131 === (7))){
var state_38130__$1 = state_38130;
var statearr_38132_38159 = state_38130__$1;
(statearr_38132_38159[(2)] = null);

(statearr_38132_38159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (1))){
var state_38130__$1 = state_38130;
var statearr_38133_38160 = state_38130__$1;
(statearr_38133_38160[(2)] = null);

(statearr_38133_38160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (4))){
var inst_38094 = (state_38130[(7)]);
var inst_38096 = (inst_38094 < cnt);
var state_38130__$1 = state_38130;
if(cljs.core.truth_(inst_38096)){
var statearr_38134_38161 = state_38130__$1;
(statearr_38134_38161[(1)] = (6));

} else {
var statearr_38135_38162 = state_38130__$1;
(statearr_38135_38162[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (15))){
var inst_38126 = (state_38130[(2)]);
var state_38130__$1 = state_38130;
var statearr_38136_38163 = state_38130__$1;
(statearr_38136_38163[(2)] = inst_38126);

(statearr_38136_38163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (13))){
var inst_38119 = cljs.core.async.close_BANG_(out);
var state_38130__$1 = state_38130;
var statearr_38137_38164 = state_38130__$1;
(statearr_38137_38164[(2)] = inst_38119);

(statearr_38137_38164[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (6))){
var state_38130__$1 = state_38130;
var statearr_38138_38165 = state_38130__$1;
(statearr_38138_38165[(2)] = null);

(statearr_38138_38165[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (3))){
var inst_38128 = (state_38130[(2)]);
var state_38130__$1 = state_38130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38130__$1,inst_38128);
} else {
if((state_val_38131 === (12))){
var inst_38116 = (state_38130[(8)]);
var inst_38116__$1 = (state_38130[(2)]);
var inst_38117 = cljs.core.some(cljs.core.nil_QMARK_,inst_38116__$1);
var state_38130__$1 = (function (){var statearr_38139 = state_38130;
(statearr_38139[(8)] = inst_38116__$1);

return statearr_38139;
})();
if(cljs.core.truth_(inst_38117)){
var statearr_38140_38166 = state_38130__$1;
(statearr_38140_38166[(1)] = (13));

} else {
var statearr_38141_38167 = state_38130__$1;
(statearr_38141_38167[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (2))){
var inst_38093 = cljs.core.reset_BANG_(dctr,cnt);
var inst_38094 = (0);
var state_38130__$1 = (function (){var statearr_38142 = state_38130;
(statearr_38142[(9)] = inst_38093);

(statearr_38142[(7)] = inst_38094);

return statearr_38142;
})();
var statearr_38143_38168 = state_38130__$1;
(statearr_38143_38168[(2)] = null);

(statearr_38143_38168[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (11))){
var inst_38094 = (state_38130[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_38130,(10),Object,null,(9));
var inst_38103 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_38094) : chs__$1.call(null,inst_38094));
var inst_38104 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_38094) : done.call(null,inst_38094));
var inst_38105 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38103,inst_38104);
var state_38130__$1 = state_38130;
var statearr_38144_38169 = state_38130__$1;
(statearr_38144_38169[(2)] = inst_38105);


cljs.core.async.impl.ioc_helpers.process_exception(state_38130__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (9))){
var inst_38094 = (state_38130[(7)]);
var inst_38107 = (state_38130[(2)]);
var inst_38108 = (inst_38094 + (1));
var inst_38094__$1 = inst_38108;
var state_38130__$1 = (function (){var statearr_38145 = state_38130;
(statearr_38145[(7)] = inst_38094__$1);

(statearr_38145[(10)] = inst_38107);

return statearr_38145;
})();
var statearr_38146_38170 = state_38130__$1;
(statearr_38146_38170[(2)] = null);

(statearr_38146_38170[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (5))){
var inst_38114 = (state_38130[(2)]);
var state_38130__$1 = (function (){var statearr_38147 = state_38130;
(statearr_38147[(11)] = inst_38114);

return statearr_38147;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38130__$1,(12),dchan);
} else {
if((state_val_38131 === (14))){
var inst_38116 = (state_38130[(8)]);
var inst_38121 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_38116);
var state_38130__$1 = state_38130;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38130__$1,(16),out,inst_38121);
} else {
if((state_val_38131 === (16))){
var inst_38123 = (state_38130[(2)]);
var state_38130__$1 = (function (){var statearr_38148 = state_38130;
(statearr_38148[(12)] = inst_38123);

return statearr_38148;
})();
var statearr_38149_38171 = state_38130__$1;
(statearr_38149_38171[(2)] = null);

(statearr_38149_38171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (10))){
var inst_38098 = (state_38130[(2)]);
var inst_38099 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_38130__$1 = (function (){var statearr_38150 = state_38130;
(statearr_38150[(13)] = inst_38098);

return statearr_38150;
})();
var statearr_38151_38172 = state_38130__$1;
(statearr_38151_38172[(2)] = inst_38099);


cljs.core.async.impl.ioc_helpers.process_exception(state_38130__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38131 === (8))){
var inst_38112 = (state_38130[(2)]);
var state_38130__$1 = state_38130;
var statearr_38152_38173 = state_38130__$1;
(statearr_38152_38173[(2)] = inst_38112);

(statearr_38152_38173[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___38158,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__36644__auto__,c__36819__auto___38158,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_38153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38153[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_38153[(1)] = (1));

return statearr_38153;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_38130){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_38130);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e38154){if((e38154 instanceof Object)){
var ex__36648__auto__ = e38154;
var statearr_38155_38174 = state_38130;
(statearr_38155_38174[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38130);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38154;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38175 = state_38130;
state_38130 = G__38175;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_38130){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_38130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___38158,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__36821__auto__ = (function (){var statearr_38156 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_38156[(6)] = c__36819__auto___38158);

return statearr_38156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___38158,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__38178 = arguments.length;
switch (G__38178) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__36819__auto___38232 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___38232,out){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___38232,out){
return (function (state_38210){
var state_val_38211 = (state_38210[(1)]);
if((state_val_38211 === (7))){
var inst_38190 = (state_38210[(7)]);
var inst_38189 = (state_38210[(8)]);
var inst_38189__$1 = (state_38210[(2)]);
var inst_38190__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38189__$1,(0),null);
var inst_38191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38189__$1,(1),null);
var inst_38192 = (inst_38190__$1 == null);
var state_38210__$1 = (function (){var statearr_38212 = state_38210;
(statearr_38212[(7)] = inst_38190__$1);

(statearr_38212[(8)] = inst_38189__$1);

(statearr_38212[(9)] = inst_38191);

return statearr_38212;
})();
if(cljs.core.truth_(inst_38192)){
var statearr_38213_38233 = state_38210__$1;
(statearr_38213_38233[(1)] = (8));

} else {
var statearr_38214_38234 = state_38210__$1;
(statearr_38214_38234[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38211 === (1))){
var inst_38179 = cljs.core.vec(chs);
var inst_38180 = inst_38179;
var state_38210__$1 = (function (){var statearr_38215 = state_38210;
(statearr_38215[(10)] = inst_38180);

return statearr_38215;
})();
var statearr_38216_38235 = state_38210__$1;
(statearr_38216_38235[(2)] = null);

(statearr_38216_38235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38211 === (4))){
var inst_38180 = (state_38210[(10)]);
var state_38210__$1 = state_38210;
return cljs.core.async.ioc_alts_BANG_(state_38210__$1,(7),inst_38180);
} else {
if((state_val_38211 === (6))){
var inst_38206 = (state_38210[(2)]);
var state_38210__$1 = state_38210;
var statearr_38217_38236 = state_38210__$1;
(statearr_38217_38236[(2)] = inst_38206);

(statearr_38217_38236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38211 === (3))){
var inst_38208 = (state_38210[(2)]);
var state_38210__$1 = state_38210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38210__$1,inst_38208);
} else {
if((state_val_38211 === (2))){
var inst_38180 = (state_38210[(10)]);
var inst_38182 = cljs.core.count(inst_38180);
var inst_38183 = (inst_38182 > (0));
var state_38210__$1 = state_38210;
if(cljs.core.truth_(inst_38183)){
var statearr_38219_38237 = state_38210__$1;
(statearr_38219_38237[(1)] = (4));

} else {
var statearr_38220_38238 = state_38210__$1;
(statearr_38220_38238[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38211 === (11))){
var inst_38180 = (state_38210[(10)]);
var inst_38199 = (state_38210[(2)]);
var tmp38218 = inst_38180;
var inst_38180__$1 = tmp38218;
var state_38210__$1 = (function (){var statearr_38221 = state_38210;
(statearr_38221[(10)] = inst_38180__$1);

(statearr_38221[(11)] = inst_38199);

return statearr_38221;
})();
var statearr_38222_38239 = state_38210__$1;
(statearr_38222_38239[(2)] = null);

(statearr_38222_38239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38211 === (9))){
var inst_38190 = (state_38210[(7)]);
var state_38210__$1 = state_38210;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38210__$1,(11),out,inst_38190);
} else {
if((state_val_38211 === (5))){
var inst_38204 = cljs.core.async.close_BANG_(out);
var state_38210__$1 = state_38210;
var statearr_38223_38240 = state_38210__$1;
(statearr_38223_38240[(2)] = inst_38204);

(statearr_38223_38240[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38211 === (10))){
var inst_38202 = (state_38210[(2)]);
var state_38210__$1 = state_38210;
var statearr_38224_38241 = state_38210__$1;
(statearr_38224_38241[(2)] = inst_38202);

(statearr_38224_38241[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38211 === (8))){
var inst_38190 = (state_38210[(7)]);
var inst_38189 = (state_38210[(8)]);
var inst_38191 = (state_38210[(9)]);
var inst_38180 = (state_38210[(10)]);
var inst_38194 = (function (){var cs = inst_38180;
var vec__38185 = inst_38189;
var v = inst_38190;
var c = inst_38191;
return ((function (cs,vec__38185,v,c,inst_38190,inst_38189,inst_38191,inst_38180,state_val_38211,c__36819__auto___38232,out){
return (function (p1__38176_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__38176_SHARP_);
});
;})(cs,vec__38185,v,c,inst_38190,inst_38189,inst_38191,inst_38180,state_val_38211,c__36819__auto___38232,out))
})();
var inst_38195 = cljs.core.filterv(inst_38194,inst_38180);
var inst_38180__$1 = inst_38195;
var state_38210__$1 = (function (){var statearr_38225 = state_38210;
(statearr_38225[(10)] = inst_38180__$1);

return statearr_38225;
})();
var statearr_38226_38242 = state_38210__$1;
(statearr_38226_38242[(2)] = null);

(statearr_38226_38242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___38232,out))
;
return ((function (switch__36644__auto__,c__36819__auto___38232,out){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_38227 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38227[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_38227[(1)] = (1));

return statearr_38227;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_38210){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_38210);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e38228){if((e38228 instanceof Object)){
var ex__36648__auto__ = e38228;
var statearr_38229_38243 = state_38210;
(statearr_38229_38243[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38210);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38228;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38244 = state_38210;
state_38210 = G__38244;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_38210){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_38210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___38232,out))
})();
var state__36821__auto__ = (function (){var statearr_38230 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_38230[(6)] = c__36819__auto___38232);

return statearr_38230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___38232,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__38246 = arguments.length;
switch (G__38246) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__36819__auto___38291 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___38291,out){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___38291,out){
return (function (state_38270){
var state_val_38271 = (state_38270[(1)]);
if((state_val_38271 === (7))){
var inst_38252 = (state_38270[(7)]);
var inst_38252__$1 = (state_38270[(2)]);
var inst_38253 = (inst_38252__$1 == null);
var inst_38254 = cljs.core.not(inst_38253);
var state_38270__$1 = (function (){var statearr_38272 = state_38270;
(statearr_38272[(7)] = inst_38252__$1);

return statearr_38272;
})();
if(inst_38254){
var statearr_38273_38292 = state_38270__$1;
(statearr_38273_38292[(1)] = (8));

} else {
var statearr_38274_38293 = state_38270__$1;
(statearr_38274_38293[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38271 === (1))){
var inst_38247 = (0);
var state_38270__$1 = (function (){var statearr_38275 = state_38270;
(statearr_38275[(8)] = inst_38247);

return statearr_38275;
})();
var statearr_38276_38294 = state_38270__$1;
(statearr_38276_38294[(2)] = null);

(statearr_38276_38294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38271 === (4))){
var state_38270__$1 = state_38270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38270__$1,(7),ch);
} else {
if((state_val_38271 === (6))){
var inst_38265 = (state_38270[(2)]);
var state_38270__$1 = state_38270;
var statearr_38277_38295 = state_38270__$1;
(statearr_38277_38295[(2)] = inst_38265);

(statearr_38277_38295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38271 === (3))){
var inst_38267 = (state_38270[(2)]);
var inst_38268 = cljs.core.async.close_BANG_(out);
var state_38270__$1 = (function (){var statearr_38278 = state_38270;
(statearr_38278[(9)] = inst_38267);

return statearr_38278;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38270__$1,inst_38268);
} else {
if((state_val_38271 === (2))){
var inst_38247 = (state_38270[(8)]);
var inst_38249 = (inst_38247 < n);
var state_38270__$1 = state_38270;
if(cljs.core.truth_(inst_38249)){
var statearr_38279_38296 = state_38270__$1;
(statearr_38279_38296[(1)] = (4));

} else {
var statearr_38280_38297 = state_38270__$1;
(statearr_38280_38297[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38271 === (11))){
var inst_38247 = (state_38270[(8)]);
var inst_38257 = (state_38270[(2)]);
var inst_38258 = (inst_38247 + (1));
var inst_38247__$1 = inst_38258;
var state_38270__$1 = (function (){var statearr_38281 = state_38270;
(statearr_38281[(8)] = inst_38247__$1);

(statearr_38281[(10)] = inst_38257);

return statearr_38281;
})();
var statearr_38282_38298 = state_38270__$1;
(statearr_38282_38298[(2)] = null);

(statearr_38282_38298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38271 === (9))){
var state_38270__$1 = state_38270;
var statearr_38283_38299 = state_38270__$1;
(statearr_38283_38299[(2)] = null);

(statearr_38283_38299[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38271 === (5))){
var state_38270__$1 = state_38270;
var statearr_38284_38300 = state_38270__$1;
(statearr_38284_38300[(2)] = null);

(statearr_38284_38300[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38271 === (10))){
var inst_38262 = (state_38270[(2)]);
var state_38270__$1 = state_38270;
var statearr_38285_38301 = state_38270__$1;
(statearr_38285_38301[(2)] = inst_38262);

(statearr_38285_38301[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38271 === (8))){
var inst_38252 = (state_38270[(7)]);
var state_38270__$1 = state_38270;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38270__$1,(11),out,inst_38252);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___38291,out))
;
return ((function (switch__36644__auto__,c__36819__auto___38291,out){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_38286 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38286[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_38286[(1)] = (1));

return statearr_38286;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_38270){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_38270);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e38287){if((e38287 instanceof Object)){
var ex__36648__auto__ = e38287;
var statearr_38288_38302 = state_38270;
(statearr_38288_38302[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38270);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38287;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38303 = state_38270;
state_38270 = G__38303;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_38270){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_38270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___38291,out))
})();
var state__36821__auto__ = (function (){var statearr_38289 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_38289[(6)] = c__36819__auto___38291);

return statearr_38289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___38291,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38305 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38305 = (function (f,ch,meta38306){
this.f = f;
this.ch = ch;
this.meta38306 = meta38306;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38305.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38307,meta38306__$1){
var self__ = this;
var _38307__$1 = this;
return (new cljs.core.async.t_cljs$core$async38305(self__.f,self__.ch,meta38306__$1));
});

cljs.core.async.t_cljs$core$async38305.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38307){
var self__ = this;
var _38307__$1 = this;
return self__.meta38306;
});

cljs.core.async.t_cljs$core$async38305.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38305.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38305.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38305.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38305.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38308 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38308 = (function (f,ch,meta38306,_,fn1,meta38309){
this.f = f;
this.ch = ch;
this.meta38306 = meta38306;
this._ = _;
this.fn1 = fn1;
this.meta38309 = meta38309;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38308.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_38310,meta38309__$1){
var self__ = this;
var _38310__$1 = this;
return (new cljs.core.async.t_cljs$core$async38308(self__.f,self__.ch,self__.meta38306,self__._,self__.fn1,meta38309__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async38308.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_38310){
var self__ = this;
var _38310__$1 = this;
return self__.meta38309;
});})(___$1))
;

cljs.core.async.t_cljs$core$async38308.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38308.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38308.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async38308.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__38304_SHARP_){
var G__38311 = (((p1__38304_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__38304_SHARP_) : self__.f.call(null,p1__38304_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__38311) : f1.call(null,G__38311));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async38308.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38306","meta38306",225151920,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async38305","cljs.core.async/t_cljs$core$async38305",1241395058,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta38309","meta38309",-119383939,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38308.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38308.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38308";

cljs.core.async.t_cljs$core$async38308.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"cljs.core.async/t_cljs$core$async38308");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38308.
 */
cljs.core.async.__GT_t_cljs$core$async38308 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38308(f__$1,ch__$1,meta38306__$1,___$2,fn1__$1,meta38309){
return (new cljs.core.async.t_cljs$core$async38308(f__$1,ch__$1,meta38306__$1,___$2,fn1__$1,meta38309));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async38308(self__.f,self__.ch,self__.meta38306,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3925__auto__ = ret;
if(cljs.core.truth_(and__3925__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__3925__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__38312 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__38312) : self__.f.call(null,G__38312));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async38305.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38305.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async38305.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38306","meta38306",225151920,null)], null);
});

cljs.core.async.t_cljs$core$async38305.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38305.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38305";

cljs.core.async.t_cljs$core$async38305.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"cljs.core.async/t_cljs$core$async38305");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38305.
 */
cljs.core.async.__GT_t_cljs$core$async38305 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38305(f__$1,ch__$1,meta38306){
return (new cljs.core.async.t_cljs$core$async38305(f__$1,ch__$1,meta38306));
});

}

return (new cljs.core.async.t_cljs$core$async38305(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38313 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38313 = (function (f,ch,meta38314){
this.f = f;
this.ch = ch;
this.meta38314 = meta38314;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38313.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38315,meta38314__$1){
var self__ = this;
var _38315__$1 = this;
return (new cljs.core.async.t_cljs$core$async38313(self__.f,self__.ch,meta38314__$1));
});

cljs.core.async.t_cljs$core$async38313.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38315){
var self__ = this;
var _38315__$1 = this;
return self__.meta38314;
});

cljs.core.async.t_cljs$core$async38313.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38313.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38313.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38313.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38313.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38313.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async38313.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38314","meta38314",2051999168,null)], null);
});

cljs.core.async.t_cljs$core$async38313.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38313.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38313";

cljs.core.async.t_cljs$core$async38313.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"cljs.core.async/t_cljs$core$async38313");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38313.
 */
cljs.core.async.__GT_t_cljs$core$async38313 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async38313(f__$1,ch__$1,meta38314){
return (new cljs.core.async.t_cljs$core$async38313(f__$1,ch__$1,meta38314));
});

}

return (new cljs.core.async.t_cljs$core$async38313(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38316 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38316 = (function (p,ch,meta38317){
this.p = p;
this.ch = ch;
this.meta38317 = meta38317;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38316.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38318,meta38317__$1){
var self__ = this;
var _38318__$1 = this;
return (new cljs.core.async.t_cljs$core$async38316(self__.p,self__.ch,meta38317__$1));
});

cljs.core.async.t_cljs$core$async38316.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38318){
var self__ = this;
var _38318__$1 = this;
return self__.meta38317;
});

cljs.core.async.t_cljs$core$async38316.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38316.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38316.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38316.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38316.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38316.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38316.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async38316.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38317","meta38317",-385638790,null)], null);
});

cljs.core.async.t_cljs$core$async38316.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38316.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38316";

cljs.core.async.t_cljs$core$async38316.cljs$lang$ctorPrWriter = (function (this__4179__auto__,writer__4180__auto__,opt__4181__auto__){
return cljs.core._write(writer__4180__auto__,"cljs.core.async/t_cljs$core$async38316");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38316.
 */
cljs.core.async.__GT_t_cljs$core$async38316 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async38316(p__$1,ch__$1,meta38317){
return (new cljs.core.async.t_cljs$core$async38316(p__$1,ch__$1,meta38317));
});

}

return (new cljs.core.async.t_cljs$core$async38316(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__38320 = arguments.length;
switch (G__38320) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__36819__auto___38360 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___38360,out){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___38360,out){
return (function (state_38341){
var state_val_38342 = (state_38341[(1)]);
if((state_val_38342 === (7))){
var inst_38337 = (state_38341[(2)]);
var state_38341__$1 = state_38341;
var statearr_38343_38361 = state_38341__$1;
(statearr_38343_38361[(2)] = inst_38337);

(statearr_38343_38361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38342 === (1))){
var state_38341__$1 = state_38341;
var statearr_38344_38362 = state_38341__$1;
(statearr_38344_38362[(2)] = null);

(statearr_38344_38362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38342 === (4))){
var inst_38323 = (state_38341[(7)]);
var inst_38323__$1 = (state_38341[(2)]);
var inst_38324 = (inst_38323__$1 == null);
var state_38341__$1 = (function (){var statearr_38345 = state_38341;
(statearr_38345[(7)] = inst_38323__$1);

return statearr_38345;
})();
if(cljs.core.truth_(inst_38324)){
var statearr_38346_38363 = state_38341__$1;
(statearr_38346_38363[(1)] = (5));

} else {
var statearr_38347_38364 = state_38341__$1;
(statearr_38347_38364[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38342 === (6))){
var inst_38323 = (state_38341[(7)]);
var inst_38328 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38323) : p.call(null,inst_38323));
var state_38341__$1 = state_38341;
if(cljs.core.truth_(inst_38328)){
var statearr_38348_38365 = state_38341__$1;
(statearr_38348_38365[(1)] = (8));

} else {
var statearr_38349_38366 = state_38341__$1;
(statearr_38349_38366[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38342 === (3))){
var inst_38339 = (state_38341[(2)]);
var state_38341__$1 = state_38341;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38341__$1,inst_38339);
} else {
if((state_val_38342 === (2))){
var state_38341__$1 = state_38341;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38341__$1,(4),ch);
} else {
if((state_val_38342 === (11))){
var inst_38331 = (state_38341[(2)]);
var state_38341__$1 = state_38341;
var statearr_38350_38367 = state_38341__$1;
(statearr_38350_38367[(2)] = inst_38331);

(statearr_38350_38367[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38342 === (9))){
var state_38341__$1 = state_38341;
var statearr_38351_38368 = state_38341__$1;
(statearr_38351_38368[(2)] = null);

(statearr_38351_38368[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38342 === (5))){
var inst_38326 = cljs.core.async.close_BANG_(out);
var state_38341__$1 = state_38341;
var statearr_38352_38369 = state_38341__$1;
(statearr_38352_38369[(2)] = inst_38326);

(statearr_38352_38369[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38342 === (10))){
var inst_38334 = (state_38341[(2)]);
var state_38341__$1 = (function (){var statearr_38353 = state_38341;
(statearr_38353[(8)] = inst_38334);

return statearr_38353;
})();
var statearr_38354_38370 = state_38341__$1;
(statearr_38354_38370[(2)] = null);

(statearr_38354_38370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38342 === (8))){
var inst_38323 = (state_38341[(7)]);
var state_38341__$1 = state_38341;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38341__$1,(11),out,inst_38323);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___38360,out))
;
return ((function (switch__36644__auto__,c__36819__auto___38360,out){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_38355 = [null,null,null,null,null,null,null,null,null];
(statearr_38355[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_38355[(1)] = (1));

return statearr_38355;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_38341){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_38341);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e38356){if((e38356 instanceof Object)){
var ex__36648__auto__ = e38356;
var statearr_38357_38371 = state_38341;
(statearr_38357_38371[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38341);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38356;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38372 = state_38341;
state_38341 = G__38372;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_38341){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_38341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___38360,out))
})();
var state__36821__auto__ = (function (){var statearr_38358 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_38358[(6)] = c__36819__auto___38360);

return statearr_38358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___38360,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__38374 = arguments.length;
switch (G__38374) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__36819__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto__){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto__){
return (function (state_38437){
var state_val_38438 = (state_38437[(1)]);
if((state_val_38438 === (7))){
var inst_38433 = (state_38437[(2)]);
var state_38437__$1 = state_38437;
var statearr_38439_38477 = state_38437__$1;
(statearr_38439_38477[(2)] = inst_38433);

(statearr_38439_38477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (20))){
var inst_38403 = (state_38437[(7)]);
var inst_38414 = (state_38437[(2)]);
var inst_38415 = cljs.core.next(inst_38403);
var inst_38389 = inst_38415;
var inst_38390 = null;
var inst_38391 = (0);
var inst_38392 = (0);
var state_38437__$1 = (function (){var statearr_38440 = state_38437;
(statearr_38440[(8)] = inst_38389);

(statearr_38440[(9)] = inst_38390);

(statearr_38440[(10)] = inst_38414);

(statearr_38440[(11)] = inst_38392);

(statearr_38440[(12)] = inst_38391);

return statearr_38440;
})();
var statearr_38441_38478 = state_38437__$1;
(statearr_38441_38478[(2)] = null);

(statearr_38441_38478[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (1))){
var state_38437__$1 = state_38437;
var statearr_38442_38479 = state_38437__$1;
(statearr_38442_38479[(2)] = null);

(statearr_38442_38479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (4))){
var inst_38378 = (state_38437[(13)]);
var inst_38378__$1 = (state_38437[(2)]);
var inst_38379 = (inst_38378__$1 == null);
var state_38437__$1 = (function (){var statearr_38443 = state_38437;
(statearr_38443[(13)] = inst_38378__$1);

return statearr_38443;
})();
if(cljs.core.truth_(inst_38379)){
var statearr_38444_38480 = state_38437__$1;
(statearr_38444_38480[(1)] = (5));

} else {
var statearr_38445_38481 = state_38437__$1;
(statearr_38445_38481[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (15))){
var state_38437__$1 = state_38437;
var statearr_38449_38482 = state_38437__$1;
(statearr_38449_38482[(2)] = null);

(statearr_38449_38482[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (21))){
var state_38437__$1 = state_38437;
var statearr_38450_38483 = state_38437__$1;
(statearr_38450_38483[(2)] = null);

(statearr_38450_38483[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (13))){
var inst_38389 = (state_38437[(8)]);
var inst_38390 = (state_38437[(9)]);
var inst_38392 = (state_38437[(11)]);
var inst_38391 = (state_38437[(12)]);
var inst_38399 = (state_38437[(2)]);
var inst_38400 = (inst_38392 + (1));
var tmp38446 = inst_38389;
var tmp38447 = inst_38390;
var tmp38448 = inst_38391;
var inst_38389__$1 = tmp38446;
var inst_38390__$1 = tmp38447;
var inst_38391__$1 = tmp38448;
var inst_38392__$1 = inst_38400;
var state_38437__$1 = (function (){var statearr_38451 = state_38437;
(statearr_38451[(8)] = inst_38389__$1);

(statearr_38451[(9)] = inst_38390__$1);

(statearr_38451[(14)] = inst_38399);

(statearr_38451[(11)] = inst_38392__$1);

(statearr_38451[(12)] = inst_38391__$1);

return statearr_38451;
})();
var statearr_38452_38484 = state_38437__$1;
(statearr_38452_38484[(2)] = null);

(statearr_38452_38484[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (22))){
var state_38437__$1 = state_38437;
var statearr_38453_38485 = state_38437__$1;
(statearr_38453_38485[(2)] = null);

(statearr_38453_38485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (6))){
var inst_38378 = (state_38437[(13)]);
var inst_38387 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38378) : f.call(null,inst_38378));
var inst_38388 = cljs.core.seq(inst_38387);
var inst_38389 = inst_38388;
var inst_38390 = null;
var inst_38391 = (0);
var inst_38392 = (0);
var state_38437__$1 = (function (){var statearr_38454 = state_38437;
(statearr_38454[(8)] = inst_38389);

(statearr_38454[(9)] = inst_38390);

(statearr_38454[(11)] = inst_38392);

(statearr_38454[(12)] = inst_38391);

return statearr_38454;
})();
var statearr_38455_38486 = state_38437__$1;
(statearr_38455_38486[(2)] = null);

(statearr_38455_38486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (17))){
var inst_38403 = (state_38437[(7)]);
var inst_38407 = cljs.core.chunk_first(inst_38403);
var inst_38408 = cljs.core.chunk_rest(inst_38403);
var inst_38409 = cljs.core.count(inst_38407);
var inst_38389 = inst_38408;
var inst_38390 = inst_38407;
var inst_38391 = inst_38409;
var inst_38392 = (0);
var state_38437__$1 = (function (){var statearr_38456 = state_38437;
(statearr_38456[(8)] = inst_38389);

(statearr_38456[(9)] = inst_38390);

(statearr_38456[(11)] = inst_38392);

(statearr_38456[(12)] = inst_38391);

return statearr_38456;
})();
var statearr_38457_38487 = state_38437__$1;
(statearr_38457_38487[(2)] = null);

(statearr_38457_38487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (3))){
var inst_38435 = (state_38437[(2)]);
var state_38437__$1 = state_38437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38437__$1,inst_38435);
} else {
if((state_val_38438 === (12))){
var inst_38423 = (state_38437[(2)]);
var state_38437__$1 = state_38437;
var statearr_38458_38488 = state_38437__$1;
(statearr_38458_38488[(2)] = inst_38423);

(statearr_38458_38488[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (2))){
var state_38437__$1 = state_38437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38437__$1,(4),in$);
} else {
if((state_val_38438 === (23))){
var inst_38431 = (state_38437[(2)]);
var state_38437__$1 = state_38437;
var statearr_38459_38489 = state_38437__$1;
(statearr_38459_38489[(2)] = inst_38431);

(statearr_38459_38489[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (19))){
var inst_38418 = (state_38437[(2)]);
var state_38437__$1 = state_38437;
var statearr_38460_38490 = state_38437__$1;
(statearr_38460_38490[(2)] = inst_38418);

(statearr_38460_38490[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (11))){
var inst_38389 = (state_38437[(8)]);
var inst_38403 = (state_38437[(7)]);
var inst_38403__$1 = cljs.core.seq(inst_38389);
var state_38437__$1 = (function (){var statearr_38461 = state_38437;
(statearr_38461[(7)] = inst_38403__$1);

return statearr_38461;
})();
if(inst_38403__$1){
var statearr_38462_38491 = state_38437__$1;
(statearr_38462_38491[(1)] = (14));

} else {
var statearr_38463_38492 = state_38437__$1;
(statearr_38463_38492[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (9))){
var inst_38425 = (state_38437[(2)]);
var inst_38426 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_38437__$1 = (function (){var statearr_38464 = state_38437;
(statearr_38464[(15)] = inst_38425);

return statearr_38464;
})();
if(cljs.core.truth_(inst_38426)){
var statearr_38465_38493 = state_38437__$1;
(statearr_38465_38493[(1)] = (21));

} else {
var statearr_38466_38494 = state_38437__$1;
(statearr_38466_38494[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (5))){
var inst_38381 = cljs.core.async.close_BANG_(out);
var state_38437__$1 = state_38437;
var statearr_38467_38495 = state_38437__$1;
(statearr_38467_38495[(2)] = inst_38381);

(statearr_38467_38495[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (14))){
var inst_38403 = (state_38437[(7)]);
var inst_38405 = cljs.core.chunked_seq_QMARK_(inst_38403);
var state_38437__$1 = state_38437;
if(inst_38405){
var statearr_38468_38496 = state_38437__$1;
(statearr_38468_38496[(1)] = (17));

} else {
var statearr_38469_38497 = state_38437__$1;
(statearr_38469_38497[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (16))){
var inst_38421 = (state_38437[(2)]);
var state_38437__$1 = state_38437;
var statearr_38470_38498 = state_38437__$1;
(statearr_38470_38498[(2)] = inst_38421);

(statearr_38470_38498[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38438 === (10))){
var inst_38390 = (state_38437[(9)]);
var inst_38392 = (state_38437[(11)]);
var inst_38397 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_38390,inst_38392);
var state_38437__$1 = state_38437;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38437__$1,(13),out,inst_38397);
} else {
if((state_val_38438 === (18))){
var inst_38403 = (state_38437[(7)]);
var inst_38412 = cljs.core.first(inst_38403);
var state_38437__$1 = state_38437;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38437__$1,(20),out,inst_38412);
} else {
if((state_val_38438 === (8))){
var inst_38392 = (state_38437[(11)]);
var inst_38391 = (state_38437[(12)]);
var inst_38394 = (inst_38392 < inst_38391);
var inst_38395 = inst_38394;
var state_38437__$1 = state_38437;
if(cljs.core.truth_(inst_38395)){
var statearr_38471_38499 = state_38437__$1;
(statearr_38471_38499[(1)] = (10));

} else {
var statearr_38472_38500 = state_38437__$1;
(statearr_38472_38500[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto__))
;
return ((function (switch__36644__auto__,c__36819__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__36645__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__36645__auto____0 = (function (){
var statearr_38473 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38473[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__36645__auto__);

(statearr_38473[(1)] = (1));

return statearr_38473;
});
var cljs$core$async$mapcat_STAR__$_state_machine__36645__auto____1 = (function (state_38437){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_38437);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e38474){if((e38474 instanceof Object)){
var ex__36648__auto__ = e38474;
var statearr_38475_38501 = state_38437;
(statearr_38475_38501[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38437);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38474;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38502 = state_38437;
state_38437 = G__38502;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__36645__auto__ = function(state_38437){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__36645__auto____1.call(this,state_38437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__36645__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__36645__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto__))
})();
var state__36821__auto__ = (function (){var statearr_38476 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_38476[(6)] = c__36819__auto__);

return statearr_38476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto__))
);

return c__36819__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__38504 = arguments.length;
switch (G__38504) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__38507 = arguments.length;
switch (G__38507) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__38510 = arguments.length;
switch (G__38510) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__36819__auto___38557 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___38557,out){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___38557,out){
return (function (state_38534){
var state_val_38535 = (state_38534[(1)]);
if((state_val_38535 === (7))){
var inst_38529 = (state_38534[(2)]);
var state_38534__$1 = state_38534;
var statearr_38536_38558 = state_38534__$1;
(statearr_38536_38558[(2)] = inst_38529);

(statearr_38536_38558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38535 === (1))){
var inst_38511 = null;
var state_38534__$1 = (function (){var statearr_38537 = state_38534;
(statearr_38537[(7)] = inst_38511);

return statearr_38537;
})();
var statearr_38538_38559 = state_38534__$1;
(statearr_38538_38559[(2)] = null);

(statearr_38538_38559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38535 === (4))){
var inst_38514 = (state_38534[(8)]);
var inst_38514__$1 = (state_38534[(2)]);
var inst_38515 = (inst_38514__$1 == null);
var inst_38516 = cljs.core.not(inst_38515);
var state_38534__$1 = (function (){var statearr_38539 = state_38534;
(statearr_38539[(8)] = inst_38514__$1);

return statearr_38539;
})();
if(inst_38516){
var statearr_38540_38560 = state_38534__$1;
(statearr_38540_38560[(1)] = (5));

} else {
var statearr_38541_38561 = state_38534__$1;
(statearr_38541_38561[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38535 === (6))){
var state_38534__$1 = state_38534;
var statearr_38542_38562 = state_38534__$1;
(statearr_38542_38562[(2)] = null);

(statearr_38542_38562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38535 === (3))){
var inst_38531 = (state_38534[(2)]);
var inst_38532 = cljs.core.async.close_BANG_(out);
var state_38534__$1 = (function (){var statearr_38543 = state_38534;
(statearr_38543[(9)] = inst_38531);

return statearr_38543;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38534__$1,inst_38532);
} else {
if((state_val_38535 === (2))){
var state_38534__$1 = state_38534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38534__$1,(4),ch);
} else {
if((state_val_38535 === (11))){
var inst_38514 = (state_38534[(8)]);
var inst_38523 = (state_38534[(2)]);
var inst_38511 = inst_38514;
var state_38534__$1 = (function (){var statearr_38544 = state_38534;
(statearr_38544[(10)] = inst_38523);

(statearr_38544[(7)] = inst_38511);

return statearr_38544;
})();
var statearr_38545_38563 = state_38534__$1;
(statearr_38545_38563[(2)] = null);

(statearr_38545_38563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38535 === (9))){
var inst_38514 = (state_38534[(8)]);
var state_38534__$1 = state_38534;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38534__$1,(11),out,inst_38514);
} else {
if((state_val_38535 === (5))){
var inst_38514 = (state_38534[(8)]);
var inst_38511 = (state_38534[(7)]);
var inst_38518 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38514,inst_38511);
var state_38534__$1 = state_38534;
if(inst_38518){
var statearr_38547_38564 = state_38534__$1;
(statearr_38547_38564[(1)] = (8));

} else {
var statearr_38548_38565 = state_38534__$1;
(statearr_38548_38565[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38535 === (10))){
var inst_38526 = (state_38534[(2)]);
var state_38534__$1 = state_38534;
var statearr_38549_38566 = state_38534__$1;
(statearr_38549_38566[(2)] = inst_38526);

(statearr_38549_38566[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38535 === (8))){
var inst_38511 = (state_38534[(7)]);
var tmp38546 = inst_38511;
var inst_38511__$1 = tmp38546;
var state_38534__$1 = (function (){var statearr_38550 = state_38534;
(statearr_38550[(7)] = inst_38511__$1);

return statearr_38550;
})();
var statearr_38551_38567 = state_38534__$1;
(statearr_38551_38567[(2)] = null);

(statearr_38551_38567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___38557,out))
;
return ((function (switch__36644__auto__,c__36819__auto___38557,out){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_38552 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38552[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_38552[(1)] = (1));

return statearr_38552;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_38534){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_38534);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e38553){if((e38553 instanceof Object)){
var ex__36648__auto__ = e38553;
var statearr_38554_38568 = state_38534;
(statearr_38554_38568[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38534);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38553;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38569 = state_38534;
state_38534 = G__38569;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_38534){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_38534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___38557,out))
})();
var state__36821__auto__ = (function (){var statearr_38555 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_38555[(6)] = c__36819__auto___38557);

return statearr_38555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___38557,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__38571 = arguments.length;
switch (G__38571) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__36819__auto___38637 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___38637,out){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___38637,out){
return (function (state_38609){
var state_val_38610 = (state_38609[(1)]);
if((state_val_38610 === (7))){
var inst_38605 = (state_38609[(2)]);
var state_38609__$1 = state_38609;
var statearr_38611_38638 = state_38609__$1;
(statearr_38611_38638[(2)] = inst_38605);

(statearr_38611_38638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38610 === (1))){
var inst_38572 = (new Array(n));
var inst_38573 = inst_38572;
var inst_38574 = (0);
var state_38609__$1 = (function (){var statearr_38612 = state_38609;
(statearr_38612[(7)] = inst_38574);

(statearr_38612[(8)] = inst_38573);

return statearr_38612;
})();
var statearr_38613_38639 = state_38609__$1;
(statearr_38613_38639[(2)] = null);

(statearr_38613_38639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38610 === (4))){
var inst_38577 = (state_38609[(9)]);
var inst_38577__$1 = (state_38609[(2)]);
var inst_38578 = (inst_38577__$1 == null);
var inst_38579 = cljs.core.not(inst_38578);
var state_38609__$1 = (function (){var statearr_38614 = state_38609;
(statearr_38614[(9)] = inst_38577__$1);

return statearr_38614;
})();
if(inst_38579){
var statearr_38615_38640 = state_38609__$1;
(statearr_38615_38640[(1)] = (5));

} else {
var statearr_38616_38641 = state_38609__$1;
(statearr_38616_38641[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38610 === (15))){
var inst_38599 = (state_38609[(2)]);
var state_38609__$1 = state_38609;
var statearr_38617_38642 = state_38609__$1;
(statearr_38617_38642[(2)] = inst_38599);

(statearr_38617_38642[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38610 === (13))){
var state_38609__$1 = state_38609;
var statearr_38618_38643 = state_38609__$1;
(statearr_38618_38643[(2)] = null);

(statearr_38618_38643[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38610 === (6))){
var inst_38574 = (state_38609[(7)]);
var inst_38595 = (inst_38574 > (0));
var state_38609__$1 = state_38609;
if(cljs.core.truth_(inst_38595)){
var statearr_38619_38644 = state_38609__$1;
(statearr_38619_38644[(1)] = (12));

} else {
var statearr_38620_38645 = state_38609__$1;
(statearr_38620_38645[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38610 === (3))){
var inst_38607 = (state_38609[(2)]);
var state_38609__$1 = state_38609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38609__$1,inst_38607);
} else {
if((state_val_38610 === (12))){
var inst_38573 = (state_38609[(8)]);
var inst_38597 = cljs.core.vec(inst_38573);
var state_38609__$1 = state_38609;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38609__$1,(15),out,inst_38597);
} else {
if((state_val_38610 === (2))){
var state_38609__$1 = state_38609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38609__$1,(4),ch);
} else {
if((state_val_38610 === (11))){
var inst_38589 = (state_38609[(2)]);
var inst_38590 = (new Array(n));
var inst_38573 = inst_38590;
var inst_38574 = (0);
var state_38609__$1 = (function (){var statearr_38621 = state_38609;
(statearr_38621[(7)] = inst_38574);

(statearr_38621[(8)] = inst_38573);

(statearr_38621[(10)] = inst_38589);

return statearr_38621;
})();
var statearr_38622_38646 = state_38609__$1;
(statearr_38622_38646[(2)] = null);

(statearr_38622_38646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38610 === (9))){
var inst_38573 = (state_38609[(8)]);
var inst_38587 = cljs.core.vec(inst_38573);
var state_38609__$1 = state_38609;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38609__$1,(11),out,inst_38587);
} else {
if((state_val_38610 === (5))){
var inst_38582 = (state_38609[(11)]);
var inst_38574 = (state_38609[(7)]);
var inst_38577 = (state_38609[(9)]);
var inst_38573 = (state_38609[(8)]);
var inst_38581 = (inst_38573[inst_38574] = inst_38577);
var inst_38582__$1 = (inst_38574 + (1));
var inst_38583 = (inst_38582__$1 < n);
var state_38609__$1 = (function (){var statearr_38623 = state_38609;
(statearr_38623[(11)] = inst_38582__$1);

(statearr_38623[(12)] = inst_38581);

return statearr_38623;
})();
if(cljs.core.truth_(inst_38583)){
var statearr_38624_38647 = state_38609__$1;
(statearr_38624_38647[(1)] = (8));

} else {
var statearr_38625_38648 = state_38609__$1;
(statearr_38625_38648[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38610 === (14))){
var inst_38602 = (state_38609[(2)]);
var inst_38603 = cljs.core.async.close_BANG_(out);
var state_38609__$1 = (function (){var statearr_38627 = state_38609;
(statearr_38627[(13)] = inst_38602);

return statearr_38627;
})();
var statearr_38628_38649 = state_38609__$1;
(statearr_38628_38649[(2)] = inst_38603);

(statearr_38628_38649[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38610 === (10))){
var inst_38593 = (state_38609[(2)]);
var state_38609__$1 = state_38609;
var statearr_38629_38650 = state_38609__$1;
(statearr_38629_38650[(2)] = inst_38593);

(statearr_38629_38650[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38610 === (8))){
var inst_38582 = (state_38609[(11)]);
var inst_38573 = (state_38609[(8)]);
var tmp38626 = inst_38573;
var inst_38573__$1 = tmp38626;
var inst_38574 = inst_38582;
var state_38609__$1 = (function (){var statearr_38630 = state_38609;
(statearr_38630[(7)] = inst_38574);

(statearr_38630[(8)] = inst_38573__$1);

return statearr_38630;
})();
var statearr_38631_38651 = state_38609__$1;
(statearr_38631_38651[(2)] = null);

(statearr_38631_38651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___38637,out))
;
return ((function (switch__36644__auto__,c__36819__auto___38637,out){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_38632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38632[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_38632[(1)] = (1));

return statearr_38632;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_38609){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_38609);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e38633){if((e38633 instanceof Object)){
var ex__36648__auto__ = e38633;
var statearr_38634_38652 = state_38609;
(statearr_38634_38652[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38609);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38633;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38653 = state_38609;
state_38609 = G__38653;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_38609){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_38609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___38637,out))
})();
var state__36821__auto__ = (function (){var statearr_38635 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_38635[(6)] = c__36819__auto___38637);

return statearr_38635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___38637,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__38655 = arguments.length;
switch (G__38655) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__36819__auto___38725 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__36819__auto___38725,out){
return (function (){
var f__36820__auto__ = (function (){var switch__36644__auto__ = ((function (c__36819__auto___38725,out){
return (function (state_38697){
var state_val_38698 = (state_38697[(1)]);
if((state_val_38698 === (7))){
var inst_38693 = (state_38697[(2)]);
var state_38697__$1 = state_38697;
var statearr_38699_38726 = state_38697__$1;
(statearr_38699_38726[(2)] = inst_38693);

(statearr_38699_38726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38698 === (1))){
var inst_38656 = [];
var inst_38657 = inst_38656;
var inst_38658 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_38697__$1 = (function (){var statearr_38700 = state_38697;
(statearr_38700[(7)] = inst_38657);

(statearr_38700[(8)] = inst_38658);

return statearr_38700;
})();
var statearr_38701_38727 = state_38697__$1;
(statearr_38701_38727[(2)] = null);

(statearr_38701_38727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38698 === (4))){
var inst_38661 = (state_38697[(9)]);
var inst_38661__$1 = (state_38697[(2)]);
var inst_38662 = (inst_38661__$1 == null);
var inst_38663 = cljs.core.not(inst_38662);
var state_38697__$1 = (function (){var statearr_38702 = state_38697;
(statearr_38702[(9)] = inst_38661__$1);

return statearr_38702;
})();
if(inst_38663){
var statearr_38703_38728 = state_38697__$1;
(statearr_38703_38728[(1)] = (5));

} else {
var statearr_38704_38729 = state_38697__$1;
(statearr_38704_38729[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38698 === (15))){
var inst_38687 = (state_38697[(2)]);
var state_38697__$1 = state_38697;
var statearr_38705_38730 = state_38697__$1;
(statearr_38705_38730[(2)] = inst_38687);

(statearr_38705_38730[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38698 === (13))){
var state_38697__$1 = state_38697;
var statearr_38706_38731 = state_38697__$1;
(statearr_38706_38731[(2)] = null);

(statearr_38706_38731[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38698 === (6))){
var inst_38657 = (state_38697[(7)]);
var inst_38682 = inst_38657.length;
var inst_38683 = (inst_38682 > (0));
var state_38697__$1 = state_38697;
if(cljs.core.truth_(inst_38683)){
var statearr_38707_38732 = state_38697__$1;
(statearr_38707_38732[(1)] = (12));

} else {
var statearr_38708_38733 = state_38697__$1;
(statearr_38708_38733[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38698 === (3))){
var inst_38695 = (state_38697[(2)]);
var state_38697__$1 = state_38697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38697__$1,inst_38695);
} else {
if((state_val_38698 === (12))){
var inst_38657 = (state_38697[(7)]);
var inst_38685 = cljs.core.vec(inst_38657);
var state_38697__$1 = state_38697;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38697__$1,(15),out,inst_38685);
} else {
if((state_val_38698 === (2))){
var state_38697__$1 = state_38697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38697__$1,(4),ch);
} else {
if((state_val_38698 === (11))){
var inst_38661 = (state_38697[(9)]);
var inst_38665 = (state_38697[(10)]);
var inst_38675 = (state_38697[(2)]);
var inst_38676 = [];
var inst_38677 = inst_38676.push(inst_38661);
var inst_38657 = inst_38676;
var inst_38658 = inst_38665;
var state_38697__$1 = (function (){var statearr_38709 = state_38697;
(statearr_38709[(7)] = inst_38657);

(statearr_38709[(11)] = inst_38677);

(statearr_38709[(8)] = inst_38658);

(statearr_38709[(12)] = inst_38675);

return statearr_38709;
})();
var statearr_38710_38734 = state_38697__$1;
(statearr_38710_38734[(2)] = null);

(statearr_38710_38734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38698 === (9))){
var inst_38657 = (state_38697[(7)]);
var inst_38673 = cljs.core.vec(inst_38657);
var state_38697__$1 = state_38697;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38697__$1,(11),out,inst_38673);
} else {
if((state_val_38698 === (5))){
var inst_38661 = (state_38697[(9)]);
var inst_38658 = (state_38697[(8)]);
var inst_38665 = (state_38697[(10)]);
var inst_38665__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38661) : f.call(null,inst_38661));
var inst_38666 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38665__$1,inst_38658);
var inst_38667 = cljs.core.keyword_identical_QMARK_(inst_38658,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_38668 = ((inst_38666) || (inst_38667));
var state_38697__$1 = (function (){var statearr_38711 = state_38697;
(statearr_38711[(10)] = inst_38665__$1);

return statearr_38711;
})();
if(cljs.core.truth_(inst_38668)){
var statearr_38712_38735 = state_38697__$1;
(statearr_38712_38735[(1)] = (8));

} else {
var statearr_38713_38736 = state_38697__$1;
(statearr_38713_38736[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38698 === (14))){
var inst_38690 = (state_38697[(2)]);
var inst_38691 = cljs.core.async.close_BANG_(out);
var state_38697__$1 = (function (){var statearr_38715 = state_38697;
(statearr_38715[(13)] = inst_38690);

return statearr_38715;
})();
var statearr_38716_38737 = state_38697__$1;
(statearr_38716_38737[(2)] = inst_38691);

(statearr_38716_38737[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38698 === (10))){
var inst_38680 = (state_38697[(2)]);
var state_38697__$1 = state_38697;
var statearr_38717_38738 = state_38697__$1;
(statearr_38717_38738[(2)] = inst_38680);

(statearr_38717_38738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38698 === (8))){
var inst_38661 = (state_38697[(9)]);
var inst_38657 = (state_38697[(7)]);
var inst_38665 = (state_38697[(10)]);
var inst_38670 = inst_38657.push(inst_38661);
var tmp38714 = inst_38657;
var inst_38657__$1 = tmp38714;
var inst_38658 = inst_38665;
var state_38697__$1 = (function (){var statearr_38718 = state_38697;
(statearr_38718[(14)] = inst_38670);

(statearr_38718[(7)] = inst_38657__$1);

(statearr_38718[(8)] = inst_38658);

return statearr_38718;
})();
var statearr_38719_38739 = state_38697__$1;
(statearr_38719_38739[(2)] = null);

(statearr_38719_38739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__36819__auto___38725,out))
;
return ((function (switch__36644__auto__,c__36819__auto___38725,out){
return (function() {
var cljs$core$async$state_machine__36645__auto__ = null;
var cljs$core$async$state_machine__36645__auto____0 = (function (){
var statearr_38720 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38720[(0)] = cljs$core$async$state_machine__36645__auto__);

(statearr_38720[(1)] = (1));

return statearr_38720;
});
var cljs$core$async$state_machine__36645__auto____1 = (function (state_38697){
while(true){
var ret_value__36646__auto__ = (function (){try{while(true){
var result__36647__auto__ = switch__36644__auto__(state_38697);
if(cljs.core.keyword_identical_QMARK_(result__36647__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36647__auto__;
}
break;
}
}catch (e38721){if((e38721 instanceof Object)){
var ex__36648__auto__ = e38721;
var statearr_38722_38740 = state_38697;
(statearr_38722_38740[(5)] = ex__36648__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38697);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38721;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36646__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38741 = state_38697;
state_38697 = G__38741;
continue;
} else {
return ret_value__36646__auto__;
}
break;
}
});
cljs$core$async$state_machine__36645__auto__ = function(state_38697){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36645__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36645__auto____1.call(this,state_38697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36645__auto____0;
cljs$core$async$state_machine__36645__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36645__auto____1;
return cljs$core$async$state_machine__36645__auto__;
})()
;})(switch__36644__auto__,c__36819__auto___38725,out))
})();
var state__36821__auto__ = (function (){var statearr_38723 = (f__36820__auto__.cljs$core$IFn$_invoke$arity$0 ? f__36820__auto__.cljs$core$IFn$_invoke$arity$0() : f__36820__auto__.call(null));
(statearr_38723[(6)] = c__36819__auto___38725);

return statearr_38723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__36821__auto__);
});})(c__36819__auto___38725,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=cljs.core.async.js.map
