(defproject zcaudate/spirit "0.9.0"
  :description "systems. simplified"
  :url "https://www.github.com/zcaudate/spirit"
  :license {:name "The MIT License"
            :url "http://http://opensource.org/licenses/MIT"}
  :aliases {"test" ["run" "-m" "hara.test" "exit"]}
  ;:jvm-opts ["--add-modules" "java.xml.bind"]
  :dependencies [[org.clojure/clojure "1.8.0"] [org.clojure/core.async "0.4.474"] [zcaudate/hara.common "2.8.6"] [zcaudate/hara.component "2.8.6"] [zcaudate/hara.data "2.8.6"] [zcaudate/hara.event "2.8.6"] [zcaudate/hara.function "2.8.6"] [zcaudate/hara.string "2.8.6"] [com.datomic/datomic-free "0.9.5697"] [inflections "0.13.0"] [http-kit "2.3.0"] [compojure "1.6.1"] [cheshire "5.8.0"] [ring/ring "1.6.3"] [ring/ring-defaults "0.3.2"] [org.eclipse.jetty.websocket/websocket-client "9.4.11.v20180605"] [com.amazonaws/aws-java-sdk-dynamodb "1.11.345"] [com.rabbitmq/amqp-client "5.2.0"] [com.sun.mail/javax.mail "1.6.1"] [javax.mail/javax.mail-api "1.6.1"] [com.github.scribejava/scribejava-apis "5.5.0"] [zcaudate/spirit.protocol.icache "0.9.0"] [zcaudate/spirit.net.mail "0.9.0"] [zcaudate/spirit.core.schema "0.9.0"] [zcaudate/spirit.protocol.iexchange "0.9.0"] [zcaudate/spirit.io.datomic "0.9.0"] [zcaudate/spirit.core.cache "0.9.0"] [zcaudate/spirit.protocol.imail "0.9.0"] [zcaudate/spirit.io.rabbitmq "0.9.0"] [zcaudate/spirit.core.pipeline "0.9.0"] [zcaudate/spirit.core.graph "0.9.0"] [zcaudate/spirit.core.atom "0.9.0"] [zcaudate/spirit.core.keystore "0.9.0"] [zcaudate/spirit.protocol.igraph "0.9.0"] [zcaudate/spirit.protocol.itransport "0.9.0"] [zcaudate/spirit.protocol.ikeystore "0.9.0"] [zcaudate/spirit.core.exchange "0.9.0"] [zcaudate/spirit.common "0.9.0"]]
  
 :injections  [(require  '[lucid.core.inject :as inject]
                         'hara.test
                         'lucid.unit
                         'lucid.publish)
               (inject/in [lucid.core.inject :refer [inject [in inject-in]]]
                          [hara.io.project project]
                           
                          clojure.core
                          [lucid.mind .& .> .? .* .% .%> .>var .>ns])]
  :java-source-paths ["java"]
  :publish {:theme  "stark"
            
            :template {:site   "spirit"
                       :author "Chris Zheng"
                       :email  "z@caudate.me"
                       :icon   "favicon"
                       :tracking-enabled "true"
                       :tracking "UA-31320512-2"}

            :files {"index"
                    {:input "test/documentation/home_spirit.clj"
                     :title "home"
                     :subtitle "systems. simplified."}
                    "spirit-core-atom"
                    {:input "test/documentation/spirit_core_atom.clj"
                     :title "core.atom"
                     :subtitle "core.atom API Reference"}
                    "spirit-core-cache"
                    {:input "test/documentation/spirit_core_cache.clj"
                     :title "core.cache"
                     :subtitle "core.cache API Reference"}
                    "spirit-core-exchange"
                    {:input "test/documentation/spirit_core_exchange.clj"
                     :title "core.exchange"
                     :subtitle "core.exchange API Reference"}
                    "spirit-core-graph"
                    {:input "test/documentation/spirit_core_graph.clj"
                     :title "core.graph"
                     :subtitle "core.graph API Reference"}
                    "spirit-core-keystore"
                    {:input "test/documentation/spirit_core_keystore.clj"
                     :title "core.keystore"
                     :subtitle "core.keystore API Reference"}
                    "spirit-core-pipeline"
                    {:input "test/documentation/spirit_core_pipeline.clj"
                     :title "core.pipeline"
                     :subtitle "core.pipeline API Reference"}
                    "spirit-core-schema"
                    {:input "test/documentation/spirit_core_schema.clj"
                     :title "core.schema"
                     :subtitle "core.schema API Reference"}
                     "spirit-io-datomic"
                    {:input "test/documentation/spirit_io_datomic.clj"
                     :title "io.datomic"
                     :subtitle "datomic API Reference"}
                    "spirit-io-rabbitmq"
                    {:input "test/documentation/spirit_io_rabbitmq.clj"
                     :title "io.rabbitmq"
                     :subtitle "rabbitmq API Reference"}
                    "spirit-net-mail"
                    {:input "test/documentation/spirit_net_mail.clj"
                     :title "net.mail"
                     :subtitle "network API Reference"}
                    "spirit-net-oauth"
                    {:input "test/documentation/spirit_net_oauth.clj"
                     :title "net.oauth"
                     :subtitle "network API Reference"}}}
  
   
  
   )
