(defproject zcaudate/spirit "0.8.0"
  :description "data. simplified"
  :url "https://www.github.com/zcaudate/spirit"
  :license {:name "The MIT License"
            :url "http://http://opensource.org/licenses/MIT"}
  :aliases {"test" ["run" "-m" "hara.test" "exit"]}
  ;:jvm-opts ["--add-modules" "java.xml.bind"]
  :dependencies [[org.clojure/clojure "1.8.0"] [org.clojure/core.async "0.4.474"] [zcaudate/hara.common "2.8.4"] [zcaudate/hara.component "2.8.4"] [zcaudate/hara.data "2.8.4"] [zcaudate/hara.event "2.8.4"] [zcaudate/hara.function "2.8.4"] [zcaudate/hara.string "2.8.4"] [com.datomic/datomic-free "0.9.5697"] [inflections "0.13.0"] [http-kit "2.3.0"] [compojure "1.6.1"] [cheshire "5.8.0"] [ring/ring "1.6.3"] [ring/ring-defaults "0.3.2"] [org.eclipse.jetty.websocket/websocket-client "9.4.10.RC1"] [com.amazonaws/aws-java-sdk-dynamodb "1.11.342"] [com.draines/postal "2.0.2"] [com.rabbitmq/amqp-client "5.1.2"] [zcaudate/spirit.data.exchange "0.8.0"] [zcaudate/spirit.protocol.icache "0.8.0"] [zcaudate/spirit.data.graph "0.8.0"] [zcaudate/spirit.data.atom "0.8.0"] [zcaudate/spirit.protocol.iexchange "0.8.0"] [zcaudate/spirit.data.table "0.8.0"] [zcaudate/spirit.protocol.imail "0.8.0"] [zcaudate/spirit.data.cache "0.8.0"] [zcaudate/spirit.data.schema "0.8.0"] [zcaudate/spirit.rabbitmq "0.8.0"] [zcaudate/spirit.protocol.igraph "0.8.0"] [zcaudate/spirit.protocol.itransport "0.8.0"] [zcaudate/spirit.datomic "0.8.0"] [zcaudate/spirit.protocol.ikeystore "0.8.0"] [zcaudate/spirit.data.pipeline "0.8.0"] [zcaudate/spirit.data.keystore "0.8.0"] [zcaudate/spirit.common "0.8.0"]]
                
 :injections  [(require  '[lucid.core.inject :as inject]
                         'hara.test
                         'lucid.unit
                         'lucid.publish)
               (inject/in [lucid.core.inject :refer [inject [in inject-in]]]
                          [hara.io.project project]
                           
                          clojure.core
                          [lucid.mind .& .> .? .* .% .%> .>var .>ns]
                          [lucid.git git])]
  :java-source-paths ["java"]
  :publish {:theme  "stark"
            
            :template {:site   "spirit"
                       :author "Chris Zheng"
                       :email  "z@caudate.me"
                       :icon   "favicon"
                       :tracking-enabled "true"
                       :tracking "UA-31320512-2"}

            :files {"index"
                    {:input "test/documentation/home_spirit.clj"
                     :title "home"
                     :subtitle "data. simplified."}
                    "spirit-datomic"
                    {:input "test/documentation/spirit_datomic.clj"
                     :title "datomic"
                     :subtitle "datomic API Reference"}
                    "spirit-httpkit"
                    {:input "test/documentation/spirit_httpkit.clj"
                     :title "httpkit"
                     :subtitle "httpkit API Reference"}
                    "spirit-rabbitmq"
                    {:input "test/documentation/spirit_rabbitmq.clj"
                     :title "rabbitmq"
                     :subtitle "rabbitmq API Reference"}
                    "spirit-data-atom"
                    {:input "test/documentation/spirit_data_atom.clj"
                     :title "data.atom"
                     :subtitle "data.atom API Reference"}
                    "spirit-data-cache"
                    {:input "test/documentation/spirit_data_cache.clj"
                     :title "data.cache"
                     :subtitle "data.cache API Reference"}
                    "spirit-data-exchange"
                    {:input "test/documentation/spirit_data_exchange.clj"
                     :title "data.exchange"
                     :subtitle "data.exchange API Reference"}
                    "spirit-data-graph"
                    {:input "test/documentation/spirit_data_graph.clj"
                     :title "data.graph"
                     :subtitle "data.graph API Reference"}
                    "spirit-data-keystore"
                    {:input "test/documentation/spirit_data_keystore.clj"
                     :title "data.keystore"
                     :subtitle "data.keystore API Reference"}
                    "spirit-data-pipeline"
                    {:input "test/documentation/spirit_data_pipeline.clj"
                     :title "data.pipeline"
                     :subtitle "data.pipeline API Reference"}
                    "spirit-data-schema"
                    {:input "test/documentation/spirit_data_schema.clj"
                     :title "data.schema"
                     :subtitle "data.schema API Reference"}
                    "spirit-data-table"
                    {:input "test/documentation/spirit_data_table.clj"
                     :title "data.table"
                     :subtitle "data.table API Reference"}
                    "spirit-network"
                    {:input "test/documentation/spirit_network.clj"
                     :title "network"
                     :subtitle "network API Reference"}}}
  
   
  
   )
