(defproject zcaudate/spirit.protocol.imail "0.9.1"
  :description "systems. simplified"
  :url "https://www.github.com/zcaudate/spirit"
  :license {:name "The MIT License"
            :url "http://http://opensource.org/licenses/MIT"}
  :aliases {"test" ["run" "-m" "hara.test" "exit"]}
  ;:jvm-opts ["--add-modules" "java.xml.bind"]
  :dependencies [[org.clojure/clojure "1.8.0"]]
  
 :injections  [(require  '[lucid.core.inject :as inject])
               (inject/in [hara.io.project project]
                          [clojure.tools.namespace.repl refresh]
                          [lucid.package pull]
                          [lucid.unit all-functions      
                                      all-missing        
                                      all-orphaned       
                                      all-tests          
                                      all-todos          
                                      arrange
                                      arrange-project    
                                      exclude            
                                      import             
                                      import-project     
                                      in-order?          
                                      missing            
                                      orphaned     
                                      purge              
                                      scaffold           
                                      scaffold-project   
                                      stats
                                      todos]
                          
                          distribute
                          [lucid.distribute deploy install manifest]

                          test
                          [hara.test run run-namespace]

                          publish
                          [lucid.publish publish publish-all copy-assets]

                          clojure.core
                          [lucid.mind .& .> .? .* .% .%> .>var .>ns])]
  :java-source-paths ["java"]
  :publish {:theme  "stark"
            
            :template {:site   "spirit"
                       :author "Chris Zheng"
                       :email  "z@caudate.me"
                       :icon   "favicon"
                       :tracking-enabled "true"
                       :tracking "UA-31320512-2"}

            :files {"index"
                    {:input "test/documentation/home_spirit.clj"
                     :title "home"
                     :subtitle "systems. simplified."}
                    "spirit-core"
                    {:input "test/documentation/spirit_core.clj"
                     :title "core"
                     :subtitle "common core methods"}
                    "spirit-core-cache"
                    {:input "test/documentation/spirit_core_cache.clj"
                     :title "core.cache"
                     :subtitle "simple cache interface"}
                    "spirit-core-exchange"
                    {:input "test/documentation/spirit_core_exchange.clj"
                     :title "core.exchange"
                     :subtitle "simple exchange interface"}
                    "spirit-core-graph"
                    {:input "test/documentation/spirit_core_graph.clj"
                     :title "core.graph"
                     :subtitle "simple graph query interface"}
                    "spirit-core-keystore"
                    {:input "test/documentation/spirit_core_keystore.clj"
                     :title "core.keystore"
                     :subtitle "simple keystore interface"}
                     "spirit-io-datomic"
                    {:input "test/documentation/spirit_io_datomic.clj"
                     :title "io.datomic"
                     :subtitle "graph query interface for datomic"}
                    "spirit-io-rabbitmq"
                    {:input "test/documentation/spirit_io_rabbitmq.clj"
                     :title "io.rabbitmq"
                     :subtitle "exchange interface for rabbitmq"}
                    "spirit-net-mail"
                    {:input "test/documentation/spirit_net_mail.clj"
                     :title "net.mail"
                     :subtitle "simple mail interface"}}}
  
   
  
   )
