(ns spirit.net.mail.common
  (:import javax.mail.internet.MimeMessage
           javax.mail.Session
           java.util.Properties
           java.io.StringBufferInputStream))

(defn to-string
  "converts a Message object into a string
 
   (-> (message/message {:from \"a@a.com\"
                         :to [\"b@b.com\"]
                         :body \"HELLO WORLD\"})
       (to-string [\"Date\" \"Message-ID\" \"Content-Transfer-Encoding\" \"Content-Type\"])
       (string/split-lines))
   => [\"From: a@a.com\"
      \"To: b@b.com\"
       \"MIME-Version: 1.0\"
       \"\"
       \"HELLO WORLD\"]"
  {:added "0.8"}
  ([message] (to-string message nil))
  ([message ignore]
   (with-open [out (java.io.ByteArrayOutputStream.)]
     (if (empty? ignore)
       (.writeTo message out)
       (.writeTo message out (into-array ignore)))
     (str out))))

(defn from-string
  "converts a string into a Message object
   
   (-> (message/message {:from \"a@a.com\"
                         :to [\"b@b.com\"]
                         :body \"HELLO WORLD\"})
       (to-string)
       (from-string)
       (object/to-data))
   => (contains {:from \"a@a.com\"
                 :to [\"b@b.com\"]
                :body \"HELLO WORLD\"})"
  {:added "0.8"}
  [s]
  (MimeMessage. (Session/getInstance (Properties.))
                (StringBufferInputStream. s)))
