(ns spirit.mail.interop.wrap)

(defn wrap-suppress
  "Suppresses the function it is wrapping
 
   ((wrap-suppress (fn [_] (throw (Exception.)))) :hello)
   => nil"
  {:added "0.8"}
  [f]
  (fn [m] (try (f m)
               (catch Throwable t))))

(defn wrap-first
  "Returns the first element of the function it is wrapping
 
   ((wrap-first identity) [1 2 3])
   => 1"
  {:added "0.8"}
  [f]
  (fn [m] (first (f m))))

