(ns spirit.mail.interop.property)

;; SMTP
;; https://javaee.github.io/javamail/docs/api/com/sun/mail/smtp/package-summary.html
(def smtp
  {"mail.smtp.user" String
   "mail.smtp.host" String
   "mail.smtp.port" Integer
   "mail.smtp.connectiontimeout" Integer
   "mail.smtp.timeout" Integer
   "mail.smtp.writetimeout" Integer
   "mail.smtp.from" String
   "mail.smtp.localhost" String
   "mail.smtp.localaddress" String
   "mail.smtp.localport" Integer
   "mail.smtp.ehlo" Boolean
   "mail.smtp.auth" Boolean
   "mail.smtp.auth.mechanisms" String
   "mail.smtp.auth.login.disable" Boolean
   "mail.smtp.auth.plain.disable" Boolean
   "mail.smtp.auth.digest-md5.disable" Boolean
   "mail.smtp.auth.ntlm.disable" Boolean
   "mail.smtp.auth.ntlm.domain" String
   "mail.smtp.auth.ntlm.flags" Integer
   "mail.smtp.auth.xoauth2.disable" Boolean
   "mail.smtp.submitter" String
   "mail.smtp.dsn.notify" String
   "mail.smtp.dsn.ret" String
   "mail.smtp.allow8bitmime" Boolean
   "mail.smtp.sendpartial" Boolean
   "mail.smtp.sasl.enable" Boolean
   "mail.smtp.sasl.mechanisms" String
   "mail.smtp.sasl.authorizationid" String
   "mail.smtp.sasl.realm" String
   "mail.smtp.sasl.usecanonicalhostname" Boolean
   "mail.smtp.quitwait" Boolean
   "mail.smtp.reportsuccess" Boolean
   "mail.smtp.socketFactory" javax.net.SocketFactory
   "mail.smtp.socketFactory.class" String
   "mail.smtp.socketFactory.fallback" Boolean
   "mail.smtp.socketFactory.port" Integer
   "mail.smtp.ssl.enable" Boolean
   "mail.smtp.ssl.checkserveridentity" Boolean
   "mail.smtp.ssl.trust" String
   "mail.smtp.ssl.socketFactory" javax.net.ssl.SSLSocketFactory
   "mail.smtp.ssl.socketFactory.class" String
   "mail.smtp.ssl.socketFactory.port" Integer
   "mail.smtp.ssl.protocols" String
   "mail.smtp.ssl.ciphersuites" String
   "mail.smtp.starttls.enable" Boolean
   "mail.smtp.starttls.required" Boolean
   "mail.smtp.proxy.host" String
   "mail.smtp.proxy.port" String
   "mail.smtp.socks.host" String
   "mail.smtp.socks.port" String
   "mail.smtp.mailextension" String
   "mail.smtp.userset" Boolean
   "mail.smtp.noop.strict" Boolean})

;; POP3
;; https://javaee.github.io/javamail/docs/api/com/sun/mail/pop3/package-summary.html
(def pop3
  {"mail.pop3.user" String
   "mail.pop3.host" String
   "mail.pop3.port" Integer
   "mail.pop3.connectiontimeout" Integer
   "mail.pop3.timeout" Integer
   "mail.pop3.writetimeout" Integer
   "mail.pop3.rsetbeforequit" Boolean
   "mail.pop3.message.class" String
   "mail.pop3.localaddress" String
   "mail.pop3.localport" Integer
   "mail.pop3.apop.enable" Boolean
   "mail.pop3.socketFactory" javax.net.SocketFactory
   "mail.pop3.socketFactory.class" String
   "mail.pop3.socketFactory.fallback" Boolean
   "mail.pop3.socketFactory.port" Integer
   "mail.pop3.ssl.enable" Boolean
   "mail.pop3.ssl.checkserveridentity" Boolean
   "mail.pop3.ssl.trust" String
   "mail.pop3.ssl.socketFactory" javax.net.ssl.SSLSocketFactory
   "mail.pop3.ssl.socketFactory.class" String
   "mail.pop3.ssl.socketFactory.port" Integer
   "mail.pop3.ssl.protocols" String
   "mail.pop3.ssl.ciphersuites" String
   "mail.pop3.starttls.enable" Boolean
   "mail.pop3.starttls.required" Boolean
   "mail.pop3.proxy.host" String
   "mail.pop3.proxy.port" String
   "mail.pop3.socks.host" String
   "mail.pop3.socks.port" String
   "mail.pop3.disabletop" Boolean
   "mail.pop3.disablecapa" Boolean
   "mail.pop3.forgettopheaders" Boolean
   "mail.pop3.filecache.enable" Boolean
   "mail.pop3.filecache.dir" String
   "mail.pop3.cachewriteto" Boolean
   "mail.pop3.keepmessagecontent" Boolean
   "mail.pop3.finalizecleanclose" Boolean})

;; IMAP
;; https://javaee.github.io/javamail/docs/api/com/sun/mail/imap/package-summary.html
(def imap
  {"mail.imap.user" String
   "mail.imap.host" String
   "mail.imap.port" Integer
   "mail.imap.partialfetch" Boolean
   "mail.imap.fetchsize" Integer
   "mail.imap.peek" Boolean
   "mail.imap.ignorebodystructuresize" Boolean
   "mail.imap.connectiontimeout" Integer
   "mail.imap.timeout" Integer
   "mail.imap.writetimeout" Integer
   "mail.imap.statuscachetimeout" Integer
   "mail.imap.appendbuffersize" Integer
   "mail.imap.connectionpoolsize" Integer
   "mail.imap.connectionpooltimeout" Integer
   "mail.imap.separatestoreconnection" Boolean
   "mail.imap.allowreadonlyselect" Boolean
   "mail.imap.auth.mechanisms" String
   "mail.imap.auth.login.disable" Boolean
   "mail.imap.auth.plain.disable" Boolean
   "mail.imap.auth.ntlm.disable" Boolean
   "mail.imap.auth.ntlm.domain" String
   "mail.imap.auth.ntlm.flags" Integer
   "mail.imap.auth.xoauth2.disable" Boolean
   "mail.imap.proxyauth.user" String
   "mail.imap.localaddress" String
   "mail.imap.localport" Integer
   "mail.imap.sasl.enable" Boolean
   "mail.imap.sasl.mechanisms" String
   "mail.imap.sasl.authorizationid" String
   "mail.imap.sasl.realm" String
   "mail.imap.sasl.usecanonicalhostname" Boolean
   "mail.imap.sasl.xgwtrustedapphack.enable" Boolean
   "mail.imap.socketFactory" javax.net.SocketFactory
   "mail.imap.socketFactory.class" String
   "mail.imap.socketFactory.fallback" Boolean
   "mail.imap.socketFactory.port" Integer
   "mail.imap.usesocketchannels" Boolean
   "mail.imap.ssl.enable" Boolean
   "mail.imap.ssl.checkserveridentity" Boolean
   "mail.imap.ssl.trust" String
   "mail.imap.ssl.socketFactory" javax.net.ssl.SSLSocketFactory
   "mail.imap.ssl.socketFactory.class" String
   "mail.imap.ssl.socketFactory.port" Integer
   "mail.imap.ssl.protocols" String
   "mail.imap.ssl.ciphersuites" String
   "mail.imap.starttls.enable" Boolean
   "mail.imap.starttls.required" Boolean
   "mail.imap.proxy.host" String
   "mail.imap.proxy.port" String
   "mail.imap.socks.host" String
   "mail.imap.socks.port" String
   "mail.imap.minidletime" Integer
   "mail.imap.enableresponseevents" Boolean
   "mail.imap.enableimapevents" Boolean
   "mail.imap.throwsearchexception" Boolean
   "mail.imap.folder.class" String
   "mail.imap.closefoldersonstorefailure" Boolean
   "mail.imap.finalizecleanclose" Boolean
   "mail.imap.referralexception" Boolean
   "mail.imap.compress.enable" Boolean
   "mail.imap.compress.level" Integer
   "mail.imap.compress.strategy" [Integer Boolean]})
