(defproject zcaudate/spirit.data.cache "0.8.1"
  :description "data. simplified"
  :url "https://www.github.com/zcaudate/spirit"
  :license {:name "The MIT License"
            :url "http://http://opensource.org/licenses/MIT"}
  :aliases {"test" ["run" "-m" "hara.test" "exit"]}
  ;:jvm-opts ["--add-modules" "java.xml.bind"]
  :dependencies [[org.clojure/clojure "1.8.0"] [zcaudate/hara.component "2.8.6"] [zcaudate/spirit.protocol.icache "0.8.1"] [zcaudate/spirit.data.atom "0.8.1"]]
  
 :injections  [(require  '[lucid.core.inject :as inject]
                         'hara.test
                         'lucid.unit
                         'lucid.publish)
               (inject/in [lucid.core.inject :refer [inject [in inject-in]]]
                          [hara.io.project project]
                           
                          clojure.core
                          [lucid.mind .& .> .? .* .% .%> .>var .>ns])]
  :java-source-paths ["java"]
  :publish {:theme  "stark"
            
            :template {:site   "spirit"
                       :author "Chris Zheng"
                       :email  "z@caudate.me"
                       :icon   "favicon"
                       :tracking-enabled "true"
                       :tracking "UA-31320512-2"}

            :files {"index"
                    {:input "test/documentation/home_spirit.clj"
                     :title "home"
                     :subtitle "data. simplified."}
                    "spirit-datomic"
                    {:input "test/documentation/spirit_datomic.clj"
                     :title "datomic"
                     :subtitle "datomic API Reference"}
                    "spirit-httpkit"
                    {:input "test/documentation/spirit_httpkit.clj"
                     :title "httpkit"
                     :subtitle "httpkit API Reference"}
                    "spirit-rabbitmq"
                    {:input "test/documentation/spirit_rabbitmq.clj"
                     :title "rabbitmq"
                     :subtitle "rabbitmq API Reference"}
                    "spirit-data-atom"
                    {:input "test/documentation/spirit_data_atom.clj"
                     :title "data.atom"
                     :subtitle "data.atom API Reference"}
                    "spirit-data-cache"
                    {:input "test/documentation/spirit_data_cache.clj"
                     :title "data.cache"
                     :subtitle "data.cache API Reference"}
                    "spirit-data-exchange"
                    {:input "test/documentation/spirit_data_exchange.clj"
                     :title "data.exchange"
                     :subtitle "data.exchange API Reference"}
                    "spirit-data-graph"
                    {:input "test/documentation/spirit_data_graph.clj"
                     :title "data.graph"
                     :subtitle "data.graph API Reference"}
                    "spirit-data-keystore"
                    {:input "test/documentation/spirit_data_keystore.clj"
                     :title "data.keystore"
                     :subtitle "data.keystore API Reference"}
                    "spirit-data-pipeline"
                    {:input "test/documentation/spirit_data_pipeline.clj"
                     :title "data.pipeline"
                     :subtitle "data.pipeline API Reference"}
                    "spirit-data-schema"
                    {:input "test/documentation/spirit_data_schema.clj"
                     :title "data.schema"
                     :subtitle "data.schema API Reference"}
                    "spirit-network"
                    {:input "test/documentation/spirit_network.clj"
                     :title "network"
                     :subtitle "network API Reference"}}}
  
   
  
   )
