(ns lucid.query.match.actual
  (:require [lucid.legacy.match :as match]))

(defrecord ActualPattern [expression])

(defn actual-pattern
  "constructs a pattern for match, used to match actual sets `#{:a :b}` in code
 
   ((pattern/pattern-fn (actual-pattern '_)) '_)
   => true
   
   ((pattern/pattern-fn (actual-pattern #{:a :b})) #{:a :b})
   => true"
  {:added "1.2"}
  [expression]
  (case expression
    '_  (ActualPattern. '(symbol "_"))
    (ActualPattern. expression)))

(defmethod match/emit-pattern ActualPattern
  [pat] pat)

(defmethod match/to-source ActualPattern
  [pat ocr]
  (let [v (:expression pat)
        v (if (-> v meta :%) (eval v) v)]
    `(= ~v ~ocr)))

(defmethod match/groupable? [ActualPattern ActualPattern]
  [a b]
  (and (= (:expression a)
          (:expression b))
       (= (-> a meta :%)
          (-> b meta :%))))
