(ns lucid.publish.link.api
  (:require [hara.io.file :as fs]
            [lucid.core.code :as code]))

(defn external-vars
  "grabs external vars from the `ns/import` form
 
   (external-vars (project/file-lookup (project/project))
                  'lucid.publish)
   => '{lucid.publish.theme [deploy]}"
  {:added "1.2"}
  [lookup ns]
  (if-let [path (lookup ns)]
    (->> (fs/code path)
         (filter #(-> % first (= 'ns/import)))
         (mapcat #(->> % rest (partition 2)))
         (map vec)
         (into {}))))

(defn create-api-table
  "creates a api table for publishing"
  {:added "1.2"}
  [references project namespace]
  (let [lookup  (:lookup project)
        all-vars (-> (external-vars lookup namespace)
                     (assoc namespace :all))
        live-vars (do (require namespace)
                      (ns-interns namespace))]
    (reduce-kv (fn [table ns vals]
                 (let [relative-to-root #(if % (->> % (fs/relativize (:root project)) str))
                       vals (if (= :all vals)
                              (-> ns references keys)
                              vals)]
                   (reduce (fn [out v]
                             (let [entry (-> (get-in references [ns v])
                                             (update-in [:test :code] code/join-nodes)
                                             (update-in [:test :path] relative-to-root)
                                             (update-in [:source :path] relative-to-root)
                                             (assoc :origin (symbol (str ns "/" v))
                                                    :arglists (-> (get live-vars v)
                                                                  meta
                                                                  :arglists)))]
                               (assoc out v entry)))
                           table
                           vals)))
               {}
               all-vars)))

(defn link-apis
  "links all the api source and test files to the elements"
  {:added "1.2"}
  [{:keys [references project] :as interim} name]
  (update-in interim [:articles name :elements]
             (fn [elements]
               (mapv (fn [{:keys [type namespace] :as element}]                       
                       (if (= type :api)
                         (-> element
                             (assoc :project project)
                             (assoc :table
                                    (create-api-table references
                                                      project
                                                      (symbol namespace))))
                         element))
                     elements))))
