(ns lucid.publish.collect.api
  (:require [lucid.core.code :as code]
            [lucid.publish.collect.reference :as reference]))

(defn collect-apis
  "gets all the `api` tags in the document
 
   (let [project (project/project)
         project (assoc project :lookup (project/file-lookup project))
         elems   (parse/parse-file \"test/documentation/lucid_core.clj\" project)
         bundle  {:articles {\"lucid-core\" {:elements elems}}
                  :references {}
                  :project project}]
    (with-redefs [reference/reference-namespaces (fn [_ _ namespaces] namespaces)]
       (-> (collect-apis bundle \"lucid-core\")
           :references)))
   => '[lucid.core.asm lucid.core.code lucid.core.debug
        lucid.core.inject lucid.core.java lucid.core.namespace]"
  {:added "1.2"}
  [{:keys [articles project] :as interim} name]
  (let [all    (->> (get-in articles [name :elements])
                    (filter #(-> % :type (= :api))))
        namespaces (-> (map (comp symbol :namespace) all))]
    (-> interim
        (update-in [:references]
                   (fnil (fn [references]
                           (reference/reference-namespaces references
                                                           (:lookup project)
                                                           namespaces))
                         {})))))


