(ns lucid.distribute
  (:require [hara.namespace.import :as ns]
            [lucid.package :as package]
            [lucid.distribute
             [common :as common]
             [manifest :as manifest]
             [split :as split]]
            [hara.io
             [file :as fs]
             [project :as project]]))

(ns/import lucid.distribute.manifest [manifest]
           lucid.distribute.split [clean split])

(defn install
  "installs all subpackages according to `:distribute` key
 
   (install (project/project))"
  {:added "1.2"}
  ([] (install (project/project)))
  ([project]
   (install project (manifest/manifest project)))
  ([project manifest]
   (let [packages (split/split project manifest)
         length (count packages)]
     (doall (map-indexed
             (fn [index package]
               (println (str "\nDeploying " package " (" (inc index) " of " length ")"))
               (try (-> (common/interim-path project)
                        (str "/branches/" package "/project.clj")
                        (project/project)
                        (package/install-project))
                    (catch Throwable t
                      (println t)
                      (println "FAILED for " package))))
             packages))
     
     (println "\nInstalling ROOT")
     (-> (common/interim-path project)
         (str "/root/project.clj")
         (project/project)
         (package/install-project)))))

(defn deploy
  "installs all subpackages according to `:distribute` key
 
   (deploy (project/project))"
  {:added "1.2"}
  ([] (deploy (project/project)))
  ([project]
   (deploy project (manifest/manifest project)))
  ([project manifest]
   (deploy project manifest {}))
  ([project manifest opts]
   (let [packages (split/split project manifest)
         length (count packages)]
     (doall (map-indexed
             (fn [index package]
               (println (str "\nDeploying " package " (" (inc index) " of " length ")"))
               (try (-> (common/interim-path project)
                        (str "/branches/" package "/project.clj")
                        (project/project)
                        (package/deploy-project opts))
                    (catch Throwable t
                      (println t)
                      (println "FAILED for " package))))
             packages))
     
     (println "\nDeploying ROOT")
     (-> (common/interim-path project)
         (str "/root/project.clj")
         (project/project)
         (package/deploy-project opts)))))

(defn deploy-current
  "installs all in the current project
 
   (deploy-current {:authentication {:username \"hello\"
                                    :password \"world\"}})"
  {:added "1.2"}
  ([]
   (deploy-current {}))
  ([opts]
   (let [project  (project/project)
         manifest (manifest/manifest project)]
     (deploy project manifest opts))))

(defn redeploy
  ([selected] (redeploy (project/project) {}))
  ([selected project opts]
   (let [length (count selected)]
     (doall (map-indexed
             (fn [index package]
               (println (str "\nRedeploying " package " (" (inc index) " of " length ")"))
               (try (-> (common/interim-path project)
                        (str "/branches/" package "/project.clj")
                        (project/project)
                        (package/deploy-project opts))
                    (catch Throwable t
                      (println t)
                      (println "FAILED for " package))))
             selected)))))

(defn redeploy-root
  ([] (redeploy-root (project/project) {}))
  ([project opts]
   (println "\nRedeploying ROOT")
   (-> (common/interim-path project)
       (str "/root/project.clj")
       (project/project)
       (package/deploy-project opts))))
