(ns lucid.aether.listener
  (:require [hara.object :as object])
  (:import [org.eclipse.aether
            RepositoryListener
            RepositoryEvent]
           [org.eclipse.aether.transfer
            TransferListener
            TransferEvent
            TransferResource]))

(object/map-like
 TransferEvent
 {:tag "transfer.event"
  :read  :class
  :exclude [:session]}

 TransferResource
 {:tag "transfer.resource"
  :read  :class
  :exclude [:trace]})

(def +no-op+ (fn [_]))

(deftype TransferListenerProxy [fns]
  TransferListener
  (transferCorrupted [_ e] ((or (:corrupted fns) +no-op+) (object/to-map e)))
  (transferFailed [_ e] ((or (:failed fns) +no-op+) (object/to-map e)))
  (transferInitiated [_ e] ((or (:initiated fns) +no-op+) (object/to-map e)))
  (transferProgressed [_ e] ((or (:corrupted fns) +no-op+) (object/to-map e)))
  (transferStarted [_ e] ((or (:started fns) +no-op+) (object/to-map e)))
  (transferSucceeded [_ e] ((or (:succeded fns) +no-op+) (object/to-map e))))

(def default-transfer-listener
  (TransferListenerProxy. {:succeded (fn [{:keys [request-type
                                                  resource]}]
                                       (println (str request-type ": " (:resource-name resource) " has SUCCEDED")))
                           :failed   (fn [{:keys [request-type
                                                  resource]}]
                                       (println (str request-type ": " (:file resource) " has FAILED")))}))

(object/map-like
 RepositoryEvent
 {:tag "repo.event"
  :read  :class
  :exclude [:repository :session :trace]})

(deftype RepositoryListenerProxy [fns]
  RepositoryListener
  (artifactDeployed     [_ e]  ((or (-> fns  :artifact :deployed) +no-op+) (object/to-map e)))
  (artifactDeploying    [_ e]  ((or (-> fns  :artifact :deploying) +no-op+) (object/to-map e)))
  (artifactDescriptorInvalid  [_ e]  ((or (-> fns  :artifact :invalid) +no-op+) (object/to-map e)))
  (artifactDescriptorMissing  [_ e]  ((or (-> fns  :artifact :missing) +no-op+) (object/to-map e)))
  (artifactDownloaded   [_ e]  ((or (-> fns  :artifact :downloaded) +no-op+) (object/to-map e)))
  (artifactDownloading  [_ e]  ((or (-> fns  :artifact :downloading) +no-op+) (object/to-map e)))
  (artifactInstalled    [_ e]  ((or (-> fns  :artifact :installed) +no-op+) (object/to-map e)))
  (artifactInstalling   [_ e]  ((or (-> fns  :artifact :installing) +no-op+) (object/to-map e)))
  (artifactResolved     [_ e]  ((or (-> fns  :artifact :resolved) +no-op+) (object/to-map e)))
  (artifactResolving    [_ e]  ((or (-> fns  :artifact :resolving) +no-op+) (object/to-map e)))

  (metadataDeployed     [_ e]  ((or (-> fns  :metadata :deployed) +no-op+) (object/to-map e)))
  (metadataDeploying    [_ e]  ((or (-> fns  :metadata :deploying) +no-op+) (object/to-map e)))
  (metadataDownloaded   [_ e]  ((or (-> fns  :metadata :downloaded) +no-op+) (object/to-map e)))
  (metadataDownloading  [_ e]  ((or (-> fns  :metadata :downloading) +no-op+) (object/to-map e)))
  (metadataInstalled    [_ e]  ((or (-> fns  :metadata :installed) +no-op+) (object/to-map e)))
  (metadataInstalling   [_ e]  ((or (-> fns  :metadata :installing) +no-op+) (object/to-map e)))
  (metadataResolved     [_ e]  ((or (-> fns  :metadata :resolved) +no-op+) (object/to-map e)))
  (metadataResolving    [_ e]  ((or (-> fns  :metadata :resolving) +no-op+) (object/to-map e))))

(def default-repository-listener
  (RepositoryListenerProxy. {:artifact {:deployed   (fn [{:keys [artifact]}]
                                                      (println (str "DEPLOYED: " artifact)))
                                        :downloaded (fn [{:keys [artifact]}]
                                                      (println (str "DOWNLOADED: " artifact)))
                                        :installed  (fn [{:keys [artifact]}]
                                                      (println (str "INSTALLED: " artifact)))
                                        :resolved   (fn [{:keys [artifact]}]
                                                      (println (str "RESOLVED: " artifact)))}}))
