(defproject zcaudate/hara "2.8.7"
  :description "patterns and utilities"
  :url "https://github.com/zcaudate/hara"
  :license {:name "The MIT License"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.8.0"] [org.jsoup/jsoup "1.11.3"] [zcaudate/hara.common.watch "2.8.7"] [zcaudate/hara.concurrent.procedure "2.8.7"] [zcaudate/hara.object "2.8.7"] [zcaudate/hara.string "2.8.7"] [zcaudate/hara.protocol.archive "2.8.7"] [zcaudate/hara.protocol.map "2.8.7"] [zcaudate/hara.security "2.8.7"] [zcaudate/hara.namespace.eval "2.8.7"] [zcaudate/hara.protocol.state "2.8.7"] [zcaudate/hara.expression.compile "2.8.7"] [zcaudate/hara.group "2.8.7"] [zcaudate/hara.class "2.8.7"] [zcaudate/hara.image "2.8.7"] [zcaudate/hara.common.string "2.8.7"] [zcaudate/hara.protocol.time "2.8.7"] [zcaudate/hara.concurrent.notification "2.8.7"] [zcaudate/hara.io.encode "2.8.7"] [zcaudate/hara.protocol.object "2.8.7"] [zcaudate/hara.data.record "2.8.7"] [zcaudate/hara.data.transform "2.8.7"] [zcaudate/hara.data.path "2.8.7"] [zcaudate/hara.component "2.8.7"] [zcaudate/hara.class.enum "2.8.7"] [zcaudate/hara.common.hash "2.8.7"] [zcaudate/hara.class.multi "2.8.7"] [zcaudate/hara.extend.abstract "2.8.7"] [zcaudate/hara.namespace.resolve "2.8.7"] [zcaudate/hara.namespace.import "2.8.7"] [zcaudate/hara.reflect "2.8.7"] [zcaudate/hara.extend.all "2.8.7"] [zcaudate/hara.io.classpath "2.8.7"] [zcaudate/hara.expression "2.8.7"] [zcaudate/hara.event "2.8.7"] [zcaudate/hara.concurrent.propagate "2.8.7"] [zcaudate/hara.protocol.string "2.8.7"] [zcaudate/hara.sort.topological "2.8.7"] [zcaudate/hara.sort "2.8.7"] [zcaudate/hara.protocol.constructor "2.8.7"] [zcaudate/hara.string.mustache "2.8.7"] [zcaudate/hara.data.complex "2.8.7"] [zcaudate/hara.common.pretty "2.8.7"] [zcaudate/hara.string.case "2.8.7"] [zcaudate/hara.class.checks "2.8.7"] [zcaudate/hara.io.project "2.8.7"] [zcaudate/hara.sort.hierarchical "2.8.7"] [zcaudate/hara.common.state "2.8.7"] [zcaudate/hara.io.environment "2.8.7"] [zcaudate/hara.io.ansii "2.8.7"] [zcaudate/hara.io.archive "2.8.7"] [zcaudate/hara.common.primitives "2.8.7"] [zcaudate/hara.concurrent.pipe "2.8.7"] [zcaudate/hara.class.inheritance "2.8.7"] [zcaudate/hara.io.file "2.8.7"] [zcaudate/hara.protocol.image "2.8.7"] [zcaudate/hara.expression.load "2.8.7"] [zcaudate/hara.common.error "2.8.7"] [zcaudate/hara.data.diff "2.8.7"] [zcaudate/hara.time "2.8.7"] [zcaudate/hara.protocol.watch "2.8.7"] [zcaudate/hara.function "2.8.7"] [zcaudate/hara.io.watch "2.8.7"] [zcaudate/hara.function.dispatch "2.8.7"] [zcaudate/hara.data.seq "2.8.7"] [zcaudate/hara.data.nested "2.8.7"] [zcaudate/hara.data.map "2.8.7"] [zcaudate/hara.concurrent.ova "2.8.7"] [zcaudate/hara.common.checks "2.8.7"] [zcaudate/hara.expression.shorthand "2.8.7"] [zcaudate/hara.io.scheduler "2.8.7"] [zcaudate/hara.concurrent "2.8.7"] [zcaudate/hara.extend "2.8.7"] [zcaudate/hara.expression.form "2.8.7"] [zcaudate/hara.io.classloader "2.8.7"] [zcaudate/hara.html "2.8.7"] [zcaudate/hara.namespace "2.8.7"] [zcaudate/hara.string.path "2.8.7"] [zcaudate/hara.data "2.8.7"] [zcaudate/hara.zip "2.8.7"] [zcaudate/hara.concurrent.latch "2.8.7"] [zcaudate/hara.data.combine "2.8.7"] [zcaudate/hara.common "2.8.7"] [zcaudate/hara.test "2.8.7"] [zcaudate/hara.string.prose "2.8.7"] [zcaudate/hara.function.args "2.8.7"]]
  :aliases {"test" ["run" "-m" "hara.test" "exit"]}
   
  :repl-options {:host "0.0.0.0"}
  :publish {:theme  "bolton"
            :template {:author "Chris Zheng"
                       :email  "z@caudate.me"
                       :site   "hara"
                       :tracking-enabled "true"
                       :tracking "UA-31320512-2"}
            :files {"index"
                    {:template "home.html"
                     :input "test/documentation/home_hara.clj"
                     :title "hara"
                     :subtitle "patterns and utilities"}
                    "hara-class"
                    {:input "test/documentation/hara_class.clj"
                     :title "class"
                     :subtitle "functions for reasoning about classes"}
                    "hara-common"
                    {:input "test/documentation/hara_common.clj"
                     :title "common"
                     :subtitle "primitives declarations and functions"}
                    "hara-component"
                    {:input "test/documentation/hara_component.clj"
                     :title "component"
                     :subtitle "constructing composable systems"}
                    "hara-concurrent"
                    {:input "test/documentation/hara_concurrent.clj"
                     :title "concurrent"
                     :subtitle "methods and datastructures for concurrency"}
                    "hara-concurrent-ova"
                    {:input "test/documentation/hara_concurrent_ova.clj"
                     :title "concurrent.ova"
                     :subtitle "shared mutable state"}
                    "hara-concurrent-procedure"
                    {:input "test/documentation/hara_concurrent_procedure.clj"
                     :title "concurrent.procedure"
                     :subtitle "controllable execution"}
                    "hara-data"
                    {:input "test/documentation/hara_data.clj"
                     :title "data"
                     :subtitle "maps and representations of data"}
                    "hara-event"
                    {:input "test/documentation/hara_event.clj"
                     :title "event"
                     :subtitle "event signalling and conditional restart"}
                    "hara-expression"
                    {:input "test/documentation/hara_expression.clj"
                     :title "expression"
                     :subtitle "interchange between code and data"}
                    "hara-extend"
                    {:input "test/documentation/hara_extend.clj"
                     :title "extend"
                     :subtitle "macros for extensible objects"}
                    "hara-function"
                    {:input "test/documentation/hara_function.clj"
                     :title "function"
                     :subtitle "reasoning about functions"}
                    "hara-group"
                    {:input "test/documentation/hara_group.clj"
                     :title "group"
                     :subtitle "generic typed collections"}
                    "hara-image"
                    {:input "test/documentation/hara_image.clj"
                     :title "image"
                     :subtitle "tools for image manipulation"}
                    "hara-io"
                    {:input "test/documentation/hara_io.clj"
                     :title "io"
                     :subtitle "tools for files and io operations"}
                    "hara-io-file"
                    {:input "test/documentation/hara_io_file.clj"
                     :title "io.file"
                     :subtitle "tools for the file system"}
                    "hara-io-scheduler"
                    {:input "test/documentation/hara_io_scheduler.clj"
                     :title "io.scheduler"
                     :subtitle "easy and intuitive task scheduling"}
                    "hara-io-watch"
                    {:input "test/documentation/hara_io_watch.clj"
                     :title "io.watch"
                     :subtitle "watch for filesystem changes"}
                    "hara-namespace"
                    {:input "test/documentation/hara_namespace.clj"
                     :title "namespace"
                     :subtitle "utilities for namespace manipulation"}
                    "hara-object"
                    {:input "test/documentation/hara_object.clj"
                     :title "object"
                     :subtitle "think data, escape encapsulation"}
                    "hara-reflect"
                    {:input "test/documentation/hara_reflect.clj"
                     :title "reflect"
                     :subtitle "java reflection made easy"}
                    "hara-security"
                    {:input "test/documentation/hara_security.clj"
                     :title "security"
                     :subtitle "cryptography that makes sense"}
                    "hara-sort"
                    {:input "test/documentation/hara_sort.clj"
                     :title "sort"
                     :subtitle "micellaneous sorting functions"}
                    "hara-string"
                    {:input "test/documentation/hara_string.clj"
                     :title "string"
                     :subtitle "methods for string manipulation"}
                    "hara-test"
                    {:input "test/documentation/hara_test.clj"
                     :title "test"
                     :subtitle "easy to use test framework"}
                    "hara-time"
                    {:input "test/documentation/hara_time.clj"
                     :title "time"
                     :subtitle "time as a clojure map"}
                    "hara-zip"
                    {:input "test/documentation/hara_zip.clj"
                     :title "zip"
                     :subtitle "data traversal in style"}}}
  :injections  [(require '[lucid.core.inject :as inject]
                         'hara.test
                         'lucid.unit)
                 (inject/in [hara.io.project project]
                            [clojure.tools.namespace.repl refresh]
                            [lucid.unit all-functions      
                                        all-missing        
                                        all-orphaned       
                                        all-tests          
                                        all-todos          
                                        arrange
                                        arrange-project    
                                        exclude            
                                        import             
                                        import-project     
                                        in-order?          
                                        missing            
                                        orphaned     
                                        purge              
                                        scaffold           
                                        scaffold-project   
                                        stats
                                        todos]

                            clojure.core
                            [lucid.mind .& .> .? .* .% .%>])]                     
  :jvm-opts []
  ;; :global-vars {*warn-on-reflection* true}
  :java-source-paths ["java"]
  :jar-exclusions [#"^test\..+\.class"]
   )
