/*
 * Decompiled with CFR 0.152.
 */
package hara.string.mustache;

import clojure.lang.Keyword;
import hara.string.mustache.Context;
import hara.string.mustache.Mustache;
import hara.string.mustache.ParserException;
import java.util.List;
import java.util.Map;

public class Token {
    public static final char TEXT = 't';
    public static final char NAME = 'n';
    public static final char NO_ESCAPE1 = '{';
    public static final char NO_ESCAPE2 = '&';
    public static final char SECTION = '#';
    public static final char TRUE = '?';
    public static final char INVERTED = '^';
    public static final char PARTIAL = '>';
    final char type;
    final Object value;
    List<Token> tokens;

    public Token(char c, String string) {
        this.type = c;
        if (c != 't') {
            string = string.trim();
            this.value = Keyword.intern((String)string);
        } else {
            this.value = string;
        }
    }

    public static String renderTokens(List<Token> list, Context context, Map<Keyword, String> map) throws ParserException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token : list) {
            stringBuilder.append(token.render(context, map));
        }
        return stringBuilder.toString();
    }

    public static String escapeHtml(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String render(Context context, Map<Keyword, String> map) throws ParserException {
        switch (this.type) {
            case 't': {
                return this.value.toString();
            }
            case 'n': {
                Object object = context.lookup(this.value);
                if (object == null) break;
                return Token.escapeHtml(object.toString());
            }
            case '&': 
            case '{': {
                Object object = context.lookup(this.value);
                if (object == null) break;
                return object.toString();
            }
            case '?': {
                if (this.tokens == null || Context.isFalse(context.lookup(this.value))) break;
                return Token.renderTokens(this.tokens, context, map);
            }
            case '#': {
                if (this.tokens == null) break;
                Object object = context.lookup(this.value);
                if (Context.isArray(object)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    List list = (List)object;
                    for (Object e : list) {
                        Context context2 = new Context(e, context);
                        for (Token token : this.tokens) {
                            stringBuilder.append(token.render(context2, map));
                        }
                    }
                    return stringBuilder.toString();
                }
                if (Context.isFalse(object)) break;
                return Token.renderTokens(this.tokens, new Context(object, context), map);
            }
            case '^': {
                if (this.tokens == null || !Context.isFalse(context.lookup(this.value))) break;
                return Token.renderTokens(this.tokens, context, map);
            }
            case '>': {
                String string;
                if (map == null || (string = map.get(this.value)) == null) break;
                return Mustache.preprocess(string).render(context, map);
            }
        }
        return "";
    }

    public String toString() {
        if (this.tokens != null) {
            return this.type + " " + this.value + "\t" + this.tokens;
        }
        return this.type + " " + this.value;
    }
}

