(ns hara.image.awt.display
  (:require [hara.image.base.common :as base]
            [hara.image.awt.common :as awt]
            [hara.protocol.image :as image])
  (:import (javax.swing JComponent JFrame WindowConstants)
           (java.awt BorderLayout Dimension)))

(defn display
  "displays a BufferedImage in a JFrame
 
   (display (io/read \"resources/data/circle-100.png\"))"
  {:added "2.8"}
  ([image {:keys [channel] :as opts}]
   (let [image (if channel
                 (-> (base/slice (base/base-map image) channel)
                     (awt/image))
                 image)
         frame (JFrame. (str [(.getWidth image) (.getHeight image)]))
         picture (proxy [JComponent] []
                   (paintComponent [g]
                     (.drawImage g image 0 0 nil)))
         size (Dimension. (.getWidth image) (.getHeight image))]
     (do
       (doto picture
         (.setPreferredSize size))
       
       (doto frame
         (.setDefaultCloseOperation WindowConstants/DISPOSE_ON_CLOSE)
         (.setLayout (BorderLayout.))
         (.add picture BorderLayout/CENTER)
         (.pack)
         (.show))))))
