(ns hara.image.awt
  (:require [hara.protocol.image :as image]
            [hara.image.awt
             [common :as common]
             [display :as display]
             [io :as io]])
  (:import java.awt.image.BufferedImage))

(extend-protocol image/IRepresentation
  BufferedImage
  (-channels [img] (common/image-channels img))
  (-size     [img] (common/image-size img))
  (-model    [img] (common/image-model img))
  (-data     [img] (common/image-data img))
  (-subimage [img x y w h]
    (common/subimage img x y w h)))

(defmethod print-method BufferedImage
  [v w]
  (.write w (str "#image.awt" [(.getWidth v) (.getHeight v)]
                 {:model (-> (image/-model v) :label)})))

(defmethod image/-image BufferedImage
  [size model data _]
  (common/image size model data))

(defmethod image/-image :awt
  [size model data _]
  (common/image size model data))

(defmethod image/-blank BufferedImage
  [size model _]
  (common/image size model nil))

(defmethod image/-blank :awt
  [size model _]
  (common/image size model nil))

(defmethod image/-read BufferedImage
  [source model _]
  (io/read source))

(extend-protocol image/ITransfer
  BufferedImage
  (-to-byte-gray [image]
    (common/image-to-byte-gray image))
  (-to-int-argb  [image]
    (common/image-to-int-argb image))
  (-write   [image sink opts]
    (io/write image sink opts)))

(defmethod image/-display BufferedImage
  [image opts _]
  (display/display image opts))

(defmethod image/-display-class BufferedImage
  [_]
  #{BufferedImage})

(defmethod image/-display :awt
  [image opts _]
  (display/display image opts))

(defmethod image/-display-class :awt
  [_]
  #{BufferedImage})
